/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.CaseInsensitiveValuePatternCondition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.ObjectPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.ValuePatternCondition;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class StringPattern
extends ObjectPattern<String, StringPattern> {
    static final StringPattern STRING_PATTERN = new StringPattern();

    private StringPattern() {
        super(new InitialPatternCondition<String>(String.class){

            @Override
            public boolean accepts(@Nullable Object o, ProcessingContext context) {
                return o instanceof String;
            }

            @Override
            public void append(@NotNull @NonNls StringBuilder builder, String indent) {
                if (builder == null) {
                    1.$$$reportNull$$$0(0);
                }
                builder.append("string()");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/patterns/StringPattern$1", "append"));
            }
        });
    }

    @NotNull
    public StringPattern startsWith(@NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(0);
        }
        StringPattern stringPattern = (StringPattern)this.with(new StartsWithCondition(s));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(1);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern endsWith(@NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(2);
        }
        StringPattern stringPattern = (StringPattern)this.with(new EndsWithCondition(s));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(3);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(@NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(4);
        }
        StringPattern stringPattern = (StringPattern)this.with(new ContainsCondition(s));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(5);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern containsChars(@NonNls @NotNull String s) {
        if (s == null) {
            StringPattern.$$$reportNull$$$0(6);
        }
        StringPattern stringPattern = (StringPattern)this.with(new ContainsCharsCondition(s));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(7);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern matches(@NonNls @NotNull String s) {
        String escaped;
        if (s == null) {
            StringPattern.$$$reportNull$$$0(8);
        }
        if ((escaped = StringUtil.escapeToRegexp((String)s)).equals(s)) {
            StringPattern stringPattern = (StringPattern)this.equalTo(s);
            if (stringPattern == null) {
                StringPattern.$$$reportNull$$$0(9);
            }
            return stringPattern;
        }
        StringPattern stringPattern = (StringPattern)this.with(new MatchesCondition(s));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(10);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern contains(final @NonNls @NotNull ElementPattern<Character> pattern) {
        if (pattern == null) {
            StringPattern.$$$reportNull$$$0(11);
        }
        StringPattern stringPattern = (StringPattern)this.with(new PatternCondition<String>("contains"){

            @Override
            public boolean accepts(@NotNull String str, ProcessingContext context) {
                if (str == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (int i = 0; i < str.length(); ++i) {
                    if (!pattern.accepts(Character.valueOf(str.charAt(i)))) continue;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/patterns/StringPattern$2", "accepts"));
            }
        });
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(12);
        }
        return stringPattern;
    }

    public StringPattern longerThan(int minLength) {
        return (StringPattern)this.with(new LongerThanCondition(minLength));
    }

    public StringPattern shorterThan(int maxLength) {
        return (StringPattern)this.with(new ShorterThanCondition(maxLength));
    }

    public StringPattern withLength(int length) {
        return (StringPattern)this.with(new WithLengthCondition(length));
    }

    @NotNull
    public StringPattern endsWithUppercaseLetter() {
        StringPattern stringPattern = (StringPattern)this.with(new EndsWithUppercaseLetterCondition());
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(13);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern afterNonJavaIdentifierPart() {
        StringPattern stringPattern = (StringPattern)this.with(new AfterNonJavaIdentifierPartCondition());
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(14);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern oneOf(String ... values) {
        if (values == null) {
            StringPattern.$$$reportNull$$$0(15);
        }
        StringPattern stringPattern = (StringPattern)super.oneOf(values);
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(16);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern oneOfIgnoreCase(String ... values) {
        StringPattern stringPattern = (StringPattern)this.with(new CaseInsensitiveValuePatternCondition("oneOfIgnoreCase", values));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(17);
        }
        return stringPattern;
    }

    @Override
    @NotNull
    public StringPattern oneOf(@NonNls Collection<String> set) {
        StringPattern stringPattern = (StringPattern)super.oneOf(set);
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(18);
        }
        return stringPattern;
    }

    @NotNull
    public StringPattern endsWithOneOf(@NotNull Iterable<String> values) {
        if (values == null) {
            StringPattern.$$$reportNull$$$0(19);
        }
        List patternList = ContainerUtil.map(values, value -> StandardPatterns.string().endsWith((String)value));
        StringPattern[] patterns = patternList.toArray(new StringPattern[0]);
        StringPattern stringPattern = (StringPattern)this.and(StandardPatterns.or(patterns));
        if (stringPattern == null) {
            StringPattern.$$$reportNull$$$0(20);
        }
        return stringPattern;
    }

    @NotNull
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence) {
        if (sequence == null) {
            StringPattern.$$$reportNull$$$0(21);
        }
        if (sequence instanceof StringUtil.BombedCharSequence) {
            CharSequence charSequence = sequence;
            if (charSequence == null) {
                StringPattern.$$$reportNull$$$0(22);
            }
            return charSequence;
        }
        return new StringUtil.BombedCharSequence(sequence){

            protected void checkCanceled() {
                ProgressManager.checkCanceled();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/patterns/StringPattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/patterns/StringPattern";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "startsWith";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "endsWith";
                break;
            }
            case 5: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "contains";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "containsChars";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "matches";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "endsWithUppercaseLetter";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "afterNonJavaIdentifierPart";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOf";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "oneOfIgnoreCase";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "endsWithOneOf";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "newBombedCharSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "endsWith";
                break;
            }
            case 4: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "containsChars";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "oneOf";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "endsWithOneOf";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "newBombedCharSequence";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class StartsWithCondition
    extends PatternCondition<String> {
        private final String prefix;

        public StartsWithCondition(@NotNull String prefix) {
            if (prefix == null) {
                StartsWithCondition.$$$reportNull$$$0(0);
            }
            super("startsWith");
            this.prefix = prefix;
        }

        @NotNull
        public String getPrefix() {
            String string = this.prefix;
            if (string == null) {
                StartsWithCondition.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean accepts(@NotNull String str, ProcessingContext context) {
            if (str == null) {
                StartsWithCondition.$$$reportNull$$$0(2);
            }
            return StringUtil.startsWith((CharSequence)str, (CharSequence)this.prefix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/patterns/StringPattern$StartsWithCondition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/patterns/StringPattern$StartsWithCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPrefix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static final class EndsWithCondition
    extends PatternCondition<String> {
        private final String suffix;

        public EndsWithCondition(@NotNull String suffix) {
            if (suffix == null) {
                EndsWithCondition.$$$reportNull$$$0(0);
            }
            super("endsWith");
            this.suffix = suffix;
        }

        @NotNull
        public String getSuffix() {
            String string = this.suffix;
            if (string == null) {
                EndsWithCondition.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean accepts(@NotNull String str, ProcessingContext context) {
            if (str == null) {
                EndsWithCondition.$$$reportNull$$$0(2);
            }
            return StringUtil.endsWith((CharSequence)str, (CharSequence)this.suffix);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/patterns/StringPattern$EndsWithCondition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/patterns/StringPattern$EndsWithCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuffix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static final class ContainsCondition
    extends PatternCondition<String> {
        private final String substring;

        public ContainsCondition(@NotNull String substring) {
            if (substring == null) {
                ContainsCondition.$$$reportNull$$$0(0);
            }
            super("contains");
            this.substring = substring;
        }

        @NotNull
        public String getSubstring() {
            String string = this.substring;
            if (string == null) {
                ContainsCondition.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean accepts(@NotNull String str, ProcessingContext context) {
            if (str == null) {
                ContainsCondition.$$$reportNull$$$0(2);
            }
            return StringUtil.contains((CharSequence)str, (CharSequence)this.substring);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "substring";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/patterns/StringPattern$ContainsCondition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/patterns/StringPattern$ContainsCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubstring";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static final class ContainsCharsCondition
    extends PatternCondition<String> {
        private final String chars;

        public ContainsCharsCondition(@NotNull String chars) {
            if (chars == null) {
                ContainsCharsCondition.$$$reportNull$$$0(0);
            }
            super("containsChars");
            this.chars = chars;
        }

        @NotNull
        public String getChars() {
            String string = this.chars;
            if (string == null) {
                ContainsCharsCondition.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean accepts(@NotNull String str, ProcessingContext context) {
            if (str == null) {
                ContainsCharsCondition.$$$reportNull$$$0(2);
            }
            return StringUtil.containsAnyChar((String)str, (String)this.chars);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "chars";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/patterns/StringPattern$ContainsCharsCondition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/patterns/StringPattern$ContainsCharsCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChars";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static final class MatchesCondition
    extends ValuePatternCondition<String> {
        private final String regex;
        private final Pattern pattern;

        public MatchesCondition(@NotNull String regex) {
            if (regex == null) {
                MatchesCondition.$$$reportNull$$$0(0);
            }
            super("matches");
            this.regex = regex;
            this.pattern = Pattern.compile(regex);
        }

        @NotNull
        public String getRegex() {
            String string = this.regex;
            if (string == null) {
                MatchesCondition.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public boolean accepts(@NotNull String str, ProcessingContext context) {
            if (str == null) {
                MatchesCondition.$$$reportNull$$$0(2);
            }
            return this.pattern.matcher(StringPattern.newBombedCharSequence(str)).matches();
        }

        @Override
        public @Unmodifiable Collection<String> getValues() {
            return Collections.singleton(this.regex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "regex";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/patterns/StringPattern$MatchesCondition";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "str";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/patterns/StringPattern$MatchesCondition";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRegex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "accepts";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @ApiStatus.Internal
    public static final class LongerThanCondition
    extends PatternCondition<String> {
        private final int minLength;

        public LongerThanCondition(int minLength) {
            super("longerThan");
            this.minLength = minLength;
        }

        public int getMinLength() {
            return this.minLength;
        }

        @Override
        public boolean accepts(@NotNull String s, ProcessingContext context) {
            if (s == null) {
                LongerThanCondition.$$$reportNull$$$0(0);
            }
            return s.length() > this.minLength;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$LongerThanCondition", "accepts"));
        }
    }

    @ApiStatus.Internal
    public static final class ShorterThanCondition
    extends PatternCondition<String> {
        private final int maxLength;

        public ShorterThanCondition(int maxLength) {
            super("shorterThan");
            this.maxLength = maxLength;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        @Override
        public boolean accepts(@NotNull String s, ProcessingContext context) {
            if (s == null) {
                ShorterThanCondition.$$$reportNull$$$0(0);
            }
            return s.length() < this.maxLength;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$ShorterThanCondition", "accepts"));
        }
    }

    @ApiStatus.Internal
    public static final class WithLengthCondition
    extends PatternCondition<String> {
        private final int length;

        public WithLengthCondition(int length) {
            super("withLength");
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        @Override
        public boolean accepts(@NotNull String s, ProcessingContext context) {
            if (s == null) {
                WithLengthCondition.$$$reportNull$$$0(0);
            }
            return s.length() == this.length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$WithLengthCondition", "accepts"));
        }
    }

    @ApiStatus.Internal
    public static final class EndsWithUppercaseLetterCondition
    extends PatternCondition<String> {
        public EndsWithUppercaseLetterCondition() {
            super("endsWithUppercaseLetter");
        }

        @Override
        public boolean accepts(@NotNull String s, ProcessingContext context) {
            if (s == null) {
                EndsWithUppercaseLetterCondition.$$$reportNull$$$0(0);
            }
            return !s.isEmpty() && Character.isUpperCase(s.charAt(s.length() - 1));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$EndsWithUppercaseLetterCondition", "accepts"));
        }
    }

    @ApiStatus.Internal
    public static final class AfterNonJavaIdentifierPartCondition
    extends PatternCondition<String> {
        public AfterNonJavaIdentifierPartCondition() {
            super("afterNonJavaIdentifierPart");
        }

        @Override
        public boolean accepts(@NotNull String s, ProcessingContext context) {
            if (s == null) {
                AfterNonJavaIdentifierPartCondition.$$$reportNull$$$0(0);
            }
            return s.length() > 1 && !Character.isJavaIdentifierPart(s.charAt(s.length() - 2));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/patterns/StringPattern$AfterNonJavaIdentifierPartCondition", "accepts"));
        }
    }
}

