/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.connectivity.ex.dataSource.artifacts;

import com.intellij.database.connectivity.ex.dataSource.artifacts.ArtifactRepositoriesProvider;
import com.intellij.database.connectivity.ex.dataSource.artifacts.MavenSettingsRepositoriesProvider$getElementWithRegardToNamespace$;
import com.intellij.database.connectivity.ex.dataSource.artifacts.MavenSettingsRepositoriesProviderKt;
import com.intellij.database.connectivity.ex.dataSource.artifacts.RemoteRepositoryDescription;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.util.SystemProperties;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/database/connectivity/ex/dataSource/artifacts/MavenSettingsRepositoriesProvider;", "Lcom/intellij/database/connectivity/ex/dataSource/artifacts/ArtifactRepositoriesProvider;", "<init>", "()V", "lastModifiedTime", "Ljava/nio/file/attribute/FileTime;", "cachedRepositories", "", "Lcom/intellij/database/connectivity/ex/dataSource/artifacts/RemoteRepositoryDescription;", "getRepositories", "context", "Lcom/intellij/database/dataSource/artifacts/DatabaseArtifactContext;", "getMirrorsFromSettings", "pathSettingsXml", "Ljava/nio/file/Path;", "getElementWithRegardToNamespace", "Lorg/jdom/Element;", "parent", "childName", "", "getElementsWithRegardToNamespace", "childrenName", "intellij.database.connectivity.ex"})
@SourceDebugExtension(value={"SMAP\nMavenSettingsRepositoriesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenSettingsRepositoriesProvider.kt\ncom/intellij/database/connectivity/ex/dataSource/artifacts/MavenSettingsRepositoriesProvider\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,85:1\n479#2:86\n*S KotlinDebug\n*F\n+ 1 MavenSettingsRepositoriesProvider.kt\ncom/intellij/database/connectivity/ex/dataSource/artifacts/MavenSettingsRepositoriesProvider\n*L\n77#1:86\n*E\n"})
public final class MavenSettingsRepositoriesProvider
extends ArtifactRepositoriesProvider {
    @NotNull
    private FileTime lastModifiedTime;
    @NotNull
    private List<RemoteRepositoryDescription> cachedRepositories;

    public MavenSettingsRepositoriesProvider() {
        FileTime fileTime = FileTime.fromMillis(Long.MIN_VALUE);
        Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"fromMillis(...)");
        this.lastModifiedTime = fileTime;
        this.cachedRepositories = CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public synchronized List<RemoteRepositoryDescription> getRepositories(@NotNull DatabaseArtifactContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        EelPath home = context.getUserHome();
        Path pathSettingsXml = home != null && context.useEel() ? EelNioBridgeServiceKt.asNioPath((EelPath)home).resolve(".m2").resolve("settings.xml") : Path.of(SystemProperties.getUserHome(), new String[0]).resolve(".m2").resolve("settings.xml");
        try {
            if (!Files.exists(pathSettingsXml, new LinkOption[0])) {
                return CollectionsKt.emptyList();
            }
            FileTime currentModifiedTime = Files.getLastModifiedTime(pathSettingsXml, new LinkOption[0]);
            if (currentModifiedTime.compareTo(this.lastModifiedTime) == 0) {
                return this.cachedRepositories;
            }
            Intrinsics.checkNotNull((Object)currentModifiedTime);
            this.lastModifiedTime = currentModifiedTime;
            Intrinsics.checkNotNull((Object)pathSettingsXml);
            this.cachedRepositories = this.getMirrorsFromSettings(pathSettingsXml);
            return this.cachedRepositories;
        }
        catch (Throwable e) {
            Logger logger = MavenSettingsRepositoriesProviderKt.access$getLOG$p();
            String string = "Failed to read %s";
            Object[] objectArray = new Object[]{"settings.xml"};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            logger.warn(string2, e);
            return CollectionsKt.emptyList();
        }
    }

    private final List<RemoteRepositoryDescription> getMirrorsFromSettings(Path pathSettingsXml) {
        List repositories = new ArrayList();
        Element element = JDOMUtil.load((Reader)new InputStreamReader(Files.newInputStream(pathSettingsXml, new OpenOption[0]), StandardCharsets.UTF_8));
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
        Element root = element;
        Element mirrorParent = this.getElementWithRegardToNamespace(root, "mirrors");
        if (mirrorParent == null) {
            return repositories;
        }
        List<Element> mirrors = this.getElementsWithRegardToNamespace(mirrorParent, "mirror");
        for (Element mirror : mirrors) {
            Element url = this.getElementWithRegardToNamespace(mirror, "url");
            if (url == null) continue;
            String string = url.getTextTrim();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextTrim(...)");
            repositories.add(new RemoteRepositoryDescription(null, string));
        }
        return repositories;
    }

    private final Element getElementWithRegardToNamespace(Element parent, String childName) {
        List list = parent.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)list);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getElementWithRegardToNamespace$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        return (Element)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)sequence, arg_0 -> MavenSettingsRepositoriesProvider.getElementWithRegardToNamespace$lambda$0(childName, arg_0)));
    }

    private final List<Element> getElementsWithRegardToNamespace(Element parent, String childrenName) {
        List list = parent.getContent(arg_0 -> MavenSettingsRepositoriesProvider.getElementsWithRegardToNamespace$lambda$0(childrenName, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        return list;
    }

    private static final boolean getElementWithRegardToNamespace$lambda$0(String $childName, Element it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getName(), (Object)$childName) && MavenSettingsRepositoriesProviderKt.access$getSETTINGS_SET_NAMESPACES$p().contains(it.getNamespace());
    }

    private static final boolean getElementsWithRegardToNamespace$lambda$0(String $childrenName, Object it) {
        return it instanceof Element && Intrinsics.areEqual((Object)((Element)it).getName(), (Object)$childrenName) && MavenSettingsRepositoriesProviderKt.access$getSETTINGS_SET_NAMESPACES$p().contains(((Element)it).getNamespace());
    }
}

