/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.undo;

import com.intellij.openapi.command.undo.ActionChangeRange;
import com.intellij.openapi.command.undo.AdjustableUndoableAction;
import java.lang.ref.WeakReference;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*BQ\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0000J\b\u0010\u001e\u001a\u00020\u0000H\u0002J\b\u0010\u001f\u001a\u00020\u0000H\u0016J\u0010\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\u001aH\u0016J\u0018\u0010\"\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u001aJ\u001a\u0010$\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0003H\u0002J\u001a\u0010&\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001b\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0003H\u0002J \u0010'\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\n\u0010(\u001a\u00020)H\u0096\u0080\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0019\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/intellij/openapi/command/undo/ImmutableActionChangeRange;", "Lcom/intellij/openapi/command/undo/ActionChangeRange;", "offset", "", "oldLength", "newLength", "oldDocumentLength", "newDocumentLength", "id", "timestamp", "actionReference", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/command/undo/AdjustableUndoableAction;", "<init>", "(IIIIIIILjava/lang/ref/WeakReference;)V", "getOffset", "()I", "getOldLength", "getNewLength", "getOldDocumentLength", "getNewDocumentLength", "getId", "getTimestamp", "getActionReference", "()Ljava/lang/ref/WeakReference;", "hasTheSameOrigin", "", "other", "isSymmetricTo", "newRange", "toInvalid", "asInverted", "toImmutable", "invalidate", "moveAfter", "preferBefore", "moveRight", "adjustment", "moveLeft", "copyWithNewTimestamp", "toString", "", "Companion", "intellij.platform.analysis"})
@ApiStatus.Experimental
public final class ImmutableActionChangeRange
implements ActionChangeRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int offset;
    private final int oldLength;
    private final int newLength;
    private final int oldDocumentLength;
    private final int newDocumentLength;
    private final int id;
    private final int timestamp;
    @NotNull
    private final WeakReference<AdjustableUndoableAction> actionReference;
    @NotNull
    private static final WeakReference<AdjustableUndoableAction> NullRef = new WeakReference<Object>(null);
    @NotNull
    private static final AtomicInteger idCounter = new AtomicInteger(0);
    @NotNull
    private static final AtomicInteger timestampCounter = new AtomicInteger(0);

    private ImmutableActionChangeRange(int offset, int oldLength, int newLength, int oldDocumentLength, int newDocumentLength, int id, int timestamp, WeakReference<AdjustableUndoableAction> actionReference) {
        this.offset = offset;
        this.oldLength = oldLength;
        this.newLength = newLength;
        this.oldDocumentLength = oldDocumentLength;
        this.newDocumentLength = newDocumentLength;
        this.id = id;
        this.timestamp = timestamp;
        this.actionReference = actionReference;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public int getOldLength() {
        return this.oldLength;
    }

    @Override
    public int getNewLength() {
        return this.newLength;
    }

    @Override
    public int getOldDocumentLength() {
        return this.oldDocumentLength;
    }

    @Override
    public int getNewDocumentLength() {
        return this.newDocumentLength;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getTimestamp() {
        return this.timestamp;
    }

    @NotNull
    public final WeakReference<AdjustableUndoableAction> getActionReference() {
        return this.actionReference;
    }

    public final boolean hasTheSameOrigin(@NotNull ImmutableActionChangeRange other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getId() == other.getId() || this.getId() == -other.getId();
    }

    public final boolean isSymmetricTo(@NotNull ImmutableActionChangeRange newRange) {
        Intrinsics.checkNotNullParameter((Object)newRange, (String)"newRange");
        return this.getOffset() == newRange.getOffset() && this.getOldLength() == newRange.getNewLength() && this.getNewLength() == newRange.getOldLength();
    }

    private final ImmutableActionChangeRange toInvalid() {
        return this.actionReference.get() != null ? new ImmutableActionChangeRange(this.getOffset(), this.getOldLength(), this.getNewLength(), this.getOldDocumentLength(), this.getNewDocumentLength(), this.getId(), this.getTimestamp(), NullRef) : this;
    }

    @Override
    @NotNull
    public ImmutableActionChangeRange asInverted() {
        return new ImmutableActionChangeRange(this.getOffset(), this.getNewLength(), this.getOldLength(), this.getNewDocumentLength(), this.getOldDocumentLength(), -this.getId(), this.getTimestamp(), this.actionReference);
    }

    @Override
    @NotNull
    public ImmutableActionChangeRange toImmutable(boolean invalidate) {
        return invalidate ? this.toInvalid() : this;
    }

    @Nullable
    public final ImmutableActionChangeRange moveAfter(@NotNull ImmutableActionChangeRange other, boolean preferBefore) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int adjustment = other.getNewLength() - other.getOldLength();
        if (preferBefore) {
            ImmutableActionChangeRange immutableActionChangeRange = this.moveRight(other, adjustment);
            if (immutableActionChangeRange == null) {
                immutableActionChangeRange = this.moveLeft(other, adjustment);
            }
            return immutableActionChangeRange;
        }
        ImmutableActionChangeRange immutableActionChangeRange = this.moveLeft(other, adjustment);
        if (immutableActionChangeRange == null) {
            immutableActionChangeRange = this.moveRight(other, adjustment);
        }
        return immutableActionChangeRange;
    }

    private final ImmutableActionChangeRange moveRight(ImmutableActionChangeRange other, int adjustment) {
        if (other.getOffset() + other.getOldLength() <= this.getOffset()) {
            return this.copyWithNewTimestamp(this.getOffset() + adjustment, this.getOldDocumentLength() + adjustment, this.getNewDocumentLength() + adjustment);
        }
        return null;
    }

    private final ImmutableActionChangeRange moveLeft(ImmutableActionChangeRange other, int adjustment) {
        if (other.getOffset() >= this.getOffset() + this.getNewLength()) {
            return this.copyWithNewTimestamp(this.getOffset(), this.getOldDocumentLength() + adjustment, this.getNewDocumentLength() + adjustment);
        }
        return null;
    }

    private final ImmutableActionChangeRange copyWithNewTimestamp(int offset, int oldDocumentLength, int newDocumentLength) {
        return new ImmutableActionChangeRange(offset, this.getOldLength(), this.getNewLength(), oldDocumentLength, newDocumentLength, this.getId(), timestampCounter.incrementAndGet(), this.actionReference);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        AdjustableUndoableAction action;
        AdjustableUndoableAction adjustableUndoableAction = action = (AdjustableUndoableAction)this.actionReference.get();
        Object info = adjustableUndoableAction == null ? "" : " for " + adjustableUndoableAction;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (this.getId() < 0) {
            $this$toString_u24lambda_u240.append("Inverted ");
        }
        $this$toString_u24lambda_u240.append("[(" + this.getOffset() + ", " + this.getOldLength() + ", " + this.getNewLength() + ", " + this.getOldDocumentLength() + ", " + this.getNewDocumentLength() + ") " + (String)info + "]");
        return stringBuilder.toString();
    }

    public /* synthetic */ ImmutableActionChangeRange(int offset, int oldLength, int newLength, int oldDocumentLength, int newDocumentLength, int id, int timestamp, WeakReference actionReference, DefaultConstructorMarker $constructor_marker) {
        this(offset, oldLength, newLength, oldDocumentLength, newDocumentLength, id, timestamp, actionReference);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0006R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/command/undo/ImmutableActionChangeRange$Companion;", "", "<init>", "()V", "NullRef", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/command/undo/AdjustableUndoableAction;", "idCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "timestampCounter", "createNew", "Lcom/intellij/openapi/command/undo/ImmutableActionChangeRange;", "offset", "", "oldLength", "newLength", "oldDocumentLength", "newDocumentLength", "actionReference", "intellij.platform.analysis"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImmutableActionChangeRange createNew(int offset, int oldLength, int newLength, int oldDocumentLength, int newDocumentLength, @NotNull AdjustableUndoableAction actionReference) {
            Intrinsics.checkNotNullParameter((Object)actionReference, (String)"actionReference");
            int id = idCounter.incrementAndGet();
            return new ImmutableActionChangeRange(offset, oldLength, newLength, oldDocumentLength, newDocumentLength, id, timestampCounter.incrementAndGet(), new WeakReference<AdjustableUndoableAction>(actionReference), null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

