/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util.common;

import com.intellij.database.util.common.NumberFun;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000f\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\b\n\u0002\u0010(\n\u0000\u001a$\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\n\b\u0000\u0010\u0001\u0018\u0001*\u00020\u0002*\u0006\u0012\u0002\b\u00030\u0003H\u0086\b\u00a2\u0006\u0002\u0010\u0004\u001a'\u0010\u0005\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\bH\u0086\u0004\u001aM\u0010\n\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000b\"\b\b\u0000\u0010\f*\u00020\u0002\"\b\b\u0001\u0010\r*\u00020\u0002*\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u0002H\r0\u000bH\u0086\u0004\u001a-\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000fH\u0086\u0004\u001a&\u0010\u0010\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u00032\u0006\u0010\u0011\u001a\u0002H\u0007H\u0086\u0004\u00a2\u0006\u0002\u0010\u0012\u001a2\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00070\u000f0\u0014\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086\u0004\u00a2\u0006\u0002\u0010\u0017\u001a\u0015\u0010\u0018\u001a\u00020\u0016*\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0082\u0004\u001a,\u0010\u001a\u001a\u00020\u001b\"\b\b\u0000\u0010\u001c*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u001c0\u001d2\b\u0010\u0011\u001a\u0004\u0018\u0001H\u001cH\u0086\f\u00a2\u0006\u0002\u0010\u001e\u001a4\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u00070\u0003\"\b\b\u0000\u0010\u0007*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00070\u001d2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020\u00060!\u001a6\u0010\"\u001a\u00020#\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u00032\u0006\u0010$\u001a\u00020#2\u0016\b\u0002\u0010%\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020&\u0018\u00010!\u001a6\u0010'\u001a\u00020&\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070\u00032\u0006\u0010$\u001a\u00020#2\u0016\b\u0002\u0010%\u001a\u0010\u0012\u0004\u0012\u0002H\u0007\u0012\u0004\u0012\u00020&\u0018\u00010!\u001a\u001f\u0010(\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\b\b\u0000\u0010\u0007*\u00020\u0002*\u0002H\u0007\u00a2\u0006\u0002\u0010)\u001a\u001f\u0010*\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f\"\b\b\u0000\u0010\u0007*\u00020\u0002*\u0002H\u0007\u00a2\u0006\u0002\u0010+\u001a!\u0010,\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f\"\b\b\u0000\u0010\u0007*\u00020\u0002*\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010+\u001a!\u0010-\u001a\b\u0012\u0004\u0012\u0002H\u00070\b\"\b\b\u0000\u0010\u0007*\u00020\u0002*\u0004\u0018\u0001H\u0007\u00a2\u0006\u0002\u0010)\u001a\u001c\u0010.\u001a\b\u0012\u0004\u0012\u0002H\u00070\u000f\"\u0004\b\u0000\u0010\u0007*\b\u0012\u0004\u0012\u0002H\u00070/\u00a8\u00060"}, d2={"findByType", "Y", "", "", "(Ljava/util/Collection;)Ljava/lang/Object;", "intersects", "", "T", "", "that", "union", "", "K", "V", "concat", "", "containsOnly", "element", "(Ljava/util/Collection;Ljava/lang/Object;)Z", "splitIntoChunksOf", "", "maxItemsPerChunk", "", "(Ljava/util/List;I)[Ljava/util/List;", "divUp", "divisor", "addIfNotNull", "", "E", "", "(Ljava/util/Collection;Ljava/lang/Object;)V", "extract", "predicate", "Lkotlin/Function1;", "dumpToLongString", "", "unit", "transform", "", "dumpToLongCharSequence", "asSingleSet", "(Ljava/lang/Object;)Ljava/util/Set;", "asSingleList", "(Ljava/lang/Object;)Ljava/util/List;", "asSingleOrEmptyList", "asSingleOrEmptySet", "toList", "", "intellij.database.util"})
@JvmName(name="CollectionFun")
@SourceDebugExtension(value={"SMAP\nCollectionFun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CollectionFun.kt\ncom/intellij/database/util/common/CollectionFun\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,177:1\n296#2,2:178\n*S KotlinDebug\n*F\n+ 1 CollectionFun.kt\ncom/intellij/database/util/common/CollectionFun\n*L\n11#1:178,2\n*E\n"})
public final class CollectionFun {
    public static final /* synthetic */ <Y> Y findByType(Collection<?> $this$findByType) {
        Object object;
        Object y;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter($this$findByType, (String)"<this>");
            boolean $i$f$findByType = false;
            Iterable $this$firstOrNull$iv = $this$findByType;
            boolean $i$f$firstOrNull = false;
            Iterator iterator = $this$firstOrNull$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                Intrinsics.reifiedOperationMarker((int)3, (String)"Y");
                if (!(it instanceof Object)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Object v1 = y = v0;
        if (v1 != null) {
            Intrinsics.reifiedOperationMarker((int)1, (String)"Y");
            object = v1;
        } else {
            object = null;
        }
        return (Y)object;
    }

    public static final <T> boolean intersects(@NotNull Set<? extends T> $this$intersects, @NotNull Set<? extends T> that) {
        Intrinsics.checkNotNullParameter($this$intersects, (String)"<this>");
        Intrinsics.checkNotNullParameter(that, (String)"that");
        int n1 = $this$intersects.size();
        if (n1 == 0) {
            return false;
        }
        int n2 = that.size();
        if (n2 == 0) {
            return false;
        }
        if (n1 <= n2) {
            for (T element : $this$intersects) {
                if (!that.contains(element)) continue;
                return true;
            }
        } else {
            for (T element : that) {
                if (!$this$intersects.contains(element)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static final <K, V> Map<K, V> union(@NotNull Map<K, ? extends V> $this$union, @NotNull Map<K, ? extends V> that) {
        Intrinsics.checkNotNullParameter($this$union, (String)"<this>");
        Intrinsics.checkNotNullParameter(that, (String)"that");
        int n1 = $this$union.size();
        int n2 = that.size();
        int n = n1 + n2;
        if (n == 0) {
            return MapsKt.emptyMap();
        }
        if (n2 == 0) {
            return $this$union;
        }
        if (n1 == 0) {
            return that;
        }
        HashMap<K, V> result = new HashMap<K, V>(n);
        result.putAll($this$union);
        result.putAll(that);
        return result;
    }

    @NotNull
    public static final <T> List<T> concat(@NotNull List<? extends T> $this$concat, @NotNull List<? extends T> that) {
        Intrinsics.checkNotNullParameter($this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter(that, (String)"that");
        int nA = $this$concat.size();
        int nB = that.size();
        if (nB == 0) {
            return $this$concat;
        }
        if (nA == 0) {
            return that;
        }
        ArrayList result = new ArrayList(nA + nB);
        result.addAll($this$concat);
        result.addAll(that);
        return result;
    }

    public static final <T> boolean containsOnly(@NotNull Collection<? extends T> $this$containsOnly, T element) {
        Intrinsics.checkNotNullParameter($this$containsOnly, (String)"<this>");
        return $this$containsOnly.size() == 1 && $this$containsOnly.contains(element);
    }

    @NotNull
    public static final <T> List<T>[] splitIntoChunksOf(@NotNull List<? extends T> $this$splitIntoChunksOf, int maxItemsPerChunk) {
        Intrinsics.checkNotNullParameter($this$splitIntoChunksOf, (String)"<this>");
        int n = $this$splitIntoChunksOf.size();
        if (n <= maxItemsPerChunk) {
            int n2 = 0;
            List[] listArray = new List[1];
            while (n2 < 1) {
                int n3 = n2++;
                listArray[n3] = $this$splitIntoChunksOf;
            }
            return listArray;
        }
        int d = CollectionFun.divUp(n, maxItemsPerChunk);
        int m = CollectionFun.divUp(n, d);
        int capacity = d * m;
        int shorts = capacity - n;
        int longs = d - shorts;
        int g = longs * m;
        List[] listArray = new List[d];
        for (int i = 0; i < d; ++i) {
            int n4 = i;
            int offset = n4 < longs ? n4 * m : g + (n4 - longs) * (m - 1);
            int length = n4 < longs ? m : m - 1;
            listArray[n4] = $this$splitIntoChunksOf.subList(offset, offset + length);
        }
        List[] result = listArray;
        return result;
    }

    private static final int divUp(int $this$divUp, int divisor) {
        return ($this$divUp + divisor - 1) / divisor;
    }

    public static final <E> void addIfNotNull(@NotNull Collection<E> $this$addIfNotNull, @Nullable E element) {
        Intrinsics.checkNotNullParameter($this$addIfNotNull, (String)"<this>");
        boolean $i$f$addIfNotNull = false;
        if (element != null) {
            $this$addIfNotNull.add(element);
        }
    }

    @NotNull
    public static final <T> Collection<T> extract(@NotNull Collection<T> $this$extract, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkNotNullParameter($this$extract, (String)"<this>");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        ArrayList<T> excluded = null;
        Iterator<T> iterator = $this$extract.iterator();
        while (iterator.hasNext()) {
            T element = iterator.next();
            if (!((Boolean)predicate.invoke(element)).booleanValue()) continue;
            iterator.remove();
            if (excluded == null) {
                excluded = new ArrayList<T>();
            }
            excluded.add(element);
        }
        ArrayList<T> arrayList = excluded;
        return arrayList != null ? (Collection)arrayList : (Collection)CollectionsKt.emptyList();
    }

    @NotNull
    public static final <T> String dumpToLongString(@NotNull Collection<? extends T> $this$dumpToLongString, @NotNull String unit, @Nullable Function1<? super T, ? extends CharSequence> transform) {
        Intrinsics.checkNotNullParameter($this$dumpToLongString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return ((Object)CollectionFun.dumpToLongCharSequence($this$dumpToLongString, unit, transform)).toString();
    }

    public static /* synthetic */ String dumpToLongString$default(Collection collection, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return CollectionFun.dumpToLongString(collection, string, function1);
    }

    @NotNull
    public static final <T> CharSequence dumpToLongCharSequence(@NotNull Collection<? extends T> $this$dumpToLongCharSequence, @NotNull String unit, @Nullable Function1<? super T, ? extends CharSequence> transform) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter($this$dumpToLongCharSequence, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        if (!$this$dumpToLongCharSequence.isEmpty()) {
            StringBuilder stringBuilder;
            StringBuilder $this$dumpToLongCharSequence_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$dumpToLongCharSequence_u24lambda_u240.append(NumberFun.toStringWithUnits($this$dumpToLongCharSequence.size(), unit));
            CollectionsKt.joinTo$default((Iterable)$this$dumpToLongCharSequence, (Appendable)$this$dumpToLongCharSequence_u24lambda_u240, null, null, null, (int)0, null, transform, (int)62, null);
            charSequence = stringBuilder;
        } else {
            charSequence = "No " + StringUtil.pluralize((String)unit, (int)0);
        }
        return charSequence;
    }

    public static /* synthetic */ CharSequence dumpToLongCharSequence$default(Collection collection, String string, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return CollectionFun.dumpToLongCharSequence(collection, string, function1);
    }

    @NotNull
    public static final <T> Set<T> asSingleSet(@NotNull T $this$asSingleSet) {
        Intrinsics.checkNotNullParameter($this$asSingleSet, (String)"<this>");
        Set<T> set = Collections.singleton($this$asSingleSet);
        Intrinsics.checkNotNullExpressionValue(set, (String)"singleton(...)");
        return set;
    }

    @NotNull
    public static final <T> List<T> asSingleList(@NotNull T $this$asSingleList) {
        Intrinsics.checkNotNullParameter($this$asSingleList, (String)"<this>");
        return CollectionsKt.listOf($this$asSingleList);
    }

    @NotNull
    public static final <T> List<T> asSingleOrEmptyList(@Nullable T $this$asSingleOrEmptyList) {
        T t = $this$asSingleOrEmptyList;
        return t != null ? CollectionsKt.listOf(t) : CollectionsKt.emptyList();
    }

    @NotNull
    public static final <T> Set<T> asSingleOrEmptySet(@Nullable T $this$asSingleOrEmptySet) {
        T t = $this$asSingleOrEmptySet;
        return t != null ? SetsKt.setOf(t) : SetsKt.emptySet();
    }

    @NotNull
    public static final <T> List<T> toList(@NotNull Iterator<? extends T> $this$toList) {
        Intrinsics.checkNotNullParameter($this$toList, (String)"<this>");
        ArrayList<T> result = new ArrayList<T>();
        while ($this$toList.hasNext()) {
            result.add($this$toList.next());
        }
        return result;
    }
}

