/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.lsp.core.type;

import com.google.common.util.concurrent.Striped;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.python.lsp.core.type.LspCollectSupportedTypesVisitor;
import com.intellij.python.lsp.core.type.PyStringTypeResolver;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b'\u0018\u0000 (2\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\u001c\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0018\u00010\u001d2\u0011\u0010\u001e\u001a\r\u0012\u0004\u0012\u00020\u00140\u001f\u00a2\u0006\u0002\b H$J\u0018\u0010!\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020\u0014J\u0012\u0010#\u001a\u0004\u0018\u00010\u00152\u0006\u0010\"\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\u0014H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010'\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0015\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00150\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/python/lsp/core/type/LspTypeEvalContext;", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "getPsiFile", "()Lcom/intellij/psi/PsiFile;", "psiFileTimestamp", "", "stringTypeLocks", "Lcom/google/common/util/concurrent/Striped;", "Ljava/util/concurrent/locks/Lock;", "Lkotlin/jvm/internal/EnhancedNullability;", "requestedTypesCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "isFullLoaded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "cacheElementToStringType", "Ljava/util/WeakHashMap;", "Lcom/jetbrains/python/psi/PyTypedElement;", "", "cacheStringTypeToType", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lcom/intellij/openapi/util/Ref;", "Lcom/jetbrains/python/psi/types/PyType;", "unresolvedSet", "Ljava/util/concurrent/ConcurrentSkipListSet;", "requestTypes", "", "pyTypedElements", "", "Lorg/jetbrains/annotations/Unmodifiable;", "provideType", "element", "resolveTypeByLsp", "loadAllTypes", "", "loadSingleType", "typedElement", "Companion", "intellij.python.lsp.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nLspTypeEvalContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspTypeEvalContext.kt\ncom/intellij/python/lsp/core/type/LspTypeEvalContext\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,108:1\n23#2:109\n*S KotlinDebug\n*F\n+ 1 LspTypeEvalContext.kt\ncom/intellij/python/lsp/core/type/LspTypeEvalContext\n*L\n82#1:109\n*E\n"})
public abstract class LspTypeEvalContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile psiFile;
    private final long psiFileTimestamp;
    @NotNull
    private final Striped<Lock> stringTypeLocks;
    @NotNull
    private final AtomicInteger requestedTypesCount;
    @NotNull
    private final AtomicBoolean isFullLoaded;
    @NotNull
    private final WeakHashMap<PyTypedElement, String> cacheElementToStringType;
    @NotNull
    private final ConcurrentSkipListMap<String, Ref<PyType>> cacheStringTypeToType;
    @NotNull
    private final ConcurrentSkipListSet<String> unresolvedSet;
    private static final int FULL_LOAD_THRESHOLD = 10;

    public LspTypeEvalContext(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        this.psiFile = psiFile;
        this.psiFileTimestamp = this.psiFile.getModificationStamp();
        Striped striped = Striped.lock((int)64);
        Intrinsics.checkNotNullExpressionValue((Object)striped, (String)"lock(...)");
        this.stringTypeLocks = striped;
        this.requestedTypesCount = new AtomicInteger(0);
        this.isFullLoaded = new AtomicBoolean(false);
        this.cacheElementToStringType = new WeakHashMap();
        this.cacheStringTypeToType = new ConcurrentSkipListMap();
        this.unresolvedSet = new ConcurrentSkipListSet();
    }

    @NotNull
    public final PsiFile getPsiFile() {
        return this.psiFile;
    }

    @Nullable
    protected abstract List<String> requestTypes(@NotNull Collection<? extends PyTypedElement> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Ref<PyType> provideType(@NotNull PyTypedElement element) {
        Ref<PyType> ref;
        String stringType;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        String string = this.cacheElementToStringType.get(element);
        if (string == null) {
            string = this.resolveTypeByLsp(element);
        }
        if ((stringType = string) == null) {
            return null;
        }
        Object object = this.stringTypeLocks.get((Object)stringType);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Lock lock = (Lock)object;
        lock.lock();
        try {
            Ref<PyType> ref2;
            boolean bl = false;
            if (this.unresolvedSet.contains(stringType)) {
                ref2 = null;
            } else {
                Ref<PyType> cachedResolved = this.cacheStringTypeToType.get(stringType);
                if (cachedResolved != null) {
                    ref2 = cachedResolved;
                } else {
                    Ref<PyType> resolvedType = PyStringTypeResolver.INSTANCE.resolvePyType((PsiElement)element, stringType);
                    if (resolvedType != null) {
                        ((Map)this.cacheStringTypeToType).put(stringType, resolvedType);
                    } else {
                        this.unresolvedSet.add(stringType);
                    }
                    ref2 = resolvedType;
                }
            }
            ref = ref2;
        }
        finally {
            lock.unlock();
        }
        return ref;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String resolveTypeByLsp(PyTypedElement element) {
        String string;
        if (this.requestedTypesCount.incrementAndGet() >= 10 && !ApplicationManager.getApplication().isDispatchThread()) {
            LspTypeEvalContext lspTypeEvalContext = this;
            synchronized (lspTypeEvalContext) {
                boolean $i$a$-synchronized-LspTypeEvalContext$resolveTypeByLsp$32 = false;
                this.loadAllTypes(element);
                Unit $i$a$-synchronized-LspTypeEvalContext$resolveTypeByLsp$32 = Unit.INSTANCE;
            }
            string = this.cacheElementToStringType.get(element);
        } else {
            PyTypedElement pyTypedElement = element;
            synchronized (pyTypedElement) {
                boolean bl = false;
                String string2 = this.loadSingleType(element);
                // MONITOREXIT @DISABLED, blocks:[1, 2, 6] lbl23 : MonitorExitStatement: MONITOREXIT : var2_3
                string = string2;
            }
        }
        return string;
    }

    private final void loadAllTypes(PyTypedElement element) {
        if (this.isFullLoaded.get()) {
            return;
        }
        Iterable iterable = Companion.collectElementsForCalculation((PsiElement)element);
        Set<PyTypedElement> set = this.cacheElementToStringType.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        List requestedTypes = CollectionsKt.minus((Iterable)iterable, (Iterable)set);
        if (requestedTypes.isEmpty()) {
            return;
        }
        List<String> contents = this.requestTypes(requestedTypes);
        if (contents == null) {
            LspTypeEvalContext $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(LspTypeEvalContext.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to load all types for " + this.psiFile.getName() + " Current stamp " + this.psiFile.getModificationStamp() + " calculating: " + this.psiFileTimestamp);
            return;
        }
        MapsKt.putAll((Map)this.cacheElementToStringType, (Iterable)CollectionsKt.zip((Iterable)requestedTypes, (Iterable)contents));
        this.isFullLoaded.set(true);
    }

    private final String loadSingleType(PyTypedElement typedElement) {
        List<String> types = this.requestTypes(CollectionsKt.listOf((Object)typedElement));
        Collection collection = types;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        String string = (String)CollectionsKt.single(types);
        if (string == null) {
            string = "";
        }
        String resolvedType = string;
        ((Map)this.cacheElementToStringType).put(typedElement, resolvedType);
        return resolvedType;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/python/lsp/core/type/LspTypeEvalContext$Companion;", "", "<init>", "()V", "FULL_LOAD_THRESHOLD", "", "collectElementsForCalculation", "", "Lcom/jetbrains/python/psi/PyTypedElement;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.python.lsp.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<PyTypedElement> collectElementsForCalculation(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            PsiFile psiFile = element.getContainingFile();
            if (psiFile == null) {
                return CollectionsKt.emptyList();
            }
            PsiFile psiFile2 = psiFile;
            LspCollectSupportedTypesVisitor visitor = new LspCollectSupportedTypesVisitor();
            psiFile2.acceptChildren((PsiElementVisitor)visitor);
            return visitor.getResult();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

