/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.python.lsp.core.PyLspToolUtil;
import com.intellij.python.ruff.PythonRuffIcons;
import com.intellij.python.ruff.RuffConfiguration;
import com.intellij.util.IconUtil;
import com.jetbrains.python.externaltools.PyLspTool;
import com.jetbrains.python.externaltools.configuration.PyLspToolConfiguration;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/python/ruff/RuffUtil;", "", "<init>", "()V", "RUFF_WEBSITE", "", "getDefaultRuffIcon", "Ljavax/swing/Icon;", "getRuffExecutable", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffUtil.kt\ncom/intellij/python/ruff/RuffUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,21:1\n30#2,2:22\n*S KotlinDebug\n*F\n+ 1 RuffUtil.kt\ncom/intellij/python/ruff/RuffUtil\n*L\n19#1:22,2\n*E\n"})
public final class RuffUtil {
    @NotNull
    public static final RuffUtil INSTANCE = new RuffUtil();
    @NotNull
    public static final String RUFF_WEBSITE = "https://docs.astral.sh/ruff";

    private RuffUtil() {
    }

    @NotNull
    public final Icon getDefaultRuffIcon() {
        Icon icon = PythonRuffIcons.Ruff;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Ruff");
        return IconUtil.resizeSquared((Icon)icon, (int)16);
    }

    @Nullable
    public final Path getRuffExecutable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<RuffConfiguration> serviceClass$iv = RuffConfiguration.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return PyLspToolUtil.INSTANCE.findExecutable((PyLspToolConfiguration)object, project, CollectionsKt.listOf((Object)PyLspTool.RUFF.getPackageName()));
    }
}

