/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.codeInsight.completion.BaseCompletionService;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProcess;
import com.intellij.codeInsight.completion.CompletionProcessEx;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.python.ruff.RuffConfigOptionInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.codeinsight.RuffConfigOptionDocumentationProviderKt;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlTableHeader;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J6\u0010\f\u001a\u00020\u00062\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffConfigOptionCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "addGroupSegments", "prefixParts", "", "", "configGroups", "", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffConfigOptionCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffConfigOptionCompletionContributor.kt\ncom/intellij/python/ruff/codeinsight/RuffConfigOptionCompletionProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,130:1\n30#2,2:131\n*S KotlinDebug\n*F\n+ 1 RuffConfigOptionCompletionContributor.kt\ncom/intellij/python/ruff/codeinsight/RuffConfigOptionCompletionProvider\n*L\n47#1:131,2\n*E\n"})
final class RuffConfigOptionCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        Project project = parameters.getPosition().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<RuffService> serviceClass$iv = RuffService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        RuffService ruffService = (RuffService)object;
        Map<String, RuffConfigOptionInfo> configOptions = ruffService.getConfigOptions();
        Set<String> configGroups = ruffService.getConfigOptionGroups();
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        if (RuffConfigOptionCompletionProvider.addCompletions$completeInsideTableHeader(position, this, parameters, result, configGroups)) {
            return;
        }
        if (RuffConfigOptionCompletionProvider.addCompletions$completeInTableBody(position, this, parameters, result, configGroups, configOptions)) {
            return;
        }
    }

    private final void addGroupSegments(List<String> prefixParts, CompletionParameters parameters, CompletionResultSet result, Set<String> configGroups) {
        CompletionProcess completionProcess = parameters.getProcess();
        Intrinsics.checkNotNull((Object)completionProcess, (String)"null cannot be cast to non-null type com.intellij.codeInsight.completion.CompletionProcessEx");
        ((CompletionProcessEx)completionProcess).putUserData(BaseCompletionService.FORBID_WORD_COMPLETION, (Object)true);
        result.stopHere();
        for (String option : configGroups) {
            char[] cArray;
            List optionParts = StringsKt.split$default((CharSequence)option, (char[])(cArray = new char[]{'.'}), (boolean)false, (int)0, (int)6, null);
            if (optionParts.size() != prefixParts.size() + 1 || !Intrinsics.areEqual((Object)CollectionsKt.take((Iterable)optionParts, (int)Math.max(0, prefixParts.size() - 1)), (Object)CollectionsKt.dropLast(prefixParts, (int)1))) continue;
            String segment = (String)CollectionsKt.last((List)optionParts);
            result.addElement((LookupElement)LookupElementBuilder.create((String)segment).withCaseSensitivity(false));
        }
    }

    static /* synthetic */ void addGroupSegments$default(RuffConfigOptionCompletionProvider ruffConfigOptionCompletionProvider, List list, CompletionParameters completionParameters, CompletionResultSet completionResultSet, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        ruffConfigOptionCompletionProvider.addGroupSegments(list, completionParameters, completionResultSet, set);
    }

    private static final boolean addCompletions$completeInsideTableHeader(PsiElement position, RuffConfigOptionCompletionProvider this$0, CompletionParameters $parameters, CompletionResultSet $result, Set<String> configGroups) {
        List list;
        PsiElement e;
        for (e = position; e != null && !(e instanceof TomlTableHeader); e = e.getParent()) {
        }
        TomlTableHeader tomlTableHeader = (TomlTableHeader)e;
        if (tomlTableHeader == null) {
            return false;
        }
        TomlTableHeader header = tomlTableHeader;
        TomlKey tomlKey = header.getKey();
        if (tomlKey == null) {
            return true;
        }
        TomlKey key = tomlKey;
        String full = key.getText();
        if (Intrinsics.areEqual((Object)header.getContainingFile().getName(), (Object)"pyproject.toml")) {
            Intrinsics.checkNotNull((Object)full);
            if (!StringsKt.startsWith$default((String)full, (String)"tool.ruff", (boolean)false, (int)2, null)) {
                return true;
            }
        }
        Intrinsics.checkNotNull((Object)full);
        char[] cArray = new char[]{'.'};
        String ruffPathRaw = StringsKt.trimStart((String)StringsKt.removePrefix((String)full, (CharSequence)"tool.ruff"), (char[])cArray);
        if (((CharSequence)ruffPathRaw).length() == 0) {
            list = CollectionsKt.emptyList();
        } else {
            char[] cArray2 = new char[]{'.'};
            list = StringsKt.split$default((CharSequence)ruffPathRaw, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
        }
        List parts = list;
        List prefixParts = parts.isEmpty() ? CollectionsKt.emptyList() : CollectionsKt.dropLast((List)parts, (int)1);
        this$0.addGroupSegments(prefixParts, $parameters, $result, configGroups);
        return true;
    }

    private static final boolean addCompletions$completeInTableBody(PsiElement position, RuffConfigOptionCompletionProvider this$0, CompletionParameters $parameters, CompletionResultSet $result, Set<String> configGroups, Map<String, RuffConfigOptionInfo> configOptions) {
        Object object;
        List list;
        if (!(position.getParent() instanceof TomlKeySegment)) {
            return false;
        }
        for (PsiElement e = position; e != null && !(e instanceof TomlTable); e = e.getParent()) {
        }
        PsiElement psiElement = position.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlKeySegment");
        String string = RuffConfigOptionDocumentationProviderKt.getFullName((TomlKeySegment)psiElement);
        if (string == null) {
            return false;
        }
        String full = string;
        if (Intrinsics.areEqual((Object)position.getContainingFile().getName(), (Object)"pyproject.toml") && !StringsKt.startsWith$default((String)full, (String)"tool.ruff", (boolean)false, (int)2, null)) {
            return false;
        }
        char[] cArray = new char[]{'.'};
        String ruffPathRaw = StringsKt.trimStart((String)StringsKt.removePrefix((String)full, (CharSequence)"tool.ruff"), (char[])cArray);
        if (((CharSequence)ruffPathRaw).length() == 0) {
            list = CollectionsKt.emptyList();
        } else {
            object = new char[]{'.'};
            list = CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)ruffPathRaw, (char[])object, (boolean)false, (int)0, (int)6, null), (int)1);
        }
        List prefixParts = list;
        this$0.addGroupSegments(prefixParts, $parameters, $result, configGroups);
        object = configOptions.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String path = (String)entry.getKey();
            RuffConfigOptionInfo configInfo = (RuffConfigOptionInfo)entry.getValue();
            char[] cArray2 = new char[]{'.'};
            List parts = StringsKt.split$default((CharSequence)path, (char[])cArray2, (boolean)false, (int)0, (int)6, null);
            if (!Intrinsics.areEqual((Object)CollectionsKt.dropLast((List)parts, (int)1), (Object)prefixParts)) continue;
            String segment = (String)CollectionsKt.last((List)parts);
            $result.addElement((LookupElement)LookupElementBuilder.create((String)segment).withCaseSensitivity(false).withTypeText(configInfo.getValueType(), true).withTailText(" default: " + configInfo.getDefault(), true));
        }
        return true;
    }
}

