/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.codeinsight.RuffDocumentationUtil;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyFile;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlLiteral;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J%\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001d\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0010J\u001d\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/intellij/python/ruff/codeinsight/RuffErrorCodeReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "acceptsTarget", "", "target", "Lcom/intellij/psi/PsiElement;", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "handleTomlFile", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "handlePythonFile", "sourceElement", "createWebReference", "errorCode", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffErrorCodeGotoDeclarationHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffErrorCodeGotoDeclarationHandler.kt\ncom/intellij/python/ruff/codeinsight/RuffErrorCodeReferenceProvider\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,123:1\n37#2,2:124\n30#3,2:126\n654#4,5:128\n*S KotlinDebug\n*F\n+ 1 RuffErrorCodeGotoDeclarationHandler.kt\ncom/intellij/python/ruff/codeinsight/RuffErrorCodeReferenceProvider\n*L\n96#1:124,2\n100#1:126,2\n105#1:128,5\n*E\n"})
public final class RuffErrorCodeReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final RuffErrorCodeReferenceProvider INSTANCE = new RuffErrorCodeReferenceProvider();

    private RuffErrorCodeReferenceProvider() {
    }

    public boolean acceptsTarget(@NotNull PsiElement target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return false;
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiFile psiFile = element.getContainingFile();
        if ((psiFile instanceof PyFile ? this.handlePythonFile(element) : (psiReferenceArray = psiFile instanceof TomlFile ? this.handleTomlFile(element) : null)) == null) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        }
        return psiReferenceArray;
    }

    private final PsiReference[] handleTomlFile(PsiElement element) {
        TomlLiteral tomlLiteral;
        if (element instanceof TomlLiteral) {
            tomlLiteral = (TomlLiteral)element;
        } else if (element.getParent() instanceof TomlLiteral) {
            PsiElement psiElement = element.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlLiteral");
            tomlLiteral = (TomlLiteral)psiElement;
        } else {
            return null;
        }
        TomlLiteral literal = tomlLiteral;
        String string = literal.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        Object[] objectArray = new char[]{'\"', '\''};
        String text = StringsKt.trim((String)string, (char[])objectArray);
        if (!RuffDocumentationUtil.INSTANCE.getCODE_PATTERN().matches((CharSequence)text) && !RuffDocumentationUtil.INSTANCE.getRUFF_LINTER_PATTERN().matches((CharSequence)text)) {
            return null;
        }
        if (!RuffDocumentationUtil.INSTANCE.isRuffCodeElement(literal)) {
            return null;
        }
        objectArray = new PsiReference[1];
        objectArray[0] = (char)RuffErrorCodeReferenceProvider.createWebReference$default(this, (PsiElement)literal, text, null, 4, null);
        return objectArray;
    }

    private final PsiReference[] handlePythonFile(PsiElement sourceElement) {
        PsiComment psiComment;
        if (sourceElement instanceof PsiComment) {
            psiComment = (PsiComment)sourceElement;
        } else if (sourceElement.getParent() instanceof PsiComment) {
            PsiElement psiElement = sourceElement.getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiComment");
            psiComment = (PsiComment)psiElement;
        } else {
            return null;
        }
        PsiComment comment = psiComment;
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)comment)), (Object)PyTokenTypes.END_OF_LINE_COMMENT)) {
            return null;
        }
        Regex regex = RuffDocumentationUtil.INSTANCE.getSUPPRESSION_PATTERN();
        String string = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = match.getGroups().get(1);
        if (matchGroup == null) {
            return null;
        }
        MatchGroup allCodesGroup = matchGroup;
        Regex regex2 = RuffDocumentationUtil.INSTANCE.getCODE_PATTERN();
        String string2 = comment.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        Collection $this$toTypedArray$iv = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)regex2.findAll((CharSequence)string2, allCodesGroup.getRange().getFirst()), arg_0 -> RuffErrorCodeReferenceProvider.handlePythonFile$lambda$0(comment, arg_0)));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PsiReference[0]);
    }

    private final PsiReference createWebReference(PsiElement element, String errorCode, TextRange textRange) {
        WebReference webReference;
        Object object;
        block8: {
            String string;
            String string2;
            RuffService ruffService;
            block6: {
                block7: {
                    Project project = element.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    ComponentManager $this$service$iv = (ComponentManager)project;
                    boolean $i$f$service = false;
                    Class<RuffService> serviceClass$iv = RuffService.class;
                    Object object2 = $this$service$iv.getService(serviceClass$iv);
                    if (object2 == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    ruffService = (RuffService)object2;
                    object = ruffService.getRuleInformation().get(errorCode);
                    if (object == null) break block7;
                    RuffRuleInfo it = object;
                    boolean bl = false;
                    String string3 = "https://docs.astral.sh/ruff/rules/" + it.getName() + "/";
                    object = string3;
                    if (string3 != null) break block8;
                }
                RuffErrorCodeReferenceProvider $this$createWebReference_u24lambda_u241 = this;
                boolean bl = false;
                String $this$takeWhile$iv = errorCode;
                boolean $i$f$takeWhile = false;
                int n = $this$takeWhile$iv.length();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    char it = $this$takeWhile$iv.charAt(index$iv);
                    boolean bl2 = false;
                    if (Character.isLetter(it)) continue;
                    String string4 = $this$takeWhile$iv;
                    int n2 = 0;
                    String string5 = string4.substring(n2, index$iv);
                    string2 = string5;
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    break block6;
                }
                string2 = $this$takeWhile$iv;
            }
            String linterCode = string2;
            String string6 = ruffService.getLinterInformation().get(linterCode);
            if (string6 != null) {
                String linterName = string6;
                boolean bl = false;
                String string7 = linterName.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                String string8 = StringsKt.replace$default((String)string7, (String)" ", (String)"-", (boolean)false, (int)4, null);
                String string9 = linterCode.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
                string = "https://docs.astral.sh/ruff/rules/#" + string8 + "-" + string9;
            } else {
                string = null;
            }
            object = string;
            if (string == null) {
                object = "https://docs.astral.sh/ruff/rules/";
            }
        }
        Object url = object;
        WebReference $this$createWebReference_u24lambda_u242 = webReference = new WebReference(element, textRange, (String)url);
        boolean bl = false;
        $this$createWebReference_u24lambda_u242.setHighlight(false);
        return (PsiReference)webReference;
    }

    static /* synthetic */ PsiReference createWebReference$default(RuffErrorCodeReferenceProvider ruffErrorCodeReferenceProvider, PsiElement psiElement, String string, TextRange textRange, int n, Object object) {
        if ((n & 4) != 0) {
            textRange = null;
        }
        return ruffErrorCodeReferenceProvider.createWebReference(psiElement, string, textRange);
    }

    private static final PsiReference handlePythonFile$lambda$0(PsiComment $comment, MatchResult code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        return INSTANCE.createWebReference((PsiElement)$comment, code.getValue(), new TextRange(code.getRange().getFirst(), code.getRange().getLast() + 1));
    }
}

