/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.server;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspFormattingSupport;
import com.intellij.python.lsp.core.PyLspService;
import com.intellij.python.lsp.core.PyLspToolCustomization;
import com.intellij.python.lsp.core.PyLspToolDescriptor;
import com.intellij.python.ruff.RuffBundle;
import com.intellij.python.ruff.RuffConfigurable;
import com.intellij.python.ruff.RuffConfiguration;
import com.intellij.python.ruff.RuffRuleInfo;
import com.intellij.python.ruff.RuffService;
import com.intellij.python.ruff.RuffUtil;
import com.intellij.python.ruff.codeinsight.actions.RuffDisableRuleForFileIntentionAction;
import com.intellij.python.ruff.codeinsight.actions.RuffDisableRuleIntentionAction;
import com.intellij.python.ruff.server.RuffLspServerDescriptor;
import com.jetbrains.python.externaltools.PyLspTool;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.InitializeResult;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001c\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\"\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0018\u0010\u001a\u001a\u00060\u001bR\u00020\u0001X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lcom/intellij/python/ruff/server/RuffLspServerDescriptor;", "Lcom/intellij/python/lsp/core/PyLspToolDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "toolConfig", "Lcom/intellij/python/ruff/RuffConfiguration;", "getToolConfig", "()Lcom/intellij/python/ruff/RuffConfiguration;", "lspArguments", "", "", "configurableClass", "Ljava/lang/Class;", "Lcom/intellij/openapi/options/Configurable;", "getConfigurableClass", "()Ljava/lang/Class;", "lspCustomization", "Lcom/intellij/python/lsp/core/PyLspToolCustomization;", "getLspCustomization", "()Lcom/intellij/python/lsp/core/PyLspToolCustomization;", "commandDescriptions", "", "getCommandDescriptions", "()Ljava/util/Map;", "lspServerListener", "Lcom/intellij/python/lsp/core/PyLspToolDescriptor$PyLspToolDescriptorLspServerListener;", "getLspServerListener", "()Lcom/intellij/python/lsp/core/PyLspToolDescriptor$PyLspToolDescriptorLspServerListener;", "Companion", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffLspServer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffLspServer.kt\ncom/intellij/python/ruff/server/RuffLspServerDescriptor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,135:1\n30#2,2:136\n13#3:138\n*S KotlinDebug\n*F\n+ 1 RuffLspServer.kt\ncom/intellij/python/ruff/server/RuffLspServerDescriptor\n*L\n46#1:136,2\n42#1:138\n*E\n"})
public final class RuffLspServerDescriptor
extends PyLspToolDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PyLspToolCustomization lspCustomization;
    @NotNull
    private final Map<String, String> commandDescriptions;
    @NotNull
    private final PyLspToolDescriptor.PyLspToolDescriptorLspServerListener lspServerListener;
    @NotNull
    private static final Logger LOG;

    public RuffLspServerDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, PyLspTool.RUFF);
        Pair[] pairArray = this.getToolConfig();
        this.lspCustomization = new PyLspToolCustomization(this, project, (RuffConfiguration)pairArray){
            private final lspCustomization.formattingCustomizer.1 formattingCustomizer;
            private final PyLspToolCustomization.PyLspToolDiagnosticsSupport diagnosticsSupport;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super($super_call_param$1);
                this.formattingCustomizer = new LspFormattingSupport($receiver){
                    final /* synthetic */ RuffLspServerDescriptor this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public boolean shouldFormatThisFileExclusivelyByServer(VirtualFile file, boolean ideCanFormatThisFileItself, boolean serverExplicitlyWantsToFormatThisFile) {
                        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                        return this.this$0.getToolConfig().getFormatting();
                    }
                };
                this.diagnosticsSupport = new PyLspToolCustomization.PyLspToolDiagnosticsSupport(this){
                    final /* synthetic */ lspCustomization.1 this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public List<IntentionAction> customizeQuickFixes(Diagnostic diagnostic, List<? extends IntentionAction> quickFixes) {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        PyLspToolCustomization.PyLspAction pyLspAction;
                        IntentionAction it;
                        IntentionAction it2;
                        int n;
                        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                        Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
                        Iterable $this$count$iv = quickFixes;
                        boolean $i$f$count = false;
                        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                            n = 0;
                        } else {
                            int count$iv = 0;
                            for (T element$iv : $this$count$iv) {
                                it2 = (IntentionAction)element$iv;
                                boolean bl = false;
                                String string = it2.getText();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                boolean bl2 = ((CharSequence)string).length() > 0;
                                if (!bl2 || ++count$iv >= 0) continue;
                                CollectionsKt.throwCountOverflow();
                            }
                            n = count$iv;
                        }
                        if (n > 1) {
                            Object v4;
                            block9: {
                                Iterable $this$firstOrNull$iv = quickFixes;
                                boolean $i$f$firstOrNull = false;
                                for (T element$iv : $this$firstOrNull$iv) {
                                    it2 = (IntentionAction)element$iv;
                                    boolean bl = false;
                                    String string = it2.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)": Disable for this line", (boolean)false, (int)2, null)) continue;
                                    v4 = element$iv;
                                    break block9;
                                }
                                v4 = null;
                            }
                            IntentionAction intentionAction = v4;
                            if (intentionAction != null) {
                                IntentionAction intentionAction2 = intentionAction;
                                lspCustomization.1 $i$f$firstOrNull = this.this$0;
                                it = intentionAction2;
                                boolean bl = false;
                                pyLspAction = new PyLspToolCustomization.PyLspAction($i$f$firstOrNull, diagnostic, it){

                                    public String getText() {
                                        return RuffBundle.INSTANCE.message("intention.name.disable.for.this.line", new Object[0]);
                                    }
                                };
                            } else {
                                pyLspAction = null;
                            }
                        } else {
                            pyLspAction = null;
                        }
                        PyLspToolCustomization.PyLspAction disableQuickFix2 = pyLspAction;
                        $this$count$iv = quickFixes;
                        lspCustomization.1 var5_6 = this.this$0;
                        boolean $i$f$mapNotNull = false;
                        it = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            PyLspToolCustomization.PyLspAction it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = iterator.next();
                            boolean bl = false;
                            IntentionAction quickfix = (IntentionAction)element$iv$iv;
                            boolean bl3 = false;
                            PyLspToolCustomization.PyLspAction pyLspAction2 = disableQuickFix2;
                            if ((quickfix == (pyLspAction2 != null ? pyLspAction2.getAction() : null) ? null : new PyLspToolCustomization.PyLspAction(var5_6, diagnostic, quickfix, disableQuickFix2){
                                final /* synthetic */ lspCustomization.1 this$0;
                                final /* synthetic */ Diagnostic $diagnostic;
                                final /* synthetic */ IntentionAction $quickfix;
                                final /* synthetic */ lspCustomization.diagnosticsSupport.customizeQuickFixes.disableQuickFix.3.1 $disableQuickFix;
                                {
                                    this.this$0 = $receiver;
                                    this.$diagnostic = $diagnostic;
                                    this.$quickfix = $quickfix;
                                    this.$disableQuickFix = $disableQuickFix;
                                    super($diagnostic, $quickfix);
                                }

                                public String getText() {
                                    String string = this.$quickfix.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                                    return this.this$0.quickFixMessage(string);
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public List<IntentionAction> getOptions() {
                                    void var3_3;
                                    List<IntentionAction> list = this.this$0.quickFixOptions(this.$diagnostic);
                                    lspCustomization.diagnosticsSupport.customizeQuickFixes.disableQuickFix.3.1 var2_2 = this.$disableQuickFix;
                                    List<IntentionAction> it = list;
                                    boolean bl = false;
                                    return var2_2 != null ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)var2_2), (Iterable)it) : var3_3;
                                }
                            }) == null) continue;
                            it$iv$iv = it$iv$iv;
                            boolean bl4 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        return (List)destination$iv$iv;
                    }
                };
            }

            public lspCustomization.formattingCustomizer.1 getFormattingCustomizer() {
                return this.formattingCustomizer;
            }

            protected PyLspToolCustomization.PyLspToolDiagnosticsSupport getDiagnosticsSupport() {
                return this.diagnosticsSupport;
            }

            public String codeCustomizer(@Nls String code) {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<RuffService> serviceClass$iv = RuffService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                Object object2 = ((RuffService)object).getRuleInformation().get(code);
                if (object2 == null || (object2 = ((RuffRuleInfo)object2).getName()) == null) {
                    object2 = code;
                }
                return object2;
            }

            public String quickFixMessage(String text) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                return new Regex("(?<=Ruff \\()(\\w+)").replace((CharSequence)text, arg_0 -> lspCustomization.1.quickFixMessage$lambda$0(this, arg_0));
            }

            public List<IntentionAction> quickFixOptions(Diagnostic diagnostic) {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                Object object = diagnostic.getCode();
                if (object == null || (object = object.get()) == null || (object = object.toString()) == null) {
                    return CollectionsKt.emptyList();
                }
                Object code = object;
                Object[] objectArray = new BaseIntentionAction[]{new RuffDisableRuleIntentionAction((String)code), new RuffDisableRuleForFileIntentionAction((String)code)};
                return CollectionsKt.listOf((Object[])objectArray);
            }

            private static final CharSequence quickFixMessage$lambda$0(lspCustomization.1 this$0, MatchResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this$0.codeCustomizer((String)it.getGroupValues().get(1));
            }
        };
        pairArray = new Pair[]{TuplesKt.to((Object)"ruff.applyFormat", (Object)"Format document"), TuplesKt.to((Object)"ruff.applyAutofix", null), TuplesKt.to((Object)"ruff.applyOrganizeImports", null), TuplesKt.to((Object)"ruff.printDebugInformation", (Object)"Print debug information")};
        this.commandDescriptions = MapsKt.mapOf((Pair[])pairArray);
        this.lspServerListener = new PyLspToolDescriptor.PyLspToolDescriptorLspServerListener(this, project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void serverInitialized(InitializeResult params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                super.serverInitialized(params);
                ComponentManager $this$service$iv = (ComponentManager)this.$project;
                boolean $i$f$service = false;
                Class<RuffService> serviceClass$iv = RuffService.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                RuffService service = (RuffService)object;
                Path path = RuffUtil.INSTANCE.getRuffExecutable(this.$project);
                if (path == null) {
                    return;
                }
                Path executablePath = path;
                ComponentManager $this$service$iv2 = (ComponentManager)this.$project;
                boolean $i$f$service2 = false;
                Class<PyLspService> serviceClass$iv2 = PyLspService.class;
                Object object2 = $this$service$iv2.getService(serviceClass$iv2);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv2, serviceClass$iv2);
                }
                BuildersKt.launch$default((CoroutineScope)((PyLspService)object2).getCs(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(service, executablePath, null){
                    int label;
                    final /* synthetic */ RuffService $service;
                    final /* synthetic */ Path $executablePath;
                    {
                        this.$service = $service;
                        this.$executablePath = $executablePath;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                try {
                                    this.$service.gatherRuleInformation(this.$executablePath);
                                    this.$service.gatherConfigOptionInformation(this.$executablePath);
                                }
                                catch (Exception e) {
                                    RuffLspServerDescriptor.access$getLOG$cp().warn("Failed to gather Ruff rule information", (Throwable)e);
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        };
    }

    @NotNull
    public RuffConfiguration getToolConfig() {
        ComponentManager $this$service$iv = (ComponentManager)this.getProject();
        boolean $i$f$service = false;
        Class<RuffConfiguration> serviceClass$iv = RuffConfiguration.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return (RuffConfiguration)((Object)object);
    }

    @Override
    @NotNull
    public List<String> lspArguments() {
        return CollectionsKt.listOf((Object)"server");
    }

    @Override
    @NotNull
    public Class<? extends Configurable> getConfigurableClass() {
        return RuffConfigurable.class;
    }

    @Override
    @NotNull
    public PyLspToolCustomization getLspCustomization() {
        return this.lspCustomization;
    }

    @Override
    @NotNull
    public Map<String, String> getCommandDescriptions() {
        return this.commandDescriptions;
    }

    @Override
    @NotNull
    public PyLspToolDescriptor.PyLspToolDescriptorLspServerListener getLspServerListener() {
        return this.lspServerListener;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RuffLspServerDescriptor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/ruff/server/RuffLspServerDescriptor$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.python.ruff"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

