/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.devkit.actions.scheme;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.devkit.StatisticsDevKitUtil;
import com.intellij.internal.statistic.devkit.actions.scheme.EditEventsTestSchemePanel;
import com.intellij.internal.statistic.eventLog.events.scheme.EventsSchemeBuilder;
import com.intellij.internal.statistic.eventLog.events.scheme.GroupDescriptor;
import com.intellij.internal.statistic.eventLog.validator.storage.GroupValidationTestRule;
import com.intellij.internal.statistic.eventLog.validator.storage.ValidationTestRulesPersistedStorage;
import com.intellij.internal.statistic.utils.StatisticsRecorderUtil;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.TextIcon;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.fus.reporting.model.metadata.EventGroupRemoteDescriptors;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0002\u0013\u0014B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "recorderId", "", "<init>", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "loadEventsScheme", "Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "project", "Lcom/intellij/openapi/project/Project;", "testSchemeStorage", "Lcom/intellij/internal/statistic/eventLog/validator/storage/ValidationTestRulesPersistedStorage;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "EventsTestScheme", "intellij.platform.statistics.devkit"})
@SourceDebugExtension(value={"SMAP\nEditEventsTestSchemeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditEventsTestSchemeAction.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction\n+ 2 progress.kt\ncom/intellij/openapi/progress/ProgressKt\n*L\n1#1,117:1\n46#2,6:118\n*S KotlinDebug\n*F\n+ 1 EditEventsTestSchemeAction.kt\ncom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction\n*L\n66#1:118,6\n*E\n"})
public final class EditEventsTestSchemeAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String recorderId;
    @NotNull
    private static final LayeredIcon ICON = new LayeredIcon(2);

    public EditEventsTestSchemeAction(@NotNull String recorderId) {
        Intrinsics.checkNotNullParameter((Object)recorderId, (String)"recorderId");
        super(ActionsBundle.messagePointer((String)"action.EditTestSchemeAction.text", (Object[])new Object[0]), ActionsBundle.messagePointer((String)"action.EditTestSchemeAction.description", (Object[])new Object[0]), (Icon)ICON);
        this.recorderId = recorderId;
    }

    public /* synthetic */ EditEventsTestSchemeAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void title$iv;
        void project$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        Project project3 = project;
        ValidationTestRulesPersistedStorage testSchemeStorage = ValidationTestRulesPersistedStorage.getTestStorage((String)this.recorderId, (boolean)true);
        if (testSchemeStorage == null) {
            String string = StatisticsBundle.message((String)"stats.cannot.find.test.scheme.storage", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            StatisticsDevKitUtil.INSTANCE.showNotification(project3, NotificationType.ERROR, string);
            return;
        }
        EventsTestScheme eventsTestScheme = this.loadEventsScheme(project3, testSchemeStorage);
        if (eventsTestScheme == null) {
            return;
        }
        EventsTestScheme scheme = eventsTestScheme;
        EditEventsTestSchemePanel editTestSchemePanel = new EditEventsTestSchemePanel(project3, scheme.getTestScheme(), scheme.getProductionGroups(), scheme.getGeneratedScheme());
        String string = StatisticsBundle.message((String)"stats.edit.test.scheme", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        DialogWrapper dialog = ComponentsKt.dialog$default((String)string, (JComponent)editTestSchemePanel, (boolean)true, (JComponent)editTestSchemePanel.getFocusedComponent(), (boolean)false, (Project)project3, null, null, null, null, () -> EditEventsTestSchemeAction.actionPerformed$lambda$0(editTestSchemePanel), (int)976, null);
        Disposer.register((Disposable)dialog.getDisposable(), (Disposable)editTestSchemePanel);
        if (!dialog.showAndGet()) {
            return;
        }
        String string2 = StatisticsBundle.message((String)"stats.updating.test.scheme", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String string3 = string2;
        Project project4 = project3;
        boolean cancellable$iv = false;
        boolean $i$f$runBackgroundableTask = false;
        ProgressManager.getInstance().run((Task)new Task.Backgroundable((Project)project$iv, (String)title$iv, cancellable$iv, testSchemeStorage, editTestSchemePanel, project3){
            final /* synthetic */ ValidationTestRulesPersistedStorage $testSchemeStorage$inlined;
            final /* synthetic */ EditEventsTestSchemePanel $editTestSchemePanel$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$testSchemeStorage$inlined = validationTestRulesPersistedStorage;
                this.$editTestSchemePanel$inlined = editEventsTestSchemePanel;
                this.$project$inlined = project;
                super($project, $title, $cancellable);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                ProgressIndicator it = indicator;
                boolean bl = false;
                try {
                    this.$testSchemeStorage$inlined.updateTestGroups(this.$editTestSchemePanel$inlined.getGroups());
                    String string = StatisticsBundle.message((String)"stats.test.scheme.was.updated", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.INFORMATION, string);
                }
                catch (IOException ex) {
                    Object[] objectArray = new Object[]{ex.getMessage()};
                    String string = StatisticsBundle.message((String)"stats.failed.updating.test.scheme.0", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    StatisticsDevKitUtil.INSTANCE.showNotification(this.$project$inlined, NotificationType.ERROR, string);
                }
            }
        });
    }

    private final EventsTestScheme loadEventsScheme(Project project, ValidationTestRulesPersistedStorage testSchemeStorage) {
        String string = StatisticsBundle.message((String)"stats.loading.test.scheme", (Object[])new Object[0]);
        return (EventsTestScheme)ProgressManager.getInstance().run((Task.WithResult)new Task.WithResult<EventsTestScheme, IOException>(project, testSchemeStorage, this, string){
            final /* synthetic */ ValidationTestRulesPersistedStorage $testSchemeStorage;
            final /* synthetic */ EditEventsTestSchemeAction this$0;
            {
                this.$testSchemeStorage = $testSchemeStorage;
                this.this$0 = $receiver;
                super($project, $super_call_param$1, true);
            }

            protected EventsTestScheme compute(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                List list = this.$testSchemeStorage.loadValidationTestRules();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"loadValidationTestRules(...)");
                List localGroups = list;
                if (indicator.isCanceled()) {
                    return null;
                }
                EventGroupRemoteDescriptors eventGroupRemoteDescriptors = this.$testSchemeStorage.loadProductionGroups();
                Intrinsics.checkNotNullExpressionValue((Object)eventGroupRemoteDescriptors, (String)"loadProductionGroups(...)");
                EventGroupRemoteDescriptors productionGroups = eventGroupRemoteDescriptors;
                if (indicator.isCanceled()) {
                    return null;
                }
                List eventsScheme = EventsSchemeBuilder.buildEventsScheme$default((String)EditEventsTestSchemeAction.access$getRecorderId$p(this.this$0), null, null, (int)6, null);
                return new EventsTestScheme(localGroups, productionGroups, eventsScheme);
            }
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(StatisticsRecorderUtil.isTestModeEnabled((String)this.recorderId));
        ValidationTestRulesPersistedStorage validationTestRulesPersistedStorage = ValidationTestRulesPersistedStorage.getTestStorage((String)this.recorderId, (boolean)true);
        int testSchemeSize = validationTestRulesPersistedStorage != null ? validationTestRulesPersistedStorage.size() : 0;
        String text = testSchemeSize < 100 ? String.valueOf(testSchemeSize) : "99+";
        TextIcon sizeCountIcon = new TextIcon(text, (Color)JBColor.DARK_GRAY, UIUtil.getLabelBackground(), 1);
        sizeCountIcon.setFont(new Font(StartupUiUtil.getLabelFont().getName(), 1, JBUIScale.scale((int)9)));
        sizeCountIcon.setInsets(1, 1, 0, 0);
        ICON.setIcon((Icon)sizeCountIcon, 1, JBUIScale.scale((int)10), JBUIScale.scale((int)10));
        e.getPresentation().setIcon((Icon)ICON);
    }

    private static final List actionPerformed$lambda$0(EditEventsTestSchemePanel $editTestSchemePanel) {
        return $editTestSchemePanel.validateGroups();
    }

    public EditEventsTestSchemeAction() {
        this(null, 1, null);
    }

    public static final /* synthetic */ String access$getRecorderId$p(EditEventsTestSchemeAction $this) {
        return $this.recorderId;
    }

    static {
        ICON.setIcon(AllIcons.Actions.Edit, 0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction$Companion;", "", "<init>", "()V", "ICON", "Lcom/intellij/ui/LayeredIcon;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0004\b\t\u0010\nR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/devkit/actions/scheme/EditEventsTestSchemeAction$EventsTestScheme;", "", "testScheme", "", "Lcom/intellij/internal/statistic/eventLog/validator/storage/GroupValidationTestRule;", "productionGroups", "Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "generatedScheme", "Lcom/intellij/internal/statistic/eventLog/events/scheme/GroupDescriptor;", "<init>", "(Ljava/util/List;Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;Ljava/util/List;)V", "getTestScheme", "()Ljava/util/List;", "getProductionGroups", "()Lcom/jetbrains/fus/reporting/model/metadata/EventGroupRemoteDescriptors;", "getGeneratedScheme", "intellij.platform.statistics.devkit"})
    public static final class EventsTestScheme {
        @NotNull
        private final List<GroupValidationTestRule> testScheme;
        @NotNull
        private final EventGroupRemoteDescriptors productionGroups;
        @NotNull
        private final List<GroupDescriptor> generatedScheme;

        public EventsTestScheme(@NotNull List<GroupValidationTestRule> testScheme, @NotNull EventGroupRemoteDescriptors productionGroups, @NotNull List<GroupDescriptor> generatedScheme) {
            Intrinsics.checkNotNullParameter(testScheme, (String)"testScheme");
            Intrinsics.checkNotNullParameter((Object)productionGroups, (String)"productionGroups");
            Intrinsics.checkNotNullParameter(generatedScheme, (String)"generatedScheme");
            this.testScheme = testScheme;
            this.productionGroups = productionGroups;
            this.generatedScheme = generatedScheme;
        }

        @NotNull
        public final List<GroupValidationTestRule> getTestScheme() {
            return this.testScheme;
        }

        @NotNull
        public final EventGroupRemoteDescriptors getProductionGroups() {
            return this.productionGroups;
        }

        @NotNull
        public final List<GroupDescriptor> getGeneratedScheme() {
            return this.generatedScheme;
        }
    }
}

