/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.ActiveRunnable;
import com.intellij.ui.DropAreaAware;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.tabs.JBTabsPresentation;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JBTabs
extends DropAreaAware {
    @NotNull
    public TabInfo addTab(TabInfo var1, int var2);

    @NotNull
    public TabInfo addTab(TabInfo var1);

    @NotNull
    public ActionCallback removeTab(@Nullable TabInfo var1);

    public void removeAllTabs();

    @NotNull
    public ActionCallback select(@NotNull TabInfo var1, boolean var2);

    @Nullable
    public TabInfo getSelectedInfo();

    @NotNull
    public TabInfo getTabAt(int var1);

    public int getTabCount();

    @NotNull
    public JBTabsPresentation getPresentation();

    @NotNull
    public List<TabInfo> getTabs();

    @Nullable
    public TabInfo getTargetInfo();

    @NotNull
    public JBTabs addTabMouseListener(@NotNull MouseListener var1);

    @NotNull
    public JBTabs removeTabMouseListener(@NotNull MouseListener var1);

    public JBTabs addListener(@NotNull TabsListener var1);

    public JBTabs addListener(@NotNull TabsListener var1, @Nullable Disposable var2);

    public JBTabs setSelectionChangeHandler(SelectionChangeHandler var1);

    @NotNull
    public JComponent getComponent();

    @Nullable
    public TabInfo findInfo(MouseEvent var1);

    @Nullable
    public TabInfo findInfo(Object var1);

    @Nullable
    public TabInfo findInfo(Component var1);

    public int getIndexOf(@NotNull TabInfo var1);

    public void requestFocus();

    public void setNavigationActionBinding(String var1, String var2);

    @NotNull
    public JBTabs setPopupGroup(@NotNull ActionGroup var1, @NotNull String var2, boolean var3);

    @NotNull
    public JBTabs setPopupGroup(@NotNull Supplier<? extends ActionGroup> var1, @NotNull String var2, boolean var3);

    public void resetDropOver(TabInfo var1);

    public Image startDropOver(TabInfo var1, RelativePoint var2);

    public void processDropOver(TabInfo var1, RelativePoint var2);

    @Nullable
    public Component getTabLabel(TabInfo var1);

    @Override
    @NotNull
    default public Rectangle getDropArea() {
        Rectangle r = new Rectangle(new Point(0, 0), this.getComponent().getSize());
        if (this.getTabCount() > 0) {
            JBInsets insets = JBUI.insets((int)0);
            Rectangle bounds = Objects.requireNonNull(this.getTabLabel(this.getTabAt(0))).getBounds();
            switch (this.getPresentation().getTabsPosition()) {
                case top: {
                    insets.top = bounds.height;
                    break;
                }
                case left: {
                    insets.left = bounds.width;
                    break;
                }
                case bottom: {
                    insets.bottom = bounds.height;
                    break;
                }
                case right: {
                    insets.right = bounds.width;
                }
            }
            JBInsets.removeFrom((Rectangle)r, (Insets)insets);
        }
        Rectangle rectangle = r;
        if (rectangle == null) {
            JBTabs.$$$reportNull$$$0(0);
        }
        return rectangle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/tabs/JBTabs", "getDropArea"));
    }

    public static interface SelectionChangeHandler {
        @NotNull
        public ActionCallback execute(TabInfo var1, boolean var2, @NotNull ActiveRunnable var3);
    }
}

