/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.NotNullizer;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u0000 \u0012*\u0004\b\u0000\u0010\u00012\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0002:\u0001\u0012B\u001f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\n\u0010\u000e\u001a\u00020\u000fH\u0096\u0080\u0004J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\u0004\u0018\u00018\u00008VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/RecursionPreventingSafePublicationLazy;", "T", "Lkotlin/Lazy;", "recursionKey", "", "initializer", "Lkotlin/Function0;", "<init>", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "valueRef", "Ljava/util/concurrent/atomic/AtomicReference;", "value", "getValue", "()Ljava/lang/Object;", "isInitialized", "", "toString", "", "Companion", "intellij.platform.util.ex"})
public final class RecursionPreventingSafePublicationLazy<T>
implements Lazy<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private volatile Function0<? extends T> initializer;
    @NotNull
    private final AtomicReference<T> valueRef;
    @NotNull
    private final Object recursionKey;
    @NotNull
    private static final RecursionGuard<Object> ourRecursionGuard;
    @NotNull
    private static final NotNullizer ourNotNullizer;

    public RecursionPreventingSafePublicationLazy(@Nullable Object recursionKey, @NotNull Function0<? extends T> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        this.initializer = () -> RecursionPreventingSafePublicationLazy.initializer$lambda$0(initializer);
        this.valueRef = new AtomicReference();
        Object object = recursionKey;
        if (object == null) {
            object = this;
        }
        this.recursionKey = object;
    }

    @Nullable
    public T getValue() {
        T computedValue = this.valueRef.get();
        if (computedValue != null) {
            return (T)ourNotNullizer.nullize(computedValue);
        }
        Function0<? extends T> initializerValue = this.initializer;
        if (initializerValue == null) {
            T t = this.valueRef.get();
            if (t == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return (T)ourNotNullizer.nullize(t);
        }
        RecursionGuard.StackStamp stackStamp = RecursionManager.markStack();
        Intrinsics.checkNotNullExpressionValue((Object)stackStamp, (String)"markStack(...)");
        RecursionGuard.StackStamp stamp = stackStamp;
        Object newValue = ourRecursionGuard.doPreventingRecursion(this.recursionKey, false, () -> RecursionPreventingSafePublicationLazy._get_value_$lambda$0(initializerValue));
        if (newValue == null) {
            return null;
        }
        if (!stamp.mayCacheNow()) {
            return (T)ourNotNullizer.nullize(newValue);
        }
        if (!this.valueRef.compareAndSet(null, newValue)) {
            T t = this.valueRef.get();
            if (t == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return (T)ourNotNullizer.nullize(t);
        }
        this.initializer = null;
        return (T)ourNotNullizer.nullize(newValue);
    }

    public boolean isInitialized() {
        return this.valueRef.get() != null;
    }

    @NotNull
    public String toString() {
        return this.isInitialized() ? String.valueOf(this.getValue()) : "Lazy value not initialized yet.";
    }

    private static final Object initializer$lambda$0(Function0 $initializer) {
        return ourNotNullizer.notNullize($initializer.invoke());
    }

    private static final Object _get_value_$lambda$0(Function0 $tmp0) {
        return $tmp0.invoke();
    }

    static {
        RecursionGuard recursionGuard = RecursionManager.createGuard((String)"RecursionPreventingSafePublicationLazy");
        Intrinsics.checkNotNullExpressionValue((Object)recursionGuard, (String)"createGuard(...)");
        ourRecursionGuard = recursionGuard;
        ourNotNullizer = new NotNullizer("RecursionPreventingSafePublicationLazy");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00010\u00010\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/util/RecursionPreventingSafePublicationLazy$Companion;", "", "<init>", "()V", "ourRecursionGuard", "Lcom/intellij/openapi/util/RecursionGuard;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "ourNotNullizer", "Lcom/intellij/util/NotNullizer;", "intellij.platform.util.ex"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

