/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remoteRunRuntime;

import com.intellij.codeWithMe.ClientId;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.remoteRunRuntime.RemoteDockerRuntime;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP, Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000f\u001a\u00020\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntimesManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "(Lkotlinx/coroutines/CoroutineScope;)V", "myCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/docker/DockerCloudConfiguration;", "Ljava/util/concurrent/Future;", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntime;", "createRuntime", "config", "dispose", "", "Companion", "intellij.clouds.docker"})
final class RemoteDockerRuntimesManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Project project;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConcurrentHashMap<DockerCloudConfiguration, Future<RemoteDockerRuntime>> myCache;

    public RemoteDockerRuntimesManager(@Nullable Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.project = project;
        this.scope = scope;
        this.myCache = new ConcurrentHashMap();
    }

    public RemoteDockerRuntimesManager(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this(null, scope);
    }

    @NotNull
    public final Future<RemoteDockerRuntime> createRuntime(@NotNull DockerCloudConfiguration config2) {
        Intrinsics.checkNotNullParameter((Object)((Object)config2), (String)"config");
        Future future = this.myCache.computeIfAbsent(config2, arg_0 -> RemoteDockerRuntimesManager.createRuntime$lambda$1(arg_0 -> RemoteDockerRuntimesManager.createRuntime$lambda$0(this, config2, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)future, (String)"computeIfAbsent(...)");
        return future;
    }

    public void dispose() {
        this.myCache.clear();
    }

    private static final RemoteDockerRuntime createRuntime$lambda$0$0(RemoteDockerRuntimesManager this$0, DockerCloudConfiguration $config, Throwable it) {
        this$0.myCache.remove((Object)$config);
        return null;
    }

    private static final Future createRuntime$lambda$0(RemoteDockerRuntimesManager this$0, DockerCloudConfiguration $config, DockerCloudConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        CompletableFuture<RemoteDockerRuntime> future = new RemoteDockerRuntime(it, this$0.project).connect$intellij_clouds_docker(this$0.scope);
        future.exceptionally(arg_0 -> RemoteDockerRuntimesManager.createRuntime$lambda$0$0(this$0, $config, arg_0));
        return future;
    }

    private static final Future createRuntime$lambda$1(Function1 $tmp0, Object p0) {
        return (Future)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntimesManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/docker/remoteRunRuntime/RemoteDockerRuntimesManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nRemoteDockerRuntime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteDockerRuntime.kt\ncom/intellij/docker/remoteRunRuntime/RemoteDockerRuntimesManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,238:1\n30#2,2:239\n42#3,3:241\n*S KotlinDebug\n*F\n+ 1 RemoteDockerRuntime.kt\ncom/intellij/docker/remoteRunRuntime/RemoteDockerRuntimesManager$Companion\n*L\n59#1:239,2\n59#1:241,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteDockerRuntimesManager getInstance(@Nullable Project project) {
            Object object;
            block6: {
                block5: {
                    object = project;
                    if (object == null) break block5;
                    ComponentManager $this$service$iv = (ComponentManager)object;
                    boolean $i$f$service = false;
                    Class<RemoteDockerRuntimesManager> serviceClass$iv = RemoteDockerRuntimesManager.class;
                    Object object2 = $this$service$iv.getService(serviceClass$iv);
                    if (object2 == null) {
                        throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                    }
                    object = (RemoteDockerRuntimesManager)object2;
                    if (object != null) break block6;
                }
                boolean $i$f$service = false;
                Class<RemoteDockerRuntimesManager> serviceClass$iv = RemoteDockerRuntimesManager.class;
                Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object3 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
                }
                object = (RemoteDockerRuntimesManager)object3;
            }
            return object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

