/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view.details;

import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.settings.DockerConsoleSettings;
import com.intellij.docker.ui.utils.DockerUiUtilsKt;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Insets;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u0014\u0010\u001f\u001a\u00020\u0016*\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u00020\u0016*\u00020 2\u0006\u0010$\u001a\u00020%H\u0002J$\u0010&\u001a\u00020\u0016*\u00020 2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006("}, d2={"Lcom/intellij/docker/view/details/DockerLogConsoleView;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "myConsoleSettings", "Lcom/intellij/docker/settings/DockerConsoleSettings;", "myShowFoldingActionGroup", "", "myShowTimestamps", "myShowPreviousSessions", "mySelectedFoldingPolicy", "Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$FoldingPolicy;", "value", "Ljava/time/ZonedDateTime;", "oldSessionEndDate", "getOldSessionEndDate", "()Ljava/time/ZonedDateTime;", "setOldSessionEndDate", "(Ljava/time/ZonedDateTime;)V", "dispose", "", "createConsoleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "()[Lcom/intellij/openapi/actionSystem/AnAction;", "updateFoldings", "startLine", "", "endLine", "showOldSessionLines", "Lcom/intellij/openapi/editor/ex/FoldingModelEx;", "document", "Lcom/intellij/openapi/editor/Document;", "hideTimestampsIfNeeded", "info", "Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$LineInfo;", "hideOldSessionLines", "Companion", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerLogConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView\n+ 2 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView$Companion\n*L\n1#1,317:1\n257#2:318\n257#2:319\n257#2:320\n257#2:321\n257#2:322\n*S KotlinDebug\n*F\n+ 1 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView\n*L\n250#1:318\n251#1:319\n252#1:320\n253#1:321\n254#1:322\n*E\n"})
public final class DockerLogConsoleView
extends ConsoleViewImpl {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerConsoleSettings myConsoleSettings;
    private volatile boolean myShowFoldingActionGroup;
    private volatile boolean myShowTimestamps;
    private volatile boolean myShowPreviousSessions;
    @NotNull
    private volatile Companion.FoldingPolicy mySelectedFoldingPolicy;
    @Nullable
    private ZonedDateTime oldSessionEndDate;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkYears = DockerLogConsoleView::checkYears$lambda$0;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkMonths;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkDays;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkHours;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkMinutes;
    @NotNull
    private static final Function2<ZonedDateTime, ZonedDateTime, Boolean> checkSeconds;

    public DockerLogConsoleView(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, false);
        this.myConsoleSettings = DockerConsoleSettings.Companion.getInstance();
        this.myShowFoldingActionGroup = this.myConsoleSettings.getEnableFoldingForLogConsole();
        this.mySelectedFoldingPolicy = Companion.FoldingPolicy.MINUTES;
        ActionsKt.runInEdt$default(null, () -> DockerLogConsoleView._init_$lambda$0(this), (int)1, null);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        boolean bl = false;
        connection.subscribe(DockerConsoleSettings.SettingsChangeListener.Companion.getTOPIC(), () -> DockerLogConsoleView.lambda$1$0(this));
    }

    @Nullable
    public final ZonedDateTime getOldSessionEndDate() {
        return this.oldSessionEndDate;
    }

    public final void setOldSessionEndDate(@Nullable ZonedDateTime value) {
        ZonedDateTime zonedDateTime = value;
        this.oldSessionEndDate = zonedDateTime != null ? zonedDateTime.plus(1L, ChronoUnit.NANOS) : null;
    }

    public void dispose() {
        ActionsKt.runInEdt$default(null, () -> DockerLogConsoleView.dispose$lambda$0(this), (int)1, null);
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        Object[] objectArray = DockerBundle.message((String)"DockerLogConsoleView.folding.action.title", (Object[])new Object[0]);
        ActionGroup group2 = new ActionGroup(this, (String)objectArray){
            final /* synthetic */ DockerLogConsoleView this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, true);
                this.getTemplatePresentation().setIcon(AllIcons.General.InspectionsEye);
            }

            public void update(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                e.getPresentation().setEnabledAndVisible(DockerLogConsoleView.access$getMyShowFoldingActionGroup$p(this.this$0));
            }

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }

            public AnAction[] getChildren(AnActionEvent e) {
                AnAction[] anActionArray = new AnAction[3];
                String string = DockerBundle.message((String)"DockerLogConsoleView.checkbox.show.previous.sessions.lines", (Object[])new Object[0]);
                anActionArray[0] = new ToggleAction(this.this$0, string){
                    final /* synthetic */ DockerLogConsoleView this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        DockerLogConsoleView.access$setMyShowPreviousSessions$p(this.this$0, state);
                        this.this$0.foldImmediately();
                    }

                    public void update(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        e.getPresentation().setEnabledAndVisible(this.this$0.getOldSessionEndDate() != null);
                        super.update(e);
                    }

                    public boolean isSelected(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        return DockerLogConsoleView.access$getMyShowPreviousSessions$p(this.this$0);
                    }

                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.BGT;
                    }
                };
                string = DockerBundle.message((String)"DockerLogConsoleView.checkbox.show.timestamps", (Object[])new Object[0]);
                anActionArray[1] = new ToggleAction(this.this$0, string){
                    final /* synthetic */ DockerLogConsoleView this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    public boolean isSelected(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        return DockerLogConsoleView.access$getMyShowTimestamps$p(this.this$0);
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        DockerLogConsoleView.access$setMyShowTimestamps$p(this.this$0, state);
                        this.this$0.foldImmediately();
                    }

                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.BGT;
                    }
                };
                string = DockerBundle.message((String)"DockerLogConsoleView.label.folding.for.previous.sessions.lines.by", (Object[])new Object[0]);
                anActionArray[2] = new DefaultActionGroup(this.this$0, string){
                    final /* synthetic */ DockerLogConsoleView this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1, true);
                    }

                    public void update(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        e.getPresentation().setEnabledAndVisible(DockerLogConsoleView.access$getMyShowPreviousSessions$p(this.this$0));
                    }

                    public ActionUpdateThread getActionUpdateThread() {
                        return ActionUpdateThread.BGT;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public AnAction[] getChildren(AnActionEvent e) {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        Iterable iterable = (Iterable)Companion.FoldingPolicy.getEntries();
                        DockerLogConsoleView dockerLogConsoleView = this.this$0;
                        boolean $i$f$map = false;
                        void var5_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            Companion.FoldingPolicy foldingPolicy = (Companion.FoldingPolicy)((Object)item$iv$iv);
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            String string = it.getLabel();
                            collection.add(new ToggleAction(dockerLogConsoleView, (Companion.FoldingPolicy)it, string){
                                final /* synthetic */ DockerLogConsoleView this$0;
                                final /* synthetic */ Companion.FoldingPolicy $it;
                                {
                                    this.this$0 = $receiver;
                                    this.$it = $it;
                                    super($super_call_param$1);
                                }

                                public void setSelected(AnActionEvent e, boolean state) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    DockerLogConsoleView.access$setMySelectedFoldingPolicy$p(this.this$0, this.$it);
                                    this.this$0.foldImmediately();
                                }

                                public boolean isSelected(AnActionEvent e) {
                                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                    return DockerLogConsoleView.access$getMySelectedFoldingPolicy$p(this.this$0) == this.$it;
                                }

                                public ActionUpdateThread getActionUpdateThread() {
                                    return ActionUpdateThread.BGT;
                                }
                            });
                        }
                        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        return thisCollection$iv.toArray(new AnAction[0]);
                    }
                };
                return anActionArray;
            }
        };
        objectArray = new AnAction[]{group2, new Separator()};
        return (AnAction[])ArraysKt.plus((Object[])objectArray, (Object[])super.createConsoleActions());
    }

    protected void updateFoldings(int startLine, int endLine) {
        FoldingModelEx foldingModel;
        super.updateFoldings(startLine, endLine);
        if (!this.myConsoleSettings.getEnableFoldingForLogConsole()) {
            return;
        }
        Editor editor = this.getEditor();
        Intrinsics.checkNotNull((Object)editor);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Editor editor2 = this.getEditor();
        Intrinsics.checkNotNull((Object)editor2);
        FoldingModel foldingModel2 = editor2.getFoldingModel();
        FoldingModelEx foldingModelEx = foldingModel = foldingModel2 instanceof FoldingModelEx ? (FoldingModelEx)foldingModel2 : null;
        if (foldingModel == null) {
            return;
        }
        foldingModel.runBatchFoldingOperation(() -> DockerLogConsoleView.updateFoldings$lambda$0(this, foldingModel, document2, startLine, endLine));
    }

    private final void showOldSessionLines(FoldingModelEx $this$showOldSessionLines, Document document) {
        Companion.FoldingPolicy foldingPolicy = this.mySelectedFoldingPolicy;
        Companion.LineInfo firstMatch = null;
        Integer lastMatchEnd = null;
        int n = document.getLineCount();
        for (int line = 0; line < n; ++line) {
            Companion.LineInfo lineInfo;
            if (DockerLogConsoleView.Companion.lineInfoFor(document, line) == null) continue;
            this.hideTimestampsIfNeeded($this$showOldSessionLines, lineInfo);
            if (foldingPolicy == Companion.FoldingPolicy.NONE || lineInfo.getTimestampText().compareTo(String.valueOf(this.oldSessionEndDate)) > 0) continue;
            if (firstMatch == null) {
                firstMatch = lineInfo;
                continue;
            }
            if (firstMatch.getTimestamp() == null || lineInfo.getTimestamp() == null) continue;
            ZonedDateTime zonedDateTime = lineInfo.getTimestamp();
            ZonedDateTime zonedDateTime2 = this.oldSessionEndDate;
            Intrinsics.checkNotNull((Object)zonedDateTime2);
            boolean isLastLine = Intrinsics.areEqual((Object)zonedDateTime, (Object)zonedDateTime2.minus(1L, ChronoUnit.NANOS));
            Function2<ZonedDateTime, ZonedDateTime, Boolean> function2 = foldingPolicy.getMatch();
            ZonedDateTime zonedDateTime3 = firstMatch.getTimestamp();
            Intrinsics.checkNotNull((Object)zonedDateTime3);
            ZonedDateTime zonedDateTime4 = lineInfo.getTimestamp();
            Intrinsics.checkNotNull((Object)zonedDateTime4);
            if (!((Boolean)function2.invoke((Object)zonedDateTime3, (Object)zonedDateTime4)).booleanValue() || isLastLine) {
                if (lastMatchEnd != null) {
                    int foldingEndOffset = isLastLine ? lineInfo.getEndOffset() : lastMatchEnd.intValue();
                    DockerLogConsoleView.Companion.collapse($this$showOldSessionLines.addFoldRegion(firstMatch.getStartOffset(), foldingEndOffset, DockerLogConsoleView.Companion.toPlaceholderText(firstMatch)));
                } else {
                    DockerLogConsoleView.Companion.collapse($this$showOldSessionLines.addFoldRegion(firstMatch.getStartOffset(), firstMatch.getEndOffset(), DockerLogConsoleView.Companion.toPlaceholderText(firstMatch)));
                }
                firstMatch = lineInfo;
                lastMatchEnd = null;
                continue;
            }
            lastMatchEnd = lineInfo.getEndOffset();
        }
    }

    private final void hideTimestampsIfNeeded(FoldingModelEx $this$hideTimestampsIfNeeded, Companion.LineInfo info) {
        block2: {
            if (this.myShowTimestamps) break block2;
            int n = info.getStartOffset() + info.getTimestampText().length() + 1;
            Editor editor = this.getEditor();
            Intrinsics.checkNotNull((Object)editor);
            int endOffset = Math.min(n, editor.getDocument().getTextLength());
            FoldRegion oldRegion = $this$hideTimestampsIfNeeded.getFoldRegion(info.getStartOffset(), endOffset);
            if (oldRegion == null) {
                FoldRegion foldRegion = $this$hideTimestampsIfNeeded.createFoldRegion(info.getStartOffset(), endOffset, "", null, true);
                if (foldRegion != null) {
                    FoldRegion it = foldRegion;
                    boolean bl = false;
                    it.setExpanded(false);
                }
            }
        }
    }

    private final void hideOldSessionLines(FoldingModelEx $this$hideOldSessionLines, int startLine, int endLine, Document document) {
        int line = startLine;
        if (line <= endLine) {
            while (true) {
                if (DockerLogConsoleView.Companion.lineInfoFor(document, line) != null) {
                    Companion.LineInfo lineInfo;
                    int endOffset = Math.min(lineInfo.getEndOffset() + 1, document.getTextLength());
                    if (this.oldSessionEndDate != null && lineInfo.getTimestampText().compareTo(String.valueOf(this.oldSessionEndDate)) <= 0) {
                        DockerLogConsoleView.Companion.collapse($this$hideOldSessionLines.createFoldRegion(lineInfo.getStartOffset(), endOffset, "", null, true));
                    }
                    this.hideTimestampsIfNeeded($this$hideOldSessionLines, lineInfo);
                }
                if (line == endLine) break;
                ++line;
            }
        }
    }

    private static final void lambda$1$0(DockerLogConsoleView this$0) {
        this$0.myShowFoldingActionGroup = this$0.myConsoleSettings.getEnableFoldingForLogConsole();
        this$0.foldImmediately();
    }

    private static final Unit _init_$lambda$0(DockerLogConsoleView this$0) {
        block0: {
            this$0.getComponent();
            Editor editor = this$0.getEditor();
            Object object = editor instanceof EditorEx ? (EditorEx)editor : null;
            if (object == null || (object = object.getScrollPane()) == null) break block0;
            JComponent jComponent = (JComponent)object;
            JBInsets jBInsets = JBUI.insetsRight((int)1);
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insetsRight(...)");
            JScrollPane cfr_ignored_0 = (JScrollPane)DockerUiUtilsKt.withBorder(jComponent, (Insets)jBInsets);
        }
        return Unit.INSTANCE;
    }

    private static final Unit dispose$lambda$0(DockerLogConsoleView this$0) {
        super.dispose();
        return Unit.INSTANCE;
    }

    private static final void updateFoldings$lambda$0(DockerLogConsoleView this$0, FoldingModelEx $foldingModel, Document $document, int $startLine, int $endLine) {
        if (this$0.myShowPreviousSessions) {
            this$0.showOldSessionLines($foldingModel, $document);
        } else {
            this$0.hideOldSessionLines($foldingModel, $startLine, $endLine, $document);
        }
    }

    private static final boolean checkYears$lambda$0(ZonedDateTime d1, ZonedDateTime d2) {
        Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
        Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
        return d1.getYear() == d2.getYear();
    }

    public static final /* synthetic */ boolean access$getMyShowFoldingActionGroup$p(DockerLogConsoleView $this) {
        return $this.myShowFoldingActionGroup;
    }

    public static final /* synthetic */ void access$setMyShowPreviousSessions$p(DockerLogConsoleView $this, boolean bl) {
        $this.myShowPreviousSessions = bl;
    }

    public static final /* synthetic */ boolean access$getMyShowPreviousSessions$p(DockerLogConsoleView $this) {
        return $this.myShowPreviousSessions;
    }

    public static final /* synthetic */ boolean access$getMyShowTimestamps$p(DockerLogConsoleView $this) {
        return $this.myShowTimestamps;
    }

    public static final /* synthetic */ void access$setMyShowTimestamps$p(DockerLogConsoleView $this, boolean bl) {
        $this.myShowTimestamps = bl;
    }

    public static final /* synthetic */ void access$setMySelectedFoldingPolicy$p(DockerLogConsoleView $this, Companion.FoldingPolicy foldingPolicy) {
        $this.mySelectedFoldingPolicy = foldingPolicy;
    }

    public static final /* synthetic */ Companion.FoldingPolicy access$getMySelectedFoldingPolicy$p(DockerLogConsoleView $this) {
        return $this.mySelectedFoldingPolicy;
    }

    static {
        Companion companion = Companion;
        Function2<ZonedDateTime, ZonedDateTime, Boolean> $this$thenCheck$iv = checkYears;
        boolean $i$f$thenCheck = false;
        checkMonths = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(ZonedDateTime d1, ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getMonth() == d22.getMonth()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        Companion this_$iv = Companion;
        $this$thenCheck$iv = checkMonths;
        $i$f$thenCheck = false;
        checkDays = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(ZonedDateTime d1, ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getDayOfMonth() == d22.getDayOfMonth()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        this_$iv = Companion;
        $this$thenCheck$iv = checkDays;
        $i$f$thenCheck = false;
        checkHours = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(ZonedDateTime d1, ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getHour() == d22.getHour()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        this_$iv = Companion;
        $this$thenCheck$iv = checkHours;
        $i$f$thenCheck = false;
        checkMinutes = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(ZonedDateTime d1, ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getMinute() == d22.getMinute()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
        this_$iv = Companion;
        $this$thenCheck$iv = checkMinutes;
        $i$f$thenCheck = false;
        checkSeconds = (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck$iv){
            final /* synthetic */ Function2 $this_thenCheck;
            {
                this.$this_thenCheck = $receiver;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(ZonedDateTime d1, ZonedDateTime d2) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                if (((Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2)).booleanValue()) {
                    void d22;
                    ZonedDateTime zonedDateTime = d2;
                    ZonedDateTime d12 = d1;
                    boolean bl2 = false;
                    if (d12.getSecond() == d22.getSecond()) {
                        bl = true;
                        return bl;
                    }
                }
                bl = false;
                return bl;
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001:\u0002\u001d\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JY\u0010\u000e\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b*\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b2\u001e\b\u0004\u0010\u000f\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bH\u0082\bJ\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\u000e\u0010\u0013\u001a\u00020\u0014*\u0004\u0018\u00010\u0015H\u0002J\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u0012*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0019\u0010\u001a\u001a\u00070\u0011\u00a2\u0006\u0002\b\u001b*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0011*\u00020\u0011H\u0002R$\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\n\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\f\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion;", "", "<init>", "()V", "checkYears", "Lkotlin/Function2;", "Ljava/time/ZonedDateTime;", "", "Lcom/intellij/docker/view/details/TimeChecker;", "checkMonths", "checkDays", "checkHours", "checkMinutes", "checkSeconds", "thenCheck", "next", "toPlaceholderText", "", "Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$LineInfo;", "collapse", "", "Lcom/intellij/openapi/editor/FoldRegion;", "lineInfoFor", "Lcom/intellij/openapi/editor/Document;", "index", "", "getLineText", "Lorg/jetbrains/annotations/NotNull;", "extractTimestampText", "LineInfo", "FoldingPolicy", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerLogConsoleView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,317:1\n1088#2,2:318\n*S KotlinDebug\n*F\n+ 1 DockerLogConsoleView.kt\ncom/intellij/docker/view/details/DockerLogConsoleView$Companion\n*L\n283#1:318,2\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final Function2<ZonedDateTime, ZonedDateTime, Boolean> thenCheck(Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean> $this$thenCheck, Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean> next) {
            boolean $i$f$thenCheck = false;
            return (Function2)new Function2<ZonedDateTime, ZonedDateTime, Boolean>($this$thenCheck, next){
                final /* synthetic */ Function2<ZonedDateTime, ZonedDateTime, Boolean> $this_thenCheck;
                final /* synthetic */ Function2<ZonedDateTime, ZonedDateTime, Boolean> $next;
                {
                    this.$this_thenCheck = $receiver;
                    this.$next = $next;
                }

                public final Boolean invoke(ZonedDateTime d1, ZonedDateTime d2) {
                    Intrinsics.checkNotNullParameter((Object)d1, (String)"d1");
                    Intrinsics.checkNotNullParameter((Object)d2, (String)"d2");
                    return (Boolean)this.$this_thenCheck.invoke((Object)d1, (Object)d2) != false && (Boolean)this.$next.invoke((Object)d1, (Object)d2) != false;
                }
            };
        }

        private final String toPlaceholderText(LineInfo $this$toPlaceholderText) {
            String string = DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm:ss").format($this$toPlaceholderText.getTimestamp());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return string;
        }

        private final void collapse(FoldRegion $this$collapse) {
            block0: {
                FoldRegion foldRegion = $this$collapse;
                if (foldRegion == null) break block0;
                foldRegion.setExpanded(false);
            }
        }

        private final LineInfo lineInfoFor(Document $this$lineInfoFor, int index) {
            int lineStart = $this$lineInfoFor.getLineStartOffset(index);
            int lineEnd = $this$lineInfoFor.getLineEndOffset(index);
            String lineText = this.getLineText($this$lineInfoFor, index);
            String string = this.extractTimestampText(lineText);
            if (string == null) {
                return null;
            }
            String timestampText = string;
            return new LineInfo(lineStart, lineEnd, lineText, timestampText);
        }

        private final String getLineText(Document $this$getLineText, int index) {
            String string = EditorHyperlinkSupport.getLineText((Document)$this$getLineText, (int)index, (boolean)false);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineText(...)");
            return string;
        }

        private final String extractTimestampText(String $this$extractTimestampText) {
            if ($this$extractTimestampText.length() >= 30) {
                boolean bl;
                String text;
                block3: {
                    String string = $this$extractTimestampText.substring(0, 30);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    text = string;
                    String string2 = text.substring(0, 4);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    CharSequence $this$all$iv = string2;
                    boolean $i$f$all = false;
                    for (int i = 0; i < $this$all$iv.length(); ++i) {
                        char element$iv;
                        char p0 = element$iv = $this$all$iv.charAt(i);
                        boolean bl2 = false;
                        if (Character.isDigit(p0)) continue;
                        bl = false;
                        break block3;
                    }
                    bl = true;
                }
                if (bl && StringsKt.endsWith$default((String)text, (String)"Z", (boolean)false, (int)2, null)) {
                    return text;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B1\b\u0002\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u001c\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010\u0016\u001a\u00020\u0003H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR'\u0010\u0004\u001a\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u0017"}, d2={"Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$FoldingPolicy;", "", "label", "", "match", "Lkotlin/Function2;", "Ljava/time/ZonedDateTime;", "", "Lcom/intellij/docker/view/details/TimeChecker;", "<init>", "(Ljava/lang/String;ILjava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getLabel", "()Ljava/lang/String;", "getMatch", "()Lkotlin/jvm/functions/Function2;", "NONE", "SECONDS", "MINUTES", "HOURS", "DAYS", "MONTHS", "YEARS", "toString", "intellij.clouds.docker"})
        private static final class FoldingPolicy
        extends Enum<FoldingPolicy> {
            @NotNull
            private final String label;
            @NotNull
            private final Function2<ZonedDateTime, ZonedDateTime, Boolean> match;
            public static final /* enum */ FoldingPolicy NONE;
            public static final /* enum */ FoldingPolicy SECONDS;
            public static final /* enum */ FoldingPolicy MINUTES;
            public static final /* enum */ FoldingPolicy HOURS;
            public static final /* enum */ FoldingPolicy DAYS;
            public static final /* enum */ FoldingPolicy MONTHS;
            public static final /* enum */ FoldingPolicy YEARS;
            private static final /* synthetic */ FoldingPolicy[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private FoldingPolicy(String label, Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean> match) {
                this.label = label;
                this.match = match;
            }

            @NotNull
            public final String getLabel() {
                return this.label;
            }

            @NotNull
            public final Function2<ZonedDateTime, ZonedDateTime, Boolean> getMatch() {
                return this.match;
            }

            @NotNull
            public String toString() {
                return this.label;
            }

            public static FoldingPolicy[] values() {
                return (FoldingPolicy[])$VALUES.clone();
            }

            public static FoldingPolicy valueOf(String value) {
                return Enum.valueOf(FoldingPolicy.class, value);
            }

            @NotNull
            public static EnumEntries<FoldingPolicy> getEntries() {
                return $ENTRIES;
            }

            private static final boolean _init_$lambda$0(ZonedDateTime zonedDateTime, ZonedDateTime zonedDateTime2) {
                Intrinsics.checkNotNullParameter((Object)zonedDateTime, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)zonedDateTime2, (String)"<unused var>");
                return false;
            }

            static {
                String string = DockerBundle.message((String)"DockerLogConsoleView.folding.policy.none", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                NONE = new FoldingPolicy(string, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)((Function2)FoldingPolicy::_init_$lambda$0));
                String string2 = DockerBundle.message((String)"DockerLogConsoleView.folding.policy.seconds", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                SECONDS = new FoldingPolicy(string2, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkSeconds);
                String string3 = DockerBundle.message((String)"DockerLogConsoleView.folding.policy.minutes", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                MINUTES = new FoldingPolicy(string3, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkMinutes);
                String string4 = DockerBundle.message((String)"DockerLogConsoleView.folding.policy.hours", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                HOURS = new FoldingPolicy(string4, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkHours);
                String string5 = DockerBundle.message((String)"DockerLogConsoleView.folding.policy.days", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                DAYS = new FoldingPolicy(string5, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkDays);
                String string6 = DockerBundle.message((String)"DockerLogConsoleView.folding.policy.months", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                MONTHS = new FoldingPolicy(string6, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkMonths);
                String string7 = DockerBundle.message((String)"DockerLogConsoleView.folding.policy.years", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
                YEARS = new FoldingPolicy(string7, (Function2<? super ZonedDateTime, ? super ZonedDateTime, Boolean>)checkYears);
                $VALUES = foldingPolicyArray = new FoldingPolicy[]{FoldingPolicy.NONE, FoldingPolicy.SECONDS, FoldingPolicy.MINUTES, FoldingPolicy.HOURS, FoldingPolicy.DAYS, FoldingPolicy.MONTHS, FoldingPolicy.YEARS};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0014\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001e\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u001f\u001a\u00020\u0006H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001d\u0010\u0010\u001a\u0004\u0018\u00010\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/docker/view/details/DockerLogConsoleView$Companion$LineInfo;", "", "startOffset", "", "endOffset", "text", "", "timestampText", "<init>", "(IILjava/lang/String;Ljava/lang/String;)V", "getStartOffset", "()I", "getEndOffset", "getText", "()Ljava/lang/String;", "getTimestampText", "timestamp", "Ljava/time/ZonedDateTime;", "getTimestamp", "()Ljava/time/ZonedDateTime;", "timestamp$delegate", "Lkotlin/Lazy;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "intellij.clouds.docker"})
        private static final class LineInfo {
            private final int startOffset;
            private final int endOffset;
            @NotNull
            private final String text;
            @NotNull
            private final String timestampText;
            @NotNull
            private final Lazy timestamp$delegate;

            public LineInfo(int startOffset, int endOffset, @NotNull String text, @NotNull String timestampText) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)timestampText, (String)"timestampText");
                this.startOffset = startOffset;
                this.endOffset = endOffset;
                this.text = text;
                this.timestampText = timestampText;
                this.timestamp$delegate = LazyKt.lazy(() -> LineInfo.timestamp_delegate$lambda$0(this));
            }

            public final int getStartOffset() {
                return this.startOffset;
            }

            public final int getEndOffset() {
                return this.endOffset;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            @NotNull
            public final String getTimestampText() {
                return this.timestampText;
            }

            @Nullable
            public final ZonedDateTime getTimestamp() {
                Lazy lazy = this.timestamp$delegate;
                return (ZonedDateTime)lazy.getValue();
            }

            public final int component1() {
                return this.startOffset;
            }

            public final int component2() {
                return this.endOffset;
            }

            @NotNull
            public final String component3() {
                return this.text;
            }

            @NotNull
            public final String component4() {
                return this.timestampText;
            }

            @NotNull
            public final LineInfo copy(int startOffset, int endOffset, @NotNull String text, @NotNull String timestampText) {
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                Intrinsics.checkNotNullParameter((Object)timestampText, (String)"timestampText");
                return new LineInfo(startOffset, endOffset, text, timestampText);
            }

            public static /* synthetic */ LineInfo copy$default(LineInfo lineInfo, int n, int n2, String string, String string2, int n3, Object object) {
                if ((n3 & 1) != 0) {
                    n = lineInfo.startOffset;
                }
                if ((n3 & 2) != 0) {
                    n2 = lineInfo.endOffset;
                }
                if ((n3 & 4) != 0) {
                    string = lineInfo.text;
                }
                if ((n3 & 8) != 0) {
                    string2 = lineInfo.timestampText;
                }
                return lineInfo.copy(n, n2, string, string2);
            }

            @NotNull
            public String toString() {
                return "LineInfo(startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", text=" + this.text + ", timestampText=" + this.timestampText + ")";
            }

            public int hashCode() {
                int result2 = Integer.hashCode(this.startOffset);
                result2 = result2 * 31 + Integer.hashCode(this.endOffset);
                result2 = result2 * 31 + this.text.hashCode();
                result2 = result2 * 31 + this.timestampText.hashCode();
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LineInfo)) {
                    return false;
                }
                LineInfo lineInfo = (LineInfo)other;
                if (this.startOffset != lineInfo.startOffset) {
                    return false;
                }
                if (this.endOffset != lineInfo.endOffset) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.text, (Object)lineInfo.text)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.timestampText, (Object)lineInfo.timestampText);
            }

            private static final ZonedDateTime timestamp_delegate$lambda$0(LineInfo this$0) {
                Object object;
                try {
                    boolean bl = false;
                    object = Result.constructor-impl((Object)ZonedDateTime.parse(this$0.timestampText).truncatedTo(ChronoUnit.NANOS));
                }
                catch (Throwable throwable) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                return (ZonedDateTime)(Result.isFailure-impl((Object)object) ? null : object);
            }
        }
    }
}

