/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ml.MLRankingIgnorable;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.ast.PyAstExpression;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.PyAnnotation;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0014\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0006H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/python/codeInsight/completion/DictLiteralCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "<init>", "()V", "DEFAULT_QUOTE", "", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "addCompletionToCallExpression", "originalElement", "Lcom/intellij/psi/PsiElement;", "possibleSequenceExpr", "Lcom/jetbrains/python/psi/PySequenceExpression;", "getForcedQuote", "addCompletionToAssignment", "addCompletionToReturnStatement", "addCompletionForTypedDictKeys", "expectedType", "Lcom/jetbrains/python/psi/types/PyType;", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "dictCompletion", "quote", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyDictLiteralCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDictLiteralCompletionContributor.kt\ncom/jetbrains/python/codeInsight/completion/DictLiteralCompletionProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n1915#2,2:166\n812#2,12:182\n1391#2:194\n1480#2,5:195\n1586#2:200\n1661#2,3:201\n296#2,2:204\n812#2,12:213\n1586#2:225\n1661#2,3:226\n832#2:229\n862#2,2:230\n12033#3,10:168\n14060#3:178\n14061#3:180\n12043#3:181\n1401#3,2:207\n11705#3:209\n12052#3,3:210\n1#4:179\n1#4:206\n*S KotlinDebug\n*F\n+ 1 PyDictLiteralCompletionContributor.kt\ncom/jetbrains/python/codeInsight/completion/DictLiteralCompletionProvider\n*L\n68#1:166,2\n76#1:182,12\n77#1:194\n77#1:195,5\n78#1:200\n78#1:201,3\n94#1:204,2\n147#1:213,12\n148#1:225\n148#1:226,3\n152#1:229\n152#1:230,2\n75#1:168,10\n75#1:178\n75#1:180\n75#1:181\n102#1:207,2\n146#1:209\n146#1:210,3\n75#1:179\n*E\n"})
final class DictLiteralCompletionProvider
extends CompletionProvider<CompletionParameters> {
    @NotNull
    private final String DEFAULT_QUOTE;

    public DictLiteralCompletionProvider() {
        this.DEFAULT_QUOTE = "\"";
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement possibleSequenceExpr;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        PsiElement psiElement = parameters.getOriginalPosition();
        if (psiElement == null || (psiElement = psiElement.getParent()) == null) {
            return;
        }
        PsiElement originalElement = psiElement;
        PsiElement psiElement2 = possibleSequenceExpr = originalElement instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)originalElement).getParent() : originalElement;
        if (possibleSequenceExpr instanceof PyKeyValueExpression) {
            possibleSequenceExpr = ((PyKeyValueExpression)possibleSequenceExpr).getParent();
        }
        if (possibleSequenceExpr instanceof PyDictLiteralExpression || possibleSequenceExpr instanceof PySetLiteralExpression) {
            this.addCompletionToCallExpression(originalElement, (PySequenceExpression)possibleSequenceExpr, result);
            this.addCompletionToAssignment(originalElement, (PySequenceExpression)possibleSequenceExpr, result);
            this.addCompletionToReturnStatement(originalElement, (PySequenceExpression)possibleSequenceExpr, result);
        }
    }

    private final void addCompletionToCallExpression(PsiElement originalElement, PySequenceExpression possibleSequenceExpr, CompletionResultSet result) {
        block1: {
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)originalElement.getProject(), (PsiFile)originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(...)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            String quote = this.getForcedQuote(possibleSequenceExpr, originalElement);
            PyExpression pyExpression = (PyExpression)possibleSequenceExpr;
            PyResolveContext pyResolveContext = PyResolveContext.defaultContext((TypeEvalContext)typeEvalContext2);
            Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(...)");
            List<PyCallableParameter> list = PyCallExpressionHelper.getMappedParameters(pyExpression, pyResolveContext);
            if (list == null) break block1;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyCallableParameter it = (PyCallableParameter)element$iv;
                boolean bl = false;
                this.addCompletionForTypedDictKeys(it.getType(typeEvalContext2), (PyExpression)possibleSequenceExpr, result, quote);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String getForcedQuote(PySequenceExpression possibleSequenceExpr, PsiElement originalElement) {
        if (!(originalElement instanceof PyStringLiteralExpression)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv;
            void $this$mapNotNullTo$iv$iv;
            PyExpression[] pyExpressionArray = possibleSequenceExpr.getElements();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getElements(...)");
            Object $this$mapNotNull$iv = pyExpressionArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                PyExpression it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                PyExpression it = (PyExpression)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof PyKeyValueExpression ? ((PyKeyValueExpression)it).getKey() : it) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapNotNullTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof PyStringLiteralExpression)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterIsInstanceTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                PyStringLiteralExpression it = (PyStringLiteralExpression)element$iv$iv;
                boolean bl = false;
                List list = it.getStringElements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getStringElements(...)");
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$flatMapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                PyStringElement list$iv$iv = (PyStringElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getQuote());
            }
            Set usedQuotes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
            String string = (String)CollectionsKt.singleOrNull((Iterable)usedQuotes);
            if (string == null) {
                string = this.DEFAULT_QUOTE;
            }
            return string;
        }
        return "";
    }

    private final void addCompletionToAssignment(PsiElement originalElement, PySequenceExpression possibleSequenceExpr, CompletionResultSet result) {
        PyAssignmentStatement assignment = (PyAssignmentStatement)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyAssignmentStatement.class);
        if (assignment != null) {
            Pair targetToValue;
            Pair pair;
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)originalElement.getProject(), (PsiFile)originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(...)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            if (assignment.getTargets().length == 1) {
                pair = TuplesKt.to((Object)assignment.getTargets()[0], (Object)assignment.getAssignedValue());
            } else {
                Object v3;
                block13: {
                    List list = assignment.getTargetsToValuesMapping();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTargetsToValuesMapping(...)");
                    Iterable $this$firstOrNull$iv = list;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        com.intellij.openapi.util.Pair it = (com.intellij.openapi.util.Pair)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.second, (Object)possibleSequenceExpr)) continue;
                        v3 = element$iv;
                        break block13;
                    }
                    v3 = null;
                }
                com.intellij.openapi.util.Pair pair2 = v3;
                if (pair2 != null) {
                    com.intellij.openapi.util.Pair it = pair2;
                    boolean bl = false;
                    pair = TuplesKt.to((Object)it.first, (Object)it.second);
                } else {
                    pair = null;
                }
            }
            Pair pair3 = targetToValue = pair;
            if ((pair3 != null ? (PyExpression)pair3.getFirst() : null) != null && targetToValue.getSecond() != null) {
                Object object = targetToValue.getFirst();
                Intrinsics.checkNotNull((Object)object);
                PyType expectedType = typeEvalContext2.getType((PyTypedElement)object);
                Object object2 = targetToValue.getSecond();
                Intrinsics.checkNotNull((Object)object2);
                this.addCompletionForTypedDictKeys(expectedType, (PyExpression)object2, result, this.getForcedQuote(possibleSequenceExpr, originalElement));
            } else {
                Object object;
                PyExpression targetExpr;
                block14: {
                    targetExpr = assignment.getAssignedValue();
                    if (targetExpr instanceof PyTupleExpression) {
                        PyAstExpression[] pyAstExpressionArray = ((PyTupleExpression)targetExpr).getElements();
                        Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
                        Object[] $this$firstOrNull$iv = pyAstExpressionArray;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            PyExpression it = (PyExpression)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it, (Object)possibleSequenceExpr)) continue;
                            object = element$iv;
                            break block14;
                        }
                        object = null;
                    } else {
                        return;
                    }
                }
                PyExpression element = (PyExpression)object;
                if (element != null) {
                    PyAstExpression[] pyAstExpressionArray = ((PyTupleExpression)targetExpr).getElements();
                    Intrinsics.checkNotNullExpressionValue((Object)pyAstExpressionArray, (String)"getElements(...)");
                    int index = ArraysKt.indexOf((Object[])pyAstExpressionArray, (Object)element);
                    if (index < assignment.getTargets().length) {
                        PyType expectedType = typeEvalContext2.getType((PyTypedElement)assignment.getTargets()[index]);
                        this.addCompletionForTypedDictKeys(expectedType, element, result, this.getForcedQuote(possibleSequenceExpr, originalElement));
                    }
                }
            }
        }
    }

    private final void addCompletionToReturnStatement(PsiElement originalElement, PySequenceExpression possibleSequenceExpr, CompletionResultSet result) {
        PyReturnStatement returnStatement = (PyReturnStatement)PsiTreeUtil.getParentOfType((PsiElement)originalElement, PyReturnStatement.class);
        if (returnStatement != null) {
            TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)originalElement.getProject(), (PsiFile)originalElement.getContainingFile());
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(...)");
            TypeEvalContext typeEvalContext2 = typeEvalContext;
            ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)returnStatement);
            if (owner instanceof PyFunction) {
                PyAnnotation annotation = (PyAnnotation)((PyFunction)owner).getAnnotation();
                String typeCommentAnnotation = ((PyFunction)owner).getTypeCommentAnnotation();
                if (annotation != null || typeCommentAnnotation != null) {
                    PyType expectedType = typeEvalContext2.getReturnType((PyCallable)owner);
                    this.addCompletionForTypedDictKeys(expectedType, (PyExpression)possibleSequenceExpr, result, this.getForcedQuote(possibleSequenceExpr, originalElement));
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addCompletionForTypedDictKeys(PyType expectedType, PyExpression expression, CompletionResultSet dictCompletion, String quote) {
        if (expectedType instanceof PyTypedDictType) {
            void $this$filterNotTo$iv$iv;
            List list;
            String it;
            Iterable $this$mapTo$iv$iv;
            Collection destination$iv$iv;
            PyExpression pyExpression = expression;
            if (pyExpression instanceof PyDictLiteralExpression) {
                Iterable $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv;
                Collection collection;
                Iterable $this$map$iv;
                PyKeyValueExpression[] pyKeyValueExpressionArray = ((PyDictLiteralExpression)expression).getElements();
                Intrinsics.checkNotNullExpressionValue((Object)pyKeyValueExpressionArray, (String)"getElements(...)");
                Object[] objectArray = pyKeyValueExpressionArray;
                boolean $i$f$map = false;
                void var9_8 = $this$map$iv;
                destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
                boolean $i$f$mapTo = false;
                for (Iterable item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it2;
                    PyKeyValueExpression pyKeyValueExpression = (PyKeyValueExpression)item$iv$iv2;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it2.getKey());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filterIsInstance = false;
                $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PyStringLiteralExpression)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                $i$f$map = false;
                $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Iterable item$iv$iv2;
                    item$iv$iv2 = (PyStringLiteralExpression)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getStringValue());
                }
                list = (List)destination$iv$iv;
            } else if (pyExpression instanceof PySetLiteralExpression) {
                list = CollectionsKt.emptyList();
            } else {
                return;
            }
            List keys = list;
            Iterable $this$filterNot$iv = ((PyTypedDictType)expectedType).getFields().keySet();
            boolean $i$f$filterNot = false;
            $this$mapTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl = false;
                if (keys.contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (String key : (List)destination$iv$iv) {
                dictCompletion.addElement(MLRankingIgnorable.wrap((LookupElement)((LookupElement)LookupElementBuilder.create((String)(quote + key + quote)).withTypeText("dict key").withIcon(IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Parameter)))));
            }
        }
    }
}

