/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResult;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.codeInsight.completion.PyClassNameCompletionContributor;
import com.jetbrains.python.codeInsight.completion.PyFunctionInsertHandler;
import com.jetbrains.python.codeInsight.completion.PyParameterizedTypeInsertHandler;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCapturePattern;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringElement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeAliasStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.search.PySearchUtilBase;
import com.jetbrains.python.psi.stubs.PyExportedModuleAttributeIndex;
import com.jetbrains.python.psi.stubs.PyModuleNameIndex;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFileType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 =2\u00020\u00012\u00020\u0002:\u0003<=>B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J5\u0010\f\u001a\u00020\r2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J&\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001d0%H\u0002J$\u0010&\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u001d0%H\u0002J(\u0010'\u001a\u00020\u001d2\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0018H\u0002J\u0018\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0018H\u0002J\u0010\u0010.\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00102\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00103\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u0012H\u0002J\"\u00104\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001b\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u00105\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J\u0018\u00106\u001a\u00020#2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u00107\u001a\u00020\u001dH\u0002J \u00108\u001a\u00020#2\u0006\u0010)\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u001dH\u0002J\u0010\u0010;\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006?"}, d2={"Lcom/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "fillCompletionVariants", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "fillCompletionVariantsImpl", "createLookupElementForImportableName", "Lcom/intellij/codeInsight/lookup/LookupElement;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "importable", "Lcom/jetbrains/python/psi/PyElement;", "originalFile", "Lcom/intellij/psi/PsiFile;", "position", "Lcom/intellij/psi/PsiElement;", "typeEvalContext", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "getInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "exported", "containsOnlyElementUnderTheCaret", "", "remainingResults", "", "Lcom/intellij/codeInsight/completion/CompletionResult;", "forEachPublicNameFromIndex", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "processor", "Lkotlin/Function1;", "forEachModulePackageNameFromIndex", "isApplicableInInsertionContext", "definition", "fqn", "Lcom/intellij/psi/util/QualifiedName;", "context", "isSuitableTypeAlias", "element", "isInsideErrorElement", "referenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "isInsideImportElement", "isDirectlyInsideClassBody", "getFullyQualifiedName", "isPrivateDefinition", "containsPrivateComponents", "createScope", "forTopLevelNames", "fileScope", "anchor", "pyiStub", "isInsideAllInInitPy", "Counters", "Companion", "InsertHandlers", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyClassNameCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyClassNameCompletionContributor.kt\ncom/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,498:1\n1#2:499\n58#3,2:500\n28#3,12:502\n58#3,2:514\n28#3,12:516\n58#3,2:528\n28#3,12:530\n58#3,2:561\n28#3,12:563\n1807#4,3:542\n812#4,12:545\n1586#4:557\n1661#4,3:558\n*S KotlinDebug\n*F\n+ 1 PyClassNameCompletionContributor.kt\ncom/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor\n*L\n315#1:500,2\n315#1:502,12\n329#1:514,2\n329#1:516,12\n333#1:528,2\n333#1:530,12\n402#1:561,2\n402#1:563,12\n360#1:542,3\n387#1:545,12\n389#1:557\n389#1:558,3\n*E\n"})
public final class PyClassNameCompletionContributor
extends CompletionContributor
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final boolean TRACING_WITH_SPUTNIK_ENABLED = false;
    @NotNull
    private static final Logger LOG;
    private static final boolean RECURSIVE_INDEX_ACCESS_ALLOWED = false;

    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        String string = result.getPrefixMatcher().getPrefix();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPrefix(...)");
        if (((CharSequence)string).length() == 0) {
            result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().longerThan(0));
            return;
        }
        result.restartCompletionWhenNothingMatches();
        LinkedHashSet linkedHashSet = result.runRemainingContributors(parameters, true);
        Intrinsics.checkNotNullExpressionValue((Object)linkedHashSet, (String)"runRemainingContributors(...)");
        LinkedHashSet remainingResults = linkedHashSet;
        if (parameters.isExtendedCompletion() || remainingResults.isEmpty() || this.containsOnlyElementUnderTheCaret(remainingResults, parameters)) {
            this.fillCompletionVariantsImpl(parameters, result);
        }
    }

    private final void fillCompletionVariantsImpl(CompletionParameters parameters, CompletionResultSet result) {
        boolean insideStringLiteralInExtendedCompletion;
        boolean isExtendedCompletion = parameters.isExtendedCompletion();
        if (!PyCodeInsightSettings.getInstance().INCLUDE_IMPORTABLE_NAMES_IN_BASIC_COMPLETION && !isExtendedCompletion) {
            return;
        }
        PsiFile psiFile = parameters.getOriginalFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getOriginalFile(...)");
        PsiFile originalFile = psiFile;
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        PsiElement psiElement2 = position.getParent();
        PyReferenceExpression refExpr = psiElement2 instanceof PyReferenceExpression ? (PyReferenceExpression)psiElement2 : null;
        PsiElement psiElement3 = position.getParent();
        PyTargetExpression targetExpr = psiElement3 instanceof PyTargetExpression ? (PyTargetExpression)psiElement3 : null;
        PyStringElement stringElem = position instanceof PyStringElement ? (PyStringElement)position : null;
        PsiElement originalPosition = parameters.getOriginalPosition();
        boolean originallyInsideTarget = originalPosition != null && originalPosition.getParent() instanceof PyTargetExpression;
        boolean insideUnqualifiedReference = refExpr != null && !refExpr.isQualified() && !originallyInsideTarget;
        boolean insidePattern = targetExpr != null && position.getParent().getParent() instanceof PyCapturePattern;
        boolean bl = insideStringLiteralInExtendedCompletion = stringElem != null && isExtendedCompletion;
        if (!(insideUnqualifiedReference || insidePattern || insideStringLiteralInExtendedCompletion)) {
            return;
        }
        if (refExpr != null && (this.isDirectlyInsideClassBody(refExpr) || this.isInsideErrorElement(refExpr) || this.isInsideImportElement(refExpr))) {
            return;
        }
        if (insideStringLiteralInExtendedCompletion) {
            String string = stringElem.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String string2 = string;
            int n = stringElem.getContentRange().getStartOffset();
            int n2 = parameters.getOffset() - stringElem.getTextRange().getStartOffset();
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            String prefix = string3;
            if (StringsKt.contains$default((CharSequence)prefix, (CharSequence)".", (boolean)false, (int)2, null)) {
                return;
            }
        }
        Project project = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        TypeEvalContext typeEvalContext = TypeEvalContext.codeCompletion((Project)project2, (PsiFile)originalFile);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"codeCompletion(...)");
        TypeEvalContext typeEvalContext2 = typeEvalContext;
        int maxVariants = Registry.Companion.intValue("ide.completion.variant.limit");
        Counters counters = new Counters(0, 0, 0, 0, 15, null);
        StubIndex stubIndex = StubIndex.getInstance();
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        TimeoutUtil.run(() -> PyClassNameCompletionContributor.fillCompletionVariantsImpl$lambda$0(this, originalFile, counters, result, fileBasedIndex, position, typeEvalContext2, maxVariants, stubIndex, project2), arg_0 -> PyClassNameCompletionContributor.fillCompletionVariantsImpl$lambda$1(counters, result, arg_0));
    }

    private final LookupElement createLookupElementForImportableName(String name, PyElement importable, PsiFile originalFile, PsiElement position, TypeEvalContext typeEvalContext) {
        LookupElementBuilder it = LookupElementBuilder.createWithSmartPointer((String)name, (PsiElement)((PsiElement)importable)).withIcon(importable.getIcon(0)).withExpensiveRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(importable, originalFile){
            final /* synthetic */ PyElement $importable;
            final /* synthetic */ PsiFile $originalFile;
            {
                this.$importable = $importable;
                this.$originalFile = $originalFile;
            }

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
                presentation.setItemText(element.getLookupString());
                presentation.setIcon(this.$importable.getIcon(0));
                QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)this.$importable, (PsiElement)this.$originalFile);
                if (importPath == null) {
                    return;
                }
                if (this.$importable instanceof PsiFileSystemItem) {
                    presentation.setTypeText(importPath.removeLastComponent().toString());
                } else {
                    presentation.setTypeText(importPath.toString());
                }
            }
        }).withInsertHandler(this.getInsertHandler(importable, position, typeEvalContext));
        boolean bl = false;
        LookupElement lookupElement = PrioritizedLookupElement.withPriority((LookupElement)((LookupElement)it), (double)-1.0);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElement, (String)"let(...)");
        return lookupElement;
    }

    private final InsertHandler<LookupElement> getInsertHandler(PyElement exported, PsiElement position, TypeEvalContext typeEvalContext) {
        if (position.getParent() instanceof PyStringLiteralExpression) {
            if (this.isInsideAllInInitPy(position)) {
                return InsertHandlers.INSTANCE.getImportingInsertHandler$intellij_python_psi_impl();
            }
            return InsertHandlers.INSTANCE.getStringLiteralInsertHandler$intellij_python_psi_impl();
        }
        if (PyParameterizedTypeInsertHandler.isCompletingParameterizedType((PsiElement)exported, position, typeEvalContext)) {
            return InsertHandlers.INSTANCE.getGenericTypeInsertHandler$intellij_python_psi_impl();
        }
        if (exported instanceof PyFunction && !(position.getParent().getParent() instanceof PyDecorator)) {
            return InsertHandlers.INSTANCE.getFunctionInsertHandler$intellij_python_psi_impl();
        }
        return InsertHandlers.INSTANCE.getImportingInsertHandler$intellij_python_psi_impl();
    }

    private final boolean containsOnlyElementUnderTheCaret(Set<CompletionResult> remainingResults, CompletionParameters parameters) {
        PsiElement position = parameters.getOriginalPosition();
        if (remainingResults.size() == 1 && position != null) {
            CompletionResult lookup = (CompletionResult)CollectionsKt.first((Iterable)remainingResults);
            return Intrinsics.areEqual((Object)lookup.getLookupElement().getLookupString(), (Object)position.getText());
        }
        return false;
    }

    private final void forEachPublicNameFromIndex(GlobalSearchScope scope, Function1<? super String, Boolean> processor2) {
        StubIndex stubIndex = StubIndex.getInstance();
        Project project = scope.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        CachedValuesManager manager = CachedValuesManager.getManager((Project)project2);
        Collection cachedAllNames = (Collection)manager.getCachedValue((UserDataHolder)project2, () -> PyClassNameCompletionContributor.forEachPublicNameFromIndex$lambda$0(project2));
        for (String name : cachedAllNames) {
            if (((Boolean)processor2.invoke((Object)name)).booleanValue()) continue;
            return;
        }
    }

    private final void forEachModulePackageNameFromIndex(GlobalSearchScope scope, Function1<? super String, Boolean> processor2) {
        Project project = scope.getProject();
        Intrinsics.checkNotNull((Object)project);
        for (String name : PyModuleNameIndex.getAllKeys(project)) {
            Intrinsics.checkNotNull((Object)name);
            if (((Boolean)processor2.invoke((Object)name)).booleanValue()) continue;
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isApplicableInInsertionContext(PyElement definition, QualifiedName fqn, PsiElement position, TypeEvalContext context) {
        PsiElement psiElement;
        PsiElement psiElement2;
        block6: {
            void $this$findParentInFile$iv$iv;
            if (PyTypingTypeProvider.isInsideTypeHint(position, context)) {
                if (definition instanceof PyClass) return true;
                if (definition instanceof PsiFileSystemItem) return true;
                if (this.isSuitableTypeAlias(definition, context)) return true;
                String[] stringArray = new String[]{"typing", "typing_extensions"};
                if (!ArrayUtil.contains((String)fqn.getFirstComponent(), (String[])stringArray)) return false;
                return true;
            }
            PsiElement $this$findParentOfType_u24default$iv = position;
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement3 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement2 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof PyPattern) {
                        psiElement2 = current$iv$iv;
                        break block6;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement2 = psiElement = null;
            }
        }
        if (!(psiElement2 instanceof PyPattern)) {
            psiElement = null;
        }
        if ((PsiElement)((PyPattern)psiElement) == null) return true;
        if (definition instanceof PyClass) return true;
        if (!(definition instanceof PsiFileSystemItem)) return false;
        return true;
    }

    private final boolean isSuitableTypeAlias(PyElement element, TypeEvalContext context) {
        if (element instanceof PyTargetExpression && element.getParent() instanceof PyAssignmentStatement) {
            PsiElement psiElement = ((PyTargetExpression)element).getParent();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyAssignmentStatement");
            if (PyTypingTypeProvider.isExplicitTypeAlias((PyAssignmentStatement)psiElement, context)) {
                return true;
            }
        }
        return element instanceof PyTypeAliasStatement;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInsideErrorElement(PyReferenceExpression referenceExpression) {
        PsiElement psiElement;
        PsiElement psiElement2;
        block5: {
            void $this$findParentInFile$iv$iv;
            PsiElement $this$findParentOfType_u24default$iv = (PsiElement)referenceExpression;
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement3 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement2 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof PsiErrorElement) {
                        psiElement2 = current$iv$iv;
                        break block5;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement2 = psiElement = null;
            }
        }
        if (!(psiElement2 instanceof PsiErrorElement)) {
            psiElement = null;
        }
        return (PsiElement)((PsiErrorElement)psiElement) != null;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInsideImportElement(PyReferenceExpression referenceExpression) {
        PsiElement psiElement;
        PsiElement psiElement2;
        block5: {
            void $this$findParentInFile$iv$iv;
            PsiElement $this$findParentOfType_u24default$iv = (PsiElement)referenceExpression;
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement3 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement2 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof PyImportStatementBase) {
                        psiElement2 = current$iv$iv;
                        break block5;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement2 = psiElement = null;
            }
        }
        if (!(psiElement2 instanceof PyImportStatementBase)) {
            psiElement = null;
        }
        return (PsiElement)((PyImportStatementBase)psiElement) != null;
    }

    private final boolean isDirectlyInsideClassBody(PyReferenceExpression referenceExpression) {
        return referenceExpression.getParent() instanceof PyExpressionStatement && ScopeUtil.getScopeOwner(referenceExpression.getParent()) instanceof PyClass;
    }

    private final QualifiedName getFullyQualifiedName(PyElement exported) {
        String qualifiedName;
        String string;
        String shortName;
        if (exported instanceof PyFile) {
            QualifiedName qualifiedName2 = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)exported);
            if (qualifiedName2 == null) {
                QualifiedName qualifiedName3 = QualifiedName.fromDottedString((String)FileUtilRt.getNameWithoutExtension((String)((PyFile)exported).getName()));
                qualifiedName2 = qualifiedName3;
                Intrinsics.checkNotNullExpressionValue((Object)qualifiedName3, (String)"fromDottedString(...)");
            }
            return qualifiedName2;
        }
        String string2 = exported.getName();
        if (string2 == null) {
            string2 = shortName = "";
        }
        if ((string = (qualifiedName = exported instanceof PyQualifiedNameOwner ? ((PyQualifiedNameOwner)exported).getQualifiedName() : null)) == null) {
            string = shortName;
        }
        QualifiedName qualifiedName4 = QualifiedName.fromDottedString((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName4, (String)"fromDottedString(...)");
        return qualifiedName4;
    }

    private final boolean isPrivateDefinition(QualifiedName fqn, PyElement exported, PsiFile originalFile) {
        if (this.containsPrivateComponents(fqn)) {
            QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)exported, (PsiElement)originalFile);
            return importPath != null && this.containsPrivateComponents(importPath);
        }
        return false;
    }

    private final boolean containsPrivateComponents(QualifiedName fqn) {
        boolean bl;
        block3: {
            List list = fqn.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComponents(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!StringsKt.startsWith$default((String)it, (String)"_", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final GlobalSearchScope createScope(PsiFile originalFile, boolean forTopLevelNames) {
        Project project = originalFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        FileType[] fileTypeArray = new FileType[]{PyiFileType.INSTANCE};
        GlobalSearchScope globalSearchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)GlobalSearchScope.everythingScope((Project)project2), (FileType[])fileTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getScopeRestrictedByFileTypes(...)");
        GlobalSearchScope pyiStubsScope = globalSearchScope;
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"com/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$createScope$HavingLegalImportPathScope", "Lcom/jetbrains/python/psi/resolve/QualifiedNameFinder$QualifiedNameBasedScope;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "containsQualifiedNameInRoot", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "qName", "Lcom/intellij/psi/util/QualifiedName;", "intellij.python.psi.impl"})
        @SourceDebugExtension(value={"SMAP\nPyClassNameCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyClassNameCompletionContributor.kt\ncom/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$createScope$HavingLegalImportPathScope\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,498:1\n1786#2,3:499\n*S KotlinDebug\n*F\n+ 1 PyClassNameCompletionContributor.kt\ncom/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$createScope$HavingLegalImportPathScope\n*L\n366#1:499,3\n*E\n"})
        public final class HavingLegalImportPathScope
        extends QualifiedNameFinder.QualifiedNameBasedScope {
            public HavingLegalImportPathScope(Project project) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                super(project);
            }

            protected boolean containsQualifiedNameInRoot(VirtualFile root, QualifiedName qName) {
                String[] stringArray;
                boolean bl;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)root, (String)"root");
                    Intrinsics.checkNotNullParameter((Object)qName, (String)"qName");
                    List list = qName.getComponents();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComponents(...)");
                    Iterable $this$all$iv = list;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (PyNames.isIdentifier((String)it)) continue;
                            bl = false;
                            break block3;
                        }
                        bl = true;
                    }
                }
                return bl && !Intrinsics.areEqual((Object)qName, (Object)QualifiedName.fromComponents((String[])(stringArray = new String[]{"__future__"})));
            }
        }
        GlobalSearchScope globalSearchScope2 = PySearchUtilBase.defaultSuggestionScope((PsiElement)originalFile).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)pyiStubsScope)).intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)GlobalSearchScope.fileScope((PsiFile)originalFile))).intersectWith((GlobalSearchScope)new HavingLegalImportPathScope(project2));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"intersectWith(...)");
        GlobalSearchScope common = globalSearchScope2;
        if (forTopLevelNames) {
            GlobalSearchScope globalSearchScope3 = common.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)this.fileScope("typing", originalFile, false))).uniteWith(this.fileScope("typing", originalFile, true));
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope3, (String)"uniteWith(...)");
            return globalSearchScope3;
        }
        return common;
    }

    /*
     * WARNING - void declaration
     */
    private final GlobalSearchScope fileScope(String fqn, PsiFile anchor, boolean pyiStub) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext;
        if (pyiStub) {
            pyQualifiedNameResolveContext = PyResolveImportUtil.fromFoothold((PsiElement)anchor);
        } else {
            PyQualifiedNameResolveContext pyQualifiedNameResolveContext2 = PyResolveImportUtil.fromFoothold((PsiElement)anchor).copyWithoutStubs();
            pyQualifiedNameResolveContext = pyQualifiedNameResolveContext2;
            Intrinsics.checkNotNullExpressionValue((Object)pyQualifiedNameResolveContext2, (String)"copyWithoutStubs(...)");
        }
        PyQualifiedNameResolveContext context = pyQualifiedNameResolveContext;
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)fqn);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromDottedString(...)");
        Iterable $this$filterIsInstance$iv = PyResolveImportUtil.resolveQualifiedName(qualifiedName, context);
        boolean $i$f$filterIsInstance22 = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List files = (List)destination$iv$iv;
        if (files.isEmpty()) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"EMPTY_SCOPE");
            return globalSearchScope;
        }
        Iterable $i$f$filterIsInstance22 = files;
        Project project = anchor.getProject();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PsiFile psiFile = (PsiFile)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getVirtualFile());
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesWithLibrariesScope((Project)project, (Collection)((List)destination$iv$iv2));
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesWithLibrariesScope(...)");
        return globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isInsideAllInInitPy(PsiElement position) {
        PyAssignmentStatement assignment;
        PsiElement psiElement;
        PsiElement psiElement2;
        block10: {
            void $this$findParentInFile$iv$iv;
            PsiFile originalFile = position.getContainingFile();
            if (originalFile == null) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)"__init__.py", (Object)originalFile.getName())) {
                return false;
            }
            PsiElement $this$findParentOfType_u24default$iv = position;
            boolean strict$iv = true;
            boolean $i$f$findParentOfType = false;
            PsiElement psiElement3 = $this$findParentOfType_u24default$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$findParentInFile = false;
            if ($this$findParentInFile$iv$iv instanceof PsiFile) {
                psiElement2 = null;
            } else {
                for (PsiElement current$iv$iv = $this$findParentInFile$iv$iv.getParent(); current$iv$iv != null; current$iv$iv = current$iv$iv.getParent()) {
                    PsiElement it$iv = current$iv$iv;
                    boolean bl = false;
                    if (it$iv instanceof PyAssignmentStatement) {
                        psiElement2 = current$iv$iv;
                        break block10;
                    }
                    if (current$iv$iv instanceof PsiFile) break;
                }
                psiElement2 = psiElement = null;
            }
        }
        if (!(psiElement2 instanceof PyAssignmentStatement)) {
            psiElement = null;
        }
        if ((assignment = (PyAssignmentStatement)((PsiElement)((PyAssignmentStatement)psiElement))) == null) {
            return false;
        }
        PyExpression[] pyExpressionArray = assignment.getTargets();
        Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getTargets(...)");
        PyExpression[] targets = pyExpressionArray;
        if (targets.length != 1) {
            return false;
        }
        PyExpression target = targets[0];
        if (!(target instanceof PyTargetExpression)) {
            return false;
        }
        return Intrinsics.areEqual((Object)"__all__", (Object)((PyTargetExpression)target).getName());
    }

    private static final boolean fillCompletionVariantsImpl$lambda$0$1$0(PyClassNameCompletionContributor this$0, PsiElement $position, TypeEvalContext $typeEvalContext, Counters $counters, Set $alreadySuggested, PsiFile $originalFile, CompletionResultSet $result, int $maxVariants, PyElement exported) {
        ProgressManager.checkCanceled();
        String name = exported.getName();
        if (name == null) {
            return true;
        }
        Intrinsics.checkNotNull((Object)exported);
        QualifiedName fqn = this$0.getFullyQualifiedName(exported);
        if (!this$0.isApplicableInInsertionContext(exported, fqn, $position, $typeEvalContext)) {
            int n = $counters.getNotApplicableInContextNames();
            $counters.setNotApplicableInContextNames(n + 1);
            return true;
        }
        if ($alreadySuggested.add(fqn)) {
            if (this$0.isPrivateDefinition(fqn, exported, $originalFile)) {
                int n = $counters.getPrivateNames();
                $counters.setPrivateNames(n + 1);
                return true;
            }
            $result.addElement(this$0.createLookupElementForImportableName(name, exported, $originalFile, $position, $typeEvalContext));
            int n = $counters.getTotalVariants();
            $counters.setTotalVariants(n + 1);
            if ($counters.getTotalVariants() >= $maxVariants) {
                return false;
            }
        }
        return true;
    }

    private static final boolean fillCompletionVariantsImpl$lambda$0$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean fillCompletionVariantsImpl$lambda$0$0(Counters $counters, CompletionResultSet $result, FileBasedIndex $fileBasedIndex, GlobalSearchScope $modulePackageScope, PsiFile $originalFile, PyClassNameCompletionContributor this$0, PsiElement $position, TypeEvalContext $typeEvalContext, Set $alreadySuggested, int $maxVariants, String modulePackageName) {
        Intrinsics.checkNotNullParameter((Object)modulePackageName, (String)"modulePackageName");
        ProgressManager.checkCanceled();
        int n = $counters.getScannedNames();
        $counters.setScannedNames(n + 1);
        if (!$result.getPrefixMatcher().isStartMatch(modulePackageName)) {
            return true;
        }
        Iterator iterator = $fileBasedIndex.getContainingFilesIterator(PyModuleNameIndex.NAME, (Object)modulePackageName, $modulePackageScope);
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"getContainingFilesIterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            int n2;
            PyFile psiFile;
            VirtualFile vFile = (VirtualFile)iterator2.next();
            ProgressManager.checkCanceled();
            PsiFile psiFile2 = $originalFile.getManager().findFile(vFile);
            PyFile pyFile = psiFile = psiFile2 instanceof PyFile ? (PyFile)psiFile2 : null;
            if (psiFile == null) {
                return true;
            }
            if (!PyUtil.isImportable($originalFile, (PsiFileSystemItem)psiFile)) {
                return true;
            }
            QualifiedName fqn = this$0.getFullyQualifiedName((PyElement)psiFile);
            if (!this$0.isApplicableInInsertionContext((PyElement)psiFile, fqn, $position, $typeEvalContext)) {
                n2 = $counters.getNotApplicableInContextNames();
                $counters.setNotApplicableInContextNames(n2 + 1);
                return true;
            }
            if (!$alreadySuggested.add(fqn)) continue;
            $result.addElement(this$0.createLookupElementForImportableName(modulePackageName, (PyElement)psiFile, $originalFile, $position, $typeEvalContext));
            n2 = $counters.getTotalVariants();
            $counters.setTotalVariants(n2 + 1);
            if ($counters.getTotalVariants() < $maxVariants) continue;
            return false;
        }
        return true;
    }

    private static final boolean fillCompletionVariantsImpl$lambda$0$1(Counters $counters, CompletionResultSet $result, StubIndex $stubIndex, Project $project, GlobalSearchScope $topLevelNameScope, PyClassNameCompletionContributor this$0, PsiElement $position, TypeEvalContext $typeEvalContext, Set $alreadySuggested, PsiFile $originalFile, int $maxVariants, String elementName) {
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        ProgressManager.checkCanceled();
        int n = $counters.getScannedNames();
        $counters.setScannedNames(n + 1);
        if (!$result.getPrefixMatcher().isStartMatch(elementName)) {
            return true;
        }
        return $stubIndex.processElements(PyExportedModuleAttributeIndex.KEY, (Object)elementName, $project, $topLevelNameScope, PyElement.class, arg_0 -> PyClassNameCompletionContributor.fillCompletionVariantsImpl$lambda$0$1$1(arg_0 -> PyClassNameCompletionContributor.fillCompletionVariantsImpl$lambda$0$1$0(this$0, $position, $typeEvalContext, $counters, $alreadySuggested, $originalFile, $result, $maxVariants, arg_0), arg_0));
    }

    private static final void fillCompletionVariantsImpl$lambda$0(PyClassNameCompletionContributor this$0, PsiFile $originalFile, Counters $counters, CompletionResultSet $result, FileBasedIndex $fileBasedIndex, PsiElement $position, TypeEvalContext $typeEvalContext, int $maxVariants, StubIndex $stubIndex, Project $project) {
        Set alreadySuggested = new HashSet();
        GlobalSearchScope modulePackageScope = this$0.createScope($originalFile, false);
        this$0.forEachModulePackageNameFromIndex(modulePackageScope, (Function1<? super String, Boolean>)((Function1)arg_0 -> PyClassNameCompletionContributor.fillCompletionVariantsImpl$lambda$0$0($counters, $result, $fileBasedIndex, modulePackageScope, $originalFile, this$0, $position, $typeEvalContext, alreadySuggested, $maxVariants, arg_0)));
        GlobalSearchScope topLevelNameScope = this$0.createScope($originalFile, true);
        this$0.forEachPublicNameFromIndex(topLevelNameScope, (Function1<? super String, Boolean>)((Function1)arg_0 -> PyClassNameCompletionContributor.fillCompletionVariantsImpl$lambda$0$1($counters, $result, $stubIndex, $project, topLevelNameScope, this$0, $position, $typeEvalContext, alreadySuggested, $originalFile, $maxVariants, arg_0)));
    }

    private static final void fillCompletionVariantsImpl$lambda$1(Counters $counters, CompletionResultSet $result, long duration) {
        LOG.debug($counters + " computed for prefix '" + $result.getPrefixMatcher().getPrefix() + "' in " + duration + " ms");
    }

    private static final CachedValueProvider.Result forEachPublicNameFromIndex$lambda$0(Project $project) {
        StubIndex index = StubIndex.getInstance();
        Collection collection = index.getAllKeys(PyExportedModuleAttributeIndex.KEY, $project);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllKeys(...)");
        Collection keys = collection;
        ModificationTracker modificationTracker = index.getPerFileElementTypeModificationTracker((IFileElementType)PyFileElementType.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)modificationTracker, (String)"getPerFileElementTypeModificationTracker(...)");
        ModificationTracker modificationTracker2 = modificationTracker;
        Object[] objectArray = new Object[]{modificationTracker2};
        return CachedValueProvider.Result.create((Object)keys, (Object[])objectArray);
    }

    private static final boolean forEachPublicNameFromIndex$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(PyClassNameCompletionContributor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$Companion;", "", "<init>", "()V", "TRACING_WITH_SPUTNIK_ENABLED", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "RECURSIVE_INDEX_ACCESS_ALLOWED", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u001b\u001a\u00020\u0003H\u00d6\u0081\u0004J\n\u0010\u001c\u001a\u00020\u001dH\u00d6\u0081\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$Counters;", "", "scannedNames", "", "privateNames", "notApplicableInContextNames", "totalVariants", "<init>", "(IIII)V", "getScannedNames", "()I", "setScannedNames", "(I)V", "getPrivateNames", "setPrivateNames", "getNotApplicableInContextNames", "setNotApplicableInContextNames", "getTotalVariants", "setTotalVariants", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.python.psi.impl"})
    private static final class Counters {
        private int scannedNames;
        private int privateNames;
        private int notApplicableInContextNames;
        private int totalVariants;

        public Counters(int scannedNames, int privateNames, int notApplicableInContextNames, int totalVariants) {
            this.scannedNames = scannedNames;
            this.privateNames = privateNames;
            this.notApplicableInContextNames = notApplicableInContextNames;
            this.totalVariants = totalVariants;
        }

        public /* synthetic */ Counters(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n5 & 1) != 0) {
                n = 0;
            }
            if ((n5 & 2) != 0) {
                n2 = 0;
            }
            if ((n5 & 4) != 0) {
                n3 = 0;
            }
            if ((n5 & 8) != 0) {
                n4 = 0;
            }
            this(n, n2, n3, n4);
        }

        public final int getScannedNames() {
            return this.scannedNames;
        }

        public final void setScannedNames(int n) {
            this.scannedNames = n;
        }

        public final int getPrivateNames() {
            return this.privateNames;
        }

        public final void setPrivateNames(int n) {
            this.privateNames = n;
        }

        public final int getNotApplicableInContextNames() {
            return this.notApplicableInContextNames;
        }

        public final void setNotApplicableInContextNames(int n) {
            this.notApplicableInContextNames = n;
        }

        public final int getTotalVariants() {
            return this.totalVariants;
        }

        public final void setTotalVariants(int n) {
            this.totalVariants = n;
        }

        public final int component1() {
            return this.scannedNames;
        }

        public final int component2() {
            return this.privateNames;
        }

        public final int component3() {
            return this.notApplicableInContextNames;
        }

        public final int component4() {
            return this.totalVariants;
        }

        @NotNull
        public final Counters copy(int scannedNames, int privateNames, int notApplicableInContextNames, int totalVariants) {
            return new Counters(scannedNames, privateNames, notApplicableInContextNames, totalVariants);
        }

        public static /* synthetic */ Counters copy$default(Counters counters, int n, int n2, int n3, int n4, int n5, Object object) {
            if ((n5 & 1) != 0) {
                n = counters.scannedNames;
            }
            if ((n5 & 2) != 0) {
                n2 = counters.privateNames;
            }
            if ((n5 & 4) != 0) {
                n3 = counters.notApplicableInContextNames;
            }
            if ((n5 & 8) != 0) {
                n4 = counters.totalVariants;
            }
            return counters.copy(n, n2, n3, n4);
        }

        @NotNull
        public String toString() {
            return "Counters(scannedNames=" + this.scannedNames + ", privateNames=" + this.privateNames + ", notApplicableInContextNames=" + this.notApplicableInContextNames + ", totalVariants=" + this.totalVariants + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.scannedNames);
            result = result * 31 + Integer.hashCode(this.privateNames);
            result = result * 31 + Integer.hashCode(this.notApplicableInContextNames);
            result = result * 31 + Integer.hashCode(this.totalVariants);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Counters)) {
                return false;
            }
            Counters counters = (Counters)other;
            if (this.scannedNames != counters.scannedNames) {
                return false;
            }
            if (this.privateNames != counters.privateNames) {
                return false;
            }
            if (this.notApplicableInContextNames != counters.notApplicableInContextNames) {
                return false;
            }
            return this.totalVariants == counters.totalVariants;
        }

        public Counters() {
            this(0, 0, 0, 0, 15, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\b\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/python/codeInsight/completion/PyClassNameCompletionContributor$InsertHandlers;", "", "<init>", "()V", "importingInsertHandler", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getImportingInsertHandler$intellij_python_psi_impl", "()Lcom/intellij/codeInsight/completion/InsertHandler;", "functionInsertHandler", "getFunctionInsertHandler$intellij_python_psi_impl", "genericTypeInsertHandler", "getGenericTypeInsertHandler$intellij_python_psi_impl", "stringLiteralInsertHandler", "getStringLiteralInsertHandler$intellij_python_psi_impl", "insertStringLiteralPrefix", "", "qualifiedName", "", "name", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "addImportForLookupElement", "item", "tailOffset", "", "intellij.python.psi.impl"})
    public static final class InsertHandlers {
        @NotNull
        public static final InsertHandlers INSTANCE = new InsertHandlers();
        @NotNull
        private static final InsertHandler<LookupElement> importingInsertHandler = InsertHandlers::importingInsertHandler$lambda$0;
        @NotNull
        private static final InsertHandler<LookupElement> functionInsertHandler = (InsertHandler)new PyFunctionInsertHandler(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                int tailOffset = context.getTailOffset() - 1;
                super.handleInsert(context, item);
                context.commitDocument();
                InsertHandlers.addImportForLookupElement(context, item, tailOffset);
            }
        };
        @NotNull
        private static final InsertHandler<LookupElement> genericTypeInsertHandler = InsertHandlers::genericTypeInsertHandler$lambda$0;
        @NotNull
        private static final InsertHandler<LookupElement> stringLiteralInsertHandler = InsertHandlers::stringLiteralInsertHandler$lambda$0;

        private InsertHandlers() {
        }

        @NotNull
        public final InsertHandler<LookupElement> getImportingInsertHandler$intellij_python_psi_impl() {
            return importingInsertHandler;
        }

        @NotNull
        public final InsertHandler<LookupElement> getFunctionInsertHandler$intellij_python_psi_impl() {
            return functionInsertHandler;
        }

        @NotNull
        public final InsertHandler<LookupElement> getGenericTypeInsertHandler$intellij_python_psi_impl() {
            return genericTypeInsertHandler;
        }

        @NotNull
        public final InsertHandler<LookupElement> getStringLiteralInsertHandler$intellij_python_psi_impl() {
            return stringLiteralInsertHandler;
        }

        private final void insertStringLiteralPrefix(String qualifiedName, String name, InsertionContext context) {
            if (qualifiedName != null && name != null) {
                String qualifiedNamePrefix = StringsKt.dropLast((String)qualifiedName, (int)name.length());
                context.getDocument().insertString(context.getStartOffset(), (CharSequence)qualifiedNamePrefix);
            }
        }

        @JvmStatic
        public static final void addImportForLookupElement(@NotNull InsertionContext context, @NotNull LookupElement item, int tailOffset) {
            PsiReference ref;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)context.getProject());
            Document document = manager.getDocument(context.getFile());
            if (document != null) {
                manager.commitDocument(document);
            }
            if ((ref = context.getFile().findReferenceAt(tailOffset)) == null || ref.resolve() == item.getPsiElement()) {
                return;
            }
            PsiFile[] psiFileArray = new PsiFile[]{context.getFile()};
            WriteCommandAction.writeCommandAction((Project)context.getProject(), (PsiFile[])psiFileArray).run(() -> InsertHandlers.addImportForLookupElement$lambda$0(item, context, ref));
        }

        private static final void importingInsertHandler$lambda$0(InsertionContext context, LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            InsertHandlers.addImportForLookupElement(context, item, context.getTailOffset() - 1);
        }

        private static final void genericTypeInsertHandler$lambda$0(InsertionContext context, LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            int tailOffset = context.getTailOffset() - 1;
            PyParameterizedTypeInsertHandler.INSTANCE.handleInsert(context, item);
            context.commitDocument();
            InsertHandlers.addImportForLookupElement(context, item, tailOffset);
        }

        private static final void stringLiteralInsertHandler$lambda$0(InsertionContext context, LookupElement item) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            PsiElement element = item.getPsiElement();
            if (element == null) {
                return;
            }
            if (element instanceof PyQualifiedNameOwner) {
                INSTANCE.insertStringLiteralPrefix(((PyQualifiedNameOwner)element).getQualifiedName(), ((PyQualifiedNameOwner)element).getName(), context);
            } else {
                QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath(element, null);
                if (importPath != null) {
                    INSTANCE.insertStringLiteralPrefix(importPath.toString(), String.valueOf(importPath.getLastComponent()), context);
                }
            }
        }

        private static final void addImportForLookupElement$lambda$0(LookupElement $item, InsertionContext $context, PsiReference $ref) {
            PsiElement psiElement = $item.getPsiElement();
            if (psiElement instanceof PsiNamedElement) {
                PsiNamedElement psiNamedElement = (PsiNamedElement)psiElement;
                PsiFile psiFile = $context.getFile();
                PsiElement psiElement2 = $ref.getElement();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyElement");
                AddImportHelper.addImport(psiNamedElement, psiFile, (PyElement)psiElement2);
            }
        }
    }
}

