/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.stdlib.PyStdlibTypeProvider;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyEnumInspectionKt;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/inspections/PyEnumInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "intellij.python.psi.impl"})
public final class PyEnumInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        return (PsiElementVisitor)new PyInspectionVisitor(holder, typeEvalContext){

            public void visitPyClass(PyClass node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.validateSuperClasses(node);
                this.validateEnumMembers(node);
            }

            private final void validateSuperClasses(PyClass node) {
                for (PyExpression superClassExpression : PyClassImpl.getUnfoldedSuperClassExpressions(node)) {
                    PyClass superClass;
                    PyType superClassType = this.myTypeEvalContext.getType((PyTypedElement)superClassExpression);
                    if (!(superClassType instanceof PyClassType)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)((PyClassType)superClassType).getPyClass(), (String)"getPyClass(...)");
                    if (!PyStdlibTypeProvider.isCustomEnum(superClass, this.myTypeEvalContext) || UtilKt.isEmpty(PyStdlibTypeProvider.getEnumMembers(superClass, this.myTypeEvalContext))) continue;
                    Object[] objectArray = new Object[]{superClass.getName()};
                    this.registerProblem((PsiElement)superClassExpression, PyPsiBundle.message("INSP.enum.enum.class.is.final.and.cannot.be.subclassed", objectArray), ProblemHighlightType.GENERIC_ERROR);
                }
            }

            private final void validateEnumMembers(PyClass pyClass) {
                if (!PyStdlibTypeProvider.isCustomEnum(pyClass, this.myTypeEvalContext)) {
                    return;
                }
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyType declaredType = PyEnumInspectionKt.access$getDeclaredEnumMemberType(pyClass, typeEvalContext);
                String string = PythonDocumentationProvider.getVerboseTypeName(declaredType, this.myTypeEvalContext);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVerboseTypeName(...)");
                String declaredTypeName = string;
                for (PyTargetExpression attribute : pyClass.getClassAttributes()) {
                    PyExpression typeHint;
                    PyExpression value;
                    PyStdlibTypeProvider.EnumAttributeInfo info = PyStdlibTypeProvider.getEnumAttributeInfo(pyClass, attribute, this.myTypeEvalContext);
                    if (info == null || info.attributeKind() == PyStdlibTypeProvider.EnumAttributeKind.NONMEMBER) continue;
                    if (declaredType != null && info.attributeKind() == PyStdlibTypeProvider.EnumAttributeKind.MEMBER && !(PyPsiUtils.flattenParens((PyExpression)(value = attribute.findAssignedValue())) instanceof PyTupleExpression) && !PyTypeChecker.match(declaredType, info.assignedValueType(), this.myTypeEvalContext)) {
                        String valueTypeName;
                        Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(info.assignedValueType(), this.myTypeEvalContext), (String)"getTypeName(...)");
                        Object[] objectArray = new Object[]{valueTypeName, declaredTypeName};
                        this.registerProblem((PsiElement)value, PyPsiBundle.message("INSP.enum.type.is.not.assignable.to.declared.type", objectArray));
                    }
                    if ((typeHint = PyTypingTypeProvider.getAnnotationValue((PyAnnotationOwner)attribute, this.myTypeEvalContext)) == null) continue;
                    this.registerProblem((PsiElement)typeHint, PyPsiBundle.message("INSP.enum.type.annotations.are.not.allowed.for.enum.members", new Object[0]));
                }
            }
        };
    }
}

