/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Processor;
import com.intellij.util.containers.SortedList;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstFunction;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.typing.PyProtocolsKt;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecoratable;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKnownDecorator;
import com.jetbrains.python.psi.PyKnownDecoratorUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyClassImpl;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyOverloadsInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Visitor", "GroupingFunctionsByNameProcessor", "intellij.python.psi.impl"})
public final class PyOverloadsInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return (PsiElementVisitor)new Visitor(holder, typeEvalContext);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0016R#\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyOverloadsInspection$GroupingFunctionsByNameProcessor;", "Lcom/intellij/util/Processor;", "Lcom/jetbrains/python/psi/PyFunction;", "<init>", "()V", "result", "", "", "", "getResult", "()Ljava/util/Map;", "process", "", "t", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyOverloadsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyOverloadsInspection.kt\ncom/jetbrains/python/inspections/PyOverloadsInspection$GroupingFunctionsByNameProcessor\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,171:1\n383#2,7:172\n*S KotlinDebug\n*F\n+ 1 PyOverloadsInspection.kt\ncom/jetbrains/python/inspections/PyOverloadsInspection$GroupingFunctionsByNameProcessor\n*L\n163#1:172,7\n*E\n"})
    private static final class GroupingFunctionsByNameProcessor
    implements Processor<PyFunction> {
        @NotNull
        private final Map<String, List<PyFunction>> result = new HashMap();

        @NotNull
        public final Map<String, List<PyFunction>> getResult() {
            return this.result;
        }

        /*
         * WARNING - void declaration
         */
        public boolean process(@Nullable PyFunction t) {
            String name;
            PyFunction pyFunction = t;
            String string = name = pyFunction != null ? pyFunction.getName() : null;
            if (name != null) {
                Object object;
                void $this$getOrPut$iv;
                Map<String, List<PyFunction>> map = this.result;
                String key$iv = name;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    List answer$iv = (List)new SortedList((arg_0, arg_1) -> GroupingFunctionsByNameProcessor.process$lambda$0$1(GroupingFunctionsByNameProcessor::process$lambda$0$0, arg_0, arg_1));
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((List)object).add(t);
            }
            return true;
        }

        private static final int process$lambda$0$0(PyFunction f1, PyFunction f2) {
            return f1.getTextOffset() - f2.getTextOffset();
        }

        private static final int process$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J$\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\t0\u0012H\u0002J\u001e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J \u0010\u0018\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J \u0010\u001b\u001a\u00020\t2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0017H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/python/inspections/PyOverloadsInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyClass", "", "node", "Lcom/jetbrains/python/psi/PyClass;", "visitPyFile", "Lcom/jetbrains/python/psi/PyFile;", "processScope", "owner", "Lcom/jetbrains/python/codeInsight/controlflow/ScopeOwner;", "processorUsage", "Lkotlin/Function1;", "Lcom/jetbrains/python/inspections/PyOverloadsInspection$GroupingFunctionsByNameProcessor;", "processSameNameFunctions", "functions", "", "Lcom/jetbrains/python/psi/PyFunction;", "checkClassMethodAndStaticMethodConsistency", "overloads", "implementation", "checkOverrideAndFinal", "isOverride", "", "function", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyOverloadsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyOverloadsInspection.kt\ncom/jetbrains/python/inspections/PyOverloadsInspection$Visitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,171:1\n1915#2,2:172\n3347#2,10:174\n1786#2,3:184\n1651#2:189\n1915#2:190\n1916#2:192\n1652#2:193\n1807#2,3:195\n1915#2,2:199\n1342#3,2:187\n1#4:191\n13225#5:194\n13226#5:198\n*S KotlinDebug\n*F\n+ 1 PyOverloadsInspection.kt\ncom/jetbrains/python/inspections/PyOverloadsInspection$Visitor\n*L\n49#1:172,2\n53#1:174,10\n79#1:184,3\n106#1:189\n106#1:190\n106#1:192\n106#1:193\n148#1:195,3\n43#1:199,2\n97#1:187,2\n106#1:191\n147#1:194\n147#1:198\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        public void visitPyClass(@NotNull PyClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.processScope((ScopeOwner)node, (Function1<? super GroupingFunctionsByNameProcessor, Unit>)((Function1)arg_0 -> Visitor.visitPyClass$lambda$0(node, this, arg_0)));
        }

        public void visitPyFile(@NotNull PyFile node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.processScope((ScopeOwner)node, (Function1<? super GroupingFunctionsByNameProcessor, Unit>)((Function1)arg_0 -> Visitor.visitPyFile$lambda$0(node, arg_0)));
        }

        private final void processScope(ScopeOwner owner, Function1<? super GroupingFunctionsByNameProcessor, Unit> processorUsage) {
            GroupingFunctionsByNameProcessor processor2 = new GroupingFunctionsByNameProcessor();
            processorUsage.invoke((Object)processor2);
            Iterable $this$forEach$iv = processor2.getResult().values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List it = (List)element$iv;
                boolean bl = false;
                this.processSameNameFunctions(owner, it);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processSameNameFunctions(ScopeOwner owner, List<? extends PyFunction> functions) {
            PyFunction problemElement;
            PyFunction it;
            Iterable $this$partition$iv = functions;
            boolean $i$f$partition = false;
            Object[] first$iv = new ArrayList();
            ArrayList second$iv = new ArrayList();
            for (Object element$iv : $this$partition$iv) {
                PyFunction it2 = (PyFunction)element$iv;
                boolean bl = false;
                boolean bl2 = PyiUtil.isOverload((PsiElement)it2, this.myTypeEvalContext) ? first$iv.add(element$iv) : second$iv.add(element$iv);
            }
            Pair pair = new Pair(first$iv, second$iv);
            List overloads = (List)pair.component1();
            List implementations = (List)pair.component2();
            if (overloads.isEmpty()) {
                return;
            }
            if (overloads.size() == 1) {
                first$iv = new Object[]{owner instanceof PyClass ? 1 : 0};
                this.registerProblem(((PyFunction)overloads.get(0)).getNameIdentifier(), PyPsiBundle.message("INSP.overloads.at.least.two.overloads.must.be.present", first$iv));
            }
            PyFunction implementation = (PyFunction)CollectionsKt.lastOrNull((List)implementations);
            this.checkClassMethodAndStaticMethodConsistency(overloads, implementation);
            this.checkOverrideAndFinal(overloads, implementation);
            boolean requiresImplementation = true;
            if (owner.getContainingFile() instanceof PyiFile) {
                requiresImplementation = false;
            } else if (owner instanceof PyClass) {
                PyClass pyClass = (PyClass)owner;
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyProtocolsKt.isProtocol(pyClass, typeEvalContext)) {
                    requiresImplementation = false;
                } else if (PyClassImpl.canHaveAbstractMethods((PyClass)owner, this.myTypeEvalContext)) {
                    boolean bl;
                    block16: {
                        Iterable $this$all$iv = overloads;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                it = (PyFunction)element$iv;
                                boolean bl3 = false;
                                if (PyKnownDecoratorUtil.hasAbstractDecorator((PyDecoratable)it, this.myTypeEvalContext)) continue;
                                bl = false;
                                break block16;
                            }
                            bl = true;
                        }
                    }
                    if (bl) {
                        requiresImplementation = false;
                    }
                }
            }
            if (requiresImplementation && implementation != CollectionsKt.last(functions)) {
                problemElement = implementation == null ? (PyFunction)CollectionsKt.first(functions) : (PyFunction)CollectionsKt.last(functions);
                Object[] $i$f$all = new Object[]{owner instanceof PyClass ? 1 : 0};
                this.registerProblem(problemElement.getNameIdentifier(), PyPsiBundle.message("INSP.overloads.series.overloads.should.always.be.followed.by.implementation", $i$f$all));
            }
            if (implementation != null) {
                void $this$forEach$iv;
                problemElement = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)overloads), arg_0 -> Visitor.processSameNameFunctions$lambda$2(implementation, this, arg_0));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (PyFunction)element$iv;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{owner instanceof PyClass ? 1 : 0};
                    this.registerProblem(it.getNameIdentifier(), PyPsiBundle.message("INSP.overloads.this.overload.signature.not.compatible.with.implementation", objectArray));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkClassMethodAndStaticMethodConsistency(List<? extends PyFunction> overloads, PyFunction implementation) {
            void $this$mapNotNullTo$iv;
            Iterable iterable = overloads;
            EnumSet<PyAstFunction.Modifier> enumSet = EnumSet.noneOf(PyAstFunction.Modifier.class);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"noneOf(...)");
            Collection destination$iv = enumSet;
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                PyAstFunction.Modifier it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                PyFunction it = (PyFunction)element$iv;
                boolean bl2 = false;
                if (it.getModifier() == null) continue;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            EnumSet modifiers = (EnumSet)destination$iv;
            for (PyFunction function : SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)overloads), (Sequence)UtilKt.sequenceOfNotNull((Object)implementation))) {
                PyAstFunction.Modifier modifier = function.getModifier();
                if (modifiers.contains(PyAstFunction.Modifier.CLASSMETHOD) && modifier != PyAstFunction.Modifier.CLASSMETHOD) {
                    this.registerProblem(function.getNameIdentifier(), PyPsiBundle.message("INSP.overloads.use.classmethod.inconsistently", new Object[0]));
                }
                if (!modifiers.contains(PyAstFunction.Modifier.STATICMETHOD) || modifier == PyAstFunction.Modifier.STATICMETHOD) continue;
                this.registerProblem(function.getNameIdentifier(), PyPsiBundle.message("INSP.overloads.use.staticmethod.inconsistently", new Object[0]));
            }
        }

        private final void checkOverrideAndFinal(List<? extends PyFunction> overloads, PyFunction implementation) {
            if (implementation == null) {
                for (PyFunction pyFunction : UtilKt.tail(overloads)) {
                    if (this.isOverride(pyFunction)) {
                        this.registerProblem(pyFunction.getNameIdentifier(), PyPsiBundle.message("INSP.overloads.override.should.be.placed.only.on.the.first.overload", new Object[0]));
                    }
                    if (!PyTypingTypeProvider.isFinal((PyDecoratable)pyFunction, this.myTypeEvalContext)) continue;
                    this.registerProblem(pyFunction.getNameIdentifier(), PyPsiBundle.message("INSP.overloads.final.should.be.placed.only.on.the.first.overload", new Object[0]));
                }
            } else {
                for (PyFunction pyFunction : overloads) {
                    if (this.isOverride(pyFunction)) {
                        this.registerProblem(pyFunction.getNameIdentifier(), PyPsiBundle.message("INSP.overloads.override.should.be.placed.on.the.implementation", new Object[0]));
                    }
                    if (!PyTypingTypeProvider.isFinal((PyDecoratable)pyFunction, this.myTypeEvalContext)) continue;
                    this.registerProblem(pyFunction.getNameIdentifier(), PyPsiBundle.message("INSP.overloads.final.should.be.placed.on.the.implementation", new Object[0]));
                }
            }
        }

        private final boolean isOverride(PyFunction function) {
            boolean bl;
            block6: {
                PyDecoratorList pyDecoratorList = (PyDecoratorList)function.getDecoratorList();
                if (pyDecoratorList == null) {
                    return false;
                }
                PyDecoratorList decoratorList = pyDecoratorList;
                PyDecorator[] pyDecoratorArray = decoratorList.getDecorators();
                Intrinsics.checkNotNullExpressionValue((Object)pyDecoratorArray, (String)"getDecorators(...)");
                Object[] $this$any$iv = pyDecoratorArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block5: {
                        PyDecorator decorator = (PyDecorator)element$iv;
                        boolean bl3 = false;
                        List<PyKnownDecorator> list = PyKnownDecoratorUtil.asKnownDecorators(decorator, this.myTypeEvalContext);
                        Intrinsics.checkNotNullExpressionValue(list, (String)"asKnownDecorators(...)");
                        Iterable $this$any$iv2 = list;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                PyKnownDecorator it = (PyKnownDecorator)element$iv2;
                                boolean bl4 = false;
                                if (!(Intrinsics.areEqual((Object)it, (Object)PyKnownDecorator.TYPING_OVERRIDE) || Intrinsics.areEqual((Object)it, (Object)PyKnownDecorator.TYPING_EXTENSIONS_OVERRIDE))) continue;
                                bl2 = true;
                                break block5;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            return bl;
        }

        private static final Unit visitPyClass$lambda$0(PyClass $node, Visitor this$0, GroupingFunctionsByNameProcessor it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            $node.visitMethods((Processor)it, false, this$0.myTypeEvalContext);
            return Unit.INSTANCE;
        }

        private static final Unit visitPyFile$lambda$0(PyFile $node, GroupingFunctionsByNameProcessor processor2) {
            Intrinsics.checkNotNullParameter((Object)processor2, (String)"processor");
            List list = $node.getTopLevelFunctions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTopLevelFunctions(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyFunction it = (PyFunction)element$iv;
                boolean bl = false;
                processor2.process(it);
            }
            return Unit.INSTANCE;
        }

        private static final boolean processSameNameFunctions$lambda$2(PyFunction $implementation, Visitor this$0, PyFunction it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return !PyUtil.isSignatureCompatibleTo((PyCallable)$implementation, (PyCallable)it, this$0.myTypeEvalContext);
        }
    }
}

