/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.AddMatchArgsFix;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyRemoveElementFix;
import com.jetbrains.python.inspections.SimplifyAsPatternFix;
import com.jetbrains.python.psi.PyAsPattern;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyClassPattern;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeywordPattern;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyClassPatternImpl;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\u0003H\u0014J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/python/inspections/PyPatternInspectionVisitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "getHolder", "visitPyAsPattern", "", "element", "Lcom/jetbrains/python/psi/PyAsPattern;", "visitPyClassPattern", "node", "Lcom/jetbrains/python/psi/PyClassPattern;", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyPatternInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPatternInspection.kt\ncom/jetbrains/python/inspections/PyPatternInspectionVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n2792#2,3:205\n777#2:208\n873#2,2:209\n832#2:211\n862#2,2:212\n1915#2,2:214\n3347#2,10:216\n1586#2:226\n1661#2,3:227\n1#3:230\n*S KotlinDebug\n*F\n+ 1 PyPatternInspection.kt\ncom/jetbrains/python/inspections/PyPatternInspectionVisitor\n*L\n64#1:205,3\n65#1:208\n65#1:209,2\n80#1:211\n80#1:212,2\n80#1:214,2\n89#1:216,10\n100#1:226\n100#1:227,3\n*E\n"})
final class PyPatternInspectionVisitor
extends PyInspectionVisitor {
    public PyPatternInspectionVisitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(holder, context);
    }

    @Override
    @NotNull
    protected ProblemsHolder getHolder() {
        ProblemsHolder problemsHolder = super.getHolder();
        Intrinsics.checkNotNull((Object)problemsHolder);
        return problemsHolder;
    }

    public void visitPyAsPattern(@NotNull PyAsPattern element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PyPattern pyPattern = element.getPattern();
        Intrinsics.checkNotNullExpressionValue((Object)pyPattern, (String)"getPattern(...)");
        PyPattern pattern = pyPattern;
        if (element.getTarget() == null) {
            return;
        }
        if (pattern instanceof PyClassPattern && PyClassPattern.SPECIAL_BUILTINS.contains(((PyClassPattern)pattern).getClassNameReference().getName()) && ((PyClassPattern)pattern).getArgumentList().getPatterns().isEmpty()) {
            this.getHolder().problem((PsiElement)element, PyPsiBundle.message("INSP.patterns.pattern.can.be.simplified", new Object[0])).highlight(ProblemHighlightType.WEAK_WARNING).fix((ModCommandAction)new SimplifyAsPatternFix(element)).register();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitPyClassPattern(@NotNull PyClassPattern node) {
        void $this$mapTo$iv$iv;
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        PyType type = this.myTypeEvalContext.getType((PyTypedElement)node.getClassNameReference());
        List types = PyTypeUtil.toStream(type).toList();
        Intrinsics.checkNotNull((Object)types);
        if (!((Collection)types).isEmpty()) {
            boolean bl;
            block17: {
                Iterable $this$none$iv = types;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        PyType it = (PyType)element$iv;
                        boolean bl2 = false;
                        if (!PyTypeChecker.isUnknown(it, this.myTypeEvalContext)) continue;
                        bl = false;
                        break block17;
                    }
                    bl = true;
                }
            }
            if (bl) {
                void $this$filterTo$iv$iv;
                Object element$iv;
                Iterable $this$filter$iv = types;
                boolean $i$f$filter = false;
                element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PyType it = (PyType)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!(it instanceof PyClassType) || !((PyClassType)it).isDefinition())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List invalidTypes = (List)destination$iv$iv;
                if (!((Collection)invalidTypes).isEmpty()) {
                    PyType invalidTypesUnion = PyUnionType.union(invalidTypes);
                    String string = PythonDocumentationProvider.getTypeName(invalidTypesUnion, this.myTypeEvalContext);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTypeName(...)");
                    String invalidTypeName = string;
                    objectArray = new Object[]{node.getClassNameReference().getText(), invalidTypeName};
                    this.getHolder().problem((PsiElement)node.getClassNameReference(), PyPsiBundle.message("INSP.patterns.not.a.class", objectArray)).register();
                    return;
                }
            }
        }
        PyClassType pyClassType = type instanceof PyClassType ? (PyClassType)type : null;
        if (pyClassType == null) {
            return;
        }
        PyClassType classType = pyClassType;
        PyClass pyClass = classType.getPyClass();
        Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
        PyClass pyClass2 = pyClass;
        if (PyClassPattern.SPECIAL_BUILTINS.contains(pyClass2.getName())) {
            return;
        }
        List<String> list = PyClassPatternImpl.getMatchArgs(classType, this.myTypeEvalContext);
        if (list == null) {
            void $this$forEach$iv;
            Object element$iv$iv;
            Iterator $this$filterNotTo$iv$iv;
            PyPatternInspectionVisitor $this$visitPyClassPattern_u24lambda_u242 = this;
            boolean bl = false;
            List list2 = node.getArgumentList().getPatterns();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getPatterns(...)");
            Iterable $this$filterNot$iv = list2;
            boolean $i$f$filterNot = false;
            Iterable bl3 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            Iterator iterator = $this$filterNotTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = iterator.next();
                PyPattern it = (PyPattern)element$iv$iv;
                boolean bl4 = false;
                if (it instanceof PyKeywordPattern) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyPattern pattern = (PyPattern)element$iv;
                boolean bl5 = false;
                element$iv$iv = new Object[]{pyClass2.getName()};
                $this$visitPyClassPattern_u24lambda_u242.getHolder().problem((PsiElement)pattern, PyPsiBundle.message("INSP.patterns.class.does.not.support.pattern.matching.with.positional.arguments", element$iv$iv)).fix((ModCommandAction)new AddMatchArgsFix(pyClass2)).register();
            }
            return;
        }
        List<String> matchArgs = list;
        List list3 = node.getArgumentList().getPatterns();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getPatterns(...)");
        Iterable $this$partition$iv = list3;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            PyPattern it = (PyPattern)element$iv;
            boolean bl = false;
            boolean bl6 = !(it instanceof PyKeywordPattern) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        objectArray = new Pair(first$iv, second$iv);
        List positionalPatterns = (List)objectArray.component1();
        List keywordPatterns = (List)objectArray.component2();
        for (PyPattern pattern : CollectionsKt.drop((Iterable)positionalPatterns, (int)matchArgs.size())) {
            Object[] $i$f$forEach = new Object[]{matchArgs.size()};
            ProblemsHolder.ProblemBuilder problemBuilder = this.getHolder().problem((PsiElement)pattern, PyPsiBundle.message("INSP.patterns.too.many.positional.patterns.expected", $i$f$forEach));
            Intrinsics.checkNotNull((Object)pattern);
            problemBuilder.fix((ModCommandAction)new PyRemoveElementFix((PyElement)pattern)).register();
        }
        if (positionalPatterns.isEmpty() || keywordPatterns.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)positionalPatterns);
        boolean $i$f$map = false;
        Iterable element$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void index;
            int item$iv$iv;
            int it = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(index < matchArgs.size() ? matchArgs.get((int)index) : null);
        }
        List positionalAttributeNames = (List)destination$iv$iv;
        for (PyPattern keywordPattern : keywordPatterns) {
            String keywordName;
            Intrinsics.checkNotNull((Object)keywordPattern, (String)"null cannot be cast to non-null type com.jetbrains.python.psi.PyKeywordPattern");
            Intrinsics.checkNotNullExpressionValue((Object)((PyKeywordPattern)keywordPattern).getKeyword(), (String)"getKeyword(...)");
            int positionalIndex = positionalAttributeNames.indexOf(keywordName);
            if (positionalIndex < 0) continue;
            Object[] objectArray2 = new Object[]{keywordName, positionalIndex + 1};
            this.getHolder().problem((PsiElement)keywordPattern, PyPsiBundle.message("INSP.patterns.attribute.already.specified.as.positional.pattern.at.position", objectArray2)).fix((ModCommandAction)new PyRemoveElementFix((PyElement)keywordPattern)).register();
        }
    }

    public void visitPyClass(@NotNull PyClass node) {
        PyExpression pyExpression;
        block8: {
            block7: {
                PyExpression pyExpression2;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PyTargetExpression pyTargetExpression = node.findClassAttribute("__match_args__", false, this.myTypeEvalContext);
                if (pyTargetExpression == null || (pyExpression2 = pyTargetExpression.findAssignedValue()) == null) break block7;
                PyExpression it = pyExpression2;
                boolean bl = false;
                pyExpression = PyPsiUtils.flattenParens((PyExpression)it);
                if (pyExpression != null) break block8;
            }
            return;
        }
        PyExpression matchArgs = pyExpression;
        PyType pyType = this.myTypeEvalContext.getType((PyTypedElement)matchArgs);
        if (pyType == null) {
            return;
        }
        PyType matchArgsType = pyType;
        PyClassType pyClassType = PyBuiltinCache.Companion.getInstance((PsiElement)matchArgs).getStrType();
        if (pyClassType == null) {
            return;
        }
        PyClassType strType = pyClassType;
        PyTupleType pyTupleType = PyTupleType.createHomogeneous((PsiElement)matchArgs, (PyType)strType);
        if (pyTupleType == null) {
            return;
        }
        PyTupleType goodTuple = pyTupleType;
        if (PyTypeChecker.match((PyType)goodTuple, matchArgsType, this.myTypeEvalContext)) {
            return;
        }
        Object[] objectArray = new Object[]{PythonDocumentationProvider.getTypeName((PyType)goodTuple, this.myTypeEvalContext), PythonDocumentationProvider.getTypeName(matchArgsType, this.myTypeEvalContext)};
        this.getHolder().problem((PsiElement)matchArgs, PyPsiBundle.message("INSP.type.checker.expected.type.got.type.instead", objectArray)).register();
    }
}

