/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyStubElementTypes;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.Property;
import com.jetbrains.python.psi.PyAssignmentExpression;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyComprehensionForComponent;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyForPart;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyGlobalStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PyNonlocalStatement;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithItem;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.impl.PyBaseElementImpl;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyElementPresentation;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.PyReferenceExpressionImpl;
import com.jetbrains.python.psi.impl.PyTypeProvider;
import com.jetbrains.python.psi.impl.references.PyQualifiedReference;
import com.jetbrains.python.psi.impl.references.PyTargetReference;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStub;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyAnnotationOwnerStub;
import com.jetbrains.python.psi.stubs.PyClassStub;
import com.jetbrains.python.psi.stubs.PyFunctionStub;
import com.jetbrains.python.psi.stubs.PyLiteralKind;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import com.jetbrains.python.psi.types.PyABCUtil;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyNamedTupleType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeParser;
import com.jetbrains.python.psi.types.PyTypeUtil;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTargetExpressionImpl
extends PyBaseElementImpl<PyTargetExpressionStub>
implements PyTargetExpression {
    @Nullable
    private volatile QualifiedName myQualifiedName;

    public PyTargetExpressionImpl(ASTNode astNode) {
        super(astNode);
    }

    public PyTargetExpressionImpl(PyTargetExpressionStub stub) {
        super(stub, (IStubElementType)PyStubElementTypes.TARGET_EXPRESSION);
    }

    public PyTargetExpressionImpl(PyTargetExpressionStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    protected void acceptPyVisitor(PyElementVisitor pyVisitor) {
        pyVisitor.visitPyTargetExpression((PyTargetExpression)this);
    }

    public int getTextOffset() {
        return super.getTextOffset();
    }

    @Nullable
    public String getName() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.getName();
        }
        return super.getName();
    }

    public PsiElement setName(@NotNull String name) throws IncorrectOperationException {
        ASTNode oldNameElement;
        if (name == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(0);
        }
        if ((oldNameElement = this.getNameElement()) != null) {
            ASTNode nameElement = PyUtil.createNewName(this, name);
            this.getNode().replaceChild(oldNameElement, nameElement);
        }
        return this;
    }

    @Nullable
    public PyType getType(@NotNull TypeEvalContext context, @NotNull TypeEvalContext.Key key) {
        PsiElement nextParent;
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(1);
        }
        if (key == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(2);
        }
        if ("__all__".equals(this.getName())) {
            return null;
        }
        Ref<PyType> pyType = PyReferenceExpressionImpl.getReferenceTypeFromProviders((PsiElement)this, context, null);
        if (pyType != null) {
            return (PyType)pyType.get();
        }
        PyType type = this.getTypeFromDocString();
        if (type != null) {
            return type;
        }
        if (!context.maySwitchToAST((PsiElement)this)) {
            PyLiteralKind literalKind = PyTargetExpressionImpl.getAssignedLiteralKind(this);
            if (literalKind != null) {
                return PyUtil.convertToType(literalKind, PyBuiltinCache.getInstance((PsiElement)this));
            }
            PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
            List types = StreamEx.of(this.multiResolveAssignedValue(resolveContext)).select(PyTypedElement.class).map(el -> {
                Property property;
                String name;
                PyFunction function;
                PyClass containingClass;
                if (el instanceof PyFunction && (containingClass = (function = (PyFunction)el).getContainingClass()) != null && (name = el.getName()) != null && (property = containingClass.findPropertyByCallable((PyCallable)function)) != null) {
                    return property.getType((PyExpression)this, context);
                }
                return context.getType(el);
            }).toList();
            return PyUnionType.union(types);
        }
        type = PyTargetExpressionImpl.getTypeFromComment(this);
        if (type != null) {
            return type;
        }
        PsiElement parent = PsiTreeUtil.skipParentsOfType((PsiElement)this, (Class[])new Class[]{PyParenthesizedExpression.class});
        if (parent instanceof PyAssignmentStatement) {
            PyAssignmentStatement assignmentStatement = (PyAssignmentStatement)parent;
            PyExpression assignedValue = assignmentStatement.getAssignedValue();
            if (assignedValue != null) {
                PyType literalType;
                if (PyTypingTypeProvider.isFinal(this, context) && (literalType = PyLiteralType.getLiteralType(assignedValue, context)) != null) {
                    return literalType;
                }
                return context.getType((PyTypedElement)assignedValue);
            }
            return null;
        }
        if ((parent instanceof PyTupleExpression || parent instanceof PyListLiteralExpression) && (nextParent = PsiTreeUtil.skipParentsOfType((PsiElement)parent, (Class[])new Class[]{PyParenthesizedExpression.class, PyTupleExpression.class, PyListLiteralExpression.class})) instanceof PyAssignmentStatement) {
            PyType positionalItemType;
            PyAssignmentStatement assignment = (PyAssignmentStatement)nextParent;
            PyExpression value = assignment.getAssignedValue();
            PyExpression lhs = assignment.getLeftHandSideExpression();
            PySequenceExpression targetTupleOrList = (PySequenceExpression)PsiTreeUtil.findChildOfType((PsiElement)lhs, PySequenceExpression.class, (boolean)false);
            if (value != null && (targetTupleOrList instanceof PyTupleExpression || targetTupleOrList instanceof PyListLiteralExpression) && (positionalItemType = this.getTargetTypeFromIterableUnpacking(targetTupleOrList, value, context)) != null) {
                return positionalItemType;
            }
        }
        if (parent instanceof PyWithItem) {
            PyWithItem withItem = (PyWithItem)parent;
            return PyTargetExpressionImpl.getWithItemVariableType(withItem, context);
        }
        if (parent instanceof PyPattern) {
            PyPattern pattern = (PyPattern)parent;
            return context.getType((PyTypedElement)pattern);
        }
        if (parent instanceof PyAssignmentExpression) {
            PyExpression assignedValue = ((PyAssignmentExpression)parent).getAssignedValue();
            return assignedValue == null ? null : context.getType((PyTypedElement)assignedValue);
        }
        if (parent instanceof PyImportElement) {
            PyImportElement importElement = (PyImportElement)parent;
            PyReferenceExpression importedRef = importElement.getImportReferenceExpression();
            return importedRef == null ? null : context.getType((PyTypedElement)importedRef);
        }
        if (parent instanceof PyGlobalStatement || parent instanceof PyNonlocalStatement) {
            PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
            List collect = ((StreamEx)StreamEx.of((Object[])this.getReference(resolveContext).multiResolve(false)).map(ResolveResult::getElement).filter(e -> e != this)).select(PyTypedElement.class).map(arg_0 -> ((TypeEvalContext)context).getType(arg_0)).toList();
            return PyUnionType.union(collect);
        }
        if (parent instanceof PyExceptPart && ((PyExceptPart)parent).isStar() && LanguageLevel.forElement((PsiElement)this).isAtLeast(LanguageLevel.PYTHON311)) {
            return PyClassTypeImpl.createTypeByQName((PsiElement)this, "ExceptionGroup", false);
        }
        PyType iterType = this.getTypeFromIteration(context);
        if (iterType != null) {
            return iterType;
        }
        PyType excType = this.getTypeFromExcept();
        if (excType != null) {
            return excType;
        }
        return null;
    }

    @Nullable
    private PyType getTargetTypeFromIterableUnpacking(@NotNull PySequenceExpression topmostContainingTupleOrList, @NotNull PyExpression assignedIterable, @NotNull TypeEvalContext context) {
        PyType assignedType;
        if (topmostContainingTupleOrList == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(3);
        }
        if (assignedIterable == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(5);
        }
        if ((assignedType = PyUnionType.toNonWeakType(context.getType((PyTypedElement)assignedIterable))) instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)assignedType;
            return PyTypeChecker.getTargetTypeFromTupleAssignment((PyExpression)this, topmostContainingTupleOrList, tupleType);
        }
        if (assignedType instanceof PyClassLikeType) {
            PyClassLikeType classLikeType = (PyClassLikeType)assignedType;
            PyNamedTupleType namedTupleType = (PyNamedTupleType)ContainerUtil.findInstance((Iterable)classLikeType.getAncestorTypes(context), PyNamedTupleType.class);
            if (namedTupleType != null) {
                return PyTypeChecker.getTargetTypeFromTupleAssignment((PyExpression)this, topmostContainingTupleOrList, namedTupleType);
            }
            return PyTargetExpressionImpl.getIterationType(assignedType, assignedIterable, (PsiElement)assignedIterable, false, context);
        }
        return null;
    }

    @Nullable
    public String getAnnotationValue() {
        PyAnnotationOwnerStub stub = (PyAnnotationOwnerStub)this.getStub();
        if (stub != null) {
            return stub.getAnnotation();
        }
        return super.getAnnotationValue();
    }

    @Nullable
    private static PyType getWithItemVariableType(@NotNull PyWithItem item, @NotNull TypeEvalContext context) {
        if (item == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(6);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(7);
        }
        PyExpression withExpression = item.getExpression();
        PyType withType = context.getType((PyTypedElement)withExpression);
        PyWithStatement withStatement = (PyWithStatement)PsiTreeUtil.getParentOfType((PsiElement)item, PyWithStatement.class);
        boolean isAsync = withStatement != null && withStatement.isAsync();
        return (PyType)PyTypeUtil.toStream(withType).select(PyClassType.class).map(t -> PyTargetExpressionImpl.getEnterTypeFromPyClass(withExpression, t, isAsync, context)).collect(PyTypeUtil.toUnion(withType));
    }

    @Nullable
    private static PyType getEnterTypeFromPyClass(@NotNull PyExpression withExpression, @NotNull PyClassType withType, boolean isAsync, @NotNull TypeEvalContext context) {
        PyClass cls;
        PyFunction enter;
        if (withExpression == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(8);
        }
        if (withType == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(9);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(10);
        }
        if ((enter = (cls = withType.getPyClass()).findMethodByName(isAsync ? "__aenter__" : "__enter__", true, context)) != null) {
            PyType enterType = PyTargetExpressionImpl.getContextSensitiveType(enter, context, withExpression);
            if (enterType != null) {
                return isAsync ? (PyType)Ref.deref(PyTypingTypeProvider.coroutineOrGeneratorElementType(enterType)) : enterType;
            }
            for (PyTypeProvider provider : PyTypeProvider.EP_NAME.getExtensionList()) {
                PyType typeFromProvider = provider.getContextManagerVariableType(cls, withExpression, context);
                if (typeFromProvider == null) continue;
                return typeFromProvider;
            }
            return PyUnionType.createWeakType((PyType)withType);
        }
        return null;
    }

    @Nullable
    public PyType getTypeFromDocString() {
        StructuredDocString classDocString;
        PyClass cls;
        String typeName = null;
        String name = this.getName();
        StructuredDocString targetDocString = this.getStructuredDocString();
        if (targetDocString != null && (typeName = targetDocString.getParamType(null)) == null) {
            typeName = targetDocString.getParamType(name);
        }
        if (typeName == null && PyUtil.isAttribute(this) && (cls = this.getContainingClass()) != null && (classDocString = cls.getStructuredDocString()) != null) {
            typeName = classDocString.getParamType(name);
        }
        if (typeName != null) {
            return PyTypeParser.getTypeByName((PsiElement)this, typeName);
        }
        return null;
    }

    @Nullable
    public static PyType getTypeFromComment(PyTargetExpressionImpl targetExpression) {
        String docComment = DocStringUtil.getAttributeDocComment(targetExpression);
        if (docComment != null) {
            StructuredDocString structuredDocString = DocStringUtil.parse(docComment, (PsiElement)targetExpression);
            String typeName = structuredDocString.getParamType(null);
            if (typeName == null) {
                typeName = structuredDocString.getParamType(targetExpression.getName());
            }
            if (typeName != null) {
                return PyTypeParser.getTypeByName((PsiElement)targetExpression, typeName);
            }
        }
        return null;
    }

    @Nullable
    private PyType getTypeFromIteration(@NotNull TypeEvalContext context) {
        PyComprehensionElement comprh;
        PyForPart forPart;
        Object expr;
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(11);
        }
        Object target = null;
        PyExpression source = null;
        boolean isAsync = false;
        PyForStatement forStatement = (PyForStatement)PsiTreeUtil.getParentOfType((PsiElement)this, PyForStatement.class);
        if (forStatement != null && PsiTreeUtil.isAncestor((PsiElement)(expr = (forPart = forStatement.getForPart()).getTarget()), (PsiElement)this, (boolean)false)) {
            target = expr;
            source = forPart.getSource();
            isAsync = forStatement.isAsync();
        }
        if ((comprh = (PyComprehensionElement)PsiTreeUtil.getParentOfType((PsiElement)this, PyComprehensionElement.class)) != null) {
            for (PyComprehensionForComponent c : comprh.getForComponents()) {
                PyExpression expr2 = (PyExpression)c.getIteratorVariable();
                if (!PsiTreeUtil.isAncestor((PsiElement)expr2, (PsiElement)this, (boolean)false)) continue;
                target = expr2;
                source = (PyExpression)c.getIteratedList();
                isAsync = c.isAsync();
            }
        }
        if (source != null) {
            PyType sourceType = context.getType(source);
            PyType type = PyTargetExpressionImpl.getIterationType(sourceType, source, (PsiElement)this, isAsync, context);
            target = PyPsiUtils.flattenParens((PyExpression)target);
            if (type instanceof PyTupleType) {
                PyTupleType tupleType = (PyTupleType)type;
                if (target instanceof PyTupleExpression || target instanceof PyListLiteralExpression) {
                    return PyTypeChecker.getTargetTypeFromTupleAssignment((PyExpression)this, (PySequenceExpression)target, tupleType);
                }
            }
            if (target == this && type != null) {
                return type;
            }
        }
        return null;
    }

    @Nullable
    public static PyType getIterationType(@Nullable PyType iterableType, @Nullable PyExpression source, @NotNull PsiElement anchor, boolean isAsync, @NotNull TypeEvalContext context) {
        PyFunction iterateMethod;
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(12);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(13);
        }
        if (iterableType instanceof PyTupleType) {
            PyTupleType tupleType = (PyTupleType)iterableType;
            return tupleType.getIteratedItemType();
        }
        if (iterableType instanceof PyUnionType) {
            return ((PyUnionType)iterableType).map(member -> PyTargetExpressionImpl.getIterationType(member, source, anchor, isAsync, context));
        }
        if (!isAsync) {
            if (iterableType != null && PyABCUtil.isSubtype(iterableType, "Iterable", context)) {
                PyFunction iterateMethod2 = PyTargetExpressionImpl.findMethodByName(iterableType, "__iter__", context);
                if (iterateMethod2 != null) {
                    PyType iterateReturnType = PyTargetExpressionImpl.getContextSensitiveType(iterateMethod2, context, source);
                    return PyTargetExpressionImpl.getIteratedItemType(iterateReturnType, source, anchor, context, false);
                }
                Ref<PyType> nextMethodCallType = PyTargetExpressionImpl.getNextMethodCallType(iterableType, source, anchor, context, false);
                if (nextMethodCallType != null) {
                    return (PyType)nextMethodCallType.get();
                }
                PyFunction getItem = PyTargetExpressionImpl.findMethodByName(iterableType, "__getitem__", context);
                if (getItem != null) {
                    return PyTargetExpressionImpl.getContextSensitiveType(getItem, context, source);
                }
            }
        } else if (iterableType != null && PyABCUtil.isSubtype(iterableType, "AsyncIterable", context) && (iterateMethod = PyTargetExpressionImpl.findMethodByName(iterableType, "__aiter__", context)) != null) {
            PyType iterateReturnType = PyTargetExpressionImpl.getContextSensitiveType(iterateMethod, context, source);
            return PyTargetExpressionImpl.getIteratedItemType(iterateReturnType, source, anchor, context, true);
        }
        return null;
    }

    @Nullable
    private static PyType getIteratedItemType(@Nullable PyType type, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context, boolean async) {
        Ref<PyType> nextMethodCallType;
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(15);
        }
        if ((nextMethodCallType = PyTargetExpressionImpl.getNextMethodCallType(type, source, anchor, context, async)) != null && !nextMethodCallType.isNull()) {
            if (async) {
                return (PyType)Ref.deref(PyTypingTypeProvider.unwrapCoroutineReturnType((PyType)nextMethodCallType.get()));
            }
            return (PyType)nextMethodCallType.get();
        }
        if (type instanceof PyCollectionType) {
            return ((PyCollectionType)type).getIteratedItemType();
        }
        return null;
    }

    @Nullable
    private static Ref<PyType> getNextMethodCallType(@Nullable PyType type, @Nullable PyExpression source, @NotNull PsiElement anchor, @NotNull TypeEvalContext context, boolean async) {
        if (anchor == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(16);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(17);
        }
        if (type == null) {
            return null;
        }
        String nextMethodName = async ? "__anext__" : (!LanguageLevel.forElement((PsiElement)anchor).isPython2() ? "__next__" : "next");
        PyFunction next = PyTargetExpressionImpl.findMethodByName(type, nextMethodName, context);
        if (next != null) {
            return Ref.create((Object)PyTargetExpressionImpl.getContextSensitiveType(next, context, source));
        }
        return null;
    }

    @Nullable
    private static PyFunction findMethodByName(@NotNull PyType type, @NotNull String name, @NotNull TypeEvalContext context) {
        PyType actualType;
        PyClassType classType;
        if (type == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(18);
        }
        if (name == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(19);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(20);
        }
        PyResolveContext resolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
        if (type instanceof PyClassType && (classType = (PyClassType)type).isDefinition()) {
            PyClassLikeType metaclassType = classType.getMetaClassType(resolveContext.getTypeEvalContext(), true);
            if (metaclassType == null) {
                return null;
            }
            actualType = metaclassType;
        } else {
            actualType = type;
        }
        List results = actualType.resolveMember(name, null, AccessDirection.READ, resolveContext);
        if (results != null) {
            List allMethods = StreamEx.of((Collection)results).map(RatedResolveResult::getElement).select(PyFunction.class).toList();
            PyFunction matchingBySelf = (PyFunction)ContainerUtil.find((Iterable)allMethods, method -> PyTargetExpressionImpl.selfParameterMatchesReceiver(method, actualType, context));
            return matchingBySelf != null ? matchingBySelf : (PyFunction)ContainerUtil.getFirstItem((List)allMethods);
        }
        return null;
    }

    private static boolean selfParameterMatchesReceiver(@NotNull PyFunction method, @NotNull PyType receiverType, @NotNull TypeEvalContext context) {
        List parameters;
        if (method == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(21);
        }
        if (receiverType == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(22);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(23);
        }
        if ((parameters = method.getParameters(context)).isEmpty()) {
            return false;
        }
        PyCallableParameter firstParameter = (PyCallableParameter)parameters.get(0);
        if (!firstParameter.isSelf()) {
            return false;
        }
        PyType selfParameterType = firstParameter.getType(context);
        PyTypeChecker.GenericSubstitutions substitutions = PyTypeChecker.unifyReceiver(receiverType, context);
        return PyTypeChecker.match(PyTypeChecker.substitute(selfParameterType, substitutions, context), receiverType, context);
    }

    @Nullable
    public static PyType getContextSensitiveType(@NotNull PyFunction function, @NotNull TypeEvalContext context, @Nullable PyExpression source) {
        if (function == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(24);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(25);
        }
        return function.getCallType(source, null, PyTargetExpressionImpl.buildArgumentsToParametersMap(source, (PyCallable)function, context), context);
    }

    @NotNull
    private static Map<PyExpression, PyCallableParameter> buildArgumentsToParametersMap(@Nullable PyExpression receiver, @NotNull PyCallable callable, @NotNull TypeEvalContext context) {
        if (callable == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(26);
        }
        if (context == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(27);
        }
        if (receiver == null) {
            Map<PyExpression, PyCallableParameter> map = Collections.emptyMap();
            if (map == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(28);
            }
            return map;
        }
        PyCallableParameter firstParameter = (PyCallableParameter)ContainerUtil.getFirstItem((List)callable.getParameters(context));
        if (firstParameter == null || !firstParameter.isSelf()) {
            Map<PyExpression, PyCallableParameter> map = Collections.emptyMap();
            if (map == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(29);
            }
            return map;
        }
        Map<PyExpression, PyCallableParameter> map = Map.of(receiver, firstParameter);
        if (map == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(30);
        }
        return map;
    }

    @Nullable
    private PyType getTypeFromExcept() {
        PsiElement element;
        PyExceptPart exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)this, PyExceptPart.class);
        if (exceptPart == null || exceptPart.getTarget() != this) {
            return null;
        }
        PyExpression exceptClass = exceptPart.getExceptClass();
        if (exceptClass instanceof PyReferenceExpression && (element = ((PyReferenceExpression)exceptClass).getReference().resolve()) instanceof PyClass) {
            return new PyClassTypeImpl((PyClass)element, false);
        }
        return null;
    }

    @Nullable
    public QualifiedName asQualifiedName() {
        if (this.myQualifiedName == null) {
            this.myQualifiedName = PyPsiUtils.asQualifiedName((PyQualifiedExpression)this);
        }
        return this.myQualifiedName;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.getName();
    }

    public Icon getIcon(int flags) {
        if (this.isQualified() || PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this, PyDocStringOwner.class) instanceof PyClass) {
            return IconManager.getInstance().getPlatformIcon(PlatformIcons.Field);
        }
        return IconManager.getInstance().getPlatformIcon(PlatformIcons.Variable);
    }

    public boolean isQualified() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.isQualified();
        }
        return this.getQualifier() != null;
    }

    @NotNull
    public List<PsiElement> multiResolveAssignedValue(@NotNull PyResolveContext resolveContext) {
        ScopeOwner owner;
        TypeEvalContext context;
        if (resolveContext == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(31);
        }
        if ((context = resolveContext.getTypeEvalContext()).maySwitchToAST((PsiElement)this)) {
            PyExpression value = this.findAssignedValue();
            List list = value != null ? ContainerUtil.filter(PyUtil.multiResolveTopPriority((PsiElement)value, resolveContext), Objects::nonNull) : Collections.emptyList();
            if (list == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(32);
            }
            return list;
        }
        QualifiedName qName = this.getAssignedQName();
        if (qName != null && qName.getComponentCount() != 0 && (owner = ScopeUtil.getScopeOwner((PsiElement)this)) != null) {
            List<PsiElement> list = PyResolveUtil.resolveQualifiedNameInScope(qName, owner, context);
            if (list == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(33);
            }
            return list;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(34);
        }
        return list;
    }

    @Nullable
    public QualifiedName getAssignedQName() {
        return (QualifiedName)Ref.deref(PyTargetExpressionImpl.getAssignedReferenceQualifiedName(this));
    }

    public QualifiedName getCalleeName() {
        return (QualifiedName)Ref.deref(PyTargetExpressionImpl.getAssignedCallCalleeQualifiedName(this));
    }

    @NotNull
    public PsiReference getReference() {
        PsiPolyVariantReference psiPolyVariantReference = this.getReference(PyResolveContext.defaultContext((TypeEvalContext)TypeEvalContext.codeInsightFallback((Project)this.getProject())));
        if (psiPolyVariantReference == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(35);
        }
        return psiPolyVariantReference;
    }

    @NotNull
    public PsiPolyVariantReference getReference(@NotNull PyResolveContext resolveContext) {
        if (resolveContext == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(36);
        }
        if (this.isQualified()) {
            return new PyQualifiedReference((PyQualifiedExpression)this, resolveContext);
        }
        return new PyTargetReference((PyQualifiedExpression)this, resolveContext);
    }

    @NotNull
    public SearchScope getUseScope() {
        if (this.isQualified()) {
            SearchScope searchScope = super.getUseScope();
            if (searchScope == null) {
                PyTargetExpressionImpl.$$$reportNull$$$0(37);
            }
            return searchScope;
        }
        ScopeOwner owner = ScopeUtil.getScopeOwner((PsiElement)this);
        if (owner != null) {
            Scope scope = ControlFlowCache.getScope(owner);
            if (scope.isGlobal(this.getName())) {
                GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)this.getProject());
                if (globalSearchScope == null) {
                    PyTargetExpressionImpl.$$$reportNull$$$0(38);
                }
                return globalSearchScope;
            }
            if (scope.isNonlocal(this.getName())) {
                return new LocalSearchScope((PsiElement)this.getContainingFile());
            }
        }
        PyTargetExpressionImpl container = this;
        while (true) {
            PyElement parentContainer;
            if ((parentContainer = (PyElement)PsiTreeUtil.getParentOfType((PsiElement)container, (Class[])new Class[]{PyFunction.class, PyClass.class})) instanceof PyClass) {
                if (!this.isQualified()) break;
                SearchScope searchScope = super.getUseScope();
                if (searchScope == null) {
                    PyTargetExpressionImpl.$$$reportNull$$$0(39);
                }
                return searchScope;
            }
            if (parentContainer == null) break;
            container = parentContainer;
        }
        if (container instanceof PyFunction) {
            return new LocalSearchScope((PsiElement)container);
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(40);
        }
        return searchScope;
    }

    public PyClass getContainingClass() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            StubElement functionParent;
            StubElement parentStub = stub.getParentStub();
            if (parentStub instanceof PyClassStub) {
                return (PyClass)((PyClassStub)parentStub).getPsi();
            }
            if (parentStub instanceof PyFunctionStub && (functionParent = parentStub.getParentStub()) instanceof PyClassStub) {
                return (PyClass)((PyClassStub)functionParent).getPsi();
            }
            return null;
        }
        return super.getContainingClass();
    }

    public ItemPresentation getPresentation() {
        return new PyElementPresentation(this);
    }

    @Nullable
    public String getDocStringValue() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.getDocString();
        }
        return super.getDocStringValue();
    }

    @Nullable
    public StructuredDocString getStructuredDocString() {
        return DocStringUtil.getStructuredDocString((PyDocStringOwner)this);
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myQualifiedName = null;
    }

    @Nullable
    public String getQualifiedName() {
        return QualifiedNameFinder.getQualifiedName(this);
    }

    @Nullable
    public String getTypeCommentAnnotation() {
        return PyTargetExpressionImpl.getTypeCommentAnnotationFromStubOrPsi(this);
    }

    public boolean hasAssignedValue() {
        PyTargetExpressionStub stub = (PyTargetExpressionStub)this.getStub();
        if (stub != null) {
            return stub.hasAssignedValue();
        }
        return this.findAssignedValue() != null;
    }

    @Nullable
    public static Ref<QualifiedName> getAssignedReferenceQualifiedName(@NotNull PyTargetExpression psi) {
        PyTargetExpressionStub stub;
        if (psi == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(41);
        }
        if ((stub = (PyTargetExpressionStub)psi.getStub()) != null) {
            if (stub.getInitializerType() == PyTargetExpressionStub.InitializerType.ReferenceExpression) {
                return Ref.create((Object)stub.getInitializer());
            }
            return null;
        }
        PyExpression value = psi.findAssignedValue();
        return value instanceof PyReferenceExpression ? Ref.create((Object)((PyReferenceExpression)value).asQualifiedName()) : null;
    }

    @Nullable
    public static Ref<QualifiedName> getAssignedCallCalleeQualifiedName(@NotNull PyTargetExpression psi) {
        PyTargetExpressionStub stub;
        if (psi == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(42);
        }
        if ((stub = (PyTargetExpressionStub)psi.getStub()) != null) {
            CustomTargetExpressionStub customStub;
            PyTargetExpressionStub.InitializerType initializerType = stub.getInitializerType();
            if (initializerType == PyTargetExpressionStub.InitializerType.CallExpression) {
                return Ref.create((Object)stub.getInitializer());
            }
            if (initializerType == PyTargetExpressionStub.InitializerType.Custom && (customStub = (CustomTargetExpressionStub)stub.getCustomStub(CustomTargetExpressionStub.class)) != null) {
                QualifiedName calleeName = customStub.getCalleeName();
                return calleeName != null ? Ref.create((Object)calleeName) : null;
            }
            return null;
        }
        PyExpression value = psi.findAssignedValue();
        return value instanceof PyCallExpression ? Ref.create((Object)PyPsiUtils.asQualifiedName((PyExpression)((PyCallExpression)value).getCallee())) : null;
    }

    @Nullable
    private static PyLiteralKind getAssignedLiteralKind(@NotNull PyTargetExpression psi) {
        PyTargetExpressionStub stub;
        if (psi == null) {
            PyTargetExpressionImpl.$$$reportNull$$$0(43);
        }
        if ((stub = (PyTargetExpressionStub)psi.getStub()) != null) {
            if (stub.getInitializerType() == PyTargetExpressionStub.InitializerType.Other) {
                return stub.getAssignedLiteralKind();
            }
            return null;
        }
        PyExpression value = psi.findAssignedValue();
        return PyLiteralKind.fromExpression((PyExpression)value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 28, 29, 30, 32, 33, 34, 35, 37, 38, 39, 40 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topmostContainingTupleOrList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignedIterable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "withType";
                break;
            }
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverType";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callable";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyTargetExpressionImpl";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyTargetExpressionImpl";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "buildArgumentsToParametersMap";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolveAssignedValue";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTargetTypeFromIterableUnpacking";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getWithItemVariableType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEnterTypeFromPyClass";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromIteration";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getIterationType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getIteratedItemType";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNextMethodCallType";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findMethodByName";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "selfParameterMatchesReceiver";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getContextSensitiveType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "buildArgumentsToParametersMap";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "multiResolveAssignedValue";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedReferenceQualifiedName";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedCallCalleeQualifiedName";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getAssignedLiteralKind";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 28, 29, 30, 32, 33, 34, 35, 37, 38, 39, 40 -> new IllegalStateException(string);
        };
    }
}

