/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.resolve;

import com.google.common.base.Preconditions;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.jetbrains.python.codeInsight.typing.PyStubPackages;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.module.PyModuleService;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.impl.PyImportResolver;
import com.jetbrains.python.psi.resolve.Priority;
import com.jetbrains.python.psi.resolve.PyNamespacePackageUtil;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContext;
import com.jetbrains.python.psi.resolve.PyQualifiedNameResolveContextImpl;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil$resolveModuleFromRoots$lambda$0$;
import com.jetbrains.python.psi.resolve.PyThirdPartySdkDetector;
import com.jetbrains.python.psi.resolve.PythonModulePathCache;
import com.jetbrains.python.psi.resolve.PythonPathCache;
import com.jetbrains.python.psi.resolve.PythonSdkPathCache;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.resolve.ResolveImportUtil;
import com.jetbrains.python.psi.resolve.RootVisitor;
import com.jetbrains.python.psi.resolve.RootVisitorHost;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\t\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0002\u001a\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0016\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015\u001a\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a#\u0010\u0017\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\u00180\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u001a \u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a(\u0010&\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\b\u0010*\u001a\u00020+H\u0002\u001aH\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a&\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a&\u00101\u001a\u00020\u001e*\u0014\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000204022\u0006\u00105\u001a\u000203H\u0002\u001a0\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u000203\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000204022\u0006\u00105\u001a\u000203H\u0002\u001a\u001a\u00108\u001a\u0002032\u0006\u0010%\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u000e\u00109\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0002\u001a\u0010\u0010:\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0002H\u0002\u001a\u001a\u0010;\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\u0010\u0010<\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u0002H\u0002\u00a8\u0006="}, d2={"resolveQualifiedName", "", "Lcom/intellij/psi/PsiElement;", "name", "Lcom/intellij/psi/util/QualifiedName;", "context", "Lcom/jetbrains/python/psi/resolve/PyQualifiedNameResolveContext;", "resolveModuleFromRoots", "resolveTopLevelMember", "resolveModuleAt", "item", "Lcom/intellij/psi/PsiFileSystemItem;", "fromFoothold", "foothold", "fromModule", "module", "Lcom/intellij/openapi/module/Module;", "fromSdk", "project", "Lcom/intellij/openapi/project/Project;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "cachePrefix", "foreignResults", "Lorg/jetbrains/annotations/Nullable;", "relativeResultsFromSkeletons", "relativeResultsForStubsFromRoots", "resolveWithRelativeLevel", "resultsFromRoots", "isAcceptRootAsTopLevelPackage", "", "resolveInRoot", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "findCache", "Lcom/jetbrains/python/psi/resolve/PythonPathCache;", "isSameDirectoryResult", "element", "isSameDirectoryOrRelativeImportResult", "directory", "Lcom/intellij/psi/PsiDirectory;", "result", "checkAccess", "", "filterTopPriorityResultsWithFallback", "primaryResults", "fallbackResults", "filterTopPriorityResults", "resolved", "topResultIs", "Ljava/util/SortedMap;", "Lcom/jetbrains/python/psi/resolve/Priority;", "", "priority", "firstResultWithFallback", "results", "resolvedElementPriority", "isInSkeletons", "isInProvidedSdk", "isUserFile", "isInTypeShed", "intellij.python.psi.impl"})
@JvmName(name="PyResolveImportUtil")
@SourceDebugExtension(value={"SMAP\nPyResolveImportUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyResolveImportUtil.kt\ncom/jetbrains/python/psi/resolve/PyResolveImportUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 DumbService.kt\ncom/intellij/openapi/project/DumbService\n*L\n1#1,496:1\n1807#2,3:497\n3347#2,10:500\n832#2:510\n862#2,2:511\n1849#2,2:514\n1851#2:517\n1849#2,2:518\n1391#2:520\n1480#2,5:521\n1851#2:526\n1538#2,3:527\n1541#2,3:537\n1807#2,3:540\n1#3:513\n479#4:516\n383#5,7:530\n438#6,8:543\n*S KotlinDebug\n*F\n+ 1 PyResolveImportUtil.kt\ncom/jetbrains/python/psi/resolve/PyResolveImportUtil\n*L\n65#1:497,3\n82#1:500,10\n99#1:510\n99#1:511,2\n115#1:514,2\n115#1:517\n149#1:518,2\n151#1:520\n151#1:521,5\n149#1:526\n414#1:527,3\n414#1:537,3\n466#1:540,3\n118#1:516\n414#1:530,7\n208#1:543,8\n*E\n"})
public final class PyResolveImportUtil {
    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @RequiresReadLock
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static final List<PsiElement> resolveQualifiedName(@NotNull QualifiedName name, @NotNull PyQualifiedNameResolveContext context) {
        block12: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PyResolveImportUtil.checkAccess();
            if (!context.isValid()) {
                return CollectionsKt.emptyList();
            }
            relativeDirectory = context.getContainingDirectory();
            relativeResults = PyResolveImportUtil.resolveWithRelativeLevel(name, context);
            if (relativeDirectory == null) ** GOTO lbl-1000
            $this$any$iv = relativeResults;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (T element$iv : $this$any$iv) {
                    it = (PsiElement)element$iv;
                    $i$a$-any-PyResolveImportUtil$resolveQualifiedName$foundRelativeImport$1 = false;
                    if (!PyResolveImportUtil.isSameDirectoryOrRelativeImportResult(name, relativeDirectory, it, context)) continue;
                    v0 = true;
                    break block12;
                }
                v0 = false;
            }
        }
        if (v0) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        foundRelativeImport = v1;
        cache = PyResolveImportUtil.findCache(context);
        mayCache = cache != null && foundRelativeImport == false;
        key = PyResolveImportUtil.cachePrefix(context).append(name);
        if (mayCache && (cachedResults = cache.get(key)) != null) {
            return CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)relativeResults, (Iterable)cachedResults));
        }
        foreignResults = PyResolveImportUtil.foreignResults(name, context);
        var10_10 = new List[]{relativeResults, PyResolveImportUtil.resolveModuleFromRoots(name, context), PyResolveImportUtil.relativeResultsFromSkeletons(name, context)};
        pythonResults = CollectionsKt.distinct((Iterable)CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object[])var10_10)));
        $this$partition$iv = pythonResults;
        $i$f$partition = false;
        first$iv = new ArrayList<T>();
        second$iv = new ArrayList<T>();
        for (T element$iv : $this$partition$iv) {
            it = (PsiElement)element$iv;
            $i$a$-partition-PyResolveImportUtil$resolveQualifiedName$1 = false;
            v2 = (relativeDirectory == null || LanguageLevel.forElement((PsiElement)((PsiElement)relativeDirectory)).isPython2() ? false : PyResolveImportUtil.isSameDirectoryResult(it, context, name)) != false ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        var10_10 = new Pair(first$iv, second$iv);
        sameDirectoryPython3Results = (List)var10_10.component1();
        notSameDirectoryPython3Results = (List)var10_10.component2();
        allResults = relativeDirectory != null && PyUtil.isExplicitPackage(relativeDirectory) != false ? PyResolveImportUtil.filterTopPriorityResultsWithFallback(notSameDirectoryPython3Results, sameDirectoryPython3Results, foreignResults, name, context) : PyResolveImportUtil.filterTopPriorityResultsWithFallback(sameDirectoryPython3Results, notSameDirectoryPython3Results, foreignResults, name, context);
        var15_17 /* !! */  = allResults;
        $i$f$filterNot = false;
        it = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (PsiElement)element$iv$iv;
            $i$a$-filterNot-PyResolveImportUtil$resolveQualifiedName$results$1 = false;
            if (it instanceof PsiFileSystemItem != false && PyResolveImportUtil.isInSkeletons(it) != false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        var15_17 /* !! */  = (List)destination$iv$iv;
        if (var15_17 /* !! */ .isEmpty()) {
            $i$a$-ifEmpty-PyResolveImportUtil$resolveQualifiedName$results$2 = false;
            v3 = allResults;
        } else {
            v3 = var15_17 /* !! */ ;
        }
        results = v3;
        if (mayCache) {
            cache.put(key, results);
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PsiElement> resolveModuleFromRoots(QualifiedName name, PyQualifiedNameResolveContext context) {
        void $this$fold$iv;
        QualifiedName qualifiedName = name.removeTail(name.getComponentCount() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"removeTail(...)");
        QualifiedName head = qualifiedName;
        QualifiedName qualifiedName2 = name.removeHead(1);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName2, (String)"removeHead(...)");
        QualifiedName nameNoHead = qualifiedName2;
        List list = nameNoHead.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComponents(...)");
        Iterable iterable = list;
        List initial$iv = CollectionsKt.distinct((Iterable)PyResolveImportUtil.resultsFromRoots(head, context));
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void component;
            void $this$filterIsInstance$iv;
            String string = (String)element$iv;
            List results = accumulator$iv;
            boolean bl = false;
            Sequence sequence = CollectionsKt.asSequence((Iterable)PyResolveImportUtil.filterTopPriorityResults(results, context.getModule()));
            boolean $i$f$filterIsInstance = false;
            Sequence sequence2 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)resolveModuleFromRoots$lambda$0$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence2, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            accumulator$iv = SequencesKt.toList((Sequence)SequencesKt.flatMap((Sequence)sequence2, arg_0 -> PyResolveImportUtil.resolveModuleFromRoots$lambda$0$0((String)component, context, arg_0)));
        }
        return accumulator$iv;
    }

    @Nullable
    public static final PsiElement resolveTopLevelMember(@NotNull QualifiedName name, @NotNull PyQualifiedNameResolveContext context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyResolveImportUtil.checkAccess();
        String string = name.getLastComponent();
        if (string == null) {
            return null;
        }
        String memberName = string;
        QualifiedName qualifiedName = name.removeLastComponent();
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"removeLastComponent(...)");
        return (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filterIsInstance((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)PyResolveImportUtil.resolveQualifiedName(qualifiedName, context)), PyResolveImportUtil::resolveTopLevelMember$lambda$0), PyFile.class), arg_0 -> PyResolveImportUtil.resolveTopLevelMember$lambda$1(memberName, arg_0)), PyResolveImportUtil::resolveTopLevelMember$lambda$2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiElement> resolveModuleAt(@NotNull QualifiedName name, @Nullable PsiFileSystemItem item, @NotNull PyQualifiedNameResolveContext context) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyResolveImportUtil.checkAccess();
        List empty = CollectionsKt.emptyList();
        if (item == null || !item.isValid()) {
            return empty;
        }
        List list = name.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComponents(...)");
        Iterable iterable = list;
        List initial$iv = CollectionsKt.listOf((Object)item);
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            List list2;
            void component;
            String string = (String)element$iv;
            List seekers = accumulator$iv;
            boolean bl = false;
            if (component == null) {
                list2 = empty;
            } else {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = seekers;
                boolean $i$f$flatMap = false;
                Iterable iterable2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    List<RatedResolveResult> children;
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(ResolveImportUtil.resolveChildren(it, (String)component, context.getFootholdFile(), !context.getWithMembers(), !context.getWithPlainDirectories(), context.getWithoutStubs(), context.getWithoutForeign()), (String)"resolveChildren(...)");
                    List<PsiElement> list3 = PyUtil.filterTopPriorityElements(children);
                    Intrinsics.checkNotNullExpressionValue(list3, (String)"filterTopPriorityElements(...)");
                    Iterable list$iv$iv = list3;
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            accumulator$iv = list2;
        }
        return accumulator$iv;
    }

    @NotNull
    public static final PyQualifiedNameResolveContext fromFoothold(@NotNull PsiElement foothold) {
        Intrinsics.checkNotNullParameter((Object)foothold, (String)"foothold");
        PsiFile psiFile = foothold.getContainingFile();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)(psiFile != null ? (PsiElement)psiFile : foothold));
        PsiManager psiManager = foothold.getManager();
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getManager(...)");
        return new PyQualifiedNameResolveContextImpl(psiManager, module, foothold, PythonSdkUtil.findPythonSdk((Module)module), 0, false, false, false, false, false, 1008, null);
    }

    @NotNull
    public static final PyQualifiedNameResolveContext fromModule(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        return new PyQualifiedNameResolveContextImpl(psiManager, module, null, PythonSdkUtil.findPythonSdk((Module)module), 0, false, false, false, false, false, 1008, null);
    }

    @NotNull
    public static final PyQualifiedNameResolveContext fromSdk(@NotNull Project project, @NotNull Sdk sdk) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        return new PyQualifiedNameResolveContextImpl(psiManager, null, null, sdk, 0, false, false, false, false, false, 1008, null);
    }

    private static final QualifiedName cachePrefix(PyQualifiedNameResolveContext context) {
        List results = new ArrayList();
        if (context.getWithoutStubs()) {
            results.add("without-stubs");
        }
        if (context.getWithoutForeign()) {
            results.add("without-foreign");
        }
        if (context.getWithoutRoots()) {
            results.add("without-roots");
        }
        if (context.getWithMembers()) {
            results.add("with-members");
        }
        QualifiedName qualifiedName = QualifiedName.fromComponents((Collection)results);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromComponents(...)");
        return qualifiedName;
    }

    private static final List<PsiElement> foreignResults(QualifiedName name, PyQualifiedNameResolveContext context) {
        return context.getWithoutForeign() ? CollectionsKt.emptyList() : SequencesKt.toList((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)PyImportResolver.EP_NAME.getExtensionList()), arg_0 -> PyResolveImportUtil.foreignResults$lambda$0(context, name, arg_0))));
    }

    private static final List<PsiElement> relativeResultsFromSkeletons(QualifiedName name, PyQualifiedNameResolveContext context) {
        PsiFile footholdFile = context.getFootholdFile();
        if (context.getWithoutRoots() && footholdFile != null) {
            QualifiedName containingName;
            VirtualFile virtualFile = footholdFile.getVirtualFile();
            if (virtualFile == null || FileIndexFacade.getInstance((Project)context.getProject()).isInContent(virtualFile)) {
                return CollectionsKt.emptyList();
            }
            PsiDirectory containingDirectory = context.getContainingDirectory();
            if (containingDirectory != null && (containingName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)containingDirectory, null)) != null && containingName.getComponentCount() > 0) {
                QualifiedName absoluteName = containingName.append(name);
                Sdk sdk = PythonSdkUtil.findPythonSdk((PsiElement)((PsiElement)footholdFile));
                if (sdk == null) {
                    return CollectionsKt.emptyList();
                }
                Sdk sdk2 = sdk;
                VirtualFile virtualFile2 = PythonSdkUtil.findSkeletonsDir((Sdk)sdk2);
                if (virtualFile2 == null) {
                    return CollectionsKt.emptyList();
                }
                VirtualFile skeletonsVirtualFile = virtualFile2;
                PsiDirectory skeletonsDir = context.getPsiManager().findDirectory(skeletonsVirtualFile);
                Intrinsics.checkNotNull((Object)absoluteName);
                PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)skeletonsDir;
                PyQualifiedNameResolveContext pyQualifiedNameResolveContext = context.copyWithoutForeign();
                Intrinsics.checkNotNullExpressionValue((Object)pyQualifiedNameResolveContext, (String)"copyWithoutForeign(...)");
                return PyResolveImportUtil.resolveModuleAt(absoluteName, psiFileSystemItem, pyQualifiedNameResolveContext);
            }
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public static final List<PsiElement> relativeResultsForStubsFromRoots(@NotNull QualifiedName name, @NotNull PyQualifiedNameResolveContext context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(context.getFootholdFile() instanceof PyiFile) || context.getRelativeLevel() <= 0) {
            return CollectionsKt.emptyList();
        }
        PsiDirectory psiDirectory = context.getContainingDirectory();
        if (psiDirectory == null) {
            return CollectionsKt.emptyList();
        }
        PsiDirectory containingDirectory = psiDirectory;
        QualifiedName qualifiedName = QualifiedNameFinder.findCanonicalImportPath((PsiElement)containingDirectory, null);
        if (qualifiedName == null) {
            return CollectionsKt.emptyList();
        }
        QualifiedName containingName = qualifiedName;
        if (containingName.getComponentCount() <= 0) {
            return CollectionsKt.emptyList();
        }
        QualifiedName absoluteName = containingName.append(name);
        Intrinsics.checkNotNull((Object)absoluteName);
        PyQualifiedNameResolveContext pyQualifiedNameResolveContext = context.copyWithRelative(-1).copyWithRoots();
        Intrinsics.checkNotNullExpressionValue((Object)pyQualifiedNameResolveContext, (String)"copyWithRoots(...)");
        return PyResolveImportUtil.resultsFromRoots(absoluteName, pyQualifiedNameResolveContext);
    }

    private static final List<PsiElement> resolveWithRelativeLevel(QualifiedName name, PyQualifiedNameResolveContext context) {
        PsiFile footholdFile = context.getFootholdFile();
        if (context.getRelativeLevel() >= 0 && footholdFile != null) {
            return CollectionsKt.plus((Collection)PyResolveImportUtil.resolveModuleAt(name, (PsiFileSystemItem)context.getContainingDirectory(), context), (Iterable)PyResolveImportUtil.relativeResultsForStubsFromRoots(name, context));
        }
        return CollectionsKt.emptyList();
    }

    private static final List<PsiElement> resultsFromRoots(QualifiedName name, PyQualifiedNameResolveContext context) {
        if (context.getWithoutRoots()) {
            return CollectionsKt.emptyList();
        }
        List moduleResults = new ArrayList();
        List sdkResults = new ArrayList();
        Sdk sdk = context.getEffectiveSdk();
        Module module = context.getModule();
        PsiFile footholdFile = context.getFootholdFile();
        boolean withoutStubs = context.getWithoutStubs();
        RootVisitor visitor = (arg_0, arg_1, arg_2, arg_3) -> PyResolveImportUtil.resultsFromRoots$lambda$0(moduleResults, sdkResults, context, name, withoutStubs, arg_0, arg_1, arg_2, arg_3);
        if (context.getVisitAllModules()) {
            RootVisitorHost.visitRootsInAllModules(context.getProject(), visitor);
            if (sdk != null) {
                RootVisitorHost.visitSdkRoots(sdk, visitor);
            } else if (footholdFile != null) {
                RootVisitorHost.visitSdkRoots(footholdFile, visitor);
            }
        } else if (module != null) {
            boolean otherSdk = !Intrinsics.areEqual((Object)sdk, (Object)context.getSdk());
            RootVisitorHost.visitRoots(module, otherSdk, visitor);
            if (otherSdk && sdk != null) {
                RootVisitorHost.visitSdkRoots(sdk, visitor);
            }
        } else if (footholdFile != null) {
            RootVisitorHost.visitRoots((PsiElement)footholdFile, visitor);
        } else if (sdk != null) {
            RootVisitorHost.visitSdkRoots(sdk, visitor);
        } else {
            throw new IllegalStateException();
        }
        return CollectionsKt.plus((Collection)moduleResults, (Iterable)sdkResults);
    }

    private static final boolean isAcceptRootAsTopLevelPackage(PyQualifiedNameResolveContext context) {
        Module module = context.getModule();
        if (module != null) {
            Module it = module;
            boolean bl = false;
            Ref ref = Ref.create((Object)false);
            PyModuleService.getInstance().forAllFacets(it, arg_0 -> PyResolveImportUtil.isAcceptRootAsTopLevelPackage$lambda$0$0(ref, arg_0));
            Object object = ref.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            return (Boolean)object;
        }
        return false;
    }

    @ApiStatus.Internal
    @NotNull
    public static final List<PsiElement> resolveInRoot(@NotNull QualifiedName name, @NotNull VirtualFile root, @NotNull PyQualifiedNameResolveContext context) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return root.isDirectory() ? PyResolveImportUtil.resolveModuleAt(name, (PsiFileSystemItem)context.getPsiManager().findDirectory(root), context) : CollectionsKt.emptyList();
    }

    @ApiStatus.Internal
    @Nullable
    public static final PythonPathCache findCache(@NotNull PyQualifiedNameResolveContext context) {
        PythonPathCache pythonPathCache;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context.getVisitAllModules()) {
            pythonPathCache = null;
        } else if (context.getModule() != null) {
            pythonPathCache = !Intrinsics.areEqual((Object)context.getEffectiveSdk(), (Object)context.getSdk()) ? null : PythonModulePathCache.getInstance(context.getModule());
        } else if (context.getFootholdFile() != null) {
            PsiFile psiFile = context.getFootholdFile();
            Intrinsics.checkNotNull((Object)psiFile);
            Sdk sdk = PyBuiltinCache.Companion.findSdkForNonModuleFile((PsiFileSystemItem)psiFile);
            pythonPathCache = sdk != null ? PythonSdkPathCache.getInstance(context.getProject(), sdk) : null;
        } else {
            pythonPathCache = null;
        }
        return pythonPathCache;
    }

    private static final boolean isSameDirectoryResult(PsiElement element, PyQualifiedNameResolveContext context, QualifiedName name) {
        boolean sameDirectoryImportsEnabled;
        if (context.getRelativeLevel() != 0) {
            return false;
        }
        boolean bl = sameDirectoryImportsEnabled = !ResolveImportUtil.isAbsoluteImportEnabledFor(context.getFoothold());
        if (!sameDirectoryImportsEnabled || !(element instanceof PsiFileSystemItem)) {
            return false;
        }
        QualifiedName shortestImportableQName = QualifiedNameFinder.findShortestImportableQName((PsiFileSystemItem)element);
        if (shortestImportableQName != null) {
            return !Intrinsics.areEqual((Object)name, (Object)shortestImportableQName);
        }
        PsiDirectory psiDirectory = context.getContainingDirectory();
        if (psiDirectory == null) {
            return false;
        }
        PsiDirectory footholdDir = psiDirectory;
        return PsiTreeUtil.isAncestor((PsiElement)((PsiElement)footholdDir), (PsiElement)element, (boolean)true);
    }

    private static final boolean isSameDirectoryOrRelativeImportResult(QualifiedName name, PsiDirectory directory, PsiElement result, PyQualifiedNameResolveContext context) {
        if (context.getRelativeLevel() > 0) {
            return true;
        }
        return PyUtil.isPackage(directory, false, null) && PyResolveImportUtil.isSameDirectoryResult(result, context, name);
    }

    private static final void checkAccess() {
        Preconditions.checkState((boolean)ApplicationManager.getApplication().isReadAccessAllowed(), (String)"This method requires read access", (Object[])new Object[0]);
    }

    private static final List<PsiElement> filterTopPriorityResultsWithFallback(List<? extends PsiElement> primaryResults, List<? extends PsiElement> fallbackResults, List<? extends PsiElement> foreignResults, QualifiedName name, PyQualifiedNameResolveContext context) {
        List allResults = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)primaryResults, (Iterable)fallbackResults), (Iterable)foreignResults);
        if (name.getComponentCount() <= 0) {
            return allResults;
        }
        List<PsiElement> filteredPrimaryResults = PyResolveImportUtil.filterTopPriorityResults(primaryResults, context.getModule());
        if (!((Collection)filteredPrimaryResults).isEmpty()) {
            return CollectionsKt.plus((Collection)filteredPrimaryResults, (Iterable)foreignResults);
        }
        return CollectionsKt.plus((Collection)PyResolveImportUtil.filterTopPriorityResults(fallbackResults, context.getModule()), (Iterable)foreignResults);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<PsiElement> filterTopPriorityResults(List<? extends PsiElement> resolved, Module module) {
        List list;
        List skeletons;
        void $this$groupByTo$iv;
        if (resolved.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = resolved;
        Map destination$iv = MapsKt.sortedMapOf((Pair[])new Pair[0]);
        boolean $i$f$groupByTo = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object;
            void $this$getOrPut$iv$iv;
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            Priority key$iv = PyResolveImportUtil.resolvedElementPriority(it, module);
            Map map = destination$iv;
            Priority key$iv$iv = key$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get((Object)key$iv$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv$iv, answer$iv$iv);
                object = answer$iv$iv;
            } else {
                object = value$iv$iv;
            }
            List list$iv = (List)object;
            list$iv.add(element$iv);
        }
        SortedMap groupedResults = (SortedMap)destination$iv;
        List list2 = (List)groupedResults.remove((Object)Priority.SKELETON);
        if (list2 == null) {
            list2 = skeletons = CollectionsKt.emptyList();
        }
        if (PyResolveImportUtil.topResultIs(groupedResults, Priority.NAMESPACE_PACKAGE)) {
            Object v = groupedResults.get((Object)Priority.NAMESPACE_PACKAGE);
            Intrinsics.checkNotNull(v);
            return CollectionsKt.plus((Collection)((Collection)v), (Iterable)skeletons);
        }
        groupedResults.remove((Object)Priority.NAMESPACE_PACKAGE);
        if (groupedResults.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else if (PyResolveImportUtil.topResultIs(groupedResults, Priority.STUB_PACKAGE)) {
            list = PyResolveImportUtil.firstResultWithFallback(groupedResults, Priority.STUB_PACKAGE);
        } else if (PyResolveImportUtil.topResultIs(groupedResults, Priority.THIRD_PARTY_SDK)) {
            list = PyResolveImportUtil.firstResultWithFallback(groupedResults, Priority.THIRD_PARTY_SDK);
        } else {
            Collection collection = groupedResults.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Object object = CollectionsKt.first((Iterable)collection);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
            list = CollectionsKt.listOf((Object)CollectionsKt.first((List)((List)object)));
        }
        List priorityResults = list;
        return CollectionsKt.plus((Collection)priorityResults, (Iterable)skeletons);
    }

    private static final boolean topResultIs(SortedMap<Priority, List<PsiElement>> $this$topResultIs, Priority priority) {
        return $this$topResultIs.containsKey((Object)priority) && $this$topResultIs.headMap(priority).isEmpty();
    }

    private static final List<PsiElement> firstResultWithFallback(SortedMap<Priority, List<PsiElement>> results, Priority priority) {
        Object v = results.get((Object)priority);
        Intrinsics.checkNotNull(v);
        PsiElement first = (PsiElement)CollectionsKt.first((List)((List)v));
        Collection<List<PsiElement>> collection = results.tailMap(priority).values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        PsiElement nextByPriority = (PsiElement)SequencesKt.firstOrNull((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.take((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)collection), (int)1), (int)1)));
        Object[] objectArray = new PsiElement[]{first, nextByPriority};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    private static final Priority resolvedElementPriority(PsiElement element, Module module) {
        return PyNamespacePackageUtil.isNamespacePackage(element) ? Priority.NAMESPACE_PACKAGE : (PyResolveImportUtil.isUserFile(element, module) ? (PyiUtil.isPyiFileOfPackage(element) ? Priority.USER_STUB : Priority.USER_CODE) : (PyStubPackages.isInStubPackage(element) ? Priority.STUB_PACKAGE : (PyResolveImportUtil.isInTypeShed(element) ? Priority.TYPESHED : (PyResolveImportUtil.isInSkeletons(element) ? Priority.SKELETON : (PyiUtil.isPyiFileOfPackage(element) ? Priority.PROVIDED_STUB : (PyStubPackages.isInInlinePackage(element, module) ? Priority.INLINE_PACKAGE : (PyResolveImportUtil.isInProvidedSdk(element) ? Priority.THIRD_PARTY_SDK : Priority.OTHER)))))));
    }

    public static final boolean isInSkeletons(@NotNull PsiElement element) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Sdk sdk = PythonSdkUtil.findPythonSdk((PsiElement)element);
        if (sdk == null) {
            return false;
        }
        Sdk sdk2 = sdk;
        if (element instanceof PsiDirectory) {
            object = ((PsiDirectory)element).getVirtualFile();
        } else {
            PsiFile psiFile = element.getContainingFile();
            object = psiFile != null ? psiFile.getVirtualFile() : null;
        }
        if (object == null) {
            return false;
        }
        VirtualFile vFile = object;
        return PythonSdkUtil.isFileInSkeletons((VirtualFile)vFile, (Sdk)sdk2);
    }

    private static final boolean isInProvidedSdk(PsiElement element) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = PyThirdPartySdkDetector.EP_NAME.getExtensionList();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PyThirdPartySdkDetector it = (PyThirdPartySdkDetector)element$iv;
                    boolean bl2 = false;
                    if (!it.isInThirdPartySdk(element)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isUserFile(PsiElement element, Module module) {
        if (module == null) return false;
        if (!(element instanceof PsiFileSystemItem)) return false;
        VirtualFile it = ((PsiFileSystemItem)element).getVirtualFile();
        boolean bl = false;
        if (it == null) return false;
        if (!ModuleUtilCore.moduleContainsFile((Module)module, (VirtualFile)it, (boolean)false)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInTypeShed(PsiElement element) {
        if (!PyiUtil.isPyiFileOfPackage(element)) return false;
        if (!(element instanceof PsiFileSystemItem)) return false;
        PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)element;
        if (psiFileSystemItem == null) return false;
        VirtualFile virtualFile = psiFileSystemItem.getVirtualFile();
        VirtualFile it = virtualFile;
        boolean bl = false;
        if (it == null) return false;
        if (!PyTypeShed.INSTANCE.isInside(it)) return false;
        return true;
    }

    private static final Sequence resolveModuleFromRoots$lambda$0$0(String $component, PyQualifiedNameResolveContext $context, PsiFileSystemItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String[] stringArray = new String[]{$component};
        QualifiedName qualifiedName = QualifiedName.fromComponents((String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)qualifiedName, (String)"fromComponents(...)");
        return CollectionsKt.asSequence((Iterable)PyResolveImportUtil.resolveModuleAt(qualifiedName, it, $context));
    }

    private static final PsiElement resolveTopLevelMember$lambda$0(PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return PyUtil.turnDirIntoInit(it);
    }

    private static final Sequence resolveTopLevelMember$lambda$1(String $memberName, PyFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List list = it.multiResolveName($memberName);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"multiResolveName(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    private static final PsiElement resolveTopLevelMember$lambda$2(RatedResolveResult it) {
        return it.getElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final PsiElement foreignResults$lambda$0(PyQualifiedNameResolveContext $context, QualifiedName $name, PyImportResolver it) {
        PsiElement psiElement;
        Project project = $context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DumbService this_$iv = DumbService.Companion.getInstance(project);
        boolean $i$f$withAlternativeResolveEnabled = false;
        boolean isDumb$iv = this_$iv.isDumb();
        boolean old$iv = this_$iv.isAlternativeResolveEnabled();
        if (isDumb$iv) {
            this_$iv.setAlternativeResolveEnabled(true);
        }
        try {
            boolean bl = false;
            psiElement = it.resolveImportReference($name, $context, !$context.getWithoutRoots());
        }
        finally {
            if (isDumb$iv) {
                this_$iv.setAlternativeResolveEnabled(old$iv);
            }
        }
        return psiElement;
    }

    private static final boolean resultsFromRoots$lambda$0(List $moduleResults, List $sdkResults, PyQualifiedNameResolveContext $context, QualifiedName $name, boolean $withoutStubs, VirtualFile root, Module module, Sdk sdk, boolean isModuleSource) {
        List results;
        block12: {
            block13: {
                boolean bl;
                block11: {
                    block10: {
                        Sdk effectiveSdk;
                        results = isModuleSource ? $moduleResults : $sdkResults;
                        Sdk sdk2 = sdk;
                        if (sdk2 == null) {
                            sdk2 = effectiveSdk = $context.getEffectiveSdk();
                        }
                        if (!root.isValid()) break block10;
                        if (effectiveSdk == null) break block11;
                        Intrinsics.checkNotNull((Object)root);
                        if (!PyTypeShed.INSTANCE.isInside(root) || PyTypeShed.INSTANCE.maySearchForStubInRoot($name, root, effectiveSdk)) break block11;
                    }
                    return true;
                }
                if (!$withoutStubs) break block12;
                Intrinsics.checkNotNull((Object)root);
                if (PyTypeShed.INSTANCE.isInside(root)) break block13;
                PsiDirectory psiDirectory = PsiManager.getInstance((Project)$context.getProject()).findDirectory(root);
                if (psiDirectory != null) {
                    PsiDirectory it = psiDirectory;
                    boolean bl2 = false;
                    bl = PyStubPackages.isInStubPackage((PsiElement)it);
                } else {
                    bl = false;
                }
                if (!bl) break block12;
            }
            return true;
        }
        Intrinsics.checkNotNull((Object)root);
        results.addAll((Collection)PyResolveImportUtil.resolveInRoot($name, root, $context));
        if (PyResolveImportUtil.isAcceptRootAsTopLevelPackage($context) && $name.matchesPrefix(QualifiedName.fromDottedString((String)root.getName()))) {
            VirtualFile virtualFile = root.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            results.addAll((Collection)PyResolveImportUtil.resolveInRoot($name, virtualFile, $context));
        }
        return true;
    }

    private static final void isAcceptRootAsTopLevelPackage$lambda$0$0(Ref $ref, Object it) {
        if (it instanceof PythonPathContributingFacet && ((PythonPathContributingFacet)it).acceptRootAsTopLevelPackage()) {
            $ref.set((Object)true);
        }
    }
}

