/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyListLiteralExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PySetLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0007J6\u0010\u0013\u001a \u0012\u0004\u0012\u00020\u0015\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0016\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0007J(\u0010\u0018\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00162\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\u0019\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/python/psi/types/PyCollectionTypeUtil;", "", "<init>", "()V", "MAX_ANALYZED_ELEMENTS_OF_LITERALS", "", "getListLiteralType", "Lcom/jetbrains/python/psi/types/PyType;", "expression", "Lcom/jetbrains/python/psi/PyListLiteralExpression;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "getSetLiteralType", "Lcom/jetbrains/python/psi/PySetLiteralExpression;", "getListOrSetIteratedValueType", "sequence", "Lcom/jetbrains/python/psi/PySequenceExpression;", "getDictLiteralType", "Lcom/jetbrains/python/psi/PyDictLiteralExpression;", "getTypedDictFieldsFromDictLiteral", "", "", "Lkotlin/Pair;", "Lcom/jetbrains/python/psi/PyExpression;", "getDictLiteralElementTypes", "getKeyValueType", "sequenceElementType", "intellij.python.psi.impl"})
@SourceDebugExtension(value={"SMAP\nPyCollectionTypeUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyCollectionTypeUtil.kt\ncom/jetbrains/python/psi/types/PyCollectionTypeUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,116:1\n1586#2:117\n1661#2,3:118\n1915#2,2:123\n14060#3,2:121\n*S KotlinDebug\n*F\n+ 1 PyCollectionTypeUtil.kt\ncom/jetbrains/python/psi/types/PyCollectionTypeUtil\n*L\n34#1:117\n34#1:118,3\n87#1:123,2\n58#1:121,2\n*E\n"})
public final class PyCollectionTypeUtil {
    @NotNull
    public static final PyCollectionTypeUtil INSTANCE = new PyCollectionTypeUtil();
    private static final int MAX_ANALYZED_ELEMENTS_OF_LITERALS = 10;

    private PyCollectionTypeUtil() {
    }

    @JvmStatic
    @Nullable
    public static final PyType getListLiteralType(@NotNull PyListLiteralExpression expression, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyClass pyClass = PyBuiltinCache.Companion.getInstance((PsiElement)expression).getClass("list");
        if (pyClass == null) {
            return null;
        }
        PyClass cls = pyClass;
        return (PyType)new PyCollectionTypeImpl(cls, false, CollectionsKt.listOf((Object)INSTANCE.getListOrSetIteratedValueType((PySequenceExpression)expression, context)));
    }

    @JvmStatic
    @Nullable
    public static final PyType getSetLiteralType(@NotNull PySetLiteralExpression expression, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyClass pyClass = PyBuiltinCache.Companion.getInstance((PsiElement)expression).getClass("set");
        if (pyClass == null) {
            return null;
        }
        PyClass cls = pyClass;
        return (PyType)new PyCollectionTypeImpl(cls, false, CollectionsKt.listOf((Object)INSTANCE.getListOrSetIteratedValueType((PySequenceExpression)expression, context)));
    }

    /*
     * WARNING - void declaration
     */
    private final PyType getListOrSetIteratedValueType(PySequenceExpression sequence, TypeEvalContext context) {
        void $this$mapTo$iv$iv;
        Object[] objectArray = sequence.getElements();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getElements(...)");
        Object[] elements = objectArray;
        Iterable $this$map$iv = ArraysKt.take((Object[])elements, (int)10);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PyExpression pyExpression = (PyExpression)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PyLiteralType.Companion.upcastLiteralToClass(context.getType((PyTypedElement)it)));
        }
        PyType analyzedElementsType = PyUnionType.union((List)destination$iv$iv);
        return elements.length > 10 ? PyUnionType.createWeakType(analyzedElementsType) : analyzedElementsType;
    }

    @JvmStatic
    @Nullable
    public static final PyType getDictLiteralType(@NotNull PyDictLiteralExpression expression, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyClass pyClass = PyBuiltinCache.Companion.getInstance((PsiElement)expression).getClass("dict");
        if (pyClass == null) {
            return null;
        }
        PyClass cls = pyClass;
        Pair<PyType, PyType> pair = INSTANCE.getDictLiteralElementTypes(expression, context);
        PyType keyType = (PyType)pair.component1();
        PyType valueType = (PyType)pair.component2();
        Object[] objectArray = new PyType[]{keyType, valueType};
        return (PyType)new PyCollectionTypeImpl(cls, false, CollectionsKt.listOf((Object[])objectArray));
    }

    @JvmStatic
    @Nullable
    public static final Map<String, Pair<PyExpression, PyType>> getTypedDictFieldsFromDictLiteral(@NotNull PyDictLiteralExpression sequence, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        LinkedHashMap strKeysToValueTypes = new LinkedHashMap();
        PyKeyValueExpression[] pyKeyValueExpressionArray = sequence.getElements();
        Intrinsics.checkNotNullExpressionValue((Object)pyKeyValueExpressionArray, (String)"getElements(...)");
        Object[] $this$forEach$iv = pyKeyValueExpressionArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyExpression keyExpression;
            PyKeyValueExpression element = (PyKeyValueExpression)element$iv;
            boolean bl = false;
            PyType elementType = context.getType((PyTypedElement)element);
            Pair<PyType, PyType> pair = INSTANCE.getKeyValueType(elementType);
            PyType keyType = (PyType)pair.component1();
            PyType valueType = (PyType)pair.component2();
            if (!(keyType instanceof PyClassType) || !Intrinsics.areEqual((Object)"str", (Object)((PyClassType)keyType).getClassQName())) {
                return null;
            }
            if (keyType instanceof PyLiteralType) {
                v1 = ((PyLiteralType)keyType).getExpression();
            } else {
                PyExpression pyExpression = element.getKey();
                Intrinsics.checkNotNull((Object)pyExpression);
                v1 = keyExpression = pyExpression;
            }
            if (!(keyExpression instanceof PyStringLiteralExpression)) {
                return null;
            }
            ((Map)strKeysToValueTypes).put(((PyStringLiteralExpression)keyExpression).getStringValue(), new Pair((Object)element.getValue(), (Object)PyLiteralType.Companion.upcastLiteralToClass(valueType)));
        }
        return strKeysToValueTypes;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<PyType, PyType> getDictLiteralElementTypes(PyDictLiteralExpression sequence, TypeEvalContext context) {
        void $this$forEach$iv;
        Object[] objectArray = sequence.getElements();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getElements(...)");
        Object[] elements = objectArray;
        List keyTypes = new ArrayList();
        List valueTypes = new ArrayList();
        Iterable iterable = ArraysKt.take((Object[])elements, (int)10);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PyKeyValueExpression it = (PyKeyValueExpression)element$iv;
            boolean bl = false;
            PyType type = context.getType((PyTypedElement)it);
            Pair<PyType, PyType> pair = INSTANCE.getKeyValueType(type);
            PyType keyType = (PyType)pair.component1();
            PyType valueType = (PyType)pair.component2();
            keyTypes.add(PyLiteralType.Companion.upcastLiteralToClass(keyType));
            valueTypes.add(PyLiteralType.Companion.upcastLiteralToClass(valueType));
        }
        if (elements.length > 10) {
            keyTypes.add(null);
            valueTypes.add(null);
        }
        return new Pair((Object)PyUnionType.union(keyTypes), (Object)PyUnionType.union(valueTypes));
    }

    private final Pair<PyType, PyType> getKeyValueType(PyType sequenceElementType) {
        if (sequenceElementType instanceof PyTupleType) {
            if (((PyTupleType)sequenceElementType).isHomogeneous()) {
                PyType iteratedItemType = ((PyTupleType)sequenceElementType).getIteratedItemType();
                return TuplesKt.to((Object)iteratedItemType, (Object)iteratedItemType);
            }
            List<PyType> list = ((PyTupleType)sequenceElementType).getElementTypes();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getElementTypes(...)");
            List<PyType> tupleElementTypes = list;
            if (tupleElementTypes.size() == 2) {
                return TuplesKt.to((Object)tupleElementTypes.get(0), (Object)tupleElementTypes.get(1));
            }
        }
        return TuplesKt.to(null, null);
    }
}

