/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.types;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyIntersectionType;
import com.jetbrains.python.psi.types.PyLiteralType;
import com.jetbrains.python.psi.types.PyRecursiveTypeVisitor;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypeVarTupleType;
import com.jetbrains.python.psi.types.PyTypeVarType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.PyUnpackedTupleTypeImpl;
import com.jetbrains.python.psi.types.PyUnsafeUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

@ApiStatus.Internal
public final class PyTypeUtil {
    private PyTypeUtil() {
    }

    public static boolean isSameType(@Nullable PyType type1, @Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(0);
        }
        if ((type1 == null || type2 == null) && type1 != type2) {
            return false;
        }
        return PyTypeChecker.match(type1, type2, context) && PyTypeChecker.match(type2, type1, context);
    }

    public static boolean isOverlappingWith(@Nullable PyType type1, @Nullable PyType type2, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(1);
        }
        if (type1 instanceof PyUnionType) {
            PyUnionType unionType1 = (PyUnionType)type1;
            return ContainerUtil.exists(unionType1.getMembers(), t -> PyTypeUtil.isOverlappingWith(t, type2, context));
        }
        if (type2 instanceof PyUnionType) {
            PyUnionType unionType2 = (PyUnionType)type2;
            return ContainerUtil.exists(unionType2.getMembers(), t -> PyTypeUtil.isOverlappingWith(type1, t, context));
        }
        if (type1 instanceof PyUnsafeUnionType) {
            PyUnsafeUnionType unionType1 = (PyUnsafeUnionType)type1;
            return ContainerUtil.exists(unionType1.getMembers(), t -> PyTypeUtil.isOverlappingWith(t, type2, context));
        }
        if (type2 instanceof PyUnsafeUnionType) {
            PyUnsafeUnionType unionType2 = (PyUnsafeUnionType)type2;
            return ContainerUtil.exists(unionType2.getMembers(), t -> PyTypeUtil.isOverlappingWith(type1, t, context));
        }
        return PyTypeChecker.match(type1, type2, context) || PyTypeChecker.match(type2, type1, context);
    }

    @NotNull
    public static <T extends PsiElement> List<T> getMembersOfType(@NotNull PyClassLikeType type, @NotNull Class<T> expectedMemberType, boolean inherited, @NotNull TypeEvalContext context) {
        if (type == null) {
            PyTypeUtil.$$$reportNull$$$0(2);
        }
        if (expectedMemberType == null) {
            PyTypeUtil.$$$reportNull$$$0(3);
        }
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(4);
        }
        ArrayList result = new ArrayList();
        type.visitMembers(t -> {
            if (expectedMemberType.isInstance(t)) {
                PsiElement castedElement = t;
                result.add(castedElement);
            }
            return true;
        }, inherited, context);
        ArrayList arrayList = result;
        if (arrayList == null) {
            PyTypeUtil.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    public static <T> T findData(@NotNull PyType type, @NotNull Key<T> key) {
        if (type == null) {
            PyTypeUtil.$$$reportNull$$$0(6);
        }
        if (key == null) {
            PyTypeUtil.$$$reportNull$$$0(7);
        }
        if (type instanceof UserDataHolder) {
            return (T)((UserDataHolder)type).getUserData(key);
        }
        if (type instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)type;
            for (PyType memberType : unionType.getMembers()) {
                T result;
                if (memberType == null || (result = PyTypeUtil.findData(memberType, key)) == null) continue;
                return result;
            }
        }
        return null;
    }

    @Nullable
    public static PyTupleType toPositionalContainerType(@NotNull PsiElement anchor, @Nullable PyType elementType) {
        if (anchor == null) {
            PyTypeUtil.$$$reportNull$$$0(8);
        }
        if (elementType instanceof PyUnpackedTupleTypeImpl) {
            PyUnpackedTupleTypeImpl unpackedTupleType = (PyUnpackedTupleTypeImpl)elementType;
            return unpackedTupleType.asTupleType(anchor);
        }
        if (elementType instanceof PyTypeVarTupleType) {
            return PyTupleType.create(anchor, Collections.singletonList(elementType));
        }
        return PyTupleType.createHomogeneous(anchor, elementType);
    }

    @Nullable
    public static PyCollectionType toKeywordContainerType(@NotNull PsiElement anchor, @Nullable PyType valueType) {
        if (anchor == null) {
            PyTypeUtil.$$$reportNull$$$0(9);
        }
        PyBuiltinCache builtinCache = PyBuiltinCache.getInstance(anchor);
        return Optional.ofNullable(builtinCache.getDictType()).map(PyClassType::getPyClass).map(dictClass -> new PyCollectionTypeImpl((PyClass)dictClass, false, (List<? extends PyType>)Arrays.asList(builtinCache.getStrType(), valueType))).orElse(null);
    }

    @NotNull
    public static StreamEx<PyType> toStream(@Nullable PyType type) {
        if (type instanceof PyUnionType) {
            PyUnionType unionType = (PyUnionType)type;
            StreamEx streamEx = StreamEx.of(unionType.getMembers());
            if (streamEx == null) {
                PyTypeUtil.$$$reportNull$$$0(10);
            }
            return streamEx;
        }
        if (type instanceof PyUnsafeUnionType) {
            PyUnsafeUnionType weakUnionType = (PyUnsafeUnionType)type;
            StreamEx streamEx = StreamEx.of(weakUnionType.getMembers());
            if (streamEx == null) {
                PyTypeUtil.$$$reportNull$$$0(11);
            }
            return streamEx;
        }
        if (type instanceof PyIntersectionType) {
            PyIntersectionType intersectionType = (PyIntersectionType)type;
            StreamEx streamEx = StreamEx.of(intersectionType.getMembers());
            if (streamEx == null) {
                PyTypeUtil.$$$reportNull$$$0(12);
            }
            return streamEx;
        }
        StreamEx streamEx = StreamEx.of((Object)type);
        if (streamEx == null) {
            PyTypeUtil.$$$reportNull$$$0(13);
        }
        return streamEx;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static Ref<PyType> notNullToRef(@Nullable PyType type) {
        return type == null ? null : Ref.create((Object)type);
    }

    @NotNull
    public static Collector<Ref<PyType>, ?, Ref<PyType>> toUnionFromRef() {
        return PyTypeUtil.toUnionFromRef(PyUnionType::union);
    }

    @NotNull
    public static Collector<Ref<PyType>, ?, Ref<PyType>> toUnsafeUnionFromRef() {
        return PyTypeUtil.toUnionFromRef((xva$0, xva$1) -> PyUnsafeUnionType.unsafeUnion(xva$0, xva$1));
    }

    @NotNull
    public static Collector<Ref<PyType>, ?, Ref<PyType>> toUnionFromRef(@Nullable PyType streamSource) {
        return PyTypeUtil.toUnionFromRef(streamSource instanceof PyUnsafeUnionType ? (xva$0, xva$1) -> PyUnsafeUnionType.unsafeUnion(xva$0, xva$1) : PyUnionType::union);
    }

    @NotNull
    private static Collector<Ref<PyType>, ?, Ref<PyType>> toUnionFromRef(@NotNull BinaryOperator<PyType> unionReduction) {
        if (unionReduction == null) {
            PyTypeUtil.$$$reportNull$$$0(14);
        }
        Collector<Object, ?, Object> collector = Collectors.reducing(null, (accType, hintType) -> {
            if (hintType == null) {
                return accType;
            }
            if (accType == null) {
                return hintType;
            }
            return Ref.create((Object)((PyType)unionReduction.apply((PyType)accType.get(), (PyType)hintType.get())));
        });
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(15);
        }
        return collector;
    }

    public static @NotNull Collector<@Nullable PyType, ?, @Nullable PyType> toUnion() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), PyUnionType::union);
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(16);
        }
        return collector;
    }

    @ApiStatus.Experimental
    public static @NotNull Collector<@Nullable PyType, ?, @Nullable PyType> toUnsafeUnion() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), PyUnsafeUnionType::unsafeUnion);
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(17);
        }
        return collector;
    }

    @ApiStatus.Experimental
    public static @NotNull Collector<@Nullable PyType, ?, @Nullable PyType> toIntersection() {
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), PyIntersectionType::intersection);
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(18);
        }
        return collector;
    }

    public static @NotNull Collector<@Nullable PyType, ?, @Nullable PyType> toUnion(@Nullable PyType streamSource) {
        return PyTypeUtil.toUnion(streamSource instanceof PyUnsafeUnionType ? PyUnsafeUnionType::unsafeUnion : PyUnionType::union);
    }

    private static @NotNull Collector<@Nullable PyType, ?, @Nullable PyType> toUnion(@NotNull Function<List<@Nullable PyType>, @Nullable PyType> unionFactory) {
        if (unionFactory == null) {
            PyTypeUtil.$$$reportNull$$$0(19);
        }
        Collector collector = Collectors.collectingAndThen(Collectors.toList(), unionFactory);
        if (collector == null) {
            PyTypeUtil.$$$reportNull$$$0(20);
        }
        return collector;
    }

    public static boolean isDict(@Nullable PyType type) {
        return type instanceof PyCollectionType && "dict".equals(type.getName());
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType getEffectiveBound(@NotNull PyTypeVarType typeVarType) {
        if (typeVarType == null) {
            PyTypeUtil.$$$reportNull$$$0(21);
        }
        return typeVarType.getConstraints().isEmpty() ? typeVarType.getBound() : PyUnionType.union(typeVarType.getConstraints());
    }

    @ApiStatus.Internal
    @Nullable
    public static PyType convertToType(@Nullable PyType type, @NotNull String superTypeName, @NotNull PsiElement anchor, @NotNull TypeEvalContext context) {
        PyClass superClass;
        if (superTypeName == null) {
            PyTypeUtil.$$$reportNull$$$0(22);
        }
        if (anchor == null) {
            PyTypeUtil.$$$reportNull$$$0(23);
        }
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(24);
        }
        if ((superClass = PyPsiFacade.getInstance((Project)anchor.getProject()).createClassByQName(superTypeName, anchor)) == null) {
            return null;
        }
        PyClassType superClassType = (PyClassType)ObjectUtils.notNull((Object)PyTypeChecker.findGenericDefinitionType(superClass, context), (Object)((Object)new PyClassTypeImpl(superClass, false)));
        return PyTypeChecker.convertToType(type, superClassType, context);
    }

    public static boolean inheritsAny(@NotNull PyType type, @NotNull TypeEvalContext context) {
        PyClassLikeType classLikeType;
        if (type == null) {
            PyTypeUtil.$$$reportNull$$$0(25);
        }
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(26);
        }
        return type instanceof PyClassLikeType && (classLikeType = (PyClassLikeType)type).getAncestorTypes(context).contains(null);
    }

    @NotNull
    public static @UnmodifiableView Set<PyType> collectTypeComponentsFromType(@Nullable PyType type, final @NotNull TypeEvalContext context) {
        if (context == null) {
            PyTypeUtil.$$$reportNull$$$0(27);
        }
        final LinkedHashSet result = new LinkedHashSet();
        PyRecursiveTypeVisitor.traverse(type, context, new PyRecursiveTypeVisitor.PyTypeTraverser(){

            @Override
            @NotNull
            public PyRecursiveTypeVisitor.Traversal visitPyType(@NotNull PyType pyType) {
                if (pyType == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.add(pyType);
                PyRecursiveTypeVisitor.Traversal traversal = super.visitPyType(pyType);
                if (traversal == null) {
                    1.$$$reportNull$$$0(1);
                }
                return traversal;
            }

            @Override
            public @NotNull PyRecursiveTypeVisitor.Traversal visitPyLiteralType(@NotNull PyLiteralType literalType) {
                PyClassLikeType literalClassType;
                if (literalType == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((literalClassType = literalType.getPyClass().getType(context)) != null) {
                    result.add(literalClassType);
                }
                PyRecursiveTypeVisitor.Traversal traversal = (PyRecursiveTypeVisitor.Traversal)((Object)super.visitPyLiteralType(literalType));
                if (traversal == null) {
                    1.$$$reportNull$$$0(3);
                }
                return traversal;
            }

            @Override
            public @NotNull PyRecursiveTypeVisitor.Traversal visitUnknownType() {
                result.add(null);
                PyRecursiveTypeVisitor.Traversal traversal = super.visitUnknownType();
                if (traversal == null) {
                    1.$$$reportNull$$$0(4);
                }
                return traversal;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 3, 4 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pyType";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeUtil$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "literalType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeUtil$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitPyType";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitPyLiteralType";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitUnknownType";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyType";
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "visitPyLiteralType";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 3, 4 -> new IllegalStateException(string);
                };
            }
        });
        Set<PyType> set = Collections.unmodifiableSet(result);
        if (set == null) {
            PyTypeUtil.$$$reportNull$$$0(28);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 10, 11, 12, 13, 15, 16, 17, 18, 20, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedMemberType";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/types/PyTypeUtil";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 8: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionReduction";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unionFactory";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeVarType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/types/PyTypeUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersOfType";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "toStream";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnionFromRef";
                break;
            }
            case 16: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnion";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "toUnsafeUnion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toIntersection";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTypeComponentsFromType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isSameType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOverlappingWith";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMembersOfType";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 28: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toPositionalContainerType";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "toKeywordContainerType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toUnionFromRef";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "toUnion";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveBound";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "convertToType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "inheritsAny";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectTypeComponentsFromType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 10, 11, 12, 13, 15, 16, 17, 18, 20, 28 -> new IllegalStateException(string);
        };
    }
}

