/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.intention.CommonIntentionAction;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstTargetExpression;
import com.jetbrains.python.inspections.PyRemoveElementFix;
import com.jetbrains.python.psi.PyAsPattern;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCaseClause;
import com.jetbrains.python.psi.PyDoubleStarPattern;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementVisitor;
import com.jetbrains.python.psi.PyGroupPattern;
import com.jetbrains.python.psi.PyKeyValuePattern;
import com.jetbrains.python.psi.PyKeywordPattern;
import com.jetbrains.python.psi.PyLiteralPattern;
import com.jetbrains.python.psi.PyMappingPattern;
import com.jetbrains.python.psi.PyMatchStatement;
import com.jetbrains.python.psi.PyNumericLiteralExpression;
import com.jetbrains.python.psi.PyOrPattern;
import com.jetbrains.python.psi.PyPattern;
import com.jetbrains.python.psi.PyPatternArgumentList;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PySequencePattern;
import com.jetbrains.python.psi.PySingleStarPattern;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyValuePattern;
import com.jetbrains.python.validation.PyAnnotationHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

final class PyPatternAnnotatorVisitor
extends PyElementVisitor {
    @NotNull
    private final PyAnnotationHolder myHolder;

    PyPatternAnnotatorVisitor(@NotNull PyAnnotationHolder holder) {
        if (holder == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        this.myHolder = holder;
    }

    public void visitPySingleStarPattern(@NotNull PySingleStarPattern starPattern) {
        PsiElement parent;
        if (starPattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        if (!((parent = starPattern.getParent()) instanceof PySequencePattern)) {
            this.myHolder.markError((PsiElement)starPattern, PyPsiBundle.message("ANN.patterns.single.star.pattern.cannot.be.used.outside.sequence.patterns", new Object[0]));
        }
    }

    public void visitPyDoubleStarPattern(@NotNull PyDoubleStarPattern starPattern) {
        PsiElement parent;
        if (starPattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if (!((parent = starPattern.getParent()) instanceof PyMappingPattern)) {
            this.myHolder.markError((PsiElement)starPattern, PyPsiBundle.message("ANN.patterns.double.star.pattern.cannot.be.used.outside.mapping.patterns", new Object[0]));
        }
    }

    public void visitPyLiteralPattern(@NotNull PyLiteralPattern literalPattern) {
        PyNumericLiteralExpression rightOperand;
        PyBinaryExpression expression;
        if (literalPattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        if ((expression = PyUtil.as(literalPattern.getExpression(), PyBinaryExpression.class)) != null && (rightOperand = PyUtil.as(expression.getRightExpression(), PyNumericLiteralExpression.class)) != null && rightOperand.getFirstChild().getNode().getElementType() != PyTokenTypes.IMAGINARY_LITERAL) {
            this.myHolder.markError((PsiElement)expression, PyPsiBundle.message("ANN.patterns.invalid.complex.number.literal", new Object[0]));
        }
    }

    public void visitPyKeyValuePattern(@NotNull PyKeyValuePattern keyValuePattern) {
        PyPattern keyPattern;
        if (keyValuePattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        if (!((keyPattern = keyValuePattern.getKeyPattern()) instanceof PyValuePattern) && !(keyPattern instanceof PyLiteralPattern)) {
            this.myHolder.markError((PsiElement)keyPattern, PyPsiBundle.message("ANN.patterns.key.pattern.can.only.be.value.or.literal.pattern", new Object[0]));
        }
    }

    public void visitPyOrPattern(@NotNull PyOrPattern orPattern) {
        Set boundNames;
        if (orPattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        List alternatives = orPattern.getAlternatives();
        PyPattern lastAlternative = (PyPattern)alternatives.get(alternatives.size() - 1);
        HashMap<PyPattern, Set> patternToBoundNames = new HashMap<PyPattern, Set>();
        HashSet allBoundNames = new HashSet();
        for (PyPattern pyPattern : alternatives) {
            boundNames = SyntaxTraverser.psiTraverser((PsiElement)pyPattern).filter(PyTargetExpression.class).map(PyAstTargetExpression::getName).toSet();
            patternToBoundNames.put(pyPattern, boundNames);
            allBoundNames.addAll(boundNames);
            if (pyPattern == lastAlternative || !pyPattern.isIrrefutable()) continue;
            this.myHolder.markError((PsiElement)pyPattern, PyPsiBundle.message("ANN.patterns.pattern.makes.remaining.alternatives.unreachable", new Object[0]));
        }
        for (Map.Entry entry : patternToBoundNames.entrySet()) {
            boundNames = (Set)entry.getValue();
            if (boundNames.equals(allBoundNames)) continue;
            Collection missingNames = ContainerUtil.subtract(allBoundNames, (Collection)boundNames);
            String nameList = StringUtil.join((Collection)ContainerUtil.sorted((Collection)missingNames), (String)", ");
            this.myHolder.markError((PsiElement)entry.getKey(), PyPsiBundle.message("ANN.patterns.pattern.does.not.bind.names", missingNames.size(), nameList));
        }
    }

    public void visitPyMatchStatement(@NotNull PyMatchStatement matchStatement) {
        List clauses;
        if (matchStatement == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        if ((clauses = matchStatement.getCaseClauses()).isEmpty()) {
            return;
        }
        for (PyCaseClause clause : clauses.subList(0, clauses.size() - 1)) {
            PyPattern unwrappedPattern;
            PyPattern pattern = clause.getPattern();
            if (pattern == null || (unwrappedPattern = PyPatternAnnotatorVisitor.unwrapGroupAndAsPatterns(pattern)) instanceof PySingleStarPattern || unwrappedPattern instanceof PyDoubleStarPattern || clause.getGuardCondition() != null || !pattern.isIrrefutable()) continue;
            this.myHolder.markError((PsiElement)pattern, PyPsiBundle.message("ANN.patterns.pattern.makes.remaining.case.clauses.unreachable", new Object[0]));
        }
    }

    public void visitPyPatternArgumentList(@NotNull PyPatternArgumentList argumentList) {
        if (argumentList == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        HashSet<String> usedAttrNames = new HashSet<String>();
        boolean seenKeywordPattern = false;
        for (PyPattern attrPattern : argumentList.getPatterns()) {
            PyKeywordPattern keywordPattern = PyUtil.as(attrPattern, PyKeywordPattern.class);
            if (keywordPattern == null) {
                if (!seenKeywordPattern) continue;
                this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.patterns.positional.pattern.must.appear.before.keyword.pattern", new Object[0])).range((PsiElement)attrPattern).withFix((CommonIntentionAction)new PyRemoveElementFix((PyElement)attrPattern)).create();
                continue;
            }
            seenKeywordPattern = true;
            if (usedAttrNames.add(keywordPattern.getKeyword())) continue;
            this.myHolder.newAnnotation(HighlightSeverity.ERROR, PyPsiBundle.message("ANN.patterns.attribute.name.is.repeated", keywordPattern.getKeyword())).range(keywordPattern.getKeywordElement()).withFix((CommonIntentionAction)new PyRemoveElementFix((PyElement)keywordPattern)).create();
        }
    }

    public void visitPyCaseClause(@NotNull PyCaseClause caseClause) {
        PyPattern pattern;
        if (caseClause == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(8);
        }
        if ((pattern = caseClause.getPattern()) == null) {
            return;
        }
        final Stack boundNamesPerOrBranch = new Stack();
        boundNamesPerOrBranch.push(new HashSet());
        pattern.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            public void visitPyOrPattern(@NotNull PyOrPattern orPattern) {
                if (orPattern == null) {
                    1.$$$reportNull$$$0(0);
                }
                HashSet allBoundNamesInOrPattern = new HashSet();
                for (PyPattern alternative : orPattern.getAlternatives()) {
                    boundNamesPerOrBranch.push(new HashSet());
                    alternative.accept((PsiElementVisitor)this);
                    allBoundNamesInOrPattern.addAll((Collection)boundNamesPerOrBranch.peek());
                    boundNamesPerOrBranch.pop();
                }
                ((Set)boundNamesPerOrBranch.peek()).addAll(allBoundNamesInOrPattern);
            }

            public void visitPyTargetExpression(@NotNull PyTargetExpression target) {
                String name;
                boolean alreadyBound;
                if (target == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (alreadyBound = ContainerUtil.exists((Iterable)boundNamesPerOrBranch, arg_0 -> 1.lambda$visitPyTargetExpression$0(name = target.getName(), arg_0))) {
                    PyPatternAnnotatorVisitor.this.myHolder.markError((PsiElement)target, PyPsiBundle.message("ANN.patterns.name.already.bound", name));
                }
                ((Set)boundNamesPerOrBranch.peek()).add(name);
            }

            private static /* synthetic */ boolean lambda$visitPyTargetExpression$0(String name, Set names) {
                return names.contains(name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "orPattern";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "target";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/python/validation/PyPatternAnnotatorVisitor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyOrPattern";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyTargetExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void visitPySequencePattern(@NotNull PySequencePattern sequencePattern) {
        List starPatterns;
        if (sequencePattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(9);
        }
        if ((starPatterns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)sequencePattern, PySingleStarPattern.class)).size() > 1) {
            for (PySingleStarPattern pattern : starPatterns.subList(1, starPatterns.size())) {
                this.myHolder.markError((PsiElement)pattern, PyPsiBundle.message("ANN.patterns.repeated.star.pattern", new Object[0]));
            }
        }
    }

    public void visitPyMappingPattern(@NotNull PyMappingPattern mappingPattern) {
        List starPatterns;
        if (mappingPattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(10);
        }
        if ((starPatterns = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)mappingPattern, PyDoubleStarPattern.class)).size() > 1) {
            for (PyDoubleStarPattern pattern : starPatterns.subList(1, starPatterns.size())) {
                this.myHolder.markError((PsiElement)pattern, PyPsiBundle.message("ANN.patterns.repeated.star.pattern", new Object[0]));
            }
        }
    }

    @NotNull
    private static PyPattern unwrapGroupAndAsPatterns(@NotNull PyPattern pattern) {
        if (pattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(11);
        }
        if (pattern instanceof PyGroupPattern) {
            return PyPatternAnnotatorVisitor.unwrapGroupAndAsPatterns(((PyGroupPattern)pattern).getPattern());
        }
        if (pattern instanceof PyAsPattern) {
            return PyPatternAnnotatorVisitor.unwrapGroupAndAsPatterns(((PyAsPattern)pattern).getPattern());
        }
        PyPattern pyPattern = pattern;
        if (pyPattern == null) {
            PyPatternAnnotatorVisitor.$$$reportNull$$$0(12);
        }
        return pyPattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "starPattern";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalPattern";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValuePattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orPattern";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caseClause";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequencePattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingPattern";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/validation/PyPatternAnnotatorVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/validation/PyPatternAnnotatorVisitor";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapGroupAndAsPatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitPySingleStarPattern";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitPyDoubleStarPattern";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "visitPyLiteralPattern";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitPyKeyValuePattern";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "visitPyOrPattern";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "visitPyMatchStatement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "visitPyPatternArgumentList";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "visitPyCaseClause";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "visitPySequencePattern";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "visitPyMappingPattern";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unwrapGroupAndAsPatterns";
                break;
            }
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12 -> new IllegalStateException(string);
        };
    }
}

