/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinChangeListSpecificComponent;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.vcs.commit.CommitOption;
import com.intellij.vcs.commit.CommitSessionCollector;
import git4idea.checkin.GitSkipHooksCommitHandlerFactoryKt;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0016J\f\u0010\u001b\u001a\u00020\u0019*\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgit4idea/checkin/GitSkipHooksConfigurationPanel;", "Lcom/intellij/openapi/vcs/ui/RefreshableOnComponent;", "Lcom/intellij/openapi/vcs/checkin/CheckinChangeListSpecificComponent;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "<init>", "(Lcom/intellij/openapi/vcs/CheckinProjectPanel;Lcom/intellij/openapi/vcs/changes/CommitContext;)V", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "Lorg/jetbrains/annotations/NotNull;", "getRepositoryManager", "()Lgit4idea/repo/GitRepositoryManager;", "runHooks", "Ljavax/swing/JCheckBox;", "getComponent", "Ljavax/swing/JComponent;", "refreshAvailability", "", "onChangeListSelected", "list", "Lcom/intellij/openapi/vcs/changes/LocalChangeList;", "saveState", "isCommitHooksFullyDisabled", "", "restoreState", "hasCommitHooks", "Lgit4idea/repo/GitRepository;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitSkipHooksCommitHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSkipHooksCommitHandlerFactory.kt\ngit4idea/checkin/GitSkipHooksConfigurationPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1807#2,3:96\n*S KotlinDebug\n*F\n+ 1 GitSkipHooksCommitHandlerFactory.kt\ngit4idea/checkin/GitSkipHooksConfigurationPanel\n*L\n70#1:96,3\n*E\n"})
final class GitSkipHooksConfigurationPanel
implements RefreshableOnComponent,
CheckinChangeListSpecificComponent {
    @NotNull
    private final CheckinProjectPanel panel;
    @NotNull
    private final CommitContext commitContext;
    @NotNull
    private final JCheckBox runHooks;

    /*
     * WARNING - void declaration
     */
    public GitSkipHooksConfigurationPanel(@NotNull CheckinProjectPanel panel2, @NotNull CommitContext commitContext) {
        void $this$runHooks_u24lambda_u240;
        JCheckBox jCheckBox;
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
        this.panel = panel2;
        this.commitContext = commitContext;
        JCheckBox jCheckBox2 = jCheckBox = new JCheckBox(GitBundle.message((String)"checkbox.run.git.hooks", (Object[])new Object[0]));
        GitSkipHooksConfigurationPanel gitSkipHooksConfigurationPanel = this;
        boolean bl = false;
        $this$runHooks_u24lambda_u240.setSelected(true);
        $this$runHooks_u24lambda_u240.addActionListener(arg_0 -> GitSkipHooksConfigurationPanel.runHooks$lambda$0$0(this, (JCheckBox)$this$runHooks_u24lambda_u240, arg_0));
        gitSkipHooksConfigurationPanel.runHooks = jCheckBox;
        this.refreshAvailability();
    }

    private final GitRepositoryManager getRepositoryManager() {
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.panel.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        return gitRepositoryManager;
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)BuilderKt.panel(arg_0 -> GitSkipHooksConfigurationPanel.getComponent$lambda$0(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshAvailability() {
        boolean bl;
        JCheckBox jCheckBox;
        block4: {
            void $this$any$iv;
            List<GitRepository> list = this.getRepositoryManager().getRepositories();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
            Iterable iterable = list;
            jCheckBox = this.runHooks;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitRepository it = (GitRepository)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!this.hasCommitHooks(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean bl3 = bl;
        jCheckBox.setVisible(bl3);
        this.runHooks.setEnabled(!this.isCommitHooksFullyDisabled());
        if (this.isCommitHooksFullyDisabled()) {
            this.runHooks.setSelected(false);
        }
        this.runHooks.setToolTipText(this.isCommitHooksFullyDisabled() ? GitBundle.message((String)"tooltip.run.git.hooks.disabled", (Object[])new Object[0]) : GitBundle.message((String)"tooltip.run.git.hooks", (Object[])new Object[0]));
    }

    public void onChangeListSelected(@NotNull LocalChangeList list) {
        Intrinsics.checkNotNullParameter((Object)list, (String)"list");
        this.refreshAvailability();
    }

    public void saveState() {
        GitSkipHooksCommitHandlerFactoryKt.setSkipHooks(this.commitContext, this.isCommitHooksFullyDisabled() || this.runHooks.isVisible() && !this.runHooks.isSelected());
    }

    private final boolean isCommitHooksFullyDisabled() {
        return AdvancedSettings.Companion.getBoolean("git.commit.do.not.run.commit.hooks");
    }

    public void restoreState() {
        this.refreshAvailability();
    }

    private final boolean hasCommitHooks(GitRepository $this$hasCommitHooks) {
        return $this$hasCommitHooks.getInfo().getHooksInfo().getAreCommitHooksAvailable();
    }

    private static final void runHooks$lambda$0$0(GitSkipHooksConfigurationPanel this$0, JCheckBox $this_apply, ActionEvent it) {
        Project project = this$0.panel.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        CommitSessionCollector.Companion.getInstance(project).logCommitOptionToggled(CommitOption.RUN_HOOKS, $this_apply.isSelected());
    }

    private static final Unit getComponent$lambda$0$0(GitSkipHooksConfigurationPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)this$0.runHooks);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0(GitSkipHooksConfigurationPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> GitSkipHooksConfigurationPanel.getComponent$lambda$0$0(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }
}

