/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.commit.CommitterResultHandler;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.i18n.GitBundle;
import git4idea.index.GitStageCommitter;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u001e\u0010\u0014\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001c\u0010\u001a\u001a\u00020\u00102\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0019\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lgit4idea/index/GitStageShowNotificationCommitResultHandler;", "Lcom/intellij/vcs/commit/CommitterResultHandler;", "committer", "Lgit4idea/index/GitStageCommitter;", "<init>", "(Lgit4idea/index/GitStageCommitter;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "notifier", "Lcom/intellij/openapi/vcs/VcsNotifier;", "Lorg/jetbrains/annotations/NotNull;", "getNotifier", "()Lcom/intellij/openapi/vcs/VcsNotifier;", "onSuccess", "", "onCancel", "onFailure", "reportResult", "reportSuccess", "repositories", "", "Lgit4idea/repo/GitRepository;", "commitMessage", "", "reportFailure", "failures", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vcs/VcsException;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStageShowNotificationCommitResultHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageShowNotificationCommitResultHandler.kt\ngit4idea/index/GitStageShowNotificationCommitResultHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1586#2:52\n1661#2,3:53\n*S KotlinDebug\n*F\n+ 1 GitStageShowNotificationCommitResultHandler.kt\ngit4idea/index/GitStageShowNotificationCommitResultHandler\n*L\n48#1:52\n48#1:53,3\n*E\n"})
public final class GitStageShowNotificationCommitResultHandler
implements CommitterResultHandler {
    @NotNull
    private final GitStageCommitter committer;

    public GitStageShowNotificationCommitResultHandler(@NotNull GitStageCommitter committer) {
        Intrinsics.checkNotNullParameter((Object)((Object)committer), (String)"committer");
        this.committer = committer;
    }

    private final Project getProject() {
        return this.committer.getProject();
    }

    private final VcsNotifier getNotifier() {
        VcsNotifier vcsNotifier = VcsNotifier.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)vcsNotifier, (String)"getInstance(...)");
        return vcsNotifier;
    }

    public void onSuccess() {
        this.reportResult();
    }

    public void onCancel() {
        this.reportResult();
    }

    public void onFailure() {
        this.reportResult();
    }

    private final void reportResult() {
        this.reportSuccess((Collection<? extends GitRepository>)this.committer.getSuccessfulRepositories(), this.committer.getCommitMessage());
        this.reportFailure(this.committer.getFailedRoots());
    }

    private final void reportSuccess(Collection<? extends GitRepository> repositories, String commitMessage) {
        if (repositories.isEmpty()) {
            return;
        }
        String repositoriesText = CollectionsKt.joinToString$default((Iterable)repositories, null, null, null, (int)0, null, arg_0 -> GitStageShowNotificationCommitResultHandler.reportSuccess$lambda$0(this, arg_0), (int)31, null);
        Object[] objectArray = new Object[]{repositoriesText, XmlStringUtil.escapeString((String)commitMessage)};
        this.getNotifier().notifyMinorInfo("git.stage.commit.successful", "", GitBundle.message((String)"stage.commit.successful", (Object[])objectArray));
    }

    /*
     * WARNING - void declaration
     */
    private final void reportFailure(Map<VirtualFile, ? extends VcsException> failures) {
        Collection<HtmlChunk> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        if (failures.isEmpty()) {
            return;
        }
        Object object = new Object[]{CollectionsKt.joinToString$default((Iterable)failures.keySet(), null, null, null, (int)0, null, arg_0 -> GitStageShowNotificationCommitResultHandler.reportFailure$lambda$0(this, arg_0), (int)31, null)};
        String string = GitBundle.message((String)"stage.commit.failed", (Object[])object);
        object = failures.values();
        HtmlChunk htmlChunk = (HtmlChunk)HtmlChunk.br();
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        String string2 = string;
        String string3 = "git.stage.commit.error";
        VcsNotifier vcsNotifier = this.getNotifier();
        boolean $i$f$map = false;
        void var4_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsException vcsException = (VcsException)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(HtmlChunk.text((String)it.getLocalizedMessage()));
        }
        collection = (List)destination$iv$iv;
        vcsNotifier.notifyError(string3, string2, htmlBuilder.appendWithSeparators(htmlChunk, (Iterable)collection).toString());
    }

    private static final CharSequence reportSuccess$lambda$0(GitStageShowNotificationCommitResultHandler this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + VcsImplUtil.getShortVcsRootName((Project)this$0.getProject(), (VirtualFile)it.getRoot()) + "'";
    }

    private static final CharSequence reportFailure$lambda$0(GitStageShowNotificationCommitResultHandler this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + VcsImplUtil.getShortVcsRootName((Project)this$0.getProject(), (VirtualFile)it) + "'";
    }
}

