/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.diagnostic.Logger;
import git4idea.repo.GitConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ini4j.Ini;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0004H\u0000\u001a\b\u0010\u0005\u001a\u00020\u0001H\u0002\u00a8\u0006\u0006"}, d2={"loadIniFile", "Lorg/ini4j/Ini;", "file", "Ljava/nio/file/Path;", "Ljava/io/File;", "createGitIniParser", "intellij.vcs.git"})
public final class GitConfigHelperKt {
    @NotNull
    public static final Ini loadIniFile(@NotNull Path file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Ini ini = GitConfigHelperKt.createGitIniParser();
        try {
            ini.load(Files.newInputStream(file, new OpenOption[0]));
            return ini;
        }
        catch (IOException e) {
            Logger.getInstance(GitConfig.class).warn("Couldn't load config file at " + file, (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public static final Ini loadIniFile(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Ini ini = GitConfigHelperKt.createGitIniParser();
        try {
            ini.load(file);
            return ini;
        }
        catch (IOException e) {
            Logger.getInstance(GitConfig.class).warn("Couldn't load config file at " + file.getPath(), (Throwable)e);
            throw e;
        }
    }

    private static final Ini createGitIniParser() {
        Ini ini = new Ini();
        ini.getConfig().setMultiOption(true);
        ini.getConfig().setTree(false);
        ini.getConfig().setLowerCaseOption(true);
        ini.getConfig().setEmptyOption(true);
        return ini;
    }
}

