/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.redis.generator.dml;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.redis.RedisDbms;
import com.intellij.database.model.DasObject;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.script.generator.dml.PlainWhereClause;
import com.intellij.database.script.generator.dml.PredicatesWhereClause;
import com.intellij.database.script.generator.dml.ValuesWhereClause;
import com.intellij.database.script.generator.dml.WhereClause;
import com.intellij.database.script.generator.dml.WrapInSelectTask;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.sql.dialects.redis.RedisDialect;
import com.intellij.sql.psi.SqlTokens;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0000\u001a\u001e\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0000\u001a\u001b\u0010\u000f\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0010*\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0000\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0015*\u00020\u0015H\u0002\u001a\f\u0010\u0018\u001a\u00020\u0015*\u00020\u0015H\u0002\u001a\u0018\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002\"\u001a\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u000b\"\u0018\u0010\u0011\u001a\u00020\u0007*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0018\u0010\u0000\u001a\u00020\u0007*\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013\u00a8\u0006\u001d"}, d2={"key", "Lcom/intellij/database/util/DdlBuilder;", "table", "Lcom/intellij/database/model/DasObject;", "task", "Lcom/intellij/database/script/generator/dml/WrapInSelectTask;", "keyScrName", "", "isNotBlank", "", "Lcom/intellij/database/script/generator/dml/WhereClause;", "(Lcom/intellij/database/script/generator/dml/WhereClause;)Z", "generateWhereHint", "hintColumnTitle", "whereClause", "generateWhere", "Lorg/jetbrains/annotations/NotNull;", "command", "getCommand", "(Lcom/intellij/database/script/generator/dml/WrapInSelectTask;)Ljava/lang/String;", "advanceToCommand", "Lcom/intellij/lexer/Lexer;", "getKey", "advanceToKey", "skipHintIfExists", "startLexer", "project", "Lcom/intellij/openapi/project/Project;", "query", "intellij.database.dialects.redis"})
@SourceDebugExtension(value={"SMAP\nutil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 util.kt\ncom/intellij/database/dialects/redis/generator/dml/UtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,76:1\n1#2:77\n*E\n"})
public final class UtilKt {
    @NotNull
    public static final DdlBuilder key(@NotNull DdlBuilder $this$key, @NotNull DasObject table) {
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        DdlBuilder ddlBuilder = $this$key.identifier(table);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"identifier(...)");
        return ddlBuilder;
    }

    @NotNull
    public static final DdlBuilder key(@NotNull DdlBuilder $this$key, @NotNull WrapInSelectTask task) {
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        DdlBuilder ddlBuilder = $this$key.plain(UtilKt.getKey(task));
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"plain(...)");
        return ddlBuilder;
    }

    @NotNull
    public static final String keyScrName(@Nullable DasObject table) {
        Object object;
        block3: {
            block2: {
                object = table;
                if (object == null) break block2;
                DasObject it = object;
                boolean bl = false;
                Dbms dbms = RedisDbms.REDIS;
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"REDIS");
                NamingService namingService = NamingServices.getNamingService$default((Dbms)dbms, null, null, (int)6, null);
                String string = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = namingService.catToScript(string, it.getKind());
                object = string2;
                if (string2 != null) break block3;
            }
            object = "???";
        }
        return object;
    }

    public static final boolean isNotBlank(@Nullable WhereClause $this$isNotBlank) {
        WhereClause whereClause = $this$isNotBlank;
        return whereClause instanceof ValuesWhereClause ? false : (whereClause instanceof PlainWhereClause ? !StringsKt.isBlank((CharSequence)((PlainWhereClause)$this$isNotBlank).getFilter()) : (whereClause instanceof PredicatesWhereClause ? false : false));
    }

    @NotNull
    public static final DdlBuilder generateWhereHint(@NotNull DdlBuilder $this$generateWhereHint, @NotNull String hintColumnTitle, @Nullable WhereClause whereClause) {
        Intrinsics.checkNotNullParameter((Object)$this$generateWhereHint, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)hintColumnTitle, (String)"hintColumnTitle");
        DdlBuilder ddlBuilder = $this$generateWhereHint.plain("--").space().plain(hintColumnTitle).space().symbol(":").space();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"space(...)");
        DdlBuilder ddlBuilder2 = UtilKt.generateWhere(ddlBuilder, whereClause).newLine();
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"newLine(...)");
        return ddlBuilder2;
    }

    @NotNull
    public static final DdlBuilder generateWhere(@NotNull DdlBuilder $this$generateWhere, @Nullable WhereClause whereClause) {
        Intrinsics.checkNotNullParameter((Object)$this$generateWhere, (String)"<this>");
        DdlBuilder ddlBuilder = whereClause instanceof PlainWhereClause ? $this$generateWhere.plain(((PlainWhereClause)whereClause).getFilter()) : $this$generateWhere;
        Intrinsics.checkNotNull((Object)ddlBuilder);
        return ddlBuilder;
    }

    @NotNull
    public static final String getCommand(@NotNull WrapInSelectTask $this$command) {
        Intrinsics.checkNotNullParameter((Object)$this$command, (String)"<this>");
        String string = UtilKt.advanceToCommand(UtilKt.startLexer($this$command.getProject(), $this$command.getQuery())).getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        return string;
    }

    private static final Lexer advanceToCommand(Lexer $this$advanceToCommand) {
        UtilKt.skipHintIfExists($this$advanceToCommand);
        return $this$advanceToCommand;
    }

    @NotNull
    public static final String getKey(@NotNull WrapInSelectTask $this$key) {
        Intrinsics.checkNotNullParameter((Object)$this$key, (String)"<this>");
        String string = UtilKt.advanceToKey(UtilKt.startLexer($this$key.getProject(), $this$key.getQuery())).getTokenText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTokenText(...)");
        return string;
    }

    private static final Lexer advanceToKey(Lexer $this$advanceToKey) {
        UtilKt.advanceToCommand($this$advanceToKey);
        $this$advanceToKey.advance();
        $this$advanceToKey.advance();
        return $this$advanceToKey;
    }

    private static final Lexer skipHintIfExists(Lexer $this$skipHintIfExists) {
        if (Intrinsics.areEqual((Object)$this$skipHintIfExists.getTokenType(), (Object)SqlTokens.SQL_LINE_COMMENT)) {
            $this$skipHintIfExists.advance();
            $this$skipHintIfExists.advance();
        }
        return $this$skipHintIfExists;
    }

    private static final Lexer startLexer(Project project, String query) {
        RedisDialect language = RedisDialect.INSTANCE;
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)language);
        Lexer lexer = parserDefinition.createLexer(project);
        Intrinsics.checkNotNullExpressionValue((Object)lexer, (String)"createLexer(...)");
        Lexer lexer2 = lexer;
        lexer2.start((CharSequence)query);
        return lexer2;
    }
}

