/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresgreenplumbase.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dialects.postgresbase.model.PgBaseModelHelper;
import com.intellij.database.dialects.postgresbase.model.PgBaseObjectWithOwner;
import com.intellij.database.dialects.postgresbase.model.properties.PgDataTypeSubKind;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDatabase;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefType;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseDefTypeAttribute;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseIndex;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseKey;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseLocalTable;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseOperatorClass;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseRole;
import com.intellij.database.dialects.postgresgreenplumbase.model.PgGPlumBaseSequence;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ModelHelper;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.meta.BasicMetaField;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.icons.AllIcons;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 &2\u00020\u0001:\u0001&B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u001c\u0010\u0015\u001a\u00020\u00162\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J4\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J4\u0010 \u001a\u00020\u001a\"\b\b\u0000\u0010!*\u00020\"2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H!0\u00142\u0012\u0010#\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H!0%0$H\u0016\u00a8\u0006'"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper;", "Lcom/intellij/database/dialects/postgresbase/model/PgBaseModelHelper;", "<init>", "()V", "hasDefaultType", "", "sequence", "Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseSequence;", "getIcon", "Ljavax/swing/Icon;", "kind", "Lcom/intellij/database/model/ObjectKind;", "variant", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "getVariant", "c", "Lcom/intellij/database/model/DasObject;", "generationVariants", "Lcom/intellij/util/containers/JBIterable;", "meta", "Lcom/intellij/database/model/meta/BasicMetaObject;", "getTitle", "", "prop", "Lcom/intellij/database/model/meta/BasicMetaId;", "fillPropertiesWithExamples", "", "e", "Lcom/intellij/database/model/basic/BasicModElement;", "vars", "", "modifyParent", "reorderProperties", "E", "Lcom/intellij/database/model/basic/BasicElement;", "fields", "", "Lcom/intellij/database/model/meta/BasicMetaField;", "Companion", "intellij.database.dialects.postgresgreenplumbase"})
public abstract class PgGPlumBaseModelHelper
extends PgBaseModelHelper {
    @NotNull
    protected static final Companion Companion = new Companion(null);
    @NotNull
    private static final ModelHelper.ObjectKindVariant ENUM = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.enum", (Object[])new Object[0]));
    @NotNull
    private static final ModelHelper.ObjectKindVariant DOMAIN = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.domain", (Object[])new Object[0]));
    @NotNull
    private static final ModelHelper.ObjectKindVariant COMPOSITE_TYPE = new ModelHelper.ObjectKindVariant(DatabaseBundle.messagePointer((String)"ObjectKindVariant.composite.type", (Object[])new Object[0]));

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasDefaultType(@NotNull PgGPlumBaseSequence sequence) {
        Intrinsics.checkNotNullParameter((Object)sequence, (String)"sequence");
        DataType dataType = sequence.getDasType().toDataType();
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"toDataType(...)");
        DataType dataType2 = dataType;
        if (Intrinsics.areEqual((Object)dataType2, (Object)DataType.UNKNOWN)) return true;
        if (StringsKt.equals((String)dataType2.typeName, (String)"bigint", (boolean)true)) return true;
        if (!StringsKt.equals((String)dataType2.typeName, (String)"integer", (boolean)true)) return false;
        Version version = ((BasicModModel)sequence.getModel()).getRoot().getServerVersion();
        if (version == null) return true;
        if (!version.isOrGreater(this.getSequenceTypeSince())) return true;
        return false;
    }

    @Nullable
    public Icon getIcon(@NotNull ObjectKind kind, @NotNull ModelHelper.ObjectKindVariant variant) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return Intrinsics.areEqual((Object)variant, (Object)ENUM) ? AllIcons.Nodes.Enum : super.getIcon(kind, variant);
    }

    @NotNull
    public ModelHelper.ObjectKindVariant getVariant(@NotNull DasObject c) {
        ModelHelper.ObjectKindVariant objectKindVariant;
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        if (c instanceof PgGPlumBaseRole && ((PgGPlumBaseRole)c).isCanLogin()) {
            ModelHelper.ObjectKindVariant objectKindVariant2 = ModelHelper.USER;
            objectKindVariant = objectKindVariant2;
            Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant2, (String)"USER");
        } else if (c instanceof PgGPlumBaseDefType) {
            switch (WhenMappings.$EnumSwitchMapping$0[((PgGPlumBaseDefType)c).getSubKind().ordinal()]) {
                case 1: {
                    objectKindVariant = ENUM;
                    break;
                }
                case 2: {
                    objectKindVariant = DOMAIN;
                    break;
                }
                case 3: {
                    objectKindVariant = COMPOSITE_TYPE;
                    break;
                }
                default: {
                    ModelHelper.ObjectKindVariant objectKindVariant3 = ModelHelper.DEFAULT;
                    objectKindVariant = objectKindVariant3;
                    Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant3, (String)"DEFAULT");
                    break;
                }
            }
        } else {
            ModelHelper.ObjectKindVariant objectKindVariant4 = super.getVariant(c);
            objectKindVariant = objectKindVariant4;
            Intrinsics.checkNotNullExpressionValue((Object)objectKindVariant4, (String)"getVariant(...)");
        }
        return objectKindVariant;
    }

    @NotNull
    public JBIterable<ModelHelper.ObjectKindVariant> generationVariants(@NotNull BasicMetaObject<?> meta) {
        JBIterable jBIterable;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        ObjectKind objectKind = meta.kind;
        if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROLE)) {
            JBIterable jBIterable2 = super.generationVariants(meta).append((Object)ModelHelper.USER);
            jBIterable = jBIterable2;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable2, (String)"append(...)");
        } else if (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.OBJECT_TYPE)) {
            Object[] objectArray = new ModelHelper.ObjectKindVariant[]{ENUM, DOMAIN, COMPOSITE_TYPE};
            JBIterable jBIterable3 = JBIterable.of((Object[])objectArray);
            jBIterable = jBIterable3;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable3, (String)"of(...)");
        } else {
            JBIterable jBIterable4 = super.generationVariants(meta);
            jBIterable = jBIterable4;
            Intrinsics.checkNotNullExpressionValue((Object)jBIterable4, (String)"generationVariants(...)");
        }
        return jBIterable;
    }

    @NotNull
    public String getTitle(@NotNull BasicMetaObject<?> meta, @NotNull BasicMetaId prop) {
        String string;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        if (Intrinsics.areEqual((Object)prop, PgGPlumBaseIndex.INCLUDED_COL_NAMES)) {
            String string2 = DatabaseBundle.message((String)"label.include.columns", (Object[])new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = super.getTitle(meta, prop);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTitle(...)");
        }
        return string;
    }

    public void fillPropertiesWithExamples(@NotNull BasicModElement e, @NotNull ModelHelper.ObjectKindVariant variant, @NotNull Map<String, String> vars, boolean modifyParent) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        if (Intrinsics.areEqual((Object)variant, (Object)ModelHelper.USER) && e instanceof PgGPlumBaseRole) {
            ((PgGPlumBaseRole)e).setCanLogin(true);
        }
        if (e instanceof PgGPlumBaseOperatorClass) {
            PgGPlumBaseOperatorClass pgGPlumBaseOperatorClass = (PgGPlumBaseOperatorClass)e;
            DataType dataType = DataTypeFactory.of((String)"int");
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            pgGPlumBaseOperatorClass.setInStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            vars.put("type", "int");
        }
        if (e instanceof PgGPlumBaseDefType) {
            ModelHelper.ObjectKindVariant objectKindVariant = variant;
            if (Intrinsics.areEqual((Object)objectKindVariant, (Object)ENUM)) {
                ((PgGPlumBaseDefType)e).setSubKind(PgDataTypeSubKind.ENUM);
                ((PgGPlumBaseDefType)e).setLabels(CollectionsKt.listOf((Object)"label"));
                vars.put("labels", "'label'");
            } else if (Intrinsics.areEqual((Object)objectKindVariant, (Object)DOMAIN)) {
                ((PgGPlumBaseDefType)e).setSubKind(PgDataTypeSubKind.DOMAIN);
            } else if (Intrinsics.areEqual((Object)objectKindVariant, (Object)COMPOSITE_TYPE)) {
                ((PgGPlumBaseDefType)e).setSubKind(PgDataTypeSubKind.COMPOSITE);
                BasicModElement basicModElement = ((PgGPlumBaseDefType)e).getAttributes().createNewOne();
                Intrinsics.checkNotNullExpressionValue((Object)basicModElement, (String)"createNewOne(...)");
                PgGPlumBaseDefTypeAttribute attr = (PgGPlumBaseDefTypeAttribute)basicModElement;
                this.setTemplateName((BasicModNamedElement)attr, "attr");
                DataType dataType = DataTypeFactory.of((String)"int");
                Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                attr.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                vars.put("attrs", "attr int");
            }
        }
        super.fillPropertiesWithExamples(e, variant, vars, modifyParent);
    }

    public <E extends BasicElement> void reorderProperties(@NotNull BasicMetaObject<E> meta, @NotNull List<BasicMetaField<E>> fields) {
        BasicMetaId[] basicMetaIdArray;
        Intrinsics.checkNotNullParameter(meta, (String)"meta");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        super.reorderProperties(meta, fields);
        if (meta.kindOf(PgGPlumBaseDatabase.class)) {
            basicMetaIdArray = new BasicMetaId[]{PgGPlumBaseDatabase.TEMPLATE, PgGPlumBaseDatabase.ALLOW_CONNECTIONS};
            ModelHelper.moveTo(fields, (int)(ModelHelper.indexOf(fields, (BasicMetaId)((BasicMetaId)PgGPlumBaseDatabase.COMMENT)) + 1), (BasicMetaId[])basicMetaIdArray);
        }
        if (meta.kindOf(PgGPlumBaseRole.class)) {
            basicMetaIdArray = new BasicMetaId[]{PgGPlumBaseRole.CONNECTION_LIMIT, PgGPlumBaseRole.CONFIG, PgGPlumBaseRole.VALID_UNTIL};
            ModelHelper.moveTo(fields, (int)fields.size(), (BasicMetaId[])basicMetaIdArray);
        }
        if (meta.kindOf(PgGPlumBaseSequence.class)) {
            ModelHelper.moveTo(fields, (int)2, (BasicMetaId)((BasicMetaId)PgGPlumBaseSequence.STORED_TYPE));
        }
        if (meta.kindOf(PgGPlumBaseLocalTable.class)) {
            ModelHelper.moveTo(fields, (int)(ModelHelper.indexOf(fields, (BasicMetaId)((BasicMetaId)PgGPlumBaseLocalTable.COMMENT)) + 1), (BasicMetaId)((BasicMetaId)PgGPlumBaseLocalTable.PERSISTENCE));
        }
        if (meta.kindOf(PgGPlumBaseKey.class)) {
            ModelHelper.moveTo(fields, (int)(ModelHelper.indexOf(fields, (BasicMetaId)((BasicMetaId)PgGPlumBaseKey.COL_NAMES)) + 1), (BasicMetaId)((BasicMetaId)PgGPlumBaseKey.EXCLUSION_OPERATOR_REFS));
        }
        basicMetaIdArray = new BasicMetaId[]{PgBaseObjectWithOwner.OWNER_REF, BasicModSourceAware.SOURCE_TEXT};
        ModelHelper.moveTo(fields, (int)fields.size(), (BasicMetaId[])basicMetaIdArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0084\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dialects/postgresgreenplumbase/model/PgGPlumBaseModelHelper$Companion;", "", "<init>", "()V", "ENUM", "Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "getENUM", "()Lcom/intellij/database/model/ModelHelper$ObjectKindVariant;", "DOMAIN", "getDOMAIN", "COMPOSITE_TYPE", "getCOMPOSITE_TYPE", "intellij.database.dialects.postgresgreenplumbase"})
    protected static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ModelHelper.ObjectKindVariant getENUM() {
            return ENUM;
        }

        @NotNull
        public final ModelHelper.ObjectKindVariant getDOMAIN() {
            return DOMAIN;
        }

        @NotNull
        public final ModelHelper.ObjectKindVariant getCOMPOSITE_TYPE() {
            return COMPOSITE_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PgDataTypeSubKind.values().length];
            try {
                nArray[PgDataTypeSubKind.ENUM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PgDataTypeSubKind.DOMAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PgDataTypeSubKind.COMPOSITE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

