/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.history;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceStorage;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.history.DataSourceFromHistory;
import com.intellij.database.dataSource.history.DataSourceHistoryImpl;
import com.intellij.database.dataSource.history.DataSourcesHistoryKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.io.SafeFileOutputStream;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.NonCancellable;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 62\u00020\u0001:\u00043456B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u0013H\u0082@\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\b\u0010\u0019\u001a\u00020\u0013H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\b\u0010 \u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010&\u001a\u00020\u001dH\u0007J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\b\u0010(\u001a\u00020\u0013H\u0002J\u0006\u0010)\u001a\u00020\u0013J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+H\u0007J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020,0+H\u0007J\u000e\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u00020\u001bJ\u0006\u00100\u001a\u00020\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/database/dataSource/history/DataSourcesHistory;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "stateFile", "Ljava/nio/file/Path;", "delegate", "Lcom/intellij/database/dataSource/history/DataSourceHistoryImpl;", "lockAccess", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "backupFile", "saveOnDiskLock", "Ljava/util/concurrent/locks/Lock;", "saveEvents", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "savesWorkerJob", "Lkotlinx/coroutines/Job;", "handleSaves", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "save", "saveOnProjectClose", "shouldSkipSavingOnDisk", "", "state", "Lorg/jdom/Element;", "saveOnDisk", "dataSourceChanged", "getMaxHistorySize", "", "addDataSourceFromProject", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "removeDataSourceFromProject", "getState", "loadState", "bindExistingDataSources", "clear", "getDataSources", "", "Lcom/intellij/database/dataSource/history/DataSourceFromHistory;", "getProjectDataSource", "restoreDataSources", "missingOnly", "suggestRestoreDataSourcesIfNeeded", "RESTORE_ACTION", "Lcom/intellij/notification/NotificationAction;", "HistoryInitialization", "Storage", "ProjectListener", "Companion", "intellij.database.connectivity"})
@SourceDebugExtension(value={"SMAP\nDataSourcesHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,272:1\n1#2:273\n1915#3,2:274\n*S KotlinDebug\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory\n*L\n194#1:274,2\n*E\n"})
public final class DataSourcesHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Path stateFile;
    @NotNull
    private final DataSourceHistoryImpl delegate;
    @NotNull
    private final ReentrantReadWriteLock lockAccess;
    @NotNull
    private final Path backupFile;
    @NotNull
    private final Lock saveOnDiskLock;
    @NotNull
    private final MutableSharedFlow<Unit> saveEvents;
    @NotNull
    private final Job savesWorkerJob;
    @NotNull
    private final NotificationAction RESTORE_ACTION;

    public DataSourcesHistory(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.lockAccess = new ReentrantReadWriteLock();
        String[] stringArray = new String[]{this.project.getLocationHash(), "data_sources_history.xml"};
        Path path = PathManager.getConfigDir().resolve(Path.of("dataSourcesHistory", stringArray));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.backupFile = path;
        this.saveOnDiskLock = new ReentrantLock();
        this.saveEvents = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)1, null);
        String projectStorage = DataSourceStorage.getStorageDir((Project)this.project);
        if (projectStorage == null) {
            String message = "Failed to get storage dir for project: " + this.project.getName();
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                DataSourcesHistoryKt.access$getLog$p().error(message);
            } else {
                DataSourcesHistoryKt.access$getLog$p().warn(message);
            }
            this.stateFile = null;
        } else {
            stringArray = new String[]{"data_sources_history.xml"};
            this.stateFile = Path.of(projectStorage, stringArray);
        }
        this.delegate = new DataSourceHistoryImpl(this.project);
        this.delegate.loadState(this.stateFile, this.backupFile);
        this.bindExistingDataSources();
        this.savesWorkerJob = BuildersKt.launch$default((CoroutineScope)cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DataSourcesHistory this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.handleSaves((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        String string = DatabaseBundle.message((String)"data.source.history.restore.notification.restore", (Object[])new Object[0]);
        this.RESTORE_ACTION = new NotificationAction(this, string){
            final /* synthetic */ DataSourcesHistory this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e, Notification notification) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                if (e.getProject() == null) {
                    return;
                }
                notification.expire();
                this.this$0.restoreDataSources(true);
            }
        };
    }

    private final Object handleSaves(Continuation<? super Unit> $completion) {
        Object object = FlowKt.collectLatest((Flow)FlowKt.debounce-HG0u8IE((Flow)((Flow)this.saveEvents), (long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS)), (Function2)((Function2)new Function2<Unit, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DataSourcesHistory this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$0;
                            int label;
                            final /* synthetic */ DataSourcesHistory this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        Element state = this.this$0.getState();
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)state);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)NonCancellable.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, state, null){
                                            int label;
                                            final /* synthetic */ DataSourcesHistory this$0;
                                            final /* synthetic */ Element $state;
                                            {
                                                this.this$0 = $receiver;
                                                this.$state = $state;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        DataSourcesHistory.access$saveOnDisk(this.this$0, this.$state);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        Element state = (Element)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Unit p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void save() {
        this.saveEvents.tryEmit((Object)Unit.INSTANCE);
    }

    private final void saveOnProjectClose() {
        Job.DefaultImpls.cancel$default((Job)this.savesWorkerJob, null, (int)1, null);
        Element state = this.getState();
        this.saveOnDisk(state);
    }

    private final boolean shouldSkipSavingOnDisk(Element state) {
        try {
            return this.stateFile != null && state.isEmpty() && Files.notExists(this.stateFile, new LinkOption[0]);
        }
        catch (Throwable e) {
            DataSourcesHistoryKt.access$getLog$p().error(e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void saveOnDisk(Element state) {
        if (this.shouldSkipSavingOnDisk(state)) {
            return;
        }
        Lock lock = this.saveOnDiskLock;
        lock.lock();
        try {
            SafeFileOutputStream it;
            Throwable throwable;
            boolean bl = false;
            if (this.stateFile != null) {
                try {
                    Files.createDirectories(this.stateFile.getParent(), new FileAttribute[0]);
                    Closeable closeable = (Closeable)new SafeFileOutputStream(this.stateFile);
                    throwable = null;
                    try {
                        it = (SafeFileOutputStream)closeable;
                        boolean bl2 = false;
                        JDOMUtil.write((Parent)((Parent)state), (OutputStream)((OutputStream)it));
                        it = Unit.INSTANCE;
                    }
                    catch (Throwable bl2) {
                        throwable = bl2;
                        throw bl2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                }
                catch (Throwable e) {
                    DataSourcesHistoryKt.access$getLog$p().error("Failed to save data sources history", e);
                }
            }
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                try {
                    Files.createDirectories(this.backupFile.getParent(), new FileAttribute[0]);
                    Closeable e = (Closeable)new SafeFileOutputStream(this.backupFile);
                    throwable = null;
                    try {
                        it = (SafeFileOutputStream)e;
                        boolean bl3 = false;
                        JDOMUtil.write((Parent)((Parent)state), (OutputStream)((OutputStream)it));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)e, (Throwable)throwable);
                    }
                }
                catch (Throwable e) {
                    DataSourcesHistoryKt.access$getLog$p().error("Failed to backup data sources history", e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void dataSourceChanged() {
        this.save();
    }

    @VisibleForTesting
    public final int getMaxHistorySize() {
        return DataSourceStorage.getProjectStorage((Project)this.project).getCount() + Registry.Companion.intValue("database.datasource.history.max.size");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addDataSourceFromProject(LocalDataSource dataSource) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lockAccess.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.delegate.addDataSourceFromProject(dataSource, this.getMaxHistorySize());
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void removeDataSourceFromProject(LocalDataSource dataSource) {
        ReentrantReadWriteLock.WriteLock writeLock = this.lockAccess.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.delegate.removeDataSourceFromProject(dataSource);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        this.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public final Element getState() {
        Element element;
        ReentrantReadWriteLock.ReadLock readLock = this.lockAccess.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            element = this.delegate.getState();
        }
        finally {
            lock.unlock();
        }
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public final void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ReentrantReadWriteLock.WriteLock writeLock = this.lockAccess.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.delegate.loadState(state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void bindExistingDataSources() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lockAccess.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            DataSourceStorage storage = DataSourceStorage.getProjectStorage((Project)this.project);
            this.delegate.bindExistingDataSources((Function1<? super String, ? extends LocalDataSource>)((Function1)arg_0 -> DataSourcesHistory.bindExistingDataSources$lambda$0$0(storage, arg_0)));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.lockAccess.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            this.delegate.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        DataSourcesHistoryKt.access$getLog$p().info("Data sources history cleared");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public final List<DataSourceFromHistory> getDataSources() {
        List<DataSourceFromHistory> list;
        ReentrantReadWriteLock.ReadLock readLock = this.lockAccess.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            list = this.delegate.getDataSources();
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NotNull
    public final List<DataSourceFromHistory> getProjectDataSource() {
        List<DataSourceFromHistory> list;
        ReentrantReadWriteLock.ReadLock readLock = this.lockAccess.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            list = this.delegate.getProjectDataSources();
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    public final void restoreDataSources(boolean missingOnly) {
        DataSourceStorage storage = DataSourceStorage.getProjectStorage((Project)this.project);
        List<DataSourceFromHistory> dataSourcesFromHistory = missingOnly ? this.getProjectDataSource() : this.getDataSources();
        Iterable $this$forEach$iv = dataSourcesFromHistory;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DataSourceFromHistory it = (DataSourceFromHistory)element$iv;
            boolean bl = false;
            LocalDataSource ds = it.getDataSource();
            ds.resolveDriver();
            if (storage.getDataSourceById(ds.getUniqueId()) != null) continue;
            storage.addDataSource(ds);
        }
        DataSourcesHistoryKt.access$getLog$p().info("Data sources restored from history");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void suggestRestoreDataSourcesIfNeeded() {
        int n;
        if (DataSourceStorage.getProjectStorage((Project)this.project).getCount() != 0) {
            return;
        }
        ReentrantReadWriteLock.ReadLock readLock = this.lockAccess.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Object[] objectArray = (Object[])readLock;
        objectArray.lock();
        try {
            boolean bl = false;
            n = this.delegate.getNumberOfProjectDataSources();
        }
        finally {
            objectArray.unlock();
        }
        int numberOfMissingDs = n;
        if (numberOfMissingDs == 0) {
            DataSourcesHistoryKt.access$getLog$p().info("Can not suggest restore data sources: no missing data sources in history");
            return;
        }
        objectArray = new Object[]{numberOfMissingDs};
        new Notification(DatabaseBundle.message((String)"data.sources.detected.empty.state.group.id", (Object[])new Object[0]), DatabaseBundle.message((String)"data.sources.detected.empty.state.group.id", (Object[])new Object[0]), DatabaseBundle.message((String)"data.source.history.restore.notification.text", (Object[])objectArray), NotificationType.WARNING).addAction((AnAction)this.RESTORE_ACTION).addAction((AnAction)NotificationAction.createSimpleExpiring((String)DatabaseBundle.message((String)"data.source.history.restore.notification.no", (Object[])new Object[0]), DataSourcesHistory::suggestRestoreDataSourcesIfNeeded$lambda$1)).notify(this.project);
    }

    private static final LocalDataSource bindExistingDataSources$lambda$0$0(DataSourceStorage $storage, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $storage.getDataSourceById(it);
    }

    private static final void suggestRestoreDataSourcesIfNeeded$lambda$1() {
    }

    public static final /* synthetic */ void access$saveOnDisk(DataSourcesHistory $this, Element state) {
        $this.saveOnDisk(state);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/history/DataSourcesHistory$Companion;", "", "<init>", "()V", "getDataSourceStringWithId", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getInstance", "Lcom/intellij/database/dataSource/history/DataSourcesHistory;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDataSourcesHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,272:1\n30#2,2:273\n*S KotlinDebug\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory$Companion\n*L\n269#1:273,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String getDataSourceStringWithId(LocalDataSource dataSource) {
            String string = dataSource.getUniqueId();
            Dbms dbms = dataSource.getDbms();
            String string2 = dataSource.getUrl();
            if (string2 == null) {
                string2 = "";
            }
            return "LocalDataSource(id=" + string + ", dbms=" + dbms + ", url=" + string2 + ")";
        }

        @NotNull
        public final DataSourcesHistory getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DataSourcesHistory> serviceClass$iv = DataSourcesHistory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DataSourcesHistory)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/dataSource/history/DataSourcesHistory$HistoryInitialization;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDataSourcesHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory$HistoryInitialization\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,272:1\n30#2,2:273\n*S KotlinDebug\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory$HistoryInitialization\n*L\n241#1:273,2\n*E\n"})
    public static final class HistoryInitialization
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DataSourcesHistory> serviceClass$iv = DataSourcesHistory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((DataSourcesHistory)object).suggestRestoreDataSourcesIfNeeded();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/database/dataSource/history/DataSourcesHistory$ProjectListener;", "Lcom/intellij/openapi/project/ProjectCloseListener;", "<init>", "()V", "projectClosing", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDataSourcesHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory$ProjectListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,272:1\n30#2,2:273\n*S KotlinDebug\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory$ProjectListener\n*L\n262#1:273,2\n*E\n"})
    public static final class ProjectListener
    implements ProjectCloseListener {
        public void projectClosing(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DataSourcesHistory> serviceClass$iv = DataSourcesHistory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((DataSourcesHistory)object).saveOnProjectClose();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/database/dataSource/history/DataSourcesHistory$Storage;", "Lcom/intellij/database/dataSource/DataSourceStorage$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "dataSourceAdded", "", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "dataSourceChanged", "dataSourceRemoved", "intellij.database.connectivity"})
    @SourceDebugExtension(value={"SMAP\nDataSourcesHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory$Storage\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,272:1\n30#2,2:273\n30#2,2:275\n30#2,2:277\n*S KotlinDebug\n*F\n+ 1 DataSourcesHistory.kt\ncom/intellij/database/dataSource/history/DataSourcesHistory$Storage\n*L\n247#1:273,2\n252#1:275,2\n256#1:277,2\n*E\n"})
    public static final class Storage
    implements DataSourceStorage.Listener {
        @NotNull
        private final Project project;

        public Storage(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void dataSourceAdded(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<DataSourcesHistory> serviceClass$iv = DataSourcesHistory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((DataSourcesHistory)object).addDataSourceFromProject(dataSource);
            DataSourcesHistoryKt.access$getLog$p().info("Data source added to history: " + Companion.getDataSourceStringWithId(dataSource));
        }

        public void dataSourceChanged(@Nullable LocalDataSource dataSource) {
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<DataSourcesHistory> serviceClass$iv = DataSourcesHistory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((DataSourcesHistory)object).dataSourceChanged();
        }

        public void dataSourceRemoved(@NotNull LocalDataSource dataSource) {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            ComponentManager $this$service$iv = (ComponentManager)this.project;
            boolean $i$f$service = false;
            Class<DataSourcesHistory> serviceClass$iv = DataSourcesHistory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((DataSourcesHistory)object).removeDataSourceFromProject(dataSource);
        }
    }
}

