/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.searchEverywhere.frontend.ui;

import com.intellij.platform.searchEverywhere.SeItemData;
import com.intellij.platform.searchEverywhere.SeItemDataKt;
import com.intellij.platform.searchEverywhere.SeResultAddedEvent;
import com.intellij.platform.searchEverywhere.SeResultEndEvent;
import com.intellij.platform.searchEverywhere.SeResultEvent;
import com.intellij.platform.searchEverywhere.SeResultReplacedEvent;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultList;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListItemRow;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListMoreRow;
import com.intellij.platform.searchEverywhere.frontend.ui.SeResultListRow;
import com.intellij.platform.searchEverywhere.frontend.vm.SeSearchContext;
import com.intellij.platform.searchEverywhere.providers.SeLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\u001aF\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0001\u0018\u00010\b2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u000bH\u0007\u001a\u001c\u0010\f\u001a\u00020\r*\u00020\u00022\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a9\u0010\u0011\u001a\u0004\u0018\u00010\r*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00130\bH\u0002\u00a2\u0006\u0002\u0010\u0016\"\u0015\u0010\u0017\u001a\u00020\r*\u00020\u00028G\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"handleEvent", "", "Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultList;", "searchContext", "Lcom/intellij/platform/searchEverywhere/frontend/vm/SeSearchContext;", "event", "Lcom/intellij/platform/searchEverywhere/SeResultEvent;", "onAdd", "Lkotlin/Function1;", "Lcom/intellij/platform/searchEverywhere/SeItemData;", "onRemove", "Lkotlin/Function0;", "indexToAdd", "", "newItem", "searchPattern", "", "firstIndexOrNull", "fullSearch", "", "acceptMoreRow", "predicate", "(Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultList;ZZLkotlin/jvm/functions/Function1;)Ljava/lang/Integer;", "lastIndexToInsertItem", "getLastIndexToInsertItem", "(Lcom/intellij/platform/searchEverywhere/frontend/ui/SeResultList;)I", "intellij.platform.searchEverywhere.frontend"})
@SourceDebugExtension(value={"SMAP\nresultListEventHandlingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resultListEventHandlingUtils.kt\ncom/intellij/platform/searchEverywhere/frontend/ui/ResultListEventHandlingUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n1642#2,10:207\n1915#2:217\n1916#2:219\n1652#2:220\n1915#2,2:221\n296#2,2:223\n1#3:218\n*S KotlinDebug\n*F\n+ 1 resultListEventHandlingUtils.kt\ncom/intellij/platform/searchEverywhere/frontend/ui/ResultListEventHandlingUtilsKt\n*L\n62#1:207,10\n62#1:217\n62#1:219\n62#1:220\n78#1:221,2\n132#1:223,2\n62#1:218\n*E\n"})
public final class ResultListEventHandlingUtilsKt {
    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static final void handleEvent(@NotNull SeResultList $this$handleEvent, @NotNull SeSearchContext searchContext, @NotNull SeResultEvent event, @Nullable Function1<? super SeItemData, Unit> onAdd, @Nullable Function0<Unit> onRemove) {
        Intrinsics.checkNotNullParameter((Object)$this$handleEvent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)searchContext, (String)"searchContext");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        SeResultEvent seResultEvent = event;
        if (seResultEvent instanceof SeResultAddedEvent) {
            if ($this$handleEvent.getPendingReplacementElementUuids().remove(((SeResultAddedEvent)event).getItemData().getUuid())) {
                SeLog.Companion.log(SeLog.DEFAULT, () -> ResultListEventHandlingUtilsKt.handleEvent$lambda$0(event));
            } else {
                int index = ResultListEventHandlingUtilsKt.indexToAdd($this$handleEvent, ((SeResultAddedEvent)event).getItemData(), searchContext.getSearchPattern());
                $this$handleEvent.addRow(index, new SeResultListItemRow(((SeResultAddedEvent)event).getItemData()));
                Function1<? super SeItemData, Unit> function1 = onAdd;
                if (function1 != null) {
                    function1.invoke((Object)((SeResultAddedEvent)event).getItemData());
                }
                if ($this$handleEvent.getSize() == 1) {
                    $this$handleEvent.addRow(SeResultListMoreRow.INSTANCE);
                }
            }
        } else if (seResultEvent instanceof SeResultReplacedEvent) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = ((SeResultReplacedEvent)event).getUuidsToReplace();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Integer it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String uuidToReplace = (String)element$iv$iv;
                boolean bl2 = false;
                Integer index = ResultListEventHandlingUtilsKt.firstIndexOrNull$default($this$handleEvent, true, false, arg_0 -> ResultListEventHandlingUtilsKt.handleEvent$lambda$1$0(uuidToReplace, arg_0), 2, null);
                if (index == null) {
                    $this$handleEvent.getPendingReplacementElementUuids().add(uuidToReplace);
                    SeLog.Companion.log(SeLog.DEFAULT, () -> ResultListEventHandlingUtilsKt.handleEvent$lambda$1$1(uuidToReplace));
                }
                if (index == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List indexes = CollectionsKt.sortedDescending((Iterable)((List)destination$iv$iv));
            if (indexes.isEmpty()) {
                int index = ResultListEventHandlingUtilsKt.indexToAdd($this$handleEvent, ((SeResultReplacedEvent)event).getNewItemData(), searchContext.getSearchPattern());
                $this$handleEvent.addRow(index, new SeResultListItemRow(((SeResultReplacedEvent)event).getNewItemData()));
                Function1<? super SeItemData, Unit> function1 = onAdd;
                if (function1 != null) {
                    function1.invoke((Object)((SeResultReplacedEvent)event).getNewItemData());
                }
            } else {
                Iterable $this$forEach$iv = indexes;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    int index = ((Number)element$iv).intValue();
                    boolean bl = false;
                    $this$handleEvent.removeRow(index);
                    Function0<Unit> function0 = onRemove;
                    if (function0 != null) {
                        function0.invoke();
                    }
                    if (index != ((Number)CollectionsKt.last((List)indexes)).intValue()) continue;
                    $this$handleEvent.addRow(index, new SeResultListItemRow(((SeResultReplacedEvent)event).getNewItemData()));
                    Function1<? super SeItemData, Unit> function1 = onAdd;
                    if (function1 == null) continue;
                    function1.invoke((Object)((SeResultReplacedEvent)event).getNewItemData());
                }
            }
        } else if (!(seResultEvent instanceof SeResultEndEvent)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static /* synthetic */ void handleEvent$default(SeResultList seResultList, SeSearchContext seSearchContext, SeResultEvent seResultEvent, Function1 function1, Function0 function0, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = null;
        }
        if ((n & 8) != 0) {
            function0 = null;
        }
        ResultListEventHandlingUtilsKt.handleEvent(seResultList, seSearchContext, seResultEvent, (Function1<? super SeItemData, Unit>)function1, (Function0<Unit>)function0);
    }

    private static final int indexToAdd(SeResultList $this$indexToAdd, SeItemData newItem, String searchPattern) {
        if (SeItemDataKt.isCommand((SeItemData)newItem)) {
            Integer n = ResultListEventHandlingUtilsKt.firstIndexOrNull($this$indexToAdd, true, true, (Function1<? super SeItemData, Boolean>)((Function1)ResultListEventHandlingUtilsKt::indexToAdd$lambda$0));
            int firstNotCommandIndex = n != null ? n.intValue() : $this$indexToAdd.getSize();
            Function1[] function1Array = new Function1[]{arg_0 -> ResultListEventHandlingUtilsKt.indexToAdd$lambda$1(searchPattern, arg_0), ResultListEventHandlingUtilsKt::indexToAdd$lambda$2};
            Comparator comparator = ComparisonsKt.compareBy((Function1[])function1Array);
            for (int i = 0; i < firstNotCommandIndex; ++i) {
                SeItemData item;
                SeResultListRow row = $this$indexToAdd.getRow(i);
                if (!(row instanceof SeResultListItemRow) || comparator.compare(newItem, item = ((SeResultListItemRow)row).getItem()) >= 0) continue;
                return i;
            }
            return firstNotCommandIndex;
        }
        Integer n = ResultListEventHandlingUtilsKt.firstIndexOrNull$default($this$indexToAdd, false, false, arg_0 -> ResultListEventHandlingUtilsKt.indexToAdd$lambda$3(newItem, arg_0), 2, null);
        return n != null ? n : ResultListEventHandlingUtilsKt.getLastIndexToInsertItem($this$indexToAdd);
    }

    private static final Integer firstIndexOrNull(SeResultList $this$firstIndexOrNull, boolean fullSearch, boolean acceptMoreRow, Function1<? super SeItemData, Boolean> predicate) {
        Object v1;
        block5: {
            int startIndex = fullSearch ? 0 : $this$firstIndexOrNull.getFrozenCount();
            Iterable $this$firstOrNull$iv = (Iterable)RangesKt.until((int)startIndex, (int)$this$firstIndexOrNull.getSize());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                int index = ((Number)element$iv).intValue();
                boolean bl2 = false;
                SeResultListRow row = $this$firstIndexOrNull.getRow(index);
                if (row instanceof SeResultListItemRow) {
                    bl = (Boolean)predicate.invoke((Object)((SeResultListItemRow)row).getItem());
                } else if (Intrinsics.areEqual((Object)row, (Object)SeResultListMoreRow.INSTANCE)) {
                    bl = acceptMoreRow;
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                if (!bl) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    static /* synthetic */ Integer firstIndexOrNull$default(SeResultList seResultList, boolean bl, boolean bl2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl2 = false;
        }
        return ResultListEventHandlingUtilsKt.firstIndexOrNull(seResultList, bl, bl2, (Function1<? super SeItemData, Boolean>)function1);
    }

    @ApiStatus.Internal
    public static final int getLastIndexToInsertItem(@NotNull SeResultList $this$lastIndexToInsertItem) {
        Intrinsics.checkNotNullParameter((Object)$this$lastIndexToInsertItem, (String)"<this>");
        return $this$lastIndexToInsertItem.getSize() == 0 ? 0 : ($this$lastIndexToInsertItem.getRow($this$lastIndexToInsertItem.getSize() - 1) instanceof SeResultListMoreRow ? $this$lastIndexToInsertItem.getSize() - 1 : $this$lastIndexToInsertItem.getSize());
    }

    private static final boolean handleEvent$lambda$1$0(String $uuidToReplace, SeItemData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)$uuidToReplace, (Object)it.getUuid());
    }

    private static final String handleEvent$lambda$1$1(String $uuidToReplace) {
        return "SeResultReplacedEvent: uuid " + $uuidToReplace + " not found in the list, saved to pending replacement";
    }

    private static final String handleEvent$lambda$0(SeResultEvent $event) {
        return "SeResultAddedEvent: uuid " + ((SeResultAddedEvent)$event).getItemData().getUuid() + " was skipped because it was supposed to be replaced by an element which came earlier";
    }

    private static final boolean indexToAdd$lambda$0(SeItemData item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return !SeItemDataKt.isCommand((SeItemData)item);
    }

    private static final Comparable indexToAdd$lambda$1(String $searchPattern, SeItemData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPresentation().getText().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return Boolean.valueOf(!StringsKt.startsWith$default((String)string, (String)$searchPattern, (boolean)false, (int)2, null));
    }

    private static final Comparable indexToAdd$lambda$2(SeItemData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getPresentation().getText().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        return (Comparable)((Object)string);
    }

    private static final boolean indexToAdd$lambda$3(SeItemData $newItem, SeItemData item) {
        int itemProviderPriority;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (SeItemDataKt.isCommand((SeItemData)item)) {
            return false;
        }
        Integer n = SeResultList.Companion.getPrioritizedProvidersPriorities().get($newItem.getProviderId());
        int newItemProviderPriority = n != null ? n : 0;
        Integer n2 = SeResultList.Companion.getPrioritizedProvidersPriorities().get(item.getProviderId());
        int n3 = itemProviderPriority = n2 != null ? n2 : 0;
        return newItemProviderPriority == itemProviderPriority ? $newItem.getWeight() > item.getWeight() : newItemProviderPriority > itemProviderPriority;
    }
}

