/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packages;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005J*\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u001e\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0005H\u0002R\u000e\u0010\u001a\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/nodejs/packages/NodePackageLinkResolver;", "", "<init>", "()V", "resolve", "Lcom/intellij/openapi/vfs/VirtualFile;", "originalFile", "findRelativePath", "", "originalDependencyRoot", "canonicalFile", "canonicalDependencyRoot", "tryResolveDependencyRootAsPnpmHardLink", "originalDependency", "canonicalDependency", "tryResolveDependency", "packageJson", "versionRange", "isPnpmHardLink", "", "dirToResolve", "getLowerNodeModules", "dir", "findNodeModulesAndDependencyName", "Lkotlin/Pair;", "dependency", "FILE_SCHEME", "DOT_PNPM", "intellij.javascript.backend"})
public final class NodePackageLinkResolver {
    @NotNull
    public static final NodePackageLinkResolver INSTANCE = new NodePackageLinkResolver();
    @NotNull
    private static final String FILE_SCHEME = "file:";
    @NotNull
    public static final String DOT_PNPM = ".pnpm";

    private NodePackageLinkResolver() {
    }

    @NotNull
    public final VirtualFile resolve(@NotNull VirtualFile originalFile) {
        String string;
        VirtualFile correctDependencyRoot;
        VirtualFile originalDependencyRoot;
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        VirtualFile canonicalFile = originalFile.getCanonicalFile();
        if (canonicalFile == null || Intrinsics.areEqual((Object)canonicalFile, (Object)originalFile)) {
            return originalFile;
        }
        VirtualFile canonicalDependencyRoot = NodeModuleSearchUtil.findDependencyRoot(canonicalFile);
        if (canonicalDependencyRoot != null && (originalDependencyRoot = NodeModuleSearchUtil.findDependencyRoot(originalFile)) != null && (correctDependencyRoot = this.tryResolveDependencyRootAsPnpmHardLink(originalDependencyRoot, canonicalDependencyRoot)) != null && (string = this.findRelativePath(originalFile, originalDependencyRoot, canonicalFile, canonicalDependencyRoot)) != null) {
            String it = string;
            boolean bl = false;
            VirtualFile virtualFile = correctDependencyRoot.findFileByRelativePath(it);
            if (virtualFile == null) {
                virtualFile = canonicalFile;
            }
            return virtualFile;
        }
        return canonicalFile;
    }

    private final String findRelativePath(VirtualFile originalFile, VirtualFile originalDependencyRoot, VirtualFile canonicalFile, VirtualFile canonicalDependencyRoot) {
        String string = VfsUtil.getRelativePath((VirtualFile)originalFile, (VirtualFile)originalDependencyRoot);
        Intrinsics.checkNotNull((Object)string);
        String originalRelativePath = string;
        String string2 = VfsUtil.getRelativePath((VirtualFile)canonicalFile, (VirtualFile)canonicalDependencyRoot);
        Intrinsics.checkNotNull((Object)string2);
        String canonicalRelativePath = string2;
        return Intrinsics.areEqual((Object)originalRelativePath, (Object)canonicalRelativePath) ? originalRelativePath : null;
    }

    private final VirtualFile tryResolveDependencyRootAsPnpmHardLink(VirtualFile originalDependency, VirtualFile canonicalDependency) {
        if (this.isPnpmHardLink(canonicalDependency) && originalDependency.is(VFileProperty.SYMLINK)) {
            Pair<VirtualFile, String> pair = this.findNodeModulesAndDependencyName(originalDependency);
            if (pair == null) {
                return null;
            }
            Pair<VirtualFile, String> pair2 = pair;
            VirtualFile nodeModulesDir = (VirtualFile)pair2.component1();
            String dependencyName = (String)pair2.component2();
            VirtualFile packageJson = NodeModuleUtil.findPackageJsonByNodeModules(nodeModulesDir);
            if (packageJson != null) {
                PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson);
                Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
                PackageJsonData packageJsonData2 = packageJsonData;
                PackageJsonData.PackageJsonDependencyEntry declaredDependency = packageJsonData2.getAllDependencyEntries().get(dependencyName);
                if (declaredDependency != null) {
                    String string = declaredDependency.getVersionRange();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionRange(...)");
                    return this.tryResolveDependency(packageJson, string);
                }
            }
        }
        return null;
    }

    private final VirtualFile tryResolveDependency(VirtualFile packageJson, String versionRange) {
        if (StringsKt.startsWith$default((String)versionRange, (String)FILE_SCHEME, (boolean)false, (int)2, null)) {
            String string = versionRange.substring(5);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String path2 = string;
            VirtualFile virtualFile = packageJson.getParent();
            return virtualFile != null ? virtualFile.findFileByRelativePath(path2) : null;
        }
        return null;
    }

    private final boolean isPnpmHardLink(VirtualFile dirToResolve) {
        if (!dirToResolve.isDirectory()) {
            return false;
        }
        VirtualFile virtualFile = this.getLowerNodeModules(dirToResolve);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile lowerNodeModulesDir = virtualFile;
        VirtualFile virtualFile2 = lowerNodeModulesDir.getParent();
        if (virtualFile2 == null || (virtualFile2 = virtualFile2.getParent()) == null) {
            return false;
        }
        VirtualFile dotPnpmDir = virtualFile2;
        if (!Intrinsics.areEqual((Object)dotPnpmDir.getName(), (Object)DOT_PNPM)) {
            return false;
        }
        VirtualFile parentNodeModulesDir = dotPnpmDir.getParent();
        return NodeModulesDirectoryManager.isNodeModulesDir(parentNodeModulesDir);
    }

    private final VirtualFile getLowerNodeModules(VirtualFile dir) {
        VirtualFile virtualFile = dir.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile;
        CharSequence charSequence = parent.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence parentName = charSequence;
        if (NodeModuleSearchUtil.isScopeDirName(parentName)) {
            VirtualFile virtualFile2 = parent.getParent();
            if (virtualFile2 == null) {
                return null;
            }
            parent = virtualFile2;
            String string = parent.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            parentName = string;
        }
        return NodeModulesDirectoryManager.isNodeModulesDirName(parentName) ? parent : null;
    }

    private final Pair<VirtualFile, String> findNodeModulesAndDependencyName(VirtualFile dependency) {
        VirtualFile virtualFile = dependency.getParent();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile;
        String string = parent.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String parentName = string;
        String string2 = dependency.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Object dependencyName = string2;
        if (NodeModuleSearchUtil.isScopeDirName(parentName)) {
            dependencyName = parentName + "/" + (String)dependencyName;
            VirtualFile virtualFile2 = parent.getParent();
            if (virtualFile2 == null) {
                return null;
            }
            parent = virtualFile2;
            String string3 = parent.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            parentName = string3;
        }
        return NodeModulesDirectoryManager.isNodeModulesDirName(parentName) ? TuplesKt.to((Object)parent, (Object)dependencyName) : null;
    }
}

