/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.findUsages;

import com.intellij.javascript.JSBuiltInTypeEngineEvaluation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.RequestResultProcessor;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u0010H\u0016J(\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00110\u0010H$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/lang/ecmascript6/findUsages/JSFindReferencesResultProcessor;", "Lcom/intellij/psi/search/RequestResultProcessor;", "myTarget", "Lcom/intellij/psi/PsiElement;", "myQueryParameters", "Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;)V", "getMyQueryParameters", "()Lcom/intellij/psi/search/searches/ReferencesSearch$SearchParameters;", "processTextOccurrence", "", "element", "offsetInElement", "", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/PsiReference;", "proceedWithReference", "collector", "Lcom/intellij/psi/search/SearchRequestCollector;", "intellij.javascript.backend"})
public abstract class JSFindReferencesResultProcessor
extends RequestResultProcessor {
    @NotNull
    private final PsiElement myTarget;
    @NotNull
    private final ReferencesSearch.SearchParameters myQueryParameters;

    public JSFindReferencesResultProcessor(@NotNull PsiElement myTarget, @NotNull ReferencesSearch.SearchParameters myQueryParameters) {
        Intrinsics.checkNotNullParameter((Object)myTarget, (String)"myTarget");
        Intrinsics.checkNotNullParameter((Object)myQueryParameters, (String)"myQueryParameters");
        Object[] objectArray = new Object[]{myTarget};
        super(objectArray);
        this.myTarget = myTarget;
        this.myQueryParameters = myQueryParameters;
    }

    @NotNull
    protected final ReferencesSearch.SearchParameters getMyQueryParameters() {
        return this.myQueryParameters;
    }

    public boolean processTextOccurrence(@NotNull PsiElement element2, int offsetInElement, @NotNull Processor<? super PsiReference> consumer) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiReference reference = element2.getReference();
        if (reference == null) {
            return true;
        }
        PsiElement psiElement = reference.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        boolean isReferenceToTarget = (Boolean)JSBuiltInTypeEngineEvaluation.forceBuiltInTypeEngineIfNeeded((PsiElement)psiElement, (PsiElement)this.myTarget, () -> JSFindReferencesResultProcessor.processTextOccurrence$lambda$0(reference, this));
        if (!isReferenceToTarget) {
            return true;
        }
        SearchRequestCollector searchRequestCollector = this.myQueryParameters.getOptimizer();
        Intrinsics.checkNotNullExpressionValue((Object)searchRequestCollector, (String)"getOptimizer(...)");
        SearchRequestCollector collector = searchRequestCollector;
        boolean additionalRequests = this.proceedWithReference(element2, collector, consumer);
        if (additionalRequests) {
            return PsiSearchHelper.getInstance((Project)element2.getProject()).processRequests(collector, consumer);
        }
        return true;
    }

    protected abstract boolean proceedWithReference(@NotNull PsiElement var1, @NotNull SearchRequestCollector var2, @NotNull Processor<? super PsiReference> var3);

    private static final boolean processTextOccurrence$lambda$0(PsiReference $reference, JSFindReferencesResultProcessor this$0) {
        return $reference.isReferenceTo(this$0.myTarget);
    }
}

