/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.editing;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.typescript.compiler.TypeScriptService;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptServerServiceImpl;
import com.intellij.lang.typescript.editing.InlayHintsServiceSupported;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspService;
import com.intellij.lang.typescript.lsp.TypeScriptGoLspServiceKt;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.SemVer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getSupported", "Lcom/intellij/lang/typescript/editing/InlayHintsServiceSupported;", "file", "Lcom/intellij/psi/PsiFile;", "state", "Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService$ServiceHintsState;", "stateUpdateSessionId", "", "Ljava/lang/Long;", "reportStatus", "", "service", "Lcom/intellij/lang/typescript/compiler/TypeScriptService;", "success", "", "message", "", "updateState", "Lcom/intellij/lang/typescript/compiler/languageService/TypeScriptServerServiceImpl;", "input", "Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService$ClientInput;", "Companion", "ServiceHintsState", "ClientInput", "intellij.javascript.backend"})
public final class TypeScriptInlayHintsSupportedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private ServiceHintsState state;
    @Nullable
    private Long stateUpdateSessionId;
    @NotNull
    public static final String ENABLED_KEY = "typescript.service.provideInlayHints.enabled";

    public TypeScriptInlayHintsSupportedService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.state = ServiceHintsState.Okay;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final InlayHintsServiceSupported getSupported(@NotNull PsiFile file) {
        InlayHintsServiceSupported inlayHintsServiceSupported;
        block13: {
            block12: {
                boolean supportedByVersion;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (file.getVirtualFile() != null) {
                    TypeScriptGoLspService typeScriptGoLspService = TypeScriptGoLspServiceKt.getTsGoLSPService(this.project);
                    VirtualFile virtualFile = file.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                    if (typeScriptGoLspService.isAcceptable(virtualFile)) {
                        return InlayHintsServiceSupported.TypeScriptGo;
                    }
                }
                if (!Registry.Companion.get(ENABLED_KEY).asBoolean()) {
                    return InlayHintsServiceSupported.UnsupportedOrFailed;
                }
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) {
                    return InlayHintsServiceSupported.UnsupportedOrFailed;
                }
                VirtualFile virtualFile2 = virtualFile;
                TypeScriptService typeScriptService = TypeScriptServiceHolder.getForFile(this.project, virtualFile2);
                if (typeScriptService == null) {
                    return InlayHintsServiceSupported.UnsupportedOrFailed;
                }
                TypeScriptService service = typeScriptService;
                if (!(service instanceof TypeScriptServerServiceImpl) || !service.supportsInlayHints(file)) {
                    return InlayHintsServiceSupported.UnsupportedOrFailed;
                }
                if (((Boolean)ReadAction.compute(() -> TypeScriptInlayHintsSupportedService.getSupported$lambda$0(service, virtualFile2))).booleanValue()) {
                    return InlayHintsServiceSupported.UnsupportedOrFailed;
                }
                SemVer version2 = ((TypeScriptServerServiceImpl)service).getServiceVersion();
                boolean bl = supportedByVersion = version2 == null || version2.getMajor() >= 5 || version2.getMajor() == 4 && version2.getMinor() >= 4;
                if (!supportedByVersion) break block12;
                switch (WhenMappings.$EnumSwitchMapping$0[this.updateState((TypeScriptServerServiceImpl)service, ClientInput.Check).ordinal()]) {
                    case 1: {
                        inlayHintsServiceSupported = InlayHintsServiceSupported.ServiceSupported;
                        break block13;
                    }
                    case 2: {
                        inlayHintsServiceSupported = InlayHintsServiceSupported.UnsupportedOrFailed;
                        break block13;
                    }
                    case 3: {
                        inlayHintsServiceSupported = InlayHintsServiceSupported.ProbeAfterFailure;
                        break block13;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            inlayHintsServiceSupported = InlayHintsServiceSupported.UnsupportedOrFailed;
        }
        return inlayHintsServiceSupported;
    }

    public final void reportStatus(@NotNull TypeScriptService service, boolean success, @Nullable String message) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        if (!(service instanceof TypeScriptServerServiceImpl)) {
            return;
        }
        if (success) {
            this.updateState((TypeScriptServerServiceImpl)service, ClientInput.Success);
        } else if (message != null && StringsKt.contains$default((CharSequence)message, (CharSequence)"Error processing request. Debug Failure. Unexpected node", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)message, (CharSequence)"visitForDisplayParts", (boolean)false, (int)2, null)) {
            this.updateState((TypeScriptServerServiceImpl)service, ClientInput.Failure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ServiceHintsState updateState(TypeScriptServerServiceImpl service, ClientInput input) {
        String notificationText;
        Pair $i$a$-synchronized-TypeScriptInlayHintsSupportedService$updateState$22;
        Long currentSessionId = service.getCurrentSessionId();
        TypeScriptInlayHintsSupportedService typeScriptInlayHintsSupportedService = this;
        synchronized (typeScriptInlayHintsSupportedService) {
            boolean $i$a$-synchronized-TypeScriptInlayHintsSupportedService$updateState$22 = false;
            ServiceHintsState oldState = this.state;
            ServiceHintsState newState = switch (WhenMappings.$EnumSwitchMapping$0[oldState.ordinal()]) {
                case 1 -> {
                    switch (WhenMappings.$EnumSwitchMapping$1[input.ordinal()]) {
                        case 1: {
                            yield ServiceHintsState.Okay;
                        }
                        case 2: {
                            yield ServiceHintsState.KnownFailure;
                        }
                        case 3: {
                            yield ServiceHintsState.Okay;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case 2 -> {
                    switch (WhenMappings.$EnumSwitchMapping$1[input.ordinal()]) {
                        case 1: {
                            yield ServiceHintsState.KnownFailure;
                        }
                        case 2: {
                            yield ServiceHintsState.KnownFailure;
                        }
                        case 3: {
                            if (!Intrinsics.areEqual((Object)this.stateUpdateSessionId, (Object)currentSessionId)) {
                                yield ServiceHintsState.Probe;
                            }
                            yield ServiceHintsState.KnownFailure;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case 3 -> {
                    switch (WhenMappings.$EnumSwitchMapping$1[input.ordinal()]) {
                        case 1: {
                            yield ServiceHintsState.Okay;
                        }
                        case 2: {
                            yield ServiceHintsState.KnownFailure;
                        }
                        case 3: {
                            yield ServiceHintsState.Probe;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default -> throw new NoWhenBranchMatchedException();
            };
            if (newState != oldState) {
                this.state = newState;
                this.stateUpdateSessionId = service.getCurrentSessionId();
            }
            $i$a$-synchronized-TypeScriptInlayHintsSupportedService$updateState$22 = TuplesKt.to((Object)((Object)oldState), (Object)((Object)newState));
        }
        Pair pair = $i$a$-synchronized-TypeScriptInlayHintsSupportedService$updateState$22;
        ServiceHintsState oldState = (ServiceHintsState)((Object)pair.component1());
        ServiceHintsState newState = (ServiceHintsState)((Object)pair.component2());
        int n = WhenMappings.$EnumSwitchMapping$0[oldState.ordinal()];
        String string = n == 1 && newState == ServiceHintsState.KnownFailure ? JavaScriptBundle.message((String)"notification.provideInlayHints.serviceDisabled", (Object[])new Object[0]) : (notificationText = n == 3 && newState == ServiceHintsState.Okay ? JavaScriptBundle.message((String)"notification.provideInlayHints.serviceRestored", (Object[])new Object[0]) : null);
        if (notificationText != null) {
            NotificationGroupManager.getInstance().getNotificationGroup("provideInlayHints status").createNotification(notificationText, NotificationType.INFORMATION).notify(this.project);
        }
        return newState;
    }

    private static final Boolean getSupported$lambda$0(TypeScriptService $service, VirtualFile $virtualFile) {
        return ((TypeScriptServerServiceImpl)$service).isDisabledByContext($virtualFile);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService$ClientInput;", "", "<init>", "(Ljava/lang/String;I)V", "Success", "Failure", "Check", "intellij.javascript.backend"})
    private static final class ClientInput
    extends Enum<ClientInput> {
        public static final /* enum */ ClientInput Success = new ClientInput();
        public static final /* enum */ ClientInput Failure = new ClientInput();
        public static final /* enum */ ClientInput Check = new ClientInput();
        private static final /* synthetic */ ClientInput[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ClientInput[] values() {
            return (ClientInput[])$VALUES.clone();
        }

        public static ClientInput valueOf(String value) {
            return Enum.valueOf(ClientInput.class, value);
        }

        @NotNull
        public static EnumEntries<ClientInput> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = clientInputArray = new ClientInput[]{ClientInput.Success, ClientInput.Failure, ClientInput.Check};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService$Companion;", "", "<init>", "()V", "ENABLED_KEY", "", "service", "Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService;", "project", "Lcom/intellij/openapi/project/Project;", "getSupported", "Lcom/intellij/lang/typescript/editing/InlayHintsServiceSupported;", "file", "Lcom/intellij/psi/PsiFile;", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TypeScriptInlayHintsSupportedService service(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(TypeScriptInlayHintsSupportedService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (TypeScriptInlayHintsSupportedService)object;
        }

        @NotNull
        public final InlayHintsServiceSupported getSupported(@NotNull PsiFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Project project = file.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return this.service(project).getSupported(file);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/lang/typescript/editing/TypeScriptInlayHintsSupportedService$ServiceHintsState;", "", "<init>", "(Ljava/lang/String;I)V", "Okay", "KnownFailure", "Probe", "intellij.javascript.backend"})
    private static final class ServiceHintsState
    extends Enum<ServiceHintsState> {
        public static final /* enum */ ServiceHintsState Okay = new ServiceHintsState();
        public static final /* enum */ ServiceHintsState KnownFailure = new ServiceHintsState();
        public static final /* enum */ ServiceHintsState Probe = new ServiceHintsState();
        private static final /* synthetic */ ServiceHintsState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ServiceHintsState[] values() {
            return (ServiceHintsState[])$VALUES.clone();
        }

        public static ServiceHintsState valueOf(String value) {
            return Enum.valueOf(ServiceHintsState.class, value);
        }

        @NotNull
        public static EnumEntries<ServiceHintsState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = serviceHintsStateArray = new ServiceHintsState[]{ServiceHintsState.Okay, ServiceHintsState.KnownFailure, ServiceHintsState.Probe};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ServiceHintsState.values().length];
            try {
                nArray[ServiceHintsState.Okay.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServiceHintsState.KnownFailure.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ServiceHintsState.Probe.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ClientInput.values().length];
            try {
                nArray[ClientInput.Success.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientInput.Failure.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ClientInput.Check.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

