/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.js.symbols;

import com.intellij.lang.javascript.psi.JSDocOwner;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeOwner;
import com.intellij.model.Pointer;
import com.intellij.openapi.util.text.Strings;
import com.intellij.platform.backend.documentation.DocumentationTarget;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolApiStatus;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.PolySymbolProperty;
import com.intellij.polySymbols.PolySymbolQualifiedName;
import com.intellij.polySymbols.documentation.PolySymbolDocumentation;
import com.intellij.polySymbols.documentation.PolySymbolDocumentationBuilder;
import com.intellij.polySymbols.documentation.PolySymbolDocumentationProvider;
import com.intellij.polySymbols.documentation.PolySymbolDocumentationTarget;
import com.intellij.polySymbols.js.JSPolySymbolUtils;
import com.intellij.polySymbols.js.JsSymbolKinds;
import com.intellij.polySymbols.js.JsSymbolSymbolKind;
import com.intellij.polySymbols.js.documentation.JSSymbolDocumentationCustomizer;
import com.intellij.polySymbols.js.documentation.JSSymbolDocumentationCustomizerKt;
import com.intellij.polySymbols.js.symbols.JSPropertySymbolKt;
import com.intellij.polySymbols.js.types.TypeScriptSymbolTypeSupportKt;
import com.intellij.polySymbols.query.PolySymbolListSymbolsQueryParams;
import com.intellij.polySymbols.query.PolySymbolNameMatchQueryParams;
import com.intellij.polySymbols.query.PolySymbolQueryStack;
import com.intellij.polySymbols.query.PolySymbolScope;
import com.intellij.polySymbols.refactoring.PolySymbolRenameTarget;
import com.intellij.polySymbols.search.PolySymbolSearchTarget;
import com.intellij.polySymbols.search.PsiSourcedPolySymbol;
import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u00032\u00020\u0004:\u0001CB\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\u0015\u001a\u0004\u0018\u0001H\u0001\"\b\b\u0001\u0010\u0001*\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0018H\u0096\u0002\u00a2\u0006\u0002\u0010\u0019J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J&\u0010'\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010(\u001a\u00020)2\u0006\u0010#\u001a\u00020*2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010!\u001a\u00020\"H\u0016J\u0014\u00105\u001a\u00020,2\b\u00106\u001a\u0004\u0018\u00010\u0016H\u0096\u0082\u0004J\n\u00107\u001a\u000208H\u0096\u0080\u0004J\u0016\u00109\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u00000:H&J\u0014\u0010;\u001a\u0004\u0018\u00010<2\b\u0010=\u001a\u0004\u0018\u00010>H\u0016J\u001a\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\b\u0010=\u001a\u0004\u0018\u00010>H\u0014R\u0016\u0010\u0005\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u001a\u001a\u00020\u001bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010-\u001a\u0004\u0018\u00010.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0016\u00101\u001a\u0004\u0018\u0001028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006D"}, d2={"Lcom/intellij/polySymbols/js/symbols/JSAbstractSymbol;", "T", "Lcom/intellij/lang/javascript/psi/JSElement;", "Lcom/intellij/polySymbols/search/PsiSourcedPolySymbol;", "Lcom/intellij/polySymbols/query/PolySymbolScope;", "source", "<init>", "(Lcom/intellij/lang/javascript/psi/JSElement;)V", "getSource", "()Lcom/intellij/lang/javascript/psi/JSElement;", "Lcom/intellij/lang/javascript/psi/JSElement;", "getModificationCount", "", "apiStatus", "Lcom/intellij/polySymbols/PolySymbolApiStatus;", "getApiStatus", "()Lcom/intellij/polySymbols/PolySymbolApiStatus;", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "getType", "()Lcom/intellij/lang/javascript/psi/JSType;", "get", "", "property", "Lcom/intellij/polySymbols/PolySymbolProperty;", "(Lcom/intellij/polySymbols/PolySymbolProperty;)Ljava/lang/Object;", "jsKind", "Lcom/intellij/polySymbols/js/JsSymbolSymbolKind;", "getJsKind", "()Lcom/intellij/polySymbols/js/JsSymbolSymbolKind;", "getSymbols", "", "Lcom/intellij/polySymbols/PolySymbol;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "params", "Lcom/intellij/polySymbols/query/PolySymbolListSymbolsQueryParams;", "stack", "Lcom/intellij/polySymbols/query/PolySymbolQueryStack;", "getMatchingSymbols", "qualifiedName", "Lcom/intellij/polySymbols/PolySymbolQualifiedName;", "Lcom/intellij/polySymbols/query/PolySymbolNameMatchQueryParams;", "isExclusiveFor", "", "searchTarget", "Lcom/intellij/polySymbols/search/PolySymbolSearchTarget;", "getSearchTarget", "()Lcom/intellij/polySymbols/search/PolySymbolSearchTarget;", "renameTarget", "Lcom/intellij/polySymbols/refactoring/PolySymbolRenameTarget;", "getRenameTarget", "()Lcom/intellij/polySymbols/refactoring/PolySymbolRenameTarget;", "equals", "other", "hashCode", "", "createPointer", "Lcom/intellij/model/Pointer;", "getDocumentationTarget", "Lcom/intellij/platform/backend/documentation/DocumentationTarget;", "location", "Lcom/intellij/psi/PsiElement;", "customizeDocumentation", "", "builder", "Lcom/intellij/polySymbols/documentation/PolySymbolDocumentationBuilder;", "JSSymbolDocumentationProvider", "intellij.javascript.web"})
@SourceDebugExtension(value={"SMAP\nJSAbstractSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSAbstractSymbol.kt\ncom/intellij/polySymbols/js/symbols/JSAbstractSymbol\n+ 2 JSSymbolUtils.kt\ncom/intellij/polySymbols/js/JSPolySymbolUtils\n*L\n1#1,147:1\n67#2:148\n*S KotlinDebug\n*F\n+ 1 JSAbstractSymbol.kt\ncom/intellij/polySymbols/js/symbols/JSAbstractSymbol\n*L\n84#1:148\n*E\n"})
public abstract class JSAbstractSymbol<T extends JSElement>
implements PsiSourcedPolySymbol,
PolySymbolScope {
    private final T source;

    public JSAbstractSymbol(T source) {
        this.source = source;
    }

    public T getSource() {
        return this.source;
    }

    public long getModificationCount() {
        Object object = this.getSource();
        return object != null && (object = ((PsiElement)object).getContainingFile()) != null ? object.getModificationStamp() : 0L;
    }

    @NotNull
    public PolySymbolApiStatus getApiStatus() {
        T t = this.getSource();
        JSElementBase jSElementBase = t instanceof JSElementBase ? (JSElementBase)t : null;
        if (jSElementBase == null || (jSElementBase = JSPolySymbolUtils.getApiStatus((JSDocOwner)jSElementBase)) == null) {
            jSElementBase = (PolySymbolApiStatus)PolySymbolApiStatus.Stable;
        }
        return jSElementBase;
    }

    @Nullable
    public JSType getType() {
        T t = this.getSource();
        JSTypeOwner jSTypeOwner = t instanceof JSTypeOwner ? (JSTypeOwner)t : null;
        return jSTypeOwner != null ? jSTypeOwner.getJSType() : null;
    }

    @Nullable
    public <T> T get(@NotNull PolySymbolProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        PolySymbolProperty<T> polySymbolProperty = property;
        return (T)(Intrinsics.areEqual(polySymbolProperty, (Object)JsSymbolKinds.PROP_JS_SYMBOL_KIND) ? property.tryCast((Object)this.getJsKind()) : (Intrinsics.areEqual(polySymbolProperty, TypeScriptSymbolTypeSupportKt.PROP_JS_TYPE) ? property.tryCast((Object)this.getType()) : null));
    }

    @NotNull
    public abstract JsSymbolSymbolKind getJsKind();

    @NotNull
    public List<PolySymbol> getSymbols(@NotNull PolySymbolKind kind, @NotNull PolySymbolListSymbolsQueryParams params, @NotNull PolySymbolQueryStack stack) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Intrinsics.areEqual((Object)kind, (Object)JsSymbolKinds.JS_PROPERTIES) ? JSPropertySymbolKt.getJSPropertySymbols((PolySymbol)this) : CollectionsKt.emptyList();
    }

    @NotNull
    public List<PolySymbol> getMatchingSymbols(@NotNull PolySymbolQualifiedName qualifiedName, @NotNull PolySymbolNameMatchQueryParams params, @NotNull PolySymbolQueryStack stack) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return Intrinsics.areEqual((Object)qualifiedName.getKind(), (Object)JsSymbolKinds.JS_PROPERTIES) ? JSPropertySymbolKt.getMatchingJSPropertySymbols((PolySymbol)this, qualifiedName, params.getQueryExecutor().getNamesProvider()) : CollectionsKt.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isExclusiveFor(@NotNull PolySymbolKind kind) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        if (!Intrinsics.areEqual((Object)kind, (Object)JsSymbolKinds.JS_PROPERTIES)) return false;
        PolySymbol $this$jsType$iv = (PolySymbol)this;
        boolean $i$f$getJSType = false;
        JSType jSType = (JSType)$this$jsType$iv.get(TypeScriptSymbolTypeSupportKt.PROP_JS_TYPE);
        if (jSType == null) return false;
        if (!jSType.isSourceStrict()) return false;
        return true;
    }

    @Nullable
    public PolySymbolSearchTarget getSearchTarget() {
        return PolySymbolSearchTarget.Companion.create((PolySymbol)this);
    }

    @Nullable
    public PolySymbolRenameTarget getRenameTarget() {
        return PolySymbolRenameTarget.Companion.create((PolySymbol)this);
    }

    public boolean equals(@Nullable Object other) {
        return other == this || other instanceof JSAbstractSymbol && Intrinsics.areEqual(other.getClass(), this.getClass()) && Intrinsics.areEqual(((JSAbstractSymbol)other).getSource(), this.getSource()) && Intrinsics.areEqual((Object)((JSAbstractSymbol)other).getName(), (Object)this.getName());
    }

    public int hashCode() {
        T t = this.getSource();
        return 31 * (t != null ? t.hashCode() : 0) + this.getName().hashCode();
    }

    @NotNull
    public abstract Pointer<? extends JSAbstractSymbol<T>> createPointer();

    @Nullable
    public DocumentationTarget getDocumentationTarget(@Nullable PsiElement location) {
        return (DocumentationTarget)PolySymbolDocumentationTarget.Companion.create((PolySymbol)this, location, (PolySymbolDocumentationProvider)JSSymbolDocumentationProvider.INSTANCE);
    }

    protected void customizeDocumentation(@NotNull PolySymbolDocumentationBuilder builder2, @Nullable PsiElement location) {
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\u00022\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\"\u0010\n\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/polySymbols/js/symbols/JSAbstractSymbol$JSSymbolDocumentationProvider;", "Lcom/intellij/polySymbols/documentation/PolySymbolDocumentationProvider;", "Lcom/intellij/polySymbols/js/symbols/JSAbstractSymbol;", "<init>", "()V", "createDocumentation", "Lcom/intellij/polySymbols/documentation/PolySymbolDocumentation;", "symbol", "location", "Lcom/intellij/psi/PsiElement;", "splitHeaderAndDefinition", "Lkotlin/Pair;", "", "text", "intellij.javascript.web"})
    public static final class JSSymbolDocumentationProvider
    implements PolySymbolDocumentationProvider<JSAbstractSymbol<?>> {
        @NotNull
        public static final JSSymbolDocumentationProvider INSTANCE = new JSSymbolDocumentationProvider();

        private JSSymbolDocumentationProvider() {
        }

        @NotNull
        public PolySymbolDocumentation createDocumentation(@NotNull JSAbstractSymbol<?> symbol2, @Nullable PsiElement location) {
            Intrinsics.checkNotNullParameter(symbol2, (String)"symbol");
            PolySymbolDocumentationBuilder builder2 = PolySymbolDocumentation.Companion.builder((PolySymbol)symbol2, location);
            Object source = symbol2.getSource();
            if (source != null) {
                Pair<String, String> definitionDocWithDetails;
                builder2.setDescription(JSSymbolDocumentationCustomizerKt.renderDocComment(JSSymbolDocumentationCustomizerKt.getJSDocumentationProviderFor((PsiElement)source), (PsiElement)source));
                JSSymbolDocumentationCustomizer.JSPolySymbolDeclarationDocPrinter docPrinter = new JSSymbolDocumentationCustomizer.JSPolySymbolDeclarationDocPrinter((PsiElement)source, location);
                Pair<String, String> pair = definitionDocWithDetails = docPrinter.getDefinitionDocWithDetails();
                Pair<String, String> pair2 = this.splitHeaderAndDefinition(pair != null ? (String)pair.getFirst() : null);
                String header = (String)pair2.component1();
                String definition = (String)pair2.component2();
                String string = definition;
                if (string == null) {
                    PolySymbol polySymbol = (PolySymbol)symbol2;
                    String string2 = source.getName();
                    if (string2 == null) {
                        string2 = symbol2.getName();
                    }
                    if ((string = JSPolySymbolUtils.renderJsTypeForDocs$default(polySymbol, string2, location, null, 4, null)) == null) {
                        String string3 = Strings.escapeXmlEntities((String)symbol2.getName());
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"escapeXmlEntities(...)");
                    }
                }
                builder2.setDefinition(string);
                Pair<String, String> pair3 = definitionDocWithDetails;
                builder2.setDefinitionDetails(pair3 != null ? (String)pair3.getSecond() : null);
                builder2.setFootnote(docPrinter.getLocation());
                builder2.setHeader(header);
            }
            symbol2.customizeDocumentation(builder2, location);
            return builder2.build();
        }

        private final Pair<String, String> splitHeaderAndDefinition(String text) {
            Pair pair;
            if (text != null) {
                int bottomIndex = StringsKt.indexOf$default((CharSequence)text, (String)"<div class=\"bottom\">", (int)0, (boolean)false, (int)6, null);
                int definitionIndex = StringsKt.indexOf$default((CharSequence)text, (String)"<div class='definition'><pre>", (int)0, (boolean)false, (int)6, null);
                if (bottomIndex >= 0 && definitionIndex >= 0) {
                    String string = text.substring(bottomIndex + 20, StringsKt.indexOf$default((CharSequence)text, (String)"</div>", (int)0, (boolean)false, (int)6, null));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String string2 = text.substring(definitionIndex + 29, StringsKt.lastIndexOf$default((CharSequence)text, (String)"</pre></div>", (int)0, (boolean)false, (int)6, null));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    pair = new Pair((Object)string, (Object)string2);
                } else {
                    pair = new Pair(null, (Object)text);
                }
            } else {
                pair = new Pair(null, null);
            }
            return pair;
        }
    }
}

