/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.polySymbols.js.symbols;

import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.model.Pointer;
import com.intellij.polySymbols.PolySymbol;
import com.intellij.polySymbols.PolySymbolKind;
import com.intellij.polySymbols.PolySymbolProperty;
import com.intellij.polySymbols.js.JSPolySymbolUtils;
import com.intellij.polySymbols.js.JsSymbolKinds;
import com.intellij.polySymbols.js.JsSymbolSymbolKind;
import com.intellij.polySymbols.js.symbols.JSAbstractSymbol;
import com.intellij.polySymbols.js.symbols.JSPropertySymbolKt;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B5\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eB\u0019\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u0011B!\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u000f\u001a\u00020\u0012\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u0013B\u0019\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u0014J(\u0010\u001b\u001a\u0004\u0018\u0001H\u001c\"\b\b\u0000\u0010\u001c*\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001fH\u0096\u0002\u00a2\u0006\u0002\u0010 J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00000&H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lcom/intellij/polySymbols/js/symbols/JSPropertySymbol;", "Lcom/intellij/polySymbols/js/symbols/JSAbstractSymbol;", "Lcom/intellij/lang/javascript/psi/JSElement;", "name", "", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "typeMember", "Lcom/intellij/lang/javascript/psi/JSRecordType$TypeMember;", "jsPropertySymbolProvider", "Lcom/intellij/polySymbols/PolySymbol;", "jsKind", "Lcom/intellij/polySymbols/js/JsSymbolSymbolKind;", "<init>", "(Ljava/lang/String;Lcom/intellij/lang/javascript/psi/JSType;Lcom/intellij/lang/javascript/psi/JSRecordType$TypeMember;Lcom/intellij/polySymbols/PolySymbol;Lcom/intellij/polySymbols/js/JsSymbolSymbolKind;)V", "member", "Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;", "(Lcom/intellij/lang/javascript/psi/JSRecordType$PropertySignature;Lcom/intellij/polySymbols/PolySymbol;)V", "Lcom/intellij/lang/javascript/psi/JSRecordType$IndexSignature;", "(Ljava/lang/String;Lcom/intellij/lang/javascript/psi/JSRecordType$IndexSignature;Lcom/intellij/polySymbols/PolySymbol;)V", "(Ljava/lang/String;Lcom/intellij/polySymbols/PolySymbol;)V", "getName", "()Ljava/lang/String;", "getType", "()Lcom/intellij/lang/javascript/psi/JSType;", "getJsKind", "()Lcom/intellij/polySymbols/js/JsSymbolSymbolKind;", "get", "T", "", "property", "Lcom/intellij/polySymbols/PolySymbolProperty;", "(Lcom/intellij/polySymbols/PolySymbolProperty;)Ljava/lang/Object;", "kind", "Lcom/intellij/polySymbols/PolySymbolKind;", "getKind", "()Lcom/intellij/polySymbols/PolySymbolKind;", "createPointer", "Lcom/intellij/model/Pointer;", "intellij.javascript.web"})
public final class JSPropertySymbol
extends JSAbstractSymbol<JSElement> {
    @NotNull
    private final String name;
    @Nullable
    private final JSType type;
    @Nullable
    private final JSRecordType.TypeMember typeMember;
    @NotNull
    private final PolySymbol jsPropertySymbolProvider;
    @NotNull
    private final JsSymbolSymbolKind jsKind;

    private JSPropertySymbol(String name, JSType type2, JSRecordType.TypeMember typeMember, PolySymbol jsPropertySymbolProvider, JsSymbolSymbolKind jsKind) {
        JSRecordType.TypeMember typeMember2 = typeMember;
        PsiElement psiElement = typeMember2 != null && (typeMember2 = typeMember2.getMemberSource()) != null ? typeMember2.getSingleElement() : null;
        super(psiElement instanceof JSElement ? (JSElement)psiElement : null);
        this.name = name;
        this.type = type2;
        this.typeMember = typeMember;
        this.jsPropertySymbolProvider = jsPropertySymbolProvider;
        this.jsKind = jsKind;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public JSType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public JsSymbolSymbolKind getJsKind() {
        return this.jsKind;
    }

    public JSPropertySymbol(@NotNull JSRecordType.PropertySignature member, @NotNull PolySymbol jsPropertySymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)jsPropertySymbolProvider, (String)"jsPropertySymbolProvider");
        String string = member.getMemberName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMemberName(...)");
        this(string, member.getJSTypeWithOptionality(), (JSRecordType.TypeMember)member, jsPropertySymbolProvider, member instanceof JSRecordType.FunctionMember ? JsSymbolSymbolKind.Method : JsSymbolSymbolKind.Property);
    }

    public JSPropertySymbol(@NotNull String name, @NotNull JSRecordType.IndexSignature member, @NotNull PolySymbol jsPropertySymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)member, (String)"member");
        Intrinsics.checkNotNullParameter((Object)jsPropertySymbolProvider, (String)"jsPropertySymbolProvider");
        this(name, member.getMemberType(), (JSRecordType.TypeMember)member, jsPropertySymbolProvider, JsSymbolSymbolKind.Property);
    }

    public JSPropertySymbol(@NotNull String name, @NotNull PolySymbol jsPropertySymbolProvider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)jsPropertySymbolProvider, (String)"jsPropertySymbolProvider");
        this(name, null, null, jsPropertySymbolProvider, JsSymbolSymbolKind.Property);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull PolySymbolProperty<T> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        return (T)(Intrinsics.areEqual(property, JSPolySymbolUtils.PROP_JS_PROPERTY_SIGNATURE) ? property.tryCast((Object)this.typeMember) : super.get(property));
    }

    @NotNull
    public PolySymbolKind getKind() {
        return JsSymbolKinds.JS_PROPERTIES;
    }

    @Override
    @NotNull
    public Pointer<JSPropertySymbol> createPointer() {
        Pointer ptr = this.jsPropertySymbolProvider.createPointer();
        String name = this.getName();
        return () -> JSPropertySymbol.createPointer$lambda$0(ptr, name);
    }

    private static final JSPropertySymbol createPointer$lambda$0(Pointer $ptr, String $name) {
        PolySymbol polySymbol = (PolySymbol)$ptr.dereference();
        return polySymbol != null ? JSPropertySymbolKt.access$resolveJSProperty(polySymbol, CollectionsKt.listOf((Object)$name)) : null;
    }
}

