/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.elevation.sudoAskPass;

import com.intellij.cwm.plugin.elevation.sudoAskPass.SudoExternalAppHandlerImpl;
import com.intellij.cwm.plugin.elevation.sudoAskPass.SudoExternalProcessHandlerService;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.sudo.LocalSudoCommandProvider;
import com.intellij.externalProcessAuthHelper.AuthenticationGate;
import com.intellij.externalProcessAuthHelper.PassthroughAuthenticationGate;
import com.intellij.externalProcessAuthHelper.ScriptGenerator;
import com.intellij.externalProcessAuthHelper.ScriptGeneratorImpl;
import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SystemInfo;
import externalApp.ExternalAppHandler;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\b\u001a\u00020\u0006H\u0016J\u001f\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u000b\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/cwm/plugin/elevation/sudoAskPass/UnattendedHostAwareSudoCommandProvider;", "Lcom/intellij/execution/sudo/LocalSudoCommandProvider;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "isSudoAvailable", "", "()Z", "isAvailable", "sudoCommand", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "wrappedCommand", "prompt", "", "Lorg/jetbrains/annotations/Nls;", "dispose", "", "intellij.execution.process.elevation.backend.split"})
public final class UnattendedHostAwareSudoCommandProvider
extends LocalSudoCommandProvider
implements Disposable {
    private final boolean isSudoAvailable() {
        return SystemInfo.isUnix && PathEnvironmentVariableUtil.isOnPath((String)"sudo");
    }

    public boolean isAvailable() {
        return AppMode.isRemoteDevHost() ? this.isSudoAvailable() : super.isAvailable();
    }

    @Nullable
    public GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine wrappedCommand, @NotNull String prompt) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)wrappedCommand, (String)"wrappedCommand");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        if (!AppMode.isRemoteDevHost()) {
            return super.sudoCommand(wrappedCommand, prompt);
        }
        if (!this.isSudoAvailable()) {
            return null;
        }
        SudoExternalProcessHandlerService sudoService = SudoExternalProcessHandlerService.Companion.getInstance();
        File scriptPath = sudoService.getCallbackScriptPath("sudo-askpass", (ScriptGenerator)new ScriptGeneratorImpl(), false);
        PassthroughAuthenticationGate authenticationGate = PassthroughAuthenticationGate.Companion.getInstance();
        SudoExternalAppHandlerImpl authenticator = new SudoExternalAppHandlerImpl(null, (AuthenticationGate)authenticationGate);
        UUID handlerUUID = sudoService.registerHandler((ExternalAppHandler)authenticator, this);
        int port = sudoService.getIdePort();
        Object[] $this$sudoCommand_u24lambda_u240 = objectArray = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$sudoCommand_u24lambda_u240.add(wrappedCommand.getExePath());
        List list = wrappedCommand.getParametersList().getList();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
        $this$sudoCommand_u24lambda_u240.addAll(list);
        List wrappedCmdAsArg = CollectionsKt.build((List)objectArray);
        objectArray = new String[]{"sudo", "--askpass", "--"};
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)this.envCommand(wrappedCommand)), (Iterable)wrappedCmdAsArg));
        objectArray = new Pair[]{TuplesKt.to((Object)"SUDO_ASKPASS", (Object)scriptPath.getAbsolutePath()), TuplesKt.to((Object)"INTELLIJ_SUDO_ASKPASS_HANDLER", (Object)handlerUUID.toString()), TuplesKt.to((Object)"INTELLIJ_SUDO_ASKPASS_PORT", (Object)String.valueOf(port))};
        return generalCommandLine.withEnvironment(MapsKt.mapOf((Pair[])objectArray));
    }

    public void dispose() {
    }
}

