/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.download.IndexDownloadHistoryEntry;
import com.intellij.indexing.shared.download.IndexDownloadHistoryState;
import com.intellij.indexing.shared.download.SharedIndexId;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@State(name="shared-index-download-history", storages={@Storage(value="$CACHE_FILE$")}, allowLoadInTests=true)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0006\u0010\n\u001a\u00020\bJ$\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\b\b\u0003\u0010\u0016\u001a\u00020\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadHistoryStore;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/indexing/shared/download/IndexDownloadHistoryState;", "<init>", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "loadState", "", "state", "reset", "updateLastDownload", "indexIds", "", "Lcom/intellij/indexing/shared/download/SharedIndexId;", "chunkId", "", "downloadSize", "", "isDownloadMakeSenseFor", "", "indexId", "checkDescriptor", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexDownloadHistory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexDownloadHistory.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadHistoryStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1642#2,10:122\n1915#2:132\n1916#2:134\n1652#2:135\n1586#2:136\n1661#2,3:137\n1#3:133\n*S KotlinDebug\n*F\n+ 1 SharedIndexDownloadHistory.kt\ncom/intellij/indexing/shared/download/SharedIndexDownloadHistoryStore\n*L\n78#1:122,10\n78#1:132\n78#1:134\n78#1:135\n79#1:136\n79#1:137,3\n78#1:133\n*E\n"})
public final class SharedIndexDownloadHistoryStore
extends SimplePersistentStateComponent<IndexDownloadHistoryState> {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();

    public SharedIndexDownloadHistoryStore() {
        super((BaseState)new IndexDownloadHistoryState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull IndexDownloadHistoryState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            super.loadState((BaseState)state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void reset() {
        this.loadState(new IndexDownloadHistoryState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void updateLastDownload(@NotNull List<SharedIndexId> indexIds, @NotNull String chunkId, long downloadSize) {
        Intrinsics.checkNotNullParameter(indexIds, (String)"indexIds");
        Intrinsics.checkNotNullParameter((Object)chunkId, (String)"chunkId");
        List indexesToProcess = CollectionsKt.distinct((Iterable)indexIds);
        if (indexesToProcess.isEmpty()) {
            return;
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            void $this$mapTo$iv$iv;
            Object it;
            Object element$iv$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            boolean bl = false;
            IndexDownloadHistoryState state = (IndexDownloadHistoryState)this.getState();
            Iterable $this$mapNotNull$iv = indexesToProcess;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Iterable<IndexDownloadHistoryEntry> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                IndexDownloadHistoryEntry it$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                it = (SharedIndexId)element$iv$iv;
                boolean bl3 = false;
                if (state.filterEntry((SharedIndexId)it) == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List toRemove = (List)destination$iv$iv;
            Iterable $this$map$iv = indexesToProcess;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void indexId;
                element$iv$iv$iv = (SharedIndexId)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                IndexDownloadHistoryEntry indexDownloadHistoryEntry = new IndexDownloadHistoryEntry();
                it = indexDownloadHistoryEntry;
                boolean bl6 = false;
                ((IndexDownloadHistoryEntry)((Object)it)).setIndexKind(indexId.getKind());
                ((IndexDownloadHistoryEntry)((Object)it)).setIndexId(indexId.getIndexId());
                ((IndexDownloadHistoryEntry)((Object)it)).setLastDeliveredChunkUniqueId(chunkId);
                ((IndexDownloadHistoryEntry)((Object)it)).setLastDownloadSize(String.valueOf(downloadSize));
                ((IndexDownloadHistoryEntry)((Object)it)).setLastDownloadDate(ZonedDateTime.now().format(DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(Locale.US)));
                collection.add(indexDownloadHistoryEntry);
            }
            List toAdd = (List)destination$iv$iv2;
            state.getEntries().removeAll(toRemove);
            state.getEntries().addAll(toAdd);
            state.intIncrementModificationCount();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDownloadMakeSenseFor(@NotNull SharedIndexId indexId, @VisibleForTesting boolean checkDescriptor) {
        Intrinsics.checkNotNullParameter((Object)indexId, (String)"indexId");
        Lock lock = this.lock;
        lock.lock();
        try {
            IndexDownloadHistoryEntry indexDownloadHistoryEntry;
            boolean bl = false;
            IndexDownloadHistoryState state = (IndexDownloadHistoryState)this.getState();
            if (state.filterEntry(indexId) == null) {
                boolean bl2 = true;
                return bl2;
            }
            IndexDownloadHistoryEntry candidate = indexDownloadHistoryEntry;
            String lastChunkId = candidate.getLastDeliveredChunkUniqueId();
            if (lastChunkId == null || candidate.getLastDownloadDate() == null) {
                state.removeEntry(candidate);
                boolean bl3 = true;
                return bl3;
            }
            if (!checkDescriptor) {
                boolean bl4 = false;
                return bl4;
            }
            if (!SharedIndexChunkConfiguration.getInstance().isAvailableChunk(lastChunkId)) {
                state.removeEntry(candidate);
                boolean bl5 = true;
                return bl5;
            }
            boolean bl6 = false;
            return bl6;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ boolean isDownloadMakeSenseFor$default(SharedIndexDownloadHistoryStore sharedIndexDownloadHistoryStore, SharedIndexId sharedIndexId, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return sharedIndexDownloadHistoryStore.isDownloadMakeSenseFor(sharedIndexId, bl);
    }
}

