/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.platform.impl;

import com.intellij.ide.nls.NlsMessages;
import com.intellij.indexing.shared.message.SharedIndexesBundle;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.util.indexing.diagnostic.ProjectDumbIndexingHistory;
import com.intellij.util.indexing.diagnostic.ProjectIndexingActivityHistoryListener;
import com.intellij.util.indexing.diagnostic.ProjectScanningHistory;
import com.intellij.util.indexing.diagnostic.dto.JsonFileProviderIndexStatistics;
import com.intellij.util.indexing.diagnostic.dto.JsonScanningStatistics;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016JD\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0010\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0013j\u0002`\u00140\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/platform/impl/SharedIndexProjectIndexingHistoryListener;", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingActivityHistoryListener;", "<init>", "()V", "onFinishedScanning", "", "history", "Lcom/intellij/util/indexing/diagnostic/ProjectScanningHistory;", "onFinishedDumbIndexing", "Lcom/intellij/util/indexing/diagnostic/ProjectDumbIndexingHistory;", "check", "project", "Lcom/intellij/openapi/project/Project;", "wasInterrupted", "", "totalNumberOfIndexedFilesProvider", "Lkotlin/Function0;", "", "indexingDurationProvider", "", "Lcom/intellij/util/indexing/diagnostic/TimeNano;", "totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider", "intellij.indexing.shared"})
@SourceDebugExtension(value={"SMAP\nSharedIndexProjectIndexingHistoryListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SharedIndexProjectIndexingHistoryListener.kt\ncom/intellij/indexing/shared/platform/impl/SharedIndexProjectIndexingHistoryListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class SharedIndexProjectIndexingHistoryListener
implements ProjectIndexingActivityHistoryListener {
    public void onFinishedScanning(@NotNull ProjectScanningHistory history) {
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        this.check(history.getProject(), history.getTimes().isCancelled(), (Function0<Integer>)((Function0)() -> SharedIndexProjectIndexingHistoryListener.onFinishedScanning$lambda$0(history)), (Function0<Long>)((Function0)() -> SharedIndexProjectIndexingHistoryListener.onFinishedScanning$lambda$1(history)), (Function0<Integer>)((Function0)() -> SharedIndexProjectIndexingHistoryListener.onFinishedScanning$lambda$2(history)));
    }

    public void onFinishedDumbIndexing(@NotNull ProjectDumbIndexingHistory history) {
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        this.check(history.getProject(), history.getTimes().isCancelled(), (Function0<Integer>)((Function0)() -> SharedIndexProjectIndexingHistoryListener.onFinishedDumbIndexing$lambda$0(history)), (Function0<Long>)((Function0)() -> SharedIndexProjectIndexingHistoryListener.onFinishedDumbIndexing$lambda$1(history)), (Function0<Integer>)((Function0)() -> SharedIndexProjectIndexingHistoryListener.onFinishedDumbIndexing$lambda$2(history)));
    }

    public final void check(@NotNull Project project, boolean wasInterrupted, @NotNull Function0<Integer> totalNumberOfIndexedFilesProvider, @NotNull Function0<Long> indexingDurationProvider, @NotNull Function0<Integer> totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(totalNumberOfIndexedFilesProvider, (String)"totalNumberOfIndexedFilesProvider");
        Intrinsics.checkNotNullParameter(indexingDurationProvider, (String)"indexingDurationProvider");
        Intrinsics.checkNotNullParameter(totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider, (String)"totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider");
        if (wasInterrupted) {
            return;
        }
        int totalNumberOfIndexedFiles = ((Number)totalNumberOfIndexedFilesProvider.invoke()).intValue();
        if (totalNumberOfIndexedFiles < 100) {
            return;
        }
        long indexingDuration = Duration.ofNanos(((Number)indexingDurationProvider.invoke()).longValue()).toMillis();
        if (indexingDuration <= Duration.ofSeconds(20L).toMillis()) {
            return;
        }
        int totalNumberOfFilesFullyIndexedByInfrastructureExtensions = ((Number)totalNumberOfFilesFullyIndexedByInfrastructureExtensionsProvider.invoke()).intValue();
        if (totalNumberOfFilesFullyIndexedByInfrastructureExtensions < 100) {
            return;
        }
        int percentage = (int)((double)totalNumberOfFilesFullyIndexedByInfrastructureExtensions / (double)totalNumberOfIndexedFiles * (double)100);
        if (percentage < 20) {
            return;
        }
        double usualIndexingSpeed = (double)(totalNumberOfIndexedFiles - totalNumberOfFilesFullyIndexedByInfrastructureExtensions) / (double)indexingDuration;
        double savedTime = (double)totalNumberOfFilesFullyIndexedByInfrastructureExtensions / usualIndexingSpeed;
        Object[] objectArray = new Object[]{NlsMessages.formatDurationApproximate((long)indexingDuration), totalNumberOfFilesFullyIndexedByInfrastructureExtensions, totalNumberOfIndexedFiles, percentage, NlsMessages.formatDurationApproximate((long)((long)savedTime))};
        String string = SharedIndexesBundle.message("eventLog.indexing.completed", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String messageText = string;
        NotificationGroupManager.getInstance().getNotificationGroup("Shared Indexes Log").createNotification(messageText, NotificationType.INFORMATION).notify(project);
    }

    /*
     * WARNING - void declaration
     */
    private static final int onFinishedScanning$lambda$0(ProjectScanningHistory $history) {
        Iterable iterable = $history.getScanningStatistics();
        int n = 0;
        for (Object t : iterable) {
            void statistics;
            JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)t;
            int n2 = n;
            boolean bl = false;
            int n3 = statistics.getNumberOfFilesForIndexing() + statistics.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
            n = n2 + n3;
        }
        return n;
    }

    private static final long onFinishedScanning$lambda$1(ProjectScanningHistory $history) {
        return $history.getTimes().getTotalUpdatingTime();
    }

    /*
     * WARNING - void declaration
     */
    private static final int onFinishedScanning$lambda$2(ProjectScanningHistory $history) {
        Iterable iterable = $history.getScanningStatistics();
        int n = 0;
        for (Object t : iterable) {
            void statistics;
            JsonScanningStatistics jsonScanningStatistics = (JsonScanningStatistics)t;
            int n2 = n;
            boolean bl = false;
            int n3 = statistics.getNumberOfFilesFullyIndexedByInfrastructureExtensions();
            n = n2 + n3;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final int onFinishedDumbIndexing$lambda$0(ProjectDumbIndexingHistory $history) {
        Iterable iterable = $history.getProviderStatistics();
        int n = 0;
        for (Object t : iterable) {
            void statistics;
            JsonFileProviderIndexStatistics jsonFileProviderIndexStatistics = (JsonFileProviderIndexStatistics)t;
            int n2 = n;
            boolean bl = false;
            int n3 = statistics.getTotalNumberOfIndexedFiles();
            n = n2 + n3;
        }
        return n;
    }

    private static final long onFinishedDumbIndexing$lambda$1(ProjectDumbIndexingHistory $history) {
        return $history.getTimes().getTotalUpdatingTime();
    }

    /*
     * WARNING - void declaration
     */
    private static final int onFinishedDumbIndexing$lambda$2(ProjectDumbIndexingHistory $history) {
        Iterable iterable = $history.getProviderStatistics();
        int n = 0;
        for (Object t : iterable) {
            void statistics;
            JsonFileProviderIndexStatistics jsonFileProviderIndexStatistics = (JsonFileProviderIndexStatistics)t;
            int n2 = n;
            boolean bl = false;
            int n3 = statistics.getTotalNumberOfFilesFullyIndexedByExtensions();
            n = n2 + n3;
        }
        return n;
    }
}

