/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.aiplayground.ui.AIPlaygroundIcons;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/aiplayground/ui/AIPlaygroundIconsHelper;", "", "<init>", "()V", "providerName2Icon", "Ljavax/swing/Icon;", "providerId", "", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=1)
public final class AIPlaygroundIconsHelper {
    @NotNull
    public static final AIPlaygroundIconsHelper INSTANCE = new AIPlaygroundIconsHelper();
    public static final int $stable;

    private AIPlaygroundIconsHelper() {
    }

    @NotNull
    public final Icon providerName2Icon(@NotNull String providerId) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)providerId, (String)"providerId");
        String string = providerId.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "openai": 
            case "openai_compatible": {
                Icon icon2 = AIPlaygroundIcons.OpenAI;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"OpenAI");
                break;
            }
            case "anthropic": {
                Icon icon3 = AIPlaygroundIcons.Anthropic;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Anthropic");
                break;
            }
            case "mistral": {
                Icon icon4 = AIPlaygroundIcons.Mistral;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Mistral");
                break;
            }
            case "ollama": {
                Icon icon5 = AIPlaygroundIcons.Ollama;
                icon = icon5;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"Ollama");
                break;
            }
            case "deepseek": {
                Icon icon6 = AIPlaygroundIcons.DeepSeek;
                icon = icon6;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"DeepSeek");
                break;
            }
            case "gemini": 
            case "google": {
                Icon icon7 = AIPlaygroundIcons.Gemini;
                icon = icon7;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"Gemini");
                break;
            }
            case "open_router": 
            case "openrouter": {
                Icon icon8 = AIPlaygroundIcons.OpenRouter;
                icon = icon8;
                Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"OpenRouter");
                break;
            }
            case "aiassistant": {
                Icon icon9 = AIPlaygroundIcons.Aiassistant;
                icon = icon9;
                Intrinsics.checkNotNullExpressionValue((Object)icon9, (String)"Aiassistant");
                break;
            }
            default: {
                Icon icon10 = AIPlaygroundIcons.ToolWindowAIPlayground;
                icon = icon10;
                Intrinsics.checkNotNullExpressionValue((Object)icon10, (String)"ToolWindowAIPlayground");
            }
        }
        return icon;
    }
}

