/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui.chat.editor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.aiplayground.models.chat.Chat;
import com.intellij.aiplayground.ui.chat.editor.ChatFileType;
import com.intellij.aiplayground.ui.chat.editor.ChatVirtualFileKt;
import com.intellij.aiplayground.ui.chat.editor.PlaygroundFileSystem;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFileWithAssignedFileType;
import com.intellij.openapi.vfs.VirtualFileWithoutContent;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\u0016\u001a\u00070\t\u00a2\u0006\u0002\b\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\r\u0010\u001a\u001a\u00070\t\u00a2\u0006\u0002\b\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\n\u0010 \u001a\u0004\u0018\u00010\u0001H\u0016J\u0019\u0010!\u001a\u000e\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0001\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010#J\"\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020)H\u0016J\b\u0010.\u001a\u00020)H\u0016J\"\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u001d2\b\u00103\u001a\u0004\u0018\u000104H\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020)H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006:"}, d2={"Lcom/intellij/aiplayground/ui/chat/editor/ChatVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFileWithAssignedFileType;", "Lcom/intellij/openapi/vfs/VirtualFileWithoutContent;", "project", "Lcom/intellij/openapi/project/Project;", "chat", "Lcom/intellij/aiplayground/models/chat/Chat;", "fileName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/aiplayground/models/chat/Chat;Ljava/lang/String;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getChat", "()Lcom/intellij/aiplayground/models/chat/Chat;", "setChat", "(Lcom/intellij/aiplayground/models/chat/Chat;)V", "getFileName", "()Ljava/lang/String;", "setFileName", "(Ljava/lang/String;)V", "getName", "Lcom/intellij/openapi/util/NlsSafe;", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getPath", "Lorg/jetbrains/annotations/NonNls;", "isWritable", "", "isDirectory", "isValid", "getParent", "getChildren", "", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "", "newModificationStamp", "", "newTimeStamp", "contentsToByteArray", "", "getTimeStamp", "getLength", "refresh", "", "asynchronous", "recursive", "postRunnable", "Ljava/lang/Runnable;", "getInputStream", "Ljava/io/InputStream;", "getAssignedFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getModificationStamp", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=0)
public final class ChatVirtualFile
extends VirtualFile
implements VirtualFileWithAssignedFileType,
VirtualFileWithoutContent {
    @NotNull
    private final Project project;
    @NotNull
    private Chat chat;
    @NotNull
    private String fileName;
    public static final int $stable = 8;

    public ChatVirtualFile(@NotNull Project project, @NotNull Chat chat, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)chat, (String)"chat");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.project = project;
        this.chat = chat;
        this.fileName = fileName;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Chat getChat() {
        return this.chat;
    }

    public final void setChat(@NotNull Chat chat) {
        Intrinsics.checkNotNullParameter((Object)chat, (String)"<set-?>");
        this.chat = chat;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    public final void setFileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.fileName = string;
    }

    @NotNull
    public String getName() {
        return this.fileName;
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return (VirtualFileSystem)PlaygroundFileSystem.Companion.getInstance();
    }

    @NotNull
    public String getPath() {
        return ChatVirtualFileKt.access$chatFileName-1mvP2ok(this.project, this.chat.getId-RNhTleA());
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDirectory() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    @Nullable
    public VirtualFile getParent() {
        return null;
    }

    @Nullable
    public VirtualFile[] getChildren() {
        return null;
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() {
        throw new UnsupportedOperationException();
    }

    public long getTimeStamp() {
        return this.chat.getUpdatedAt();
    }

    public long getLength() {
        return 0L;
    }

    public void refresh(boolean asynchronous, boolean recursive, @Nullable Runnable postRunnable) {
    }

    @NotNull
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public FileType getAssignedFileType() {
        return ChatFileType.INSTANCE;
    }

    public long getModificationStamp() {
        return this.chat.getUpdatedAt();
    }
}

