/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui.chat.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.aiplayground.ui.actions.RenameChatKt;
import com.intellij.aiplayground.ui.chat.ChatViewModel;
import com.intellij.aiplayground.ui.chat.view.MessagesView;
import com.intellij.aiplayground.ui.chat.view.PropertiesView;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.OnePixelSplitter;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0001R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/aiplayground/ui/chat/view/ChatView;", "Ljavax/swing/JComponent;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "viewModel", "Lcom/intellij/aiplayground/ui/chat/ChatViewModel;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/aiplayground/ui/chat/ChatViewModel;)V", "messagesView", "Lcom/intellij/aiplayground/ui/chat/view/MessagesView;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getPreferredFocusedComponent", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=0)
public final class ChatView
extends JComponent
implements UiDataProvider {
    @NotNull
    private final ChatViewModel viewModel;
    @NotNull
    private final MessagesView messagesView;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    public ChatView(@NotNull Project project, @NotNull CoroutineScope coroutineScope, @NotNull ChatViewModel viewModel) {
        void $this$lambda_u240_u240;
        JPanel jPanel;
        OnePixelSplitter onePixelSplitter;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
        this.viewModel = viewModel;
        this.messagesView = new MessagesView(this.viewModel, coroutineScope, project);
        this.setLayout(new BorderLayout());
        OnePixelSplitter $this$_init__u24lambda_u240 = onePixelSplitter = new OnePixelSplitter(){

            public void reshape(int x, int y, int w, int h) {
                if (this.getWidth() == 0 && this.getHeight() == 0) {
                    this.setProportion(1.0f - 360.0f / (float)w);
                }
                super.reshape(x, y, w, h);
            }
        };
        boolean bl = false;
        $this$_init__u24lambda_u240.setFirstComponent((JComponent)this.messagesView);
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        OnePixelSplitter onePixelSplitter2 = $this$_init__u24lambda_u240;
        boolean bl2 = false;
        $this$lambda_u240_u240.add((Component)new PropertiesView(project, coroutineScope, this.viewModel), "North");
        onePixelSplitter2.setSecondComponent((JComponent)jPanel);
        $this$_init__u24lambda_u240.setDividerPositionStrategy(Splitter.DividerPositionStrategy.KEEP_SECOND_SIZE);
        OnePixelSplitter splitPane2 = onePixelSplitter;
        this.add((Component)splitPane2, "Center");
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        sink.set(RenameChatKt.getCHAT(), this.viewModel.getActiveChat().getValue());
    }

    @NotNull
    public final JComponent getPreferredFocusedComponent() {
        return this.messagesView.getPreferredFocusedComponent();
    }
}

