/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aiplayground.ui.chat.view;

import androidx.compose.runtime.internal.StabilityInferred;
import com.intellij.util.ui.WrapLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J`\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/aiplayground/ui/chat/view/ModelsPanelLayoutManager;", "Lcom/intellij/util/ui/WrapLayout;", "<init>", "()V", "layoutContainer", "", "target", "Ljava/awt/Container;", "preferredSize", "Ljava/awt/Dimension;", "m", "Ljava/awt/Component;", "moveComponents", "", "_x", "y", "width", "_height", "rowStart", "rowEnd", "ltr", "", "useBaseline", "ascent", "", "descent", "intellij.aiplayground.ui"})
@StabilityInferred(parameters=0)
public final class ModelsPanelLayoutManager
extends WrapLayout {
    public static final int $stable = 8;

    public ModelsPanelLayoutManager() {
        super(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(@NotNull Container target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Object object = target.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            Insets insets = target.getInsets();
            int maxwidth = target.getWidth() - (insets.left + insets.right + this.getHgap() * 2);
            int nmembers = target.getComponentCount();
            int x = 0;
            int y = insets.top + this.getVgap();
            int rowh = 0;
            int start = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            boolean useBaseline = this.getAlignOnBaseline();
            int[] ascent = new int[nmembers];
            int[] descent = new int[nmembers];
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Intrinsics.checkNotNull((Object)m);
                Dimension d = this.preferredSize(m);
                m.setSize(d.width, d.height);
                if (useBaseline) {
                    int baseline = m.getBaseline(d.width, d.height);
                    if (baseline >= 0) {
                        ascent[i] = baseline;
                        descent[i] = d.height - baseline;
                    } else {
                        ascent[i] = -1;
                    }
                }
                if (x == 0 || x + d.width <= maxwidth) {
                    x += d.width + this.getHgap();
                    rowh = Math.max(rowh, d.height);
                } else {
                    rowh = this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, i, ltr, useBaseline, ascent, descent);
                    x = d.width + this.getHgap();
                    y += this.getVgap() + rowh;
                    rowh = d.height;
                    start = i;
                }
                if (start != i || x - this.getHgap() <= maxwidth) continue;
                m.setSize(new Dimension(Math.max(m.getMinimumSize().width, maxwidth), d.height));
            }
            int n = this.moveComponents(target, insets.left + this.getHgap(), y, maxwidth - x, rowh, start, nmembers, ltr, useBaseline, ascent, descent);
        }
    }

    private final Dimension preferredSize(Component m) {
        return new Dimension(Math.max(m.getPreferredSize().width, m.getMinimumSize().width), Math.max(m.getPreferredSize().height, m.getMinimumSize().height));
    }

    private final int moveComponents(Container target, int _x, int y, int width, int _height, int rowStart, int rowEnd, boolean ltr, boolean useBaseline, int[] ascent, int[] descent) {
        int x = _x;
        int height = _height;
        switch (this.getAlignment()) {
            case 0: {
                x += ltr ? 0 : width;
                break;
            }
            case 1: {
                x += width / 2;
                break;
            }
            case 2: {
                x += ltr ? width : 0;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                x += width;
            }
        }
        int maxAscent = 0;
        int nonBaselineHeight = 0;
        int baselineOffset = 0;
        if (useBaseline) {
            int maxDescent = 0;
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ascent[i] >= 0) {
                    maxAscent = Math.max(maxAscent, ascent[i]);
                    maxDescent = Math.max(maxDescent, descent[i]);
                    continue;
                }
                nonBaselineHeight = Math.max(m.getHeight(), nonBaselineHeight);
            }
            height = Math.max(maxAscent + maxDescent, nonBaselineHeight);
            baselineOffset = (height - maxAscent - maxDescent) / 2;
        }
        double expand = 1.0;
        if (this.getFillWidth()) {
            double sum = 0.0;
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                sum += (double)Math.max(m.getPreferredSize().width, m.getMinimumSize().width);
            }
            expand = (double)target.getWidth() / sum;
        }
        for (int i = rowStart; i < rowEnd; ++i) {
            int w;
            Component m = target.getComponent(i);
            if (!m.isVisible()) continue;
            int cy = useBaseline && ascent[i] >= 0 ? y + baselineOffset + maxAscent - ascent[i] : y + (height - m.getHeight()) / 2;
            int n = w = this.getFillWidth() ? (int)Math.floor((double)Math.max(m.getPreferredSize().width, m.getMinimumSize().width) * expand) : m.getWidth();
            if (ltr) {
                m.setBounds(x, cy, w, m.getHeight());
            } else {
                m.setBounds(target.getWidth() - x - w, cy, w, m.getHeight());
            }
            x += m.getWidth() + this.getHgap();
        }
        return height;
    }
}

