/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js.psi.resolve.scopes;

import com.intellij.database.DatabaseDataKeysCore;
import com.intellij.database.console.JdbcConsoleCore;
import com.intellij.database.console.JdbcConsoleProviderCore;
import com.intellij.database.editor.DatabaseEditorHelperCore;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.SearchPath;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.dialects.mongo.js.MongoJSPsiUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSExpression;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReference;
import com.intellij.sql.dialects.mongo.js.psi.MongoJSReferenceExpression;
import com.intellij.sql.dialects.mongo.js.psi.resolve.MongoJSResolveHelper;
import com.intellij.sql.dialects.mongo.js.psi.resolve.ResolveUtilKt;
import com.intellij.sql.dialects.mongo.js.psi.resolve.scopes.MongoJSScope;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSCollection;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSDatabase;
import com.intellij.sql.dialects.mongo.js.psi.resolve.symbols.MongoJSSymbol;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eH\u0002J\u0014\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\fH\u0002J\u0014\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0082\u0004J\n\u0010$\u001a\u00020%H\u0096\u0080\u0004J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001e2\u0006\u0010'\u001a\u00020\rH\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eH\u0016J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u001e2\u0006\u0010)\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006*"}, d2={"Lcom/intellij/sql/dialects/mongo/js/psi/resolve/scopes/MongoJSFileScope;", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/scopes/MongoJSScope;", "file", "Lcom/intellij/psi/PsiFile;", "<init>", "(Lcom/intellij/psi/PsiFile;)V", "dbPsiFacade", "Lcom/intellij/database/psi/DbPsiFacade;", "Lorg/jetbrains/annotations/NotNull;", "getDbPsiFacade", "()Lcom/intellij/database/psi/DbPsiFacade;", "databaseMap", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/symbols/MongoJSDatabase;", "getDatabaseMap", "()Lcom/intellij/util/containers/MultiMap;", "extraCollections", "Lcom/intellij/sql/dialects/mongo/js/psi/resolve/symbols/MongoJSCollection;", "getExtraCollections", "dataSource", "Lcom/intellij/database/model/DasDataSource;", "getDataSource", "()Lcom/intellij/database/model/DasDataSource;", "searchPath", "Lcom/intellij/database/util/SearchPath;", "getSearchPath", "()Lcom/intellij/database/util/SearchPath;", "computeDatabaseMap", "computeCurrentDatabases", "", "computeExtraCollections", "equals", "", "other", "", "hashCode", "", "getDatabases", "name", "getCurrentDatabases", "database", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoJSFileScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoJSFileScope.kt\ncom/intellij/sql/dialects/mongo/js/psi/resolve/scopes/MongoJSFileScope\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 MongoJSPsiUtil.kt\ncom/intellij/sql/dialects/mongo/js/MongoJSPsiUtilKt\n*L\n1#1,96:1\n1#2:97\n1586#3:98\n1661#3,3:99\n1391#3:102\n1480#3,5:103\n1915#3:108\n1916#3:110\n41#4:109\n*S KotlinDebug\n*F\n+ 1 MongoJSFileScope.kt\ncom/intellij/sql/dialects/mongo/js/psi/resolve/scopes/MongoJSFileScope\n*L\n62#1:98\n62#1:99,3\n64#1:102\n64#1:103,5\n70#1:108\n70#1:110\n72#1:109\n*E\n"})
public final class MongoJSFileScope
implements MongoJSScope {
    @NotNull
    private final PsiFile file;

    public MongoJSFileScope(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
    }

    private final DbPsiFacade getDbPsiFacade() {
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)this.file.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
        return dbPsiFacade;
    }

    private final MultiMap<String, MongoJSDatabase> getDatabaseMap() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.file), () -> MongoJSFileScope._get_databaseMap_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (MultiMap)object;
    }

    private final MultiMap<String, MongoJSCollection> getExtraCollections() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.file), () -> MongoJSFileScope._get_extraCollections_$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (MultiMap)object;
    }

    private final DasDataSource getDataSource() {
        JdbcConsoleCore console;
        DbDataSource dataSource = (DbDataSource)this.file.getUserData(DatabaseDataKeysCore.DATA_SOURCE_KEY);
        if (dataSource != null) {
            return (DasDataSource)dataSource;
        }
        VirtualFile virtualFile = DatabaseEditorHelperCore.getVirtualFile((PsiFile)this.file);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile virtualFile2 = virtualFile;
        JdbcConsoleCore jdbcConsoleCore = console = JdbcConsoleProviderCore.getValidConsole((Project)this.file.getProject(), (VirtualFile)virtualFile2);
        return (DasDataSource)(jdbcConsoleCore != null ? jdbcConsoleCore.getDataSource() : null);
    }

    private final SearchPath getSearchPath() {
        return DatabaseEditorHelperCore.getSearchPath((PsiFile)this.file);
    }

    private final MultiMap<String, MongoJSDatabase> computeDatabaseMap() {
        Object object;
        MultiMap results;
        block5: {
            block4: {
                results = new MultiMap();
                object = this.getDataSource();
                if (object == null) break block4;
                DasDataSource it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)it);
                object = list;
                if (list != null) break block5;
            }
            List list = SqlImplUtil.getDataSources((PsiElement)((PsiElement)this.file));
            object = list;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDataSources(...)");
        }
        Object dataSources = object;
        Iterator iterator = dataSources.iterator();
        while (iterator.hasNext()) {
            DasDataSource dataSource = (DasDataSource)iterator.next();
            DbDataSource dbDs = this.getDbPsiFacade().findDataSource(dataSource.getUniqueId());
            for (DasObject root : dataSource.getModel().getModelRoots()) {
                DbElement psi;
                if (DbImplUtilCore.findElement((DbDataSource)dbDs, (DasObject)root) == null) continue;
                String string = root.getName();
                String string2 = psi.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                results.putValue((Object)string, (Object)new MongoJSDatabase(string2, (PsiElement)psi));
            }
        }
        return results;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<MongoJSDatabase> computeCurrentDatabases() {
        void $this$flatMapTo$iv$iv;
        List schemaNames;
        Object object = this.getSearchPath();
        if (object != null && (object = object.elements) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ObjectPath objectPath = (ObjectPath)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.name);
            }
            v1 = (List)destination$iv$iv;
        } else {
            v1 = schemaNames = CollectionsKt.emptyList();
        }
        if (schemaNames.isEmpty()) {
            Collection collection = this.getDatabaseMap().values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
            return collection;
        }
        Iterable $this$flatMap$iv = schemaNames;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            Iterable list$iv$iv = this.getDatabases(it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final MultiMap<String, MongoJSCollection> computeExtraCollections() {
        MongoJSResolveHelper mongoJSResolveHelper = ResolveUtilKt.getMongoHelper((PsiElement)this.file);
        if (mongoJSResolveHelper == null) {
            MultiMap multiMap = MultiMap.empty();
            Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"empty(...)");
            return multiMap;
        }
        MongoJSResolveHelper helper = mongoJSResolveHelper;
        MultiMap results = new MultiMap();
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)this.file)).filter(MongoJSReferenceExpression.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"filter(...)");
        Iterable $this$forEach$iv = (Iterable)jBIterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ResolveResult[] resolveResultArray;
            MongoJSCollection collection;
            ResolveResult resolveResult;
            MongoJSSymbol mongoJSSymbol;
            MongoJSReferenceExpression it = (MongoJSReferenceExpression)element$iv;
            boolean bl = false;
            MongoJSExpression mongoJSExpression = it.getQualifier();
            MongoJSReferenceExpression qualifier = mongoJSExpression instanceof MongoJSReferenceExpression ? (MongoJSReferenceExpression)mongoJSExpression : null;
            if (qualifier == null) continue;
            MongoJSReferenceExpression $this$isDbReference$iv = qualifier;
            boolean $i$f$isDbReference = false;
            MongoJSReference mongoJSReference = $this$isDbReference$iv.getReference();
            Intrinsics.checkNotNullExpressionValue((Object)mongoJSReference, (String)"getReference(...)");
            if (!MongoJSPsiUtilKt.isDbReference(mongoJSReference)) continue;
            ResolveResult[] resolveResultArray2 = it.getReference().multiResolve(false);
            Intrinsics.checkNotNullExpressionValue((Object)resolveResultArray2, (String)"multiResolve(...)");
            if ((ResolveResult)ArraysKt.singleOrNull((Object[])resolveResultArray2) == null || ((mongoJSSymbol = helper.getSymbol(resolveResult)) instanceof MongoJSCollection ? (MongoJSCollection)mongoJSSymbol : null) == null) continue;
            collection = collection;
            Intrinsics.checkNotNullExpressionValue((Object)qualifier.getReference().multiResolve(false), (String)"multiResolve(...)");
            for (ResolveResult target : resolveResultArray) {
                MongoJSDatabase db;
                Intrinsics.checkNotNull((Object)target);
                MongoJSSymbol mongoJSSymbol2 = helper.getSymbol(target);
                if ((mongoJSSymbol2 instanceof MongoJSDatabase ? (MongoJSDatabase)mongoJSSymbol2 : null) == null) continue;
                db = db;
                results.putValue((Object)db.getName(), (Object)collection);
            }
        }
        return results;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof MongoJSFileScope && Intrinsics.areEqual((Object)this.file, (Object)((MongoJSFileScope)other).file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    @Override
    @NotNull
    public Collection<MongoJSDatabase> getDatabases(@NotNull String name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Collection collection = this.getDatabaseMap().get((Object)name2);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return collection;
    }

    @Override
    @NotNull
    public Collection<MongoJSDatabase> getDatabases() {
        Collection collection = this.getDatabaseMap().values();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"values(...)");
        return collection;
    }

    @Override
    @NotNull
    public Collection<MongoJSDatabase> getCurrentDatabases() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.file), () -> MongoJSFileScope.getCurrentDatabases$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Collection)object;
    }

    @Override
    @NotNull
    public Collection<MongoJSCollection> getExtraCollections(@NotNull MongoJSDatabase database) {
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Collection collection = this.getExtraCollections().get((Object)database.getName());
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
        return collection;
    }

    private static final CachedValueProvider.Result _get_databaseMap_$lambda$0(MongoJSFileScope this$0) {
        Object[] objectArray = new Object[]{this$0.getDbPsiFacade()};
        return new CachedValueProvider.Result(this$0.computeDatabaseMap(), objectArray);
    }

    private static final CachedValueProvider.Result _get_extraCollections_$lambda$0(MongoJSFileScope this$0) {
        Object[] objectArray = new Object[]{this$0.getDbPsiFacade()};
        return new CachedValueProvider.Result(this$0.computeExtraCollections(), objectArray);
    }

    private static final CachedValueProvider.Result getCurrentDatabases$lambda$0(MongoJSFileScope this$0) {
        Object[] objectArray = new Object[]{this$0.getDbPsiFacade()};
        return new CachedValueProvider.Result(this$0.computeCurrentDatabases(), objectArray);
    }
}

