/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.async.extractor;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.profiler.ultimate.async.extractor.LazyCachingExtractorFromJarKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B3\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00018\u0000\u0012\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0014J\u0006\u0010\u0015\u001a\u00020\u0007J+\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u001aH\u0014\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0012\u0010\u0004\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/ultimate/async/extractor/AbstractLazyCachingExtractor;", "T", "", "libraryInfo", "extraLibraryInfo", "postProcessor", "Lkotlin/Function1;", "Ljava/io/File;", "", "<init>", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "Ljava/lang/Object;", "extractedFile", "lastModified", "", "fileName", "", "(Ljava/lang/Object;)Ljava/lang/String;", "sourceStream", "Ljava/io/InputStream;", "(Ljava/lang/Object;)Ljava/io/InputStream;", "getFile", "extract", "isExtra", "", "createDestination", "Lkotlin/Function0;", "(Ljava/lang/Object;ZLkotlin/jvm/functions/Function0;)Ljava/io/File;", "createTempFile", "name", "intellij.profiler.ultimate.ideaAsyncProfiler"})
public abstract class AbstractLazyCachingExtractor<T> {
    private final T libraryInfo;
    @Nullable
    private final T extraLibraryInfo;
    @Nullable
    private final Function1<File, Unit> postProcessor;
    private File extractedFile;
    private long lastModified;

    public AbstractLazyCachingExtractor(T libraryInfo, @Nullable T extraLibraryInfo, @Nullable Function1<? super File, Unit> postProcessor) {
        this.libraryInfo = libraryInfo;
        this.extraLibraryInfo = extraLibraryInfo;
        this.postProcessor = postProcessor;
        this.lastModified = -1L;
    }

    public /* synthetic */ AbstractLazyCachingExtractor(Object object, Object object2, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            object2 = null;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        this(object, object2, (Function1<? super File, Unit>)function1);
    }

    @NotNull
    public abstract String fileName(T var1);

    @NotNull
    public abstract InputStream sourceStream(T var1);

    @NotNull
    public final synchronized File getFile() {
        File file;
        block11: {
            block10: {
                if (this.extractedFile == null) break block10;
                File file2 = this.extractedFile;
                if (file2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
                    file2 = null;
                }
                if (!file2.exists()) break block10;
                File file3 = this.extractedFile;
                if (file3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
                    file3 = null;
                }
                if (file3.lastModified() == this.lastModified) break block11;
            }
            Ref.ObjectRef extracted = new Ref.ObjectRef();
            try {
                extracted.element = this.extract(this.libraryInfo, false, (Function0<File>)((Function0)() -> AbstractLazyCachingExtractor.getFile$lambda$0(this)));
                if (this.extraLibraryInfo != null) {
                    this.extract(this.extraLibraryInfo, true, (Function0<File>)((Function0)() -> AbstractLazyCachingExtractor.getFile$lambda$1(extracted, this)));
                }
                Function1<File, Unit> function1 = this.postProcessor;
                if (function1 != null) {
                    function1.invoke(extracted.element);
                }
                this.extractedFile = (File)extracted.element;
                this.lastModified = ((File)extracted.element).lastModified();
            }
            catch (Exception e) {
                LazyCachingExtractorFromJarKt.access$getLOG$p().error((Throwable)e);
                File file4 = (File)extracted.element;
                throw new Exception("Internal error: can't extract file '" + (file4 != null ? file4.getAbsolutePath() : null) + "'", e);
            }
        }
        if ((file = this.extractedFile) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"extractedFile");
            file = null;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected File extract(T libraryInfo, boolean isExtra, @NotNull Function0<? extends File> createDestination) {
        Intrinsics.checkNotNullParameter(createDestination, (String)"createDestination");
        File destination = (File)createDestination.invoke();
        Closeable closeable = this.sourceStream(libraryInfo);
        Throwable throwable = null;
        try {
            InputStream input = (InputStream)closeable;
            boolean bl = false;
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            long l = Files.copy(input, destination.toPath(), copyOptionArray);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return destination;
    }

    private final File createTempFile(String name) {
        String fileNameForFolder = StringsKt.replace$default((String)name, (char)'.', (char)'_', (boolean)false, (int)4, null);
        File file = FileUtil.createTempDirectory((String)("idea_" + fileNameForFolder + "_temp_folder"), (String)"", (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
        File enclosingFolder = file;
        File file2 = FileUtil.createTempFile((File)enclosingFolder, (String)name, null);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(...)");
        return file2;
    }

    private static final File getFile$lambda$0(AbstractLazyCachingExtractor this$0) {
        return this$0.createTempFile(this$0.fileName(this$0.libraryInfo));
    }

    private static final File getFile$lambda$1(Ref.ObjectRef $extracted, AbstractLazyCachingExtractor this$0) {
        File file = ((File)$extracted.element).getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getParentFile(...)");
        return FilesKt.resolve((File)file, (String)this$0.fileName(this$0.extraLibraryInfo));
    }
}

