/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentBuilder;
import com.intellij.grazie.text.TextExtractor;
import com.intellij.grazie.utils.EscapeUtilsKt;
import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.linter.JSDirectiveCommentSpellcheckerProvider;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSXmlLiteralExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.jsdoc.JSDocComment;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagNamepath;
import com.intellij.lang.javascript.psi.jsdoc.JSDocTagType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0014J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\f\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/lang/javascript/highlighting/JsTextExtractor;", "Lcom/intellij/grazie/text/TextExtractor;", "<init>", "()V", "docMarkup", "", "Lcom/intellij/psi/tree/IElementType;", "commentBuilder", "Lcom/intellij/grazie/text/TextContentBuilder;", "kotlin.jvm.PlatformType", "buildTextContent", "Lcom/intellij/grazie/text/TextContent;", "element", "Lcom/intellij/psi/PsiElement;", "allowedDomains", "", "Lcom/intellij/grazie/text/TextContent$TextDomain;", "buildContent", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "range", "Lcom/intellij/openapi/util/TextRange;", "exclusionRanges", "", "Lcom/intellij/grazie/text/TextContent$Exclusion;", "offsets", "", "text", "", "shouldBeExcluded", "", "isUnknownContent", "intellij.javascript.grazie"})
@SourceDebugExtension(value={"SMAP\nJsTextExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsTextExtractor.kt\ncom/intellij/lang/javascript/highlighting/JsTextExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,123:1\n1642#2,10:124\n1915#2:134\n1916#2:136\n1652#2:137\n1#3:135\n*S KotlinDebug\n*F\n+ 1 JsTextExtractor.kt\ncom/intellij/lang/javascript/highlighting/JsTextExtractor\n*L\n47#1:124,10\n47#1:134\n47#1:136\n47#1:137\n47#1:135\n*E\n"})
public final class JsTextExtractor
extends TextExtractor {
    @NotNull
    private final Set<IElementType> docMarkup;
    private final TextContentBuilder commentBuilder;

    public JsTextExtractor() {
        Object[] objectArray = new IElementType[]{JSDocTokenTypes.DOC_COMMENT_START, JSDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK, JSDocTokenTypes.DOC_COMMENT_END};
        this.docMarkup = SetsKt.setOf((Object[])objectArray);
        this.commentBuilder = TextContentBuilder.FromPsi.removingIndents(" \t").removingLineSuffixes(" \t");
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected TextContent buildTextContent(@NotNull PsiElement element, @NotNull Set<TextContent.TextDomain> allowedDomains) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(allowedDomains, (String)"allowedDomains");
        if (JSDirectiveCommentSpellcheckerProvider.isDirectiveComment((PsiElement)element)) {
            return null;
        }
        if (element instanceof JSDocComment && allowedDomains.contains(TextContent.TextDomain.DOCUMENTATION)) {
            return this.commentBuilder.excluding(arg_0 -> JsTextExtractor.buildTextContent$lambda$0(this, arg_0)).withUnknown(JsTextExtractor::buildTextContent$lambda$1).build(element, TextContent.TextDomain.DOCUMENTATION);
        }
        if (element instanceof PsiComment && allowedDomains.contains(TextContent.TextDomain.COMMENTS)) {
            if (Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)JSTokenTypes.C_STYLE_COMMENT) || Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)element), (Object)JSTokenTypes.END_OF_LINE_COMMENT)) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                List siblings = PsiUtilsKt.getNotSoDistantSimilarSiblings((PsiElement)element, arg_0 -> JsTextExtractor.buildTextContent$lambda$2(element, arg_0));
                Iterable iterable = siblings;
                char c = '\n';
                boolean $i$f$mapNotNull = false;
                void var6_8 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    TextContent it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    PsiElement it = (PsiElement)element$iv$iv;
                    boolean bl2 = false;
                    if (this.commentBuilder.build(it, TextContent.TextDomain.COMMENTS) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                return TextContent.joinWithWhitespace((char)c, (List)list);
            }
            return this.commentBuilder.build(element, TextContent.TextDomain.COMMENTS);
        }
        if (element instanceof JSLiteralExpression && allowedDomains.contains(TextContent.TextDomain.LITERALS)) {
            if (element instanceof JSXmlLiteralExpression && PsiTreeUtil.getParentOfType((PsiElement)element, JSXmlLiteralExpression.class) != null) {
                return null;
            }
            TextRange textRange = JSStringUtil.getStringLiteralOrTemplateUnquotedRange((String)element.getText());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getStringLiteralOrTemplateUnquotedRange(...)");
            TextRange unquotedRange = textRange;
            return this.buildContent((JSLiteralExpression)element, unquotedRange);
        }
        return null;
    }

    private final TextContent buildContent(JSLiteralExpression element, TextRange range) {
        TextContent textContent;
        TextContent textContent2;
        TextContent textContent3;
        TextContent content;
        TextContent textContent4 = TextContentBuilder.FromPsi.withUnknown(this::isUnknownContent).excluding(JsTextExtractor::buildContent$lambda$0).build((PsiElement)element, TextContent.TextDomain.LITERALS, range);
        TextContent textContent5 = content = textContent4 != null && (textContent3 = EscapeUtilsKt.replaceBackslashEscapedWhitespace((TextContent)textContent4)) != null && (textContent2 = EscapeUtilsKt.replaceBackslashEscapedWhitespace((TextContent)textContent3, (char)'f')) != null && (textContent = EscapeUtilsKt.replaceBackslashEscapedWhitespace((TextContent)textContent2, (char)'r')) != null ? EscapeUtilsKt.replaceBackslashEscapedWhitespace((TextContent)textContent, (char)'b') : null;
        if (content != null && StringsKt.contains$default((CharSequence)((CharSequence)content), (CharSequence)"\\", (boolean)false, (int)2, null)) {
            StringBuilder unescapedText = new StringBuilder();
            JSStringLiteralEscaper.SourceOffsets offsets = new JSStringLiteralEscaper.SourceOffsets();
            JSStringLiteralEscaper.parseStringCharacters((String)content.toString(), (StringBuilder)unescapedText, (JSStringLiteralEscaper.SourceOffsets)offsets, (boolean)element.isRegExpLiteral(), (boolean)(element instanceof JSStringTemplateExpression));
            int[] nArray = offsets.toOffsetArray();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toOffsetArray(...)");
            return content.excludeRanges(this.exclusionRanges(nArray, content.toString()));
        }
        return content;
    }

    private final List<TextContent.Exclusion> exclusionRanges(int[] offsets, String text) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)1, (int)offsets.length))), arg_0 -> JsTextExtractor.exclusionRanges$lambda$0(offsets, arg_0)), arg_0 -> JsTextExtractor.exclusionRanges$lambda$1(offsets, this, text, arg_0)));
    }

    private final boolean shouldBeExcluded(TextRange range, String text) {
        if (range.getLength() != 2) {
            return false;
        }
        String string = range.substring(text);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String subText = string;
        return Intrinsics.areEqual((Object)subText, (Object)"\\'") || Intrinsics.areEqual((Object)subText, (Object)"\\\"");
    }

    private final boolean isUnknownContent(PsiElement element) {
        Object[] objectArray;
        return element.getParent() instanceof JSStringTemplateExpression && element instanceof LeafPsiElement ? !CollectionsKt.listOf((Object[])(objectArray = new IElementType[]{JSTokenTypes.BACKQUOTE, JSTokenTypes.STRING_TEMPLATE_PART, JSTokenTypes.STRING_LITERAL, JSTokenTypes.STRING_LITERAL_PART})).contains(((LeafPsiElement)element).getElementType()) : (element.getParent() instanceof JSStringTemplateExpression && !(element instanceof LeafPsiElement) ? true : element.getParent() instanceof JSXmlLiteralExpression && !(element instanceof JSXmlLiteralExpression) && !(element instanceof XmlText) && !(element instanceof PsiWhiteSpace));
    }

    private static final boolean buildTextContent$lambda$0(JsTextExtractor this$0, PsiElement it) {
        return this$0.docMarkup.contains(it.getNode().getElementType());
    }

    private static final boolean buildTextContent$lambda$1(PsiElement it) {
        return it instanceof JSDocTagType || it instanceof JSDocTagNamepath || Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)JSDocTokenTypes.DOC_TAG_NAME);
    }

    private static final boolean buildTextContent$lambda$2(PsiElement $element, PsiElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)it), (Object)PsiTreeUtilKt.getElementType((PsiElement)$element));
    }

    private static final boolean buildContent$lambda$0(PsiElement it) {
        return Intrinsics.areEqual((Object)it.getNode().getElementType(), (Object)JSTokenTypes.BACKQUOTE);
    }

    private static final boolean exclusionRanges$lambda$0(int[] $offsets, int i) {
        return $offsets[i] > 0 && $offsets[i] - $offsets[i - 1] != 1;
    }

    private static final TextContent.Exclusion exclusionRanges$lambda$1(int[] $offsets, JsTextExtractor this$0, String $text, int index) {
        TextRange range = new TextRange($offsets[index - 1], $offsets[index]);
        return this$0.shouldBeExcluded(range, $text) ? TextContent.Exclusion.exclude((TextRange)new TextRange($offsets[index - 1], $offsets[index] - 1)) : TextContent.Exclusion.markUnknown((TextRange)range);
    }
}

