/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.EmptyStyle;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.LineBox;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.util.BoxUtil;
import com.openhtmltopdf.util.OpenUtil;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public class FootnoteManager {
    private final Map<PageBox, FootnoteArea> _footnoteAreas = new HashMap<PageBox, FootnoteArea>();
    private final Map<BlockBox, FootnoteArea> _containerMap = new HashMap<BlockBox, FootnoteArea>();

    private FootnoteArea createFootnoteArea(LayoutContext c, PageBox page) {
        FootnoteArea area = new FootnoteArea();
        area.footnoteArea = this.createFootnoteAreaBlock(c, page);
        area.maxHeight = page.getFootnoteMaxHeight(c);
        return area;
    }

    private BlockBox createFootnoteAreaBlock(LayoutContext c, PageBox footnoteCallPage) {
        CalculatedStyle style = new EmptyStyle().deriveStyle(footnoteCallPage.getPageInfo().createFootnoteAreaStyle());
        BlockBox rootBox = c.getRootLayer().getMaster();
        Element root = rootBox.getElement();
        Element me = root.getOwnerDocument().createElement("fs-footnote");
        Element body = BoxUtil.getBodyElementOrSomething(root);
        body.appendChild(me);
        Box bodyBox = BoxUtil.getBodyBoxOrSomething(c.getRootLayer().getMaster());
        int containingBlockWidth = OpenUtil.firstNonZero(bodyBox.getContentWidth(), bodyBox.getWidth(), rootBox.getContentWidth(), rootBox.getWidth(), footnoteCallPage.getContentWidth(c), footnoteCallPage.getWidth(c));
        BlockBox footnoteArea = this.getFootNoteArea(me, containingBlockWidth, style);
        return footnoteArea;
    }

    private BlockBox getFootNoteArea(Element me, int containingBlockWidth, CalculatedStyle style) {
        BlockBox footnoteArea = new BlockBox();
        footnoteArea.setContainingBlock(new ViewportBox(new Rectangle(0, 0, containingBlockWidth, 0)));
        footnoteArea.setStyle(style);
        footnoteArea.setChildrenContentType(BlockBox.ContentType.BLOCK);
        footnoteArea.setElement(me);
        return footnoteArea;
    }

    private void positionFootnoteArea(LayoutContext c, FootnoteArea area, PageBox firstPage, int lineHeight, boolean allowRepeat) {
        boolean multiPage;
        this.clearFootnoteAreaPages(area);
        int desiredHeight = area.footnoteArea.getBorderBoxHeight(c);
        int pageTop = firstPage.getTop();
        int pageBottom = firstPage.getBottom();
        int minFootnoteTop = area.maxHeight > 0.0f ? Math.max(pageTop + lineHeight, (int)((float)pageBottom - area.maxHeight)) : Math.max(pageTop + lineHeight, (int)((double)pageBottom - (double)firstPage.getContentHeight(c) * 0.6));
        if (minFootnoteTop > pageBottom) {
            firstPage = c.getRootLayer().getFirstPage((CssContext)c, minFootnoteTop);
        }
        int maxFootnoteHeight = firstPage.getBottom() - minFootnoteTop;
        int firstPageHeight = Math.min(maxFootnoteHeight, desiredHeight);
        firstPage.setFootnoteAreaHeight(firstPageHeight);
        this._footnoteAreas.put(firstPage, area);
        if (firstPageHeight < desiredHeight) {
            multiPage = true;
            this.reserveSubsequentPagesForFootnoteArea(c, area, desiredHeight, minFootnoteTop, 1);
        } else {
            multiPage = false;
            area.pages = Collections.singletonList(firstPage);
        }
        int x = 0;
        Box body = BoxUtil.getBodyOrNull(c.getRootLayer().getMaster());
        if (body != null) {
            x = body.getMarginBorderPadding(c, 1);
        }
        area.footnoteArea.setAbsX(x);
        area.footnoteArea.setAbsY(firstPage.getBottom() - firstPageHeight);
        if (multiPage && allowRepeat) {
            area.footnoteArea.reset(c);
            area.footnoteArea.layout(c);
            area.footnoteArea.calcChildLocations();
            int oldPagesCount = area.pages.size();
            int newDesiredHeight = area.footnoteArea.getBorderBoxHeight(c);
            this.reserveSubsequentPagesForFootnoteArea(c, area, newDesiredHeight, minFootnoteTop, oldPagesCount);
        } else {
            area.footnoteArea.calcChildLocations();
        }
    }

    private void reserveSubsequentPagesForFootnoteArea(LayoutContext c, FootnoteArea area, int desiredHeight, int footnoteTop, int startAt) {
        area.pages = c.getRootLayer().getPages(c, footnoteTop, footnoteTop + desiredHeight);
        for (int i = startAt; i < area.pages.size(); ++i) {
            PageBox page = area.pages.get(i);
            page.setFootnoteAreaHeight(page.getContentHeight(c));
            this._footnoteAreas.put(page, area);
        }
    }

    private void clearFootnoteAreaPages(FootnoteArea area) {
        if (area.pages != null) {
            for (PageBox page : area.pages) {
                page.setFootnoteAreaHeight(0);
                this._footnoteAreas.remove(page);
            }
            area.pages = null;
        }
    }

    public void addFootnoteBody(LayoutContext c, BlockBox footnoteBody, LineBox line) {
        PageBox page = c.getRootLayer().getFirstPage((CssContext)c, line);
        FootnoteArea footnote = this._footnoteAreas.get(page);
        c.setIsInFloatBottom(true);
        boolean createdArea = false;
        if (footnote == null) {
            footnote = this.createFootnoteArea(c, page);
            createdArea = true;
        }
        footnoteBody.setContainingBlock(footnote.footnoteArea.getContainingBlock());
        footnote.footnoteArea.addChild(footnoteBody);
        this._containerMap.put(footnoteBody, footnote);
        if (!createdArea) {
            footnote.footnoteArea.reset(c);
        } else {
            footnoteBody.reset(c);
        }
        c.setIsPrintOverride(false);
        footnote.footnoteArea.layout(c);
        c.setIsPrintOverride(null);
        this.positionFootnoteArea(c, footnote, page, line.getHeight(), true);
        c.setIsInFloatBottom(false);
    }

    public void removeFootnoteBodies(LayoutContext c, List<BlockBox> footnoteBodies, LineBox line) {
        for (BlockBox body : footnoteBodies) {
            FootnoteArea area = this._containerMap.get(body);
            area.footnoteArea.removeChild(body);
            this._containerMap.remove(body);
            if (area.footnoteArea.getChildCount() > 0) {
                c.setIsInFloatBottom(true);
                PageBox page = c.getRootLayer().getFirstPage((CssContext)c, line);
                area.footnoteArea.reset(c);
                c.setIsPrintOverride(false);
                area.footnoteArea.layout(c);
                c.setIsPrintOverride(null);
                this.positionFootnoteArea(c, area, page, line.getHeight(), true);
                c.setIsInFloatBottom(false);
                continue;
            }
            if (area.footnoteArea.getLayer() != null) {
                area.footnoteArea.getLayer().detach();
            }
            this.clearFootnoteAreaPages(area);
        }
    }

    private static class FootnoteArea {
        BlockBox footnoteArea;
        List<PageBox> pages;
        public float maxHeight;

        private FootnoteArea() {
        }
    }
}

