/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Function;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.impl.frame.XStandaloneVariablesView;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.console.PyConsoleOutputCustomizer;
import com.jetbrains.python.console.PyConsoleProcessFinishedException;
import com.jetbrains.python.console.PyConsoleUtil;
import com.jetbrains.python.console.PydevConsoleCommunicationUtil;
import com.jetbrains.python.console.PythonConsoleBackendServiceDisposable;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugConsoleCommunication;
import com.jetbrains.python.console.actions.CommandQueueForPythonConsoleService;
import com.jetbrains.python.console.protocol.CompletionOption;
import com.jetbrains.python.console.protocol.DebugValue;
import com.jetbrains.python.console.protocol.GetArrayResponse;
import com.jetbrains.python.console.protocol.KeyboardInterruptException;
import com.jetbrains.python.console.protocol.PythonConsoleFrontendService;
import com.jetbrains.python.console.protocol.PythonTableException;
import com.jetbrains.python.console.protocol.PythonUnhandledException;
import com.jetbrains.python.console.pydev.AbstractConsoleCommunication;
import com.jetbrains.python.console.pydev.ConsoleCommunication;
import com.jetbrains.python.console.pydev.InterpreterResponse;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueExecutionService;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyFrameListener;
import com.jetbrains.python.debugger.PyReferrersLoader;
import com.jetbrains.python.debugger.PyUserTypeRenderer;
import com.jetbrains.python.debugger.containerview.PyViewNumericContainerAction;
import com.jetbrains.python.debugger.pydev.GetVariableCommand;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.SetUserTypeRenderersCommand;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandBuilder;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandResult;
import com.jetbrains.python.debugger.pydev.tables.PyDevCommandParameters;
import com.jetbrains.python.debugger.pydev.tables.PyDevImageCommandParameters;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.ConfigureTypeRenderersActionKt;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.ConfigureTypeRenderersHyperLink;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserNodeRenderer;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserTypeRenderersSettings;
import com.jetbrains.python.parsing.console.PythonConsoleData;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.tables.TableCommandParameters;
import com.jetbrains.python.tables.TableCommandType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.thrift.TException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class PydevConsoleCommunication
extends AbstractConsoleCommunication
implements PyFrameAccessor {
    private static final Logger LOG = Logger.getInstance(PydevConsoleCommunication.class);
    protected volatile boolean keyboardInterruption;
    protected volatile String inputReceived;
    @Nullable
    protected volatile InterpreterResponse nextResponse;
    private boolean myExecuting;
    private PythonDebugConsoleCommunication myDebugCommunication;
    private boolean myNeedsMore = false;
    @Nullable
    private Pair<String, String> myPrevNameToDescription = null;
    private int myFullValueSeq = 0;
    private final Map<Integer, List<PyFrameAccessor.PyAsyncValue<String>>> myCallbackHashMap = new ConcurrentHashMap<Integer, List<PyFrameAccessor.PyAsyncValue<String>>>();
    @Nullable
    private PythonConsoleView myConsoleView;
    private final List<PyFrameListener> myFrameListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private XCompositeNode myCurrentRootNode;
    private final Object lock = new Object();

    @Nullable
    public PsiFile getHistoryPsiFile() {
        return this.myConsoleView != null ? this.myConsoleView.getHistoryPsiFile() : null;
    }

    public PydevConsoleCommunication(Project project) {
        super(project);
    }

    @NotNull
    protected abstract PythonConsoleBackendServiceDisposable getPythonConsoleBackendClient();

    public boolean handshake() {
        if (!this.isCommunicationClosed()) {
            try {
                return "PyCharm".equals(this.getPythonConsoleBackendClient().handshake());
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException e) {
                return false;
            }
            catch (TException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    public void close() {
        PyDebugValueExecutionService.getInstance((Project)this.myProject).sessionStopped((PyFrameAccessor)this);
        this.notifySessionStopped();
        this.myCallbackHashMap.clear();
        new Task.Backgroundable(this.myProject, PyBundle.message("console.close.console.communication", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    PydevConsoleCommunication.this.closeCommunication().get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    LOG.debug((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$1", "run"));
            }
        }.queue();
    }

    @NotNull
    public Future<?> closeAsync() {
        PyDebugValueExecutionService.getInstance((Project)this.myProject).sessionStopped((PyFrameAccessor)this);
        this.myCallbackHashMap.clear();
        Future<?> future = this.closeCommunication();
        if (future == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(0);
        }
        return future;
    }

    @NotNull
    protected abstract Future<?> closeCommunication();

    public abstract boolean isCommunicationClosed();

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    private void execNotifyAboutMagic(List<String> commands, boolean isAutoMagic) {
        if (this.getConsoleFile() != null) {
            PythonConsoleData consoleData = PyConsoleUtil.getOrCreateIPythonData(this.getConsoleFile());
            consoleData.setIPythonAutomagic(isAutoMagic);
            consoleData.setIPythonMagicCommands(commands);
        }
    }

    private boolean execIPythonEditor(String path2) {
        VirtualFile file;
        VirtualFile virtualFile = file = StringUtil.isEmpty((String)path2) ? null : LocalFileSystem.getInstance().findFileByPath(path2);
        if (file != null) {
            ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)this.myProject).openFile(file, true));
            return true;
        }
        return false;
    }

    private void execNotifyFinished(boolean more) {
        this.myNeedsMore = more;
        this.setExecuting(false);
        this.notifyCommandExecuted(more);
    }

    private void setExecuting(boolean executing) {
        this.myExecuting = executing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execRequestInput() throws KeyboardInterruptException {
        this.waitingForInput = true;
        this.inputReceived = null;
        this.keyboardInterruption = false;
        boolean needInput = true;
        this.nextResponse = new InterpreterResponse(false, needInput);
        this.notifyInputRequested();
        while (this.inputReceived == null) {
            if (this.keyboardInterruption) {
                this.waitingForInput = false;
                throw new KeyboardInterruptException();
            }
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.inputReceived;
    }

    protected Pair<String, Boolean> exec(ConsoleCommunication.ConsoleCodeFragment command) throws PythonUnhandledException {
        boolean more;
        this.setExecuting(true);
        PsiFile psi = this.getHistoryPsiFile();
        if (this.myConsoleView != null && psi != null) {
            ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)this.myProject, null, null, () -> {
                PsiElement[] newElems;
                for (PsiElement elem : newElems = PyElementGenerator.getInstance((Project)this.myProject).createDummyFile(LanguageLevel.forElement((PsiElement)this.myConsoleView.getFile()), command.getText()).getChildren()) {
                    psi.add(elem);
                }
            }, (PsiFile[])new PsiFile[]{psi}));
        }
        try {
            more = command.isSingleLine() ? this.getPythonConsoleBackendClient().execLine(command.getText()) : this.getPythonConsoleBackendClient().execMultipleLines(command.getText());
        }
        catch (PythonUnhandledException e) {
            this.setExecuting(false);
            throw e;
        }
        catch (TException e) {
            this.setExecuting(false);
            throw new RuntimeException(e);
        }
        if (more) {
            this.setExecuting(false);
        }
        return Pair.create(null, (Object)more);
    }

    private static String createRuntimeMessage(String taskName) {
        return PyBundle.message("console.getting.from.runtime", taskName);
    }

    @NotNull
    public List<PydevCompletionVariant> getCompletions(String text, String actTok) throws Exception {
        if (this.waitingForInput || this.isExecuting()) {
            List<PydevCompletionVariant> list = Collections.emptyList();
            if (list == null) {
                PydevConsoleCommunication.$$$reportNull$$$0(1);
            }
            return list;
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setText(PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.completion", new Object[0])));
        List list = (List)ApplicationUtil.runWithCheckCanceled(() -> this.doGetCompletions(text, actTok), (ProgressIndicator)indicator);
        if (list == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(2);
        }
        return list;
    }

    private List<PydevCompletionVariant> doGetCompletions(String text, String actTok) throws Exception {
        try {
            if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
                return this.myDebugCommunication.getCompletions(text, actTok);
            }
            List<CompletionOption> fromServer = this.getPythonConsoleBackendClient().getCompletions(text, actTok);
            return ContainerUtil.map(fromServer, option -> PydevConsoleCommunication.toPydevCompletionVariant(option));
        }
        catch (PythonUnhandledException e) {
            LOG.warn("Completion error in Python Console: " + e.traceback);
            return Collections.emptyList();
        }
    }

    @ApiStatus.Internal
    public String execRaw(String command) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            return this.executeBackgroundTask(() -> {
                try {
                    String string = this.getPythonConsoleBackendClient().execRaw(command);
                    return string;
                }
                catch (PythonUnhandledException e) {
                    throw new PyDebuggerException(e.traceback);
                }
                finally {
                    this.notifyCommandExecuted(false);
                }
            }, true, PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.table.data", new Object[0])), PyBundle.message("console.table.failed.to.load", new Object[0]));
        }
        return null;
    }

    public String execTableCommand(String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            return this.executeBackgroundTask(() -> {
                String startIndex = "";
                String endIndex = "";
                String format = "";
                try {
                    if (tableCommandParameters instanceof PyDevCommandParameters) {
                        startIndex = String.valueOf(((PyDevCommandParameters)tableCommandParameters).getStart());
                        endIndex = String.valueOf(((PyDevCommandParameters)tableCommandParameters).getEnd());
                        format = String.valueOf(((PyDevCommandParameters)tableCommandParameters).getFormat());
                    }
                    return this.getPythonConsoleBackendClient().execTableCommand(command, commandType.name(), startIndex, endIndex, format);
                }
                catch (PythonTableException e) {
                    throw new PyDebuggerException(e.message);
                }
            }, true, PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.table.data", new Object[0])), PyBundle.message("console.table.failed.to.load", new Object[0]));
        }
        return null;
    }

    public String execTableImageCommand(String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            return this.executeBackgroundTask(() -> {
                String offset = "";
                String imageId = "";
                try {
                    if (tableCommandParameters instanceof PyDevImageCommandParameters) {
                        offset = String.valueOf(((PyDevImageCommandParameters)tableCommandParameters).getOffset());
                        imageId = String.valueOf(((PyDevImageCommandParameters)tableCommandParameters).getImageId());
                    }
                    return this.getPythonConsoleBackendClient().execTableImageCommand(command, commandType.name(), offset, imageId);
                }
                catch (PythonTableException e) {
                    throw new PyDebuggerException(e.message);
                }
            }, true, PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.table.data", new Object[0])), PyBundle.message("console.table.failed.to.load", new Object[0]));
        }
        return null;
    }

    @TestOnly
    public List<PydevCompletionVariant> gerCompletionVariants(String text, String actTok) throws Exception {
        return this.doGetCompletions(text, actTok);
    }

    @NotNull
    private static PydevCompletionVariant toPydevCompletionVariant(@NotNull CompletionOption option) {
        if (option == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(3);
        }
        String args = String.join((CharSequence)" ", option.arguments);
        return new PydevCompletionVariant(option.name, option.documentation, args, option.type.getValue());
    }

    private void executeBackgroundTaskSuppressException(Callable<?> task, @NlsContexts.ProgressTitle String userVisibleMessage, String errorLogMessage) {
        try {
            this.executeBackgroundTask(task, false, userVisibleMessage, errorLogMessage);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Nullable
    private <T> T executeBackgroundTask(final Callable<T> task, boolean waitForResult, @NlsContexts.ProgressTitle String userVisibleMessage, final String errorLogMessage) throws PyDebuggerException {
        final FutureResult future = new FutureResult();
        new Task.Backgroundable(this, this.myProject, userVisibleMessage, false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    Object result2 = task.call();
                    future.set(result2);
                }
                catch (PythonUnhandledException e) {
                    LOG.error(errorLogMessage + e.traceback);
                    future.set(null);
                }
                catch (Exception e) {
                    future.setException((Throwable)e);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$2", "run"));
            }
        }.queue();
        if (waitForResult) {
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PyDebuggerException(errorLogMessage + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public String getDescription(String text) throws Exception {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            return this.myDebugCommunication.getDescription(text);
        }
        if (this.waitingForInput) {
            return "Unable to get description: waiting for input.";
        }
        if (this.myPrevNameToDescription != null) {
            if (((String)this.myPrevNameToDescription.first).equals(text)) {
                return (String)this.myPrevNameToDescription.second;
            }
        } else {
            this.myPrevNameToDescription = Pair.create((Object)text, (Object)"");
        }
        ApplicationManager.getApplication().assertIsNonDispatchThread();
        ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator indicator = progressManager.hasProgressIndicator() ? progressManager.getProgressIndicator() : new EmptyProgressIndicator();
        indicator.setText(PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.documentation", new Object[0])));
        return (String)ApplicationUtil.runWithCheckCanceled(() -> {
            String resultDescription = this.getPythonConsoleBackendClient().getDescription(text);
            this.myPrevNameToDescription = Pair.create((Object)text, (Object)resultDescription);
            return resultDescription;
        }, (ProgressIndicator)indicator);
    }

    public void execInterpreter(final ConsoleCommunication.ConsoleCodeFragment command, final Function<InterpreterResponse, Object> onResponseReceived) {
        if (this.myDebugCommunication != null && this.myDebugCommunication.isSuspended()) {
            this.myDebugCommunication.execInterpreter(command, onResponseReceived);
            return;
        }
        this.nextResponse = null;
        if (this.waitingForInput && this.myConsoleView != null && this.myConsoleView.isInitialized()) {
            this.inputReceived = command.getText();
            this.waitingForInput = false;
        } else {
            new Task.Backgroundable(this.myProject, PyBundle.message("console.waiting.execution.result", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    try {
                        if (indicator.isCanceled()) {
                            return;
                        }
                        Pair<String, Boolean> executed = PydevConsoleCommunication.this.exec(command);
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(((Boolean)executed.second).booleanValue(), false);
                    }
                    catch (ProcessCanceledException response) {
                    }
                    catch (PythonUnhandledException e) {
                        LOG.error("Error in execInterpreter():" + e.traceback);
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        PydevConsoleCommunication.this.notifyCommandExecuted(true);
                    }
                    catch (Exception e) {
                        PydevConsoleCommunication.this.nextResponse = new InterpreterResponse(false, false);
                        PydevConsoleCommunication.this.notifyCommandExecuted(true);
                    }
                    finally {
                        InterpreterResponse response = PydevConsoleCommunication.this.nextResponse;
                        if (response != null && response.more) {
                            PydevConsoleCommunication.this.myNeedsMore = true;
                        }
                        onResponseReceived.fun((Object)response);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/python/console/PydevConsoleCommunication$3", "run"));
                }
            }.queue();
        }
    }

    public void interrupt() {
        if (this.waitingForInput) {
            this.keyboardInterruption = true;
            return;
        }
        this.executeBackgroundTaskSuppressException(() -> {
            this.getPythonConsoleBackendClient().interrupt();
            return null;
        }, PyBundle.message("console.interrupting.execution", new Object[0]), "");
    }

    public boolean isExecuting() {
        return this.myExecuting;
    }

    public boolean needsMore() {
        return this.myNeedsMore;
    }

    public PyDebugValue evaluate(String expression, boolean execute2, boolean doTrunc) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            return this.executeBackgroundTask(() -> {
                List<DebugValue> debugValues = this.getPythonConsoleBackendClient().evaluate(expression, doTrunc);
                return PydevConsoleCommunicationUtil.createPyDebugValue(debugValues.iterator().next(), this);
            }, true, PyBundle.message("console.evaluating.expression.in.console", new Object[0]), "Error in evaluate():");
        }
        return null;
    }

    @Nullable
    public XValueChildrenList loadFrame(@Nullable XStackFrame contextFrame) throws PyDebuggerException {
        return this.loadFrame(() -> {
            List<DebugValue> frame = this.getPythonConsoleBackendClient().getFrame(ProcessDebugger.GROUP_TYPE.DEFAULT.ordinal());
            XValueChildrenList frameValues = PydevConsoleCommunicationUtil.parseVars(frame, null, this);
            this.notifyVariablesLoaded(frameValues);
            return frameValues;
        });
    }

    public XValueChildrenList loadSpecialVariables(ProcessDebugger.GROUP_TYPE groupType) throws PyDebuggerException {
        return this.loadFrame(() -> {
            List<DebugValue> frame = this.getPythonConsoleBackendClient().getFrame(groupType.ordinal());
            XValueChildrenList values = PydevConsoleCommunicationUtil.parseVars(frame, null, this);
            PyDebugValue.getAsyncValues(null, (PyFrameAccessor)this, (XValueChildrenList)values);
            return values;
        });
    }

    private <T> XValueChildrenList loadFrame(Callable<T> task) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            return (XValueChildrenList)this.executeBackgroundTask(task, true, PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.frame.variables", new Object[0])), "Error in loadFrame():");
        }
        return new XValueChildrenList();
    }

    public synchronized int getNextFullValueSeq() {
        ++this.myFullValueSeq;
        return this.myFullValueSeq;
    }

    public void loadAsyncVariablesValues(@Nullable XStackFrame frame, @NotNull List<PyFrameAccessor.PyAsyncValue<String>> pyAsyncValues) {
        if (pyAsyncValues == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(4);
        }
        PyDebugValueExecutionService.getInstance((Project)this.myProject).submitTask((PyFrameAccessor)this, () -> {
            try {
                ArrayList<String> evaluationExpressions = new ArrayList<String>();
                for (PyFrameAccessor.PyAsyncValue asyncValue : pyAsyncValues) {
                    evaluationExpressions.add(GetVariableCommand.composeName((PyDebugValue)asyncValue.getDebugValue()));
                }
                int seq = this.getNextFullValueSeq();
                this.myCallbackHashMap.put(seq, pyAsyncValues);
                this.getPythonConsoleBackendClient().loadFullValue(seq, evaluationExpressions);
            }
            catch (PyConsoleProcessFinishedException | CommunicationClosedException | TException e) {
                for (PyFrameAccessor.PyAsyncValue asyncValue : pyAsyncValues) {
                    PyDebugValue value = asyncValue.getDebugValue();
                    for (XValueNode node : value.getValueNodes()) {
                        if (node == null || node.isObsolete()) continue;
                        if (e.getMessage().startsWith("Timeout") || e.getMessage().startsWith("Console already exited")) {
                            value.updateNodeValueAfterLoading(node, " ", "", PyBundle.message("debugger.variables.view.loading.timed.out", new Object[0]));
                            continue;
                        }
                        LOG.error((Throwable)e);
                    }
                }
            }
        });
    }

    @Nullable
    public XValueChildrenList loadVariableDefaultView(PyDebugValue variable) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            return this.executeBackgroundTask(() -> {
                String name2 = variable.getOffset() == 0 ? GetVariableCommand.composeName((PyDebugValue)variable) : variable.getOffset() + "\t" + GetVariableCommand.composeName((PyDebugValue)variable);
                List<DebugValue> ret = this.getPythonConsoleBackendClient().getVariable(name2);
                return PydevConsoleCommunicationUtil.parseVars(ret, variable, this);
            }, true, PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.variable.value", new Object[0])), "Error in loadVariable():");
        }
        return new XValueChildrenList();
    }

    @Nullable
    public XValueChildrenList loadVariable(PyDebugValue var) throws PyDebuggerException {
        PyUserNodeRenderer typeRenderer = ConfigureTypeRenderersActionKt.getTypeRenderer(var);
        if (typeRenderer != null) {
            return this.executeBackgroundTask(() -> ConfigureTypeRenderersActionKt.loadTypeRendererChildren(this, var, typeRenderer), true, PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.variable.value", new Object[0])), "Error in loadVariable():");
        }
        return this.loadVariableDefaultView(var);
    }

    public void setCurrentRootNode(@NotNull XCompositeNode node) {
        if (node == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(5);
        }
        this.myCurrentRootNode = node;
    }

    public boolean isSimplifiedView() {
        return PyDebuggerSettings.getInstance().isSimplifiedView();
    }

    @Nullable
    public XCompositeNode getCurrentRootNode() {
        return this.myCurrentRootNode;
    }

    public void changeVariable(PyDebugValue variable, String value) {
        if (!this.isCommunicationClosed()) {
            this.executeBackgroundTaskSuppressException(() -> {
                this.getPythonConsoleBackendClient().changeVariable(variable.getEvaluationExpression(), value);
                return null;
            }, PyBundle.message("console.changing.variable", new Object[0]), "Error in changeVariable():");
        }
    }

    @Nullable
    public PyReferrersLoader getReferrersLoader() {
        return null;
    }

    public ArrayChunk getArrayItems(PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            return this.executeBackgroundTask(() -> {
                GetArrayResponse ret = this.getPythonConsoleBackendClient().getArray(var.getEvaluationExpression(), rowOffset, colOffset, rows, cols, format);
                return PydevConsoleCommunicationUtil.createArrayChunk(ret, this);
            }, true, PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.getting.array", new Object[0])), "Error in getArrayItems():");
        }
        return null;
    }

    public DataViewerCommandResult executeDataViewerCommand(DataViewerCommandBuilder builder) throws PyDebuggerException {
        if (!this.isCommunicationClosed()) {
            return this.executeBackgroundTask(() -> {
                try {
                    this.getPythonConsoleBackendClient().execDataViewerAction(builder.getVar().getName(), builder.getAction().name(), builder.getArgs() == null ? "" : String.join((CharSequence)"\t", builder.getArgs()));
                    return DataViewerCommandResult.makeSuccessResult((String)"Export successful");
                }
                catch (PythonUnhandledException e) {
                    return DataViewerCommandResult.errorFromExportTraceback((String)e.getTraceback());
                }
            }, true, PyBundle.message("console.executing.dataviewer.command", new Object[0]), "Error in DataViewer command:");
        }
        return DataViewerCommandResult.makeErrorResult((DataViewerCommandResult.ResultType)DataViewerCommandResult.ResultType.UNHANDLED_ERROR, (String)"Console communication is closed");
    }

    @Nullable
    public XSourcePosition getSourcePositionForName(String name2, String parentType) {
        return null;
    }

    @Nullable
    public XSourcePosition getSourcePositionForType(String type2) {
        return null;
    }

    public void connectToDebugger(int localPort, @Nullable String debuggerHost, @NotNull Map<String, Boolean> dbgOpts, @NotNull Map<String, String> extraEnvs) throws Exception {
        if (dbgOpts == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(6);
        }
        if (extraEnvs == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(7);
        }
        if (this.waitingForInput) {
            throw new Exception("Can't connect debugger now, waiting for input");
        }
        this.executeBackgroundTask(() -> {
            this.getPythonConsoleBackendClient().connectToDebugger(localPort, debuggerHost, dbgOpts, extraEnvs);
            return null;
        }, true, PyBundle.message("console.connecting.to.debugger", new Object[0]), "Error in connectToDebugger():");
    }

    public void notifyCommandExecuted(boolean more) {
        super.notifyCommandExecuted(more);
        PyFrameListener.publisher().frameChanged();
        for (PyFrameListener listener2 : this.myFrameListeners) {
            listener2.frameChanged();
        }
    }

    private void notifyVariablesLoaded(XValueChildrenList values) {
        PyFrameListener.publisher().valuesUpdated((PyFrameAccessor)this, values);
        for (PyFrameListener listener2 : this.myFrameListeners) {
            listener2.valuesUpdated((PyFrameAccessor)this, values);
        }
    }

    void notifyViewCreated(XStandaloneVariablesView view) {
        PyFrameListener.publisher().viewCreated((PyFrameAccessor)this, view);
        for (PyFrameListener listener2 : this.myFrameListeners) {
            listener2.viewCreated((PyFrameAccessor)this, view);
        }
    }

    private void notifySessionStopped() {
        PyFrameListener.publisher().sessionStopped((PyFrameAccessor)this);
        for (PyFrameListener listener2 : this.myFrameListeners) {
            listener2.sessionStopped((PyFrameAccessor)this);
        }
    }

    public void setUserTypeRenderersSettings() {
        if (!this.isCommunicationClosed()) {
            try {
                this.executeBackgroundTask(() -> {
                    PyUserTypeRenderersSettings settings = PyUserTypeRenderersSettings.getInstance();
                    if (settings == null) {
                        return false;
                    }
                    ArrayList<PyUserTypeRenderer> renderers = settings.getApplicableRenderers();
                    if (renderers.isEmpty()) {
                        return false;
                    }
                    String renderersMessage = SetUserTypeRenderersCommand.createMessage(renderers);
                    return this.getPythonConsoleBackendClient().setUserTypeRenderers(renderersMessage);
                }, false, PydevConsoleCommunication.createRuntimeMessage(PyBundle.message("console.setting.user.type.renderers", new Object[0])), "Error in setUserTypeRenderersSettings():");
            }
            catch (PyDebuggerException e) {
                LOG.warn("Failed to send Type Renderers", (Throwable)e);
            }
        }
    }

    @Nullable
    public XDebuggerTreeNodeHyperlink getUserTypeRenderersLink(@NotNull String typeRendererId) {
        if (typeRendererId == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(8);
        }
        return new ConfigureTypeRenderersHyperLink(typeRendererId, this.getProject(), null);
    }

    public void setDebugCommunication(PythonDebugConsoleCommunication debugCommunication) {
        this.myDebugCommunication = debugCommunication;
    }

    public void setConsoleView(@Nullable PythonConsoleView consoleView) {
        this.myConsoleView = consoleView;
    }

    public void showNumericContainer(@NotNull PyDebugValue value) {
        if (value == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(9);
        }
        PyViewNumericContainerAction.showNumericViewer(this.myProject, value);
    }

    public void addFrameListener(@NotNull PyFrameListener listener2) {
        if (listener2 == null) {
            PydevConsoleCommunication.$$$reportNull$$$0(10);
        }
        this.myFrameListeners.add(listener2);
    }

    @NotNull
    protected final PythonConsoleFrontendService.Iface createPythonConsoleFrontendHandler() {
        return new PythonConsoleFrontendHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/console/PydevConsoleCommunication";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyAsyncValues";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbgOpts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraEnvs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRendererId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "closeAsync";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/console/PydevConsoleCommunication";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "toPydevCompletionVariant";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadAsyncVariablesValues";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentRootNode";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "connectToDebugger";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUserTypeRenderersLink";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showNumericContainer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addFrameListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }

    protected static class CommunicationClosedException
    extends RuntimeException {
        protected CommunicationClosedException() {
        }
    }

    private class PythonConsoleFrontendHandler
    implements PythonConsoleFrontendService.Iface {
        private PythonConsoleFrontendHandler() {
        }

        @Override
        public void notifyFinished(boolean needsMoreInput, boolean exceptionOccurred) {
            if (PyConsoleUtil.isCommandQueueEnabled(PydevConsoleCommunication.this.myProject)) {
                ((CommandQueueForPythonConsoleService)ApplicationManager.getApplication().getService(CommandQueueForPythonConsoleService.class)).removeCommand((ConsoleCommunication)PydevConsoleCommunication.this, exceptionOccurred);
            }
            PydevConsoleCommunication.this.execNotifyFinished(needsMoreInput);
        }

        @Override
        public String requestInput(String path2) throws KeyboardInterruptException {
            return (String)PydevConsoleCommunication.this.execRequestInput();
        }

        @Override
        public void notifyAboutMagic(List<String> commands, boolean isAutoMagic) {
            PydevConsoleCommunication.this.execNotifyAboutMagic(commands, isAutoMagic);
        }

        @Override
        public void showConsole() {
            if (PydevConsoleCommunication.this.myConsoleView != null) {
                PydevConsoleCommunication.this.myConsoleView.setConsoleEnabled(true);
            }
        }

        @Override
        public void returnFullValue(int requestSeq, List<DebugValue> response) {
            block4: {
                List<PyFrameAccessor.PyAsyncValue<String>> values = PydevConsoleCommunication.this.myCallbackHashMap.remove(requestSeq);
                try {
                    List debugValues = ContainerUtil.map(response, value -> PydevConsoleCommunicationUtil.createPyDebugValue(value, PydevConsoleCommunication.this));
                    for (int i = 0; i < debugValues.size(); ++i) {
                        PyDebugValue resultValue = (PyDebugValue)debugValues.get(i);
                        values.get(i).getCallback().ok((Object)resultValue.getValue());
                    }
                }
                catch (Exception e) {
                    if (values == null) break block4;
                    for (PyFrameAccessor.PyAsyncValue<String> vars : values) {
                        vars.getCallback().error(new PyDebuggerException(response.toString()));
                    }
                }
            }
        }

        @Override
        public boolean IPythonEditor(String path2, String line) {
            return PydevConsoleCommunication.this.execIPythonEditor(path2);
        }

        @Override
        public void sendRichOutput(Map<String, String> data) {
            if (PydevConsoleCommunication.this.myConsoleView == null) {
                return;
            }
            if (data.isEmpty()) {
                return;
            }
            PyConsoleOutputCustomizer.Companion.getInstance().showRichOutput(PydevConsoleCommunication.this.myConsoleView, data);
        }
    }
}

