/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyLiteralExpression;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyDebugSupportUtils {
    private PyDebugSupportUtils() {
    }

    public static boolean isExpression(Project project, String expression) {
        return (Boolean)ReadAction.compute(() -> {
            PsiFile file = PyElementGenerator.getInstance((Project)project).createDummyFile(LanguageLevel.getDefault(), expression);
            return file.getFirstChild() instanceof PyExpressionStatement && file.getFirstChild() == file.getLastChild();
        });
    }

    @Nullable
    public static TextRange getExpressionRangeAtOffset(Project project, Document document, int offset) {
        return (TextRange)ReadAction.compute(() -> {
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (psiFile != null) {
                PsiElement patt0$temp;
                PsiElement element2 = psiFile.findElementAt(offset);
                if (!(element2 instanceof PyExpression) || element2 instanceof PyLiteralExpression) {
                    element2 = PsiTreeUtil.getParentOfType((PsiElement)element2, PyExpression.class);
                }
                if (element2 instanceof PyLiteralExpression) {
                    return null;
                }
                if (element2 instanceof PyReferenceExpression && (patt0$temp = element2.getParent()) instanceof PyCallExpression) {
                    PyCallExpression parent = (PyCallExpression)patt0$temp;
                    element2 = parent;
                }
                if (element2 != null && PyDebugSupportUtils.isSimpleEnough(element2) && PyDebugSupportUtils.isExpression(project, document.getText(element2.getTextRange()))) {
                    return element2.getTextRange();
                }
            }
            return null;
        });
    }

    private static boolean isSimpleEnough(PsiElement element2) {
        return element2 instanceof PyLiteralExpression || element2 instanceof PyQualifiedExpression || element2 instanceof PyNamedParameter || element2 instanceof PyCallExpression;
    }

    public static boolean canSaveToTemp(Project project, String expression) {
        return (Boolean)ReadAction.compute(() -> {
            PsiFile file = PyElementGenerator.getInstance((Project)project).createDummyFile(LanguageLevel.getDefault(), expression);
            PsiElement root = file.getFirstChild();
            return PyDebugSupportUtils.isVariable(root) == false && root instanceof PyExpressionStatement;
        });
    }

    private static Boolean isVariable(PsiElement root) {
        return root instanceof PyExpressionStatement && root.getFirstChild() instanceof PyReferenceExpression && root.getFirstChild() == root.getLastChild() && root.getFirstChild().getFirstChild() != null && root.getFirstChild().getFirstChild().getNode().getElementType() == PyTokenTypes.IDENTIFIER && root.getFirstChild().getFirstChild() == root.getFirstChild().getLastChild() && root.getFirstChild().getFirstChild().getFirstChild() == null;
    }

    @Nullable
    private static String getLineText(@NotNull Document document, int line) {
        if (document == null) {
            PyDebugSupportUtils.$$$reportNull$$$0(0);
        }
        if (line > 0 && line < document.getLineCount()) {
            return document.getText(TextRange.create((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line)));
        }
        return null;
    }

    public static boolean isContinuationLine(@NotNull Document document, int line) {
        String text;
        if (document == null) {
            PyDebugSupportUtils.$$$reportNull$$$0(1);
        }
        return (text = PyDebugSupportUtils.getLineText(document, line)) != null && text.trim().endsWith("\\");
    }

    public static boolean isCurrentPythonDebugProcess(@NotNull AnActionEvent event) {
        XDebugSession session;
        if (event == null) {
            PyDebugSupportUtils.$$$reportNull$$$0(2);
        }
        return (session = DebuggerUIUtil.getSession((AnActionEvent)event)) != null && session.getDebugProcess() instanceof PyDebugProcess;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyDebugSupportUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isContinuationLine";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCurrentPythonDebugProcess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

