/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.xdebugger.XDebugProcess;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class WatchReturnValuesAction
extends ToggleAction {
    private volatile boolean myWatchesReturnValues;
    private final XDebugProcess myProcess;
    private final @NlsActions.ActionText String myText;
    private final Consumer<Boolean> myToggleCallback;

    public WatchReturnValuesAction(@NotNull XDebugProcess frameAccessor, Consumer<Boolean> toggleCallback) {
        if (frameAccessor == null) {
            WatchReturnValuesAction.$$$reportNull$$$0(0);
        }
        super("", PyBundle.message("debugger.watch.return.values.description", new Object[0]), null);
        this.myWatchesReturnValues = PyDebuggerSettings.getInstance().isWatchReturnValues();
        this.myProcess = frameAccessor;
        this.myText = PyBundle.message("debugger.watch.show.return.values", new Object[0]);
        this.myToggleCallback = toggleCallback;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            WatchReturnValuesAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(true);
        presentation.setText(this.myText);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            WatchReturnValuesAction.$$$reportNull$$$0(2);
        }
        return actionUpdateThread;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        if (e == null) {
            WatchReturnValuesAction.$$$reportNull$$$0(3);
        }
        return this.myWatchesReturnValues;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean watch) {
        if (e == null) {
            WatchReturnValuesAction.$$$reportNull$$$0(4);
        }
        this.myWatchesReturnValues = watch;
        PyDebuggerSettings.getInstance().setWatchReturnValues(watch);
        Project project = e.getProject();
        if (project != null) {
            if (this.myToggleCallback != null) {
                this.myToggleCallback.accept(this.myWatchesReturnValues);
            }
            this.myProcess.getSession().rebuildViews();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameAccessor";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/WatchReturnValuesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/WatchReturnValuesAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

